/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.externalSystem.util.ExternalSystemCrcCalculator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH&J$\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\f\u001a\u00020\nH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/externalSystem/util/AbstractCrcCalculator;", "Lcom/intellij/openapi/externalSystem/util/ExternalSystemCrcCalculator;", "()V", "calculateCrc", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileText", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/CharSequence;)Ljava/lang/Long;", "charSequence", "parserDefinition", "Lcom/intellij/lang/ParserDefinition;", "getParserDefinition", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "isIgnoredToken", "", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "tokenText", "update", "", "Ljava/util/zip/CRC32;", "intellij.platform.externalSystem.impl"})
public abstract class AbstractCrcCalculator
implements ExternalSystemCrcCalculator {
    public abstract boolean isIgnoredToken(@NotNull IElementType var1, @NotNull CharSequence var2, @NotNull ParserDefinition var3);

    @Nullable
    public Long calculateCrc(@NotNull Project project, @NotNull VirtualFile file2, @NotNull CharSequence fileText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
        FileType fileType = file2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"file.fileType");
        ParserDefinition parserDefinition = this.getParserDefinition(fileType);
        if (parserDefinition == null) {
            return null;
        }
        ParserDefinition parserDefinition2 = parserDefinition;
        return this.calculateCrc(project, fileText, parserDefinition2);
    }

    private final long calculateCrc(Project project, CharSequence charSequence, ParserDefinition parserDefinition) {
        Lexer lexer = parserDefinition.createLexer(project);
        Intrinsics.checkNotNullExpressionValue((Object)lexer, (String)"parserDefinition.createLexer(project)");
        Lexer lexer2 = lexer;
        CRC32 crc32 = new CRC32();
        lexer2.start(charSequence);
        ProgressManager.checkCanceled();
        while (lexer2.getTokenType() != null) {
            IElementType tokenType;
            Intrinsics.checkNotNullExpressionValue((Object)tokenType, (String)"lexer.tokenType ?: break");
            CharSequence tokenText = charSequence.subSequence(lexer2.getTokenStart(), lexer2.getTokenEnd());
            this.update(crc32, tokenType, tokenText, parserDefinition);
            lexer2.advance();
            ProgressManager.checkCanceled();
        }
        return crc32.getValue();
    }

    private final void update(CRC32 $this$update, IElementType tokenType, CharSequence tokenText, ParserDefinition parserDefinition) {
        if (this.isIgnoredToken(tokenType, tokenText, parserDefinition)) {
            return;
        }
        if (StringsKt.isBlank((CharSequence)tokenText)) {
            return;
        }
        this.update($this$update, tokenText);
    }

    private final void update(CRC32 $this$update, CharSequence charSequence) {
        $this$update.update(charSequence.length());
        CharSequence charSequence2 = charSequence;
        for (int j = 0; j < charSequence2.length(); ++j) {
            char ch = charSequence2.charAt(j);
            $this$update.update(ch);
        }
    }

    private final ParserDefinition getParserDefinition(FileType fileType) {
        FileType fileType2 = fileType;
        return fileType2 instanceof LanguageFileType ? (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(((LanguageFileType)fileType).getLanguage()) : null;
    }
}

