/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.impl.CachedFileType;
import com.intellij.util.FileContentUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

abstract class PersistentFileSetManager
implements PersistentStateComponent<Element> {
    private static final String FILE_ELEMENT = "file";
    private static final String URL_ATTR = "url";
    private static final String VALUE_ATTR = "value";
    private final Map<VirtualFile, String> myMap = new HashMap<VirtualFile, String>();

    PersistentFileSetManager() {
    }

    boolean addFile(@NotNull VirtualFile file2, @NotNull FileType type) {
        String prevValue;
        if (file2 == null) {
            PersistentFileSetManager.$$$reportNull$$$0(0);
        }
        if (type == null) {
            PersistentFileSetManager.$$$reportNull$$$0(1);
        }
        if (!(file2 instanceof VirtualFileWithId)) {
            throw new IllegalArgumentException("file must be instanceof VirtualFileWithId but got: " + file2);
        }
        if (file2.isDirectory()) {
            throw new IllegalArgumentException("file must not be directory but got: " + file2);
        }
        String value2 = type.getName();
        if (!value2.equals(prevValue = this.myMap.put(file2, value2))) {
            PersistentFileSetManager.onFileSettingsChanged(Collections.singleton(file2));
        }
        return true;
    }

    boolean removeFile(@NotNull VirtualFile file2) {
        boolean isRemoved;
        if (file2 == null) {
            PersistentFileSetManager.$$$reportNull$$$0(2);
        }
        boolean bl = isRemoved = this.myMap.remove(file2) != null;
        if (isRemoved) {
            PersistentFileSetManager.onFileSettingsChanged(Collections.singleton(file2));
        }
        return isRemoved;
    }

    String getFileValue(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFileSetManager.$$$reportNull$$$0(3);
        }
        return this.myMap.get(file2);
    }

    private static void onFileSettingsChanged(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            PersistentFileSetManager.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            WriteAction.run(() -> CachedFileType.clearCache());
            FileContentUtilCore.reparseFiles((Collection)files2);
        });
    }

    @NotNull
    Collection<VirtualFile> getFiles() {
        Set<VirtualFile> set2 = this.myMap.keySet();
        if (set2 == null) {
            PersistentFileSetManager.$$$reportNull$$$0(5);
        }
        return set2;
    }

    public Element getState() {
        Element root2 = new Element("root");
        ArrayList<Map.Entry<VirtualFile, String>> sorted = new ArrayList<Map.Entry<VirtualFile, String>>(this.myMap.entrySet());
        sorted.sort(Comparator.comparing(e -> ((VirtualFile)e.getKey()).getPath()));
        for (Map.Entry entry2 : sorted) {
            Element element2 = new Element(FILE_ELEMENT);
            element2.setAttribute(URL_ATTR, VfsUtilCore.pathToUrl((String)((VirtualFile)entry2.getKey()).getPath()));
            String fileTypeName = (String)entry2.getValue();
            if (fileTypeName != null && !PlainTextFileType.INSTANCE.getName().equals(fileTypeName)) {
                element2.setAttribute(VALUE_ATTR, fileTypeName);
            }
            root2.addContent(element2);
        }
        return root2;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            PersistentFileSetManager.$$$reportNull$$$0(6);
        }
        HashSet<VirtualFile> oldFiles = new HashSet<VirtualFile>(this.getFiles());
        this.myMap.clear();
        for (Element fileElement : state.getChildren(FILE_ELEMENT)) {
            Attribute urlAttr = fileElement.getAttribute(URL_ATTR);
            if (urlAttr == null) continue;
            String url = urlAttr.getValue();
            VirtualFile vf = VirtualFileManager.getInstance().findFileByUrl(url);
            if (vf == null) continue;
            String value2 = fileElement.getAttributeValue(VALUE_ATTR);
            this.myMap.put(vf, Objects.requireNonNullElse(value2, PlainTextFileType.INSTANCE.getName()));
        }
        Sets.SetView toReparse = Sets.symmetricDifference(this.myMap.keySet(), oldFiles);
        PersistentFileSetManager.onFileSettingsChanged((Collection<? extends VirtualFile>)toReparse);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILE_ELEMENT;
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/file/exclude/PersistentFileSetManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/file/exclude/PersistentFileSetManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onFileSettingsChanged";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

