/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.tree;

import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.tree.FileNode;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileRenderer {
    private static final Color GRAYED = SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor();
    private static final Color HIDDEN = SimpleTextAttributes.DARK_TEXT.getFgColor();

    public <T> ColoredListCellRenderer<T> forList() {
        return new ColoredListCellRenderer<T>(){

            protected void customizeCellRenderer(@NotNull JList<? extends T> list2, T value2, int index2, boolean selected2, boolean focused) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileRenderer.this.customize((SimpleColoredComponent)this, value2, selected2, focused);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/fileChooser/tree/FileRenderer$1", "customizeCellRenderer"));
            }
        };
    }

    public ColoredTableCellRenderer forTable() {
        return new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value2, boolean selected2, boolean focused, int row2, int column2) {
                if (table == null) {
                    2.$$$reportNull$$$0(0);
                }
                FileRenderer.this.customize((SimpleColoredComponent)this, value2, selected2, focused);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/fileChooser/tree/FileRenderer$2", "customizeCellRenderer"));
            }
        };
    }

    public ColoredTreeCellRenderer forTree() {
        return new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded2, boolean leaf, int row2, boolean focused) {
                if (tree == null) {
                    3.$$$reportNull$$$0(0);
                }
                FileRenderer.this.customize((SimpleColoredComponent)this, value2, selected2, focused);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/fileChooser/tree/FileRenderer$3", "customizeCellRenderer"));
            }
        };
    }

    protected void customize(SimpleColoredComponent renderer2, Object value2, boolean selected2, boolean focused) {
        int style = 0;
        Color color = null;
        Icon icon2 = null;
        String name2 = null;
        String comment = null;
        boolean hidden = false;
        boolean valid = true;
        if (value2 instanceof FileNode) {
            FileNode node2 = (FileNode)value2;
            icon2 = node2.getIcon();
            name2 = node2.getName();
            comment = node2.getComment();
            hidden = node2.isHidden();
            valid = node2.isValid();
        } else if (value2 instanceof VirtualFile) {
            VirtualFile file2 = (VirtualFile)value2;
            name2 = file2.getName();
            hidden = FileElement.isFileHidden((VirtualFile)file2);
            valid = file2.isValid();
        } else if (value2 != null) {
            name2 = value2.toString();
            color = GRAYED;
        }
        if (!valid) {
            style |= 4;
        }
        if (hidden) {
            color = HIDDEN;
        }
        renderer2.setIcon(!hidden || icon2 == null ? icon2 : IconLoader.getTransparentIcon((Icon)icon2));
        SimpleTextAttributes attributes2 = new SimpleTextAttributes(style, color);
        if (name2 != null) {
            renderer2.append(name2, attributes2);
        }
        if (comment != null) {
            renderer2.append(comment, attributes2);
        }
    }
}

