/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.LayoutActionsFloatingToolbar;
import com.intellij.openapi.fileEditor.SplitEditorToolbar;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorWithPreview
extends UserDataHolderBase
implements TextEditor {
    protected final TextEditor myEditor;
    protected final FileEditor myPreview;
    @NotNull
    private final MyListenersMultimap myListenersGenerator;
    private final Layout myDefaultLayout;
    private Layout myLayout;
    private boolean myIsVerticalSplit;
    private JComponent myComponent;
    private JBSplitter mySplitter;
    private SplitEditorToolbar myToolbarWrapper;
    @Nls
    private final String myName;
    public static final Key<Layout> DEFAULT_LAYOUT_FOR_FILE = Key.create((String)"TextEditorWithPreview.DefaultLayout");

    public TextEditorWithPreview(@NotNull TextEditor editor2, @NotNull FileEditor preview2, @NotNull @Nls String editorName, @NotNull Layout defaultLayout, boolean isVerticalSplit) {
        if (editor2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(0);
        }
        if (preview2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(1);
        }
        if (editorName == null) {
            TextEditorWithPreview.$$$reportNull$$$0(2);
        }
        if (defaultLayout == null) {
            TextEditorWithPreview.$$$reportNull$$$0(3);
        }
        this.myListenersGenerator = new MyListenersMultimap();
        this.myEditor = editor2;
        this.myPreview = preview2;
        this.myName = editorName;
        this.myDefaultLayout = (Layout)((Object)ObjectUtils.notNull((Object)((Object)TextEditorWithPreview.getLayoutForFile(this.myEditor.getFile())), (Object)((Object)defaultLayout)));
        this.myIsVerticalSplit = isVerticalSplit;
    }

    public TextEditorWithPreview(@NotNull TextEditor editor2, @NotNull FileEditor preview2, @NotNull @Nls String editorName, @NotNull Layout defaultLayout) {
        if (editor2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(4);
        }
        if (preview2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(5);
        }
        if (editorName == null) {
            TextEditorWithPreview.$$$reportNull$$$0(6);
        }
        if (defaultLayout == null) {
            TextEditorWithPreview.$$$reportNull$$$0(7);
        }
        this(editor2, preview2, editorName, defaultLayout, false);
    }

    public TextEditorWithPreview(@NotNull TextEditor editor2, @NotNull FileEditor preview2, @NotNull @Nls String editorName) {
        if (editor2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(8);
        }
        if (preview2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(9);
        }
        if (editorName == null) {
            TextEditorWithPreview.$$$reportNull$$$0(10);
        }
        this(editor2, preview2, editorName, Layout.SHOW_EDITOR_AND_PREVIEW);
    }

    public TextEditorWithPreview(@NotNull TextEditor editor2, @NotNull FileEditor preview2) {
        if (editor2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(11);
        }
        if (preview2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(12);
        }
        this(editor2, preview2, "TextEditorWithPreview");
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return this.myEditor.getBackgroundHighlighter();
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return this.myEditor.getCurrentLocation();
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return this.myEditor.getStructureViewBuilder();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myEditor);
        Disposer.dispose((Disposable)this.myPreview);
    }

    public void selectNotify() {
        this.myEditor.selectNotify();
        this.myPreview.selectNotify();
    }

    public void deselectNotify() {
        this.myEditor.deselectNotify();
        this.myPreview.deselectNotify();
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myComponent != null) {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                TextEditorWithPreview.$$$reportNull$$$0(13);
            }
            return jComponent;
        }
        this.mySplitter = new JBSplitter(this.myIsVerticalSplit, 0.5f, 0.15f, 0.85f);
        this.mySplitter.setSplitterProportionKey(this.getSplitterProportionKey());
        this.mySplitter.setFirstComponent(this.myEditor.getComponent());
        this.mySplitter.setSecondComponent(this.myPreview.getComponent());
        this.mySplitter.setDividerWidth(2);
        this.myToolbarWrapper = this.createMarkdownToolbarWrapper((JComponent)this.mySplitter);
        if (this.myLayout == null) {
            String lastUsed = PropertiesComponent.getInstance().getValue(this.getLayoutPropertyName());
            this.myLayout = Layout.fromId(lastUsed, this.myDefaultLayout);
        }
        this.adjustEditorsVisibility();
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)this.mySplitter).addToTop((Component)this.myToolbarWrapper);
        if (!this.isShowFloatingToolbar()) {
            JComponent jComponent = this.myComponent = panel2;
            if (jComponent == null) {
                TextEditorWithPreview.$$$reportNull$$$0(14);
            }
            return jComponent;
        }
        this.myToolbarWrapper.setVisible(false);
        MyEditorLayeredComponentWrapper layeredPane2 = new MyEditorLayeredComponentWrapper((JComponent)panel2);
        this.myComponent = layeredPane2;
        LayoutActionsFloatingToolbar toolbar = new LayoutActionsFloatingToolbar(this.myComponent, (ActionGroup)new DefaultActionGroup(this.myToolbarWrapper.getRightToolbar().getActions()));
        Disposer.register((Disposable)this, (Disposable)toolbar);
        layeredPane2.add((Component)panel2, JLayeredPane.DEFAULT_LAYER);
        this.myComponent.add((Component)toolbar, JLayeredPane.POPUP_LAYER);
        this.registerToolbarListeners((JComponent)panel2, toolbar);
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            TextEditorWithPreview.$$$reportNull$$$0(15);
        }
        return jComponent;
    }

    protected boolean isShowFloatingToolbar() {
        return Registry.is((String)"ide.text.editor.with.preview.show.floating.toolbar") && this.myToolbarWrapper.isLeftToolbarEmpty();
    }

    private void registerToolbarListeners(JComponent actualComponent, final LayoutActionsFloatingToolbar toolbar) {
        UIUtil.addAwtListener((AWTEventListener)new MyMouseListener(toolbar), (long)32L, (Disposable)toolbar);
        EditorComponentImpl actualEditor = (EditorComponentImpl)UIUtil.findComponentOfType((JComponent)actualComponent, EditorComponentImpl.class);
        if (actualEditor != null) {
            KeyAdapter editorKeyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent event) {
                    toolbar.getVisibilityController().scheduleHide();
                }
            };
            actualEditor.getEditor().getContentComponent().addKeyListener(editorKeyListener);
            Disposer.register((Disposable)toolbar, () -> TextEditorWithPreview.lambda$registerToolbarListeners$0(actualEditor, editorKeyListener));
        }
    }

    public boolean isVerticalSplit() {
        return this.myIsVerticalSplit;
    }

    public void setVerticalSplit(boolean verticalSplit) {
        this.myIsVerticalSplit = verticalSplit;
        this.mySplitter.setOrientation(verticalSplit);
    }

    @NotNull
    private SplitEditorToolbar createMarkdownToolbarWrapper(@NotNull JComponent targetComponentForActions) {
        ActionToolbar leftToolbar;
        if (targetComponentForActions == null) {
            TextEditorWithPreview.$$$reportNull$$$0(16);
        }
        if ((leftToolbar = this.createToolbar()) != null) {
            leftToolbar.setTargetComponent(targetComponentForActions);
            leftToolbar.setReservePlaceAutoPopupIcon(false);
        }
        ActionToolbar rightToolbar = this.createRightToolbar();
        rightToolbar.setTargetComponent(targetComponentForActions);
        rightToolbar.setReservePlaceAutoPopupIcon(false);
        return new SplitEditorToolbar(leftToolbar, rightToolbar);
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            TextEditorWithPreview.$$$reportNull$$$0(17);
        }
        if (state instanceof MyFileEditorState) {
            MyFileEditorState compositeState = (MyFileEditorState)state;
            if (compositeState.getFirstState() != null) {
                this.myEditor.setState(compositeState.getFirstState());
            }
            if (compositeState.getSecondState() != null) {
                this.myPreview.setState(compositeState.getSecondState());
            }
            if (compositeState.getSplitLayout() != null) {
                this.myLayout = compositeState.getSplitLayout();
                this.invalidateLayout();
            }
        }
    }

    protected void onLayoutChange(Layout oldValue, Layout newValue2) {
    }

    private void adjustEditorsVisibility() {
        this.myEditor.getComponent().setVisible(this.myLayout == Layout.SHOW_EDITOR || this.myLayout == Layout.SHOW_EDITOR_AND_PREVIEW);
        this.myPreview.getComponent().setVisible(this.myLayout == Layout.SHOW_PREVIEW || this.myLayout == Layout.SHOW_EDITOR_AND_PREVIEW);
    }

    protected void setLayout(@NotNull Layout layout) {
        if (layout == null) {
            TextEditorWithPreview.$$$reportNull$$$0(18);
        }
        Layout oldLayout = this.myLayout;
        this.myLayout = layout;
        PropertiesComponent.getInstance().setValue(this.getLayoutPropertyName(), this.myLayout.myId, this.myDefaultLayout.myId);
        this.adjustEditorsVisibility();
        this.onLayoutChange(oldLayout, this.myLayout);
    }

    private void invalidateLayout() {
        this.adjustEditorsVisibility();
        this.myToolbarWrapper.refresh();
        this.myComponent.repaint();
        JComponent focusComponent = this.getPreferredFocusedComponent();
        Component focusOwner = IdeFocusManager.findInstance().getFocusOwner();
        if (focusComponent != null && focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, this.getComponent())) {
            IdeFocusManager.findInstanceByComponent((Component)focusComponent).requestFocus((Component)focusComponent, true);
        }
    }

    @NotNull
    protected String getSplitterProportionKey() {
        return "TextEditorWithPreview.SplitterProportionKey";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        switch (this.myLayout) {
            case SHOW_EDITOR_AND_PREVIEW: 
            case SHOW_EDITOR: {
                return this.myEditor.getPreferredFocusedComponent();
            }
            case SHOW_PREVIEW: {
                return this.myPreview.getPreferredFocusedComponent();
            }
        }
        throw new IllegalStateException(this.myLayout.myId);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            TextEditorWithPreview.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            TextEditorWithPreview.$$$reportNull$$$0(20);
        }
        return new MyFileEditorState(this.myLayout, this.myEditor.getState(level), this.myPreview.getState(level));
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(21);
        }
        this.myEditor.addPropertyChangeListener(listener2);
        this.myPreview.addPropertyChangeListener(listener2);
        DoublingEventListenerDelegate delegate2 = this.myListenersGenerator.addListenerAndGetDelegate(listener2);
        this.myEditor.addPropertyChangeListener((PropertyChangeListener)delegate2);
        this.myPreview.addPropertyChangeListener((PropertyChangeListener)delegate2);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(22);
        }
        this.myEditor.removePropertyChangeListener(listener2);
        this.myPreview.removePropertyChangeListener(listener2);
        DoublingEventListenerDelegate delegate2 = this.myListenersGenerator.removeListenerAndGetDelegate(listener2);
        if (delegate2 != null) {
            this.myEditor.removePropertyChangeListener((PropertyChangeListener)delegate2);
            this.myPreview.removePropertyChangeListener((PropertyChangeListener)delegate2);
        }
    }

    @NotNull
    public TextEditor getTextEditor() {
        TextEditor textEditor = this.myEditor;
        if (textEditor == null) {
            TextEditorWithPreview.$$$reportNull$$$0(23);
        }
        return textEditor;
    }

    @NotNull
    public FileEditor getPreviewEditor() {
        FileEditor fileEditor = this.myPreview;
        if (fileEditor == null) {
            TextEditorWithPreview.$$$reportNull$$$0(24);
        }
        return fileEditor;
    }

    public Layout getLayout() {
        return this.myLayout;
    }

    public boolean isModified() {
        return this.myEditor.isModified() || this.myPreview.isModified();
    }

    public boolean isValid() {
        return this.myEditor.isValid() && this.myPreview.isValid();
    }

    @Nullable
    protected ActionToolbar createToolbar() {
        ActionGroup actionGroup2 = this.createLeftToolbarActionGroup();
        if (actionGroup2 != null) {
            return ActionManager.getInstance().createActionToolbar("TextEditorWithPreview", actionGroup2, true);
        }
        return null;
    }

    @Nullable
    protected ActionGroup createLeftToolbarActionGroup() {
        return null;
    }

    @NotNull
    private ActionToolbar createRightToolbar() {
        ActionGroup viewActions = this.createViewActionGroup();
        ActionGroup group2 = this.createRightToolbarActionGroup();
        ActionGroup rightToolbarActions = group2 == null ? viewActions : new DefaultActionGroup(new AnAction[]{group2, Separator.create(), viewActions});
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("TextEditorWithPreview", rightToolbarActions, true);
        if (actionToolbar == null) {
            TextEditorWithPreview.$$$reportNull$$$0(25);
        }
        return actionToolbar;
    }

    @NotNull
    protected ActionGroup createViewActionGroup() {
        return new DefaultActionGroup(new AnAction[]{this.getShowEditorAction(), this.getShowEditorAndPreviewAction(), this.getShowPreviewAction()});
    }

    @Nullable
    protected ActionGroup createRightToolbarActionGroup() {
        return null;
    }

    @NotNull
    protected ToggleAction getShowEditorAction() {
        return new ChangeViewModeAction(Layout.SHOW_EDITOR);
    }

    @NotNull
    protected ToggleAction getShowPreviewAction() {
        return new ChangeViewModeAction(Layout.SHOW_PREVIEW);
    }

    @NotNull
    protected ToggleAction getShowEditorAndPreviewAction() {
        return new ChangeViewModeAction(Layout.SHOW_EDITOR_AND_PREVIEW);
    }

    @NotNull
    private String getLayoutPropertyName() {
        String string = this.myName + "Layout";
        if (string == null) {
            TextEditorWithPreview.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.getTextEditor().getFile();
    }

    @NotNull
    public Editor getEditor() {
        Editor editor2 = this.getTextEditor().getEditor();
        if (editor2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(27);
        }
        return editor2;
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable2) {
        if (navigatable2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(28);
        }
        return this.getTextEditor().canNavigateTo(navigatable2);
    }

    public void navigateTo(@NotNull Navigatable navigatable2) {
        if (navigatable2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(29);
        }
        this.getTextEditor().navigateTo(navigatable2);
    }

    protected void handleLayoutChange(boolean isVerticalSplit) {
        if (this.myIsVerticalSplit == isVerticalSplit) {
            return;
        }
        this.myIsVerticalSplit = isVerticalSplit;
        this.myToolbarWrapper.refresh();
        this.mySplitter.setOrientation(this.myIsVerticalSplit);
        this.myComponent.repaint();
    }

    @Nullable
    private static Layout getLayoutForFile(@Nullable VirtualFile file2) {
        if (file2 != null) {
            return (Layout)((Object)file2.getUserData(DEFAULT_LAYOUT_FOR_FILE));
        }
        return null;
    }

    public static void openPreviewForFile(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            TextEditorWithPreview.$$$reportNull$$$0(30);
        }
        if (file2 == null) {
            TextEditorWithPreview.$$$reportNull$$$0(31);
        }
        file2.putUserData(DEFAULT_LAYOUT_FOR_FILE, (Object)Layout.SHOW_PREVIEW);
        FileEditorManager.getInstance((Project)project).openFile(file2, true);
    }

    private static /* synthetic */ void lambda$registerToolbarListeners$0(EditorComponentImpl actualEditor, 1 editorKeyListener) {
        actualEditor.getEditor().getContentComponent().removeKeyListener(editorKeyListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preview";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorName";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLayout";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/TextEditorWithPreview";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetComponentForActions";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/TextEditorWithPreview";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextEditor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewEditor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createRightToolbar";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutPropertyName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createMarkdownToolbarWrapper";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setLayout";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateTo";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "openPreviewForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyMouseListener
    implements AWTEventListener {
        private final LayoutActionsFloatingToolbar toolbar;
        private final Alarm alarm;

        MyMouseListener(LayoutActionsFloatingToolbar toolbar) {
            this.toolbar = toolbar;
            this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)toolbar);
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            boolean isMouseOutsideToolbar;
            boolean bl = isMouseOutsideToolbar = this.toolbar.getMousePosition() == null;
            if (TextEditorWithPreview.this.myComponent.getMousePosition() != null) {
                this.alarm.cancelAllRequests();
                this.toolbar.getVisibilityController().scheduleShow();
                if (isMouseOutsideToolbar) {
                    this.alarm.addRequest(() -> this.toolbar.getVisibilityController().scheduleHide(), 1400);
                }
            } else if (isMouseOutsideToolbar) {
                this.toolbar.getVisibilityController().scheduleHide();
            }
        }
    }

    private static class MyEditorLayeredComponentWrapper
    extends JBLayeredPane {
        private final JComponent editorComponent;
        static final int toolbarTopPadding = 25;
        static final int toolbarRightPadding = 20;

        private MyEditorLayeredComponentWrapper(JComponent component2) {
            this.editorComponent = component2;
        }

        public void doLayout() {
            Component[] components = this.getComponents();
            Rectangle bounds2 = this.getBounds();
            for (Component component2 : components) {
                if (component2 == this.editorComponent) {
                    component2.setBounds(0, 0, bounds2.width, bounds2.height);
                    continue;
                }
                Dimension preferredComponentSize = component2.getPreferredSize();
                int x = 0;
                int y = 0;
                if (component2 instanceof LayoutActionsFloatingToolbar) {
                    x = bounds2.width - preferredComponentSize.width - 20;
                    y = 25;
                }
                component2.setBounds(x, y, preferredComponentSize.width, preferredComponentSize.height);
            }
        }

        public Dimension getPreferredSize() {
            return this.editorComponent.getPreferredSize();
        }
    }

    private class ChangeViewModeAction
    extends ToggleAction
    implements DumbAware {
        private final Layout myActionLayout;

        ChangeViewModeAction(Layout layout) {
            super(layout.getName(), layout.getName(), layout.getIcon(TextEditorWithPreview.this));
            this.myActionLayout = layout;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeViewModeAction.$$$reportNull$$$0(0);
            }
            return TextEditorWithPreview.this.myLayout == this.myActionLayout;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ChangeViewModeAction.$$$reportNull$$$0(1);
            }
            if (state) {
                TextEditorWithPreview.this.setLayout(this.myActionLayout);
            } else if (this.myActionLayout == Layout.SHOW_EDITOR_AND_PREVIEW) {
                TextEditorWithPreview.this.mySplitter.setOrientation(!TextEditorWithPreview.this.myIsVerticalSplit);
                TextEditorWithPreview.this.myIsVerticalSplit = !TextEditorWithPreview.this.myIsVerticalSplit;
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeViewModeAction.$$$reportNull$$$0(2);
            }
            super.update(e);
            e.getPresentation().setIcon(this.myActionLayout.getIcon(TextEditorWithPreview.this));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/fileEditor/TextEditorWithPreview$ChangeViewModeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum Layout {
        SHOW_EDITOR("Editor only", IdeBundle.messagePointer((String)"tab.title.editor.only", (Object[])new Object[0])),
        SHOW_PREVIEW("Preview only", IdeBundle.messagePointer((String)"tab.title.preview.only", (Object[])new Object[0])),
        SHOW_EDITOR_AND_PREVIEW("Editor and Preview", IdeBundle.messagePointer((String)"tab.title.editor.and.preview", (Object[])new Object[0]));

        private final @NotNull Supplier<@Nls String> myName;
        private final String myId;

        private Layout(String id2, Supplier<String> name2) {
            if (name2 == null) {
                Layout.$$$reportNull$$$0(0);
            }
            this.myId = id2;
            this.myName = name2;
        }

        public static Layout fromId(String id2, Layout defaultValue) {
            for (Layout layout : Layout.values()) {
                if (!layout.myId.equals(id2)) continue;
                return layout;
            }
            return defaultValue;
        }

        @Nls
        public String getName() {
            return this.myName.get();
        }

        public Icon getIcon(@Nullable TextEditorWithPreview editor2) {
            if (this == SHOW_EDITOR) {
                return AllIcons.General.LayoutEditorOnly;
            }
            if (this == SHOW_PREVIEW) {
                return AllIcons.General.LayoutPreviewOnly;
            }
            return editor2 != null && editor2.myIsVerticalSplit ? AllIcons.Actions.PreviewDetailsVertically : AllIcons.Actions.PreviewDetails;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/fileEditor/TextEditorWithPreview$Layout", "<init>"));
        }
    }

    private class MyListenersMultimap {
        private final Map<PropertyChangeListener, Pair<Integer, DoublingEventListenerDelegate>> myMap = new HashMap<PropertyChangeListener, Pair<Integer, DoublingEventListenerDelegate>>();

        private MyListenersMultimap() {
        }

        @NotNull
        public DoublingEventListenerDelegate addListenerAndGetDelegate(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                MyListenersMultimap.$$$reportNull$$$0(0);
            }
            if (!this.myMap.containsKey(listener2)) {
                this.myMap.put(listener2, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)1, (Object)new DoublingEventListenerDelegate(listener2)));
            } else {
                Pair<Integer, DoublingEventListenerDelegate> oldPair = this.myMap.get(listener2);
                this.myMap.put(listener2, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)((Integer)oldPair.getFirst() + 1), (Object)((DoublingEventListenerDelegate)oldPair.getSecond())));
            }
            DoublingEventListenerDelegate doublingEventListenerDelegate = (DoublingEventListenerDelegate)this.myMap.get(listener2).getSecond();
            if (doublingEventListenerDelegate == null) {
                MyListenersMultimap.$$$reportNull$$$0(1);
            }
            return doublingEventListenerDelegate;
        }

        @Nullable
        public DoublingEventListenerDelegate removeListenerAndGetDelegate(@NotNull PropertyChangeListener listener2) {
            Pair<Integer, DoublingEventListenerDelegate> oldPair;
            if (listener2 == null) {
                MyListenersMultimap.$$$reportNull$$$0(2);
            }
            if ((oldPair = this.myMap.get(listener2)) == null) {
                return null;
            }
            if ((Integer)oldPair.getFirst() == 1) {
                this.myMap.remove(listener2);
            } else {
                this.myMap.put(listener2, (Pair<Integer, DoublingEventListenerDelegate>)Pair.create((Object)((Integer)oldPair.getFirst() - 1), (Object)((DoublingEventListenerDelegate)oldPair.getSecond())));
            }
            return (DoublingEventListenerDelegate)oldPair.getSecond();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/TextEditorWithPreview$MyListenersMultimap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/TextEditorWithPreview$MyListenersMultimap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addListenerAndGetDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addListenerAndGetDelegate";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removeListenerAndGetDelegate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class DoublingEventListenerDelegate
    implements PropertyChangeListener {
        @NotNull
        private final PropertyChangeListener myDelegate;

        private DoublingEventListenerDelegate(PropertyChangeListener delegate2) {
            if (delegate2 == null) {
                DoublingEventListenerDelegate.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate2;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.myDelegate.propertyChange(new PropertyChangeEvent((Object)TextEditorWithPreview.this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/fileEditor/TextEditorWithPreview$DoublingEventListenerDelegate", "<init>"));
        }
    }

    public static class MyFileEditorState
    implements FileEditorState {
        private final Layout mySplitLayout;
        private final FileEditorState myFirstState;
        private final FileEditorState mySecondState;

        public MyFileEditorState(Layout layout, FileEditorState firstState, FileEditorState secondState) {
            this.mySplitLayout = layout;
            this.myFirstState = firstState;
            this.mySecondState = secondState;
        }

        @Nullable
        public Layout getSplitLayout() {
            return this.mySplitLayout;
        }

        @Nullable
        public FileEditorState getFirstState() {
            return this.myFirstState;
        }

        @Nullable
        public FileEditorState getSecondState() {
            return this.mySecondState;
        }

        public boolean canBeMergedWith(@NotNull FileEditorState otherState, @NotNull FileEditorStateLevel level) {
            if (otherState == null) {
                MyFileEditorState.$$$reportNull$$$0(0);
            }
            if (level == null) {
                MyFileEditorState.$$$reportNull$$$0(1);
            }
            return !(!(otherState instanceof MyFileEditorState) || this.myFirstState != null && !this.myFirstState.canBeMergedWith(((MyFileEditorState)otherState).myFirstState, level) || this.mySecondState != null && !this.mySecondState.canBeMergedWith(((MyFileEditorState)otherState).mySecondState, level));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "otherState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "level";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/fileEditor/TextEditorWithPreview$MyFileEditorState";
            objectArray[2] = "canBeMergedWith";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

