/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorTabColorProvider;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.UniqueNameEditorTabTitleProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorTabPresentationUtil {
    @NotNull
    @NlsContexts.TabTitle
    public static String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file2) {
        String overriddenTitle;
        if (project == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(1);
        }
        if ((overriddenTitle = EditorTabPresentationUtil.getCustomEditorTabTitle(project, file2)) != null) {
            String string = overriddenTitle;
            if (string == null) {
                EditorTabPresentationUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        String uniqueTitle = new UniqueNameEditorTabTitleProvider().getEditorTabTitle(project, file2);
        if (uniqueTitle != null) {
            String string = uniqueTitle;
            if (string == null) {
                EditorTabPresentationUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = file2.getPresentableName();
        if (string == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    @NlsContexts.TabTitle
    public static String getCustomEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(6);
        }
        for (EditorTabTitleProvider provider2 : DumbService.getDumbAwareExtensions((Project)project, EditorTabTitleProvider.EP_NAME)) {
            String result2 = provider2.getEditorTabTitle(project, file2);
            if (!StringUtil.isNotEmpty((String)result2)) continue;
            return result2;
        }
        return null;
    }

    @NotNull
    public static String getUniqueEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file2) {
        String name2;
        if (project == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(8);
        }
        if ((name2 = EditorTabPresentationUtil.getEditorTabTitle(project, file2)).equals(file2.getPresentableName())) {
            String string = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file2);
            if (string == null) {
                EditorTabPresentationUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = name2;
        if (string == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public static Color getEditorTabBackgroundColor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(12);
        }
        for (EditorTabColorProvider provider2 : DumbService.getDumbAwareExtensions((Project)project, EditorTabColorProvider.EP_NAME)) {
            Color result2 = provider2.getEditorTabColor(project, file2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static Color getFileBackgroundColor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            EditorTabPresentationUtil.$$$reportNull$$$0(14);
        }
        for (EditorTabColorProvider provider2 : DumbService.getDumbAwareExtensions((Project)project, EditorTabColorProvider.EP_NAME)) {
            Color result2 = provider2.getProjectViewColor(project, file2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorTabPresentationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorTabPresentationUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorTabTitle";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueEditorTabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTabTitle";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCustomEditorTabTitle";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueEditorTabTitle";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTabBackgroundColor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileBackgroundColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

