/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.EdtDataContext;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.UnlockOption;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.proxy.CommonProxy;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IdeUiServiceImpl
extends IdeUiService {
    public void revealFile(File file2) {
        RevealFileAction.openFile(file2);
    }

    public UnlockOption askForUnlock(@NotNull Project project, List<? extends VirtualFile> files2) {
        NonProjectFileWritingAccessDialog dialog2;
        if (project == null) {
            IdeUiServiceImpl.$$$reportNull$$$0(0);
        }
        if (!(dialog2 = new NonProjectFileWritingAccessDialog(project, files2)).showAndGet()) {
            return null;
        }
        return dialog2.getUnlockOption();
    }

    public boolean isFileRecentlyChanged(Project project, VirtualFile file2) {
        IdeDocumentHistoryImpl documentHistory = (IdeDocumentHistoryImpl)IdeDocumentHistory.getInstance(project);
        return documentHistory.isRecentlyChanged(file2);
    }

    public void logUsageEvent(Class<?> clazz, String groupId2, String eventId) {
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(clazz);
        String factoryClass = pluginInfo.isSafeToReport() ? clazz.getName() : "third.party";
        FeatureUsageData data2 = new FeatureUsageData().addData("factory", factoryClass).addPluginInfo(pluginInfo);
        FUCounterUsageLogger.getInstance().logEvent(groupId2, eventId, data2);
    }

    public void systemNotify(@NlsContexts.SystemNotificationTitle String title2, @NlsContexts.SystemNotificationText String text2) {
        SystemNotifications.getInstance().notify("SessionLogger", title2, StringUtil.stripHtml((String)text2, (boolean)true));
    }

    public DataContext createUiDataContext(Component component2) {
        return new EdtDataContext(component2);
    }

    public Component getComponentFromRecentMouseEvent() {
        return SwingHelper.getComponentFromRecentMouseEvent();
    }

    public void browse(URL url) {
        BrowserUtil.browse((URL)url);
    }

    public void browse(String url) {
        BrowserUtil.browse((String)url);
    }

    public void performActionDumbAwareWithCallbacks(AnAction action2, AnActionEvent event) {
        if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)event, (boolean)false)) {
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action2, (AnActionEvent)event);
        }
    }

    public void notifyByBalloon(Project project, String toolWindowId, MessageType messageType, @Nls String title2, @Nls String fullMessage, @Nls String description, Icon icon2, HyperlinkListener listener2) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        if (toolWindowManager.canShowNotification(toolWindowId)) {
            toolWindowManager.notifyByBalloon(toolWindowId, MessageType.ERROR, fullMessage, icon2, listener2);
        } else {
            Messages.showErrorDialog((Project)project, (String)UIUtil.toHtml((String)description), (String)title2);
        }
    }

    public URLConnection openHttpConnection(String url) throws IOException {
        return HttpConfigurable.getInstance().openConnection(url);
    }

    public SSLSocketFactory getSslSocketFactory() {
        return CertificateManager.getInstance().getSslContext().getSocketFactory();
    }

    public boolean isUseSafeWrite() {
        return GeneralSettings.getInstance().isUseSafeWrite();
    }

    public VirtualFile[] chooseFiles(FileChooserDescriptor descriptor2, Project project, VirtualFile toSelect2) {
        return FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project, (VirtualFile)toSelect2);
    }

    public VirtualFile chooseFile(FileChooserDescriptor descriptor2, JComponent component2, Project project, VirtualFile dir) {
        return FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Component)component2, (Project)project, (VirtualFile)dir);
    }

    public SSLContext getSslContext() {
        return CertificateManager.getInstance().getSslContext();
    }

    public String getProxyLogin() {
        return HttpConfigurable.getInstance().getProxyLogin();
    }

    public String getPlainProxyPassword() {
        return HttpConfigurable.getInstance().getPlainProxyPassword();
    }

    public boolean isProxyAuth() {
        return HttpConfigurable.getInstance().PROXY_AUTHENTICATION;
    }

    public List<Proxy> getProxyList(URL url) {
        return CommonProxy.getInstance().select(url);
    }

    public void prepareURL(String url) throws IOException {
        HttpConfigurable.getInstance().prepareURL(url);
    }

    public boolean showErrorDialog(@NlsContexts.DialogTitle String title2, @NlsContexts.DetailedDescription String message2) {
        return IOExceptionDialog.showErrorDialog((String)title2, (String)message2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/IdeUiServiceImpl", "askForUnlock"));
    }
}

