/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.DynamicBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileEditor.UnlockOption;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.readOnlyHandler.FileListRenderer;
import com.intellij.openapi.vcs.readOnlyHandler.ReadOnlyStatusDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NonProjectFileWritingAccessDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JLabel myListTitle;
    private JList<VirtualFile> myFileList;
    private JRadioButton myUnlockOneButton;
    private JRadioButton myUnlockDirButton;
    private JRadioButton myUnlockAllButton;

    NonProjectFileWritingAccessDialog(@NotNull Project project, @NotNull List<? extends VirtualFile> nonProjectFiles) {
        if (project == null) {
            NonProjectFileWritingAccessDialog.$$$reportNull$$$0(0);
        }
        if (nonProjectFiles == null) {
            NonProjectFileWritingAccessDialog.$$$reportNull$$$0(1);
        }
        super(project);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(IdeBundle.message((String)"dialog.title.non.project.files.protection", (Object[])objectArray));
        this.myFileList.setPreferredSize(ReadOnlyStatusDialog.getDialogPreferredSize());
        this.myFileList.setCellRenderer(new FileListRenderer());
        this.myFileList.setModel((ListModel<VirtualFile>)new CollectionListModel(nonProjectFiles));
        boolean dirsOnly = nonProjectFiles.stream().allMatch(VirtualFile::isDirectory);
        int size = nonProjectFiles.size();
        String listTitle = dirsOnly ? IdeBundle.message((String)"this.directory.does.not.belong.to.the.project", (Object[])new Object[]{size}) : IdeBundle.message((String)"this.file.does.not.belong.to.the.project", (Object[])new Object[]{size});
        this.myListTitle.setText(listTitle);
        this.myUnlockOneButton.setSelected(true);
        String text2 = dirsOnly ? IdeBundle.message((String)"button.i.want.to.edit.choice.this.directory.anyway", (Object[])new Object[]{size}) : IdeBundle.message((String)"button.i.want.to.edit.choice.this.file.anyway", (Object[])new Object[]{size});
        this.setTextAndMnemonicAndListeners(this.myUnlockOneButton, text2, "edit");
        int dirsSize = ContainerUtil.map2Set(nonProjectFiles, VirtualFile::getParent).size();
        String dirsText = IdeBundle.message((String)"button.i.want.to.edit.all.files.in.choice.this.directory", (Object[])new Object[]{dirsSize});
        this.setTextAndMnemonicAndListeners(this.myUnlockDirButton, dirsText, "dir");
        this.setTextAndMnemonicAndListeners(this.myUnlockAllButton, IdeBundle.message((String)"button.i.want.to.edit.any.non.project.file.in.current.session", (Object[])new Object[0]), "any");
        this.getRootPane().registerKeyboardAction(e -> this.doOKAction(), KeyStroke.getKeyStroke(10, 128), 1);
        this.getRootPane().registerKeyboardAction(e -> this.doOKAction(), KeyStroke.getKeyStroke(10, 256), 1);
        this.init();
    }

    private void setTextAndMnemonicAndListeners(JRadioButton button4, @NlsContexts.RadioButton String text2, String mnemonic) {
        button4.setText(text2);
        button4.setMnemonic(mnemonic.charAt(0));
        button4.setDisplayedMnemonicIndex(button4.getText().indexOf(mnemonic));
        Runnable setDefaultButton = () -> {
            JRootPane rootPane = button4.getRootPane();
            if (rootPane != null) {
                rootPane.setDefaultButton(this.getButton(this.getOKAction()));
            }
        };
        button4.addActionListener(e -> setDefaultButton.run());
        button4.addItemListener(e -> setDefaultButton.run());
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myUnlockOneButton;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NotNull
    public UnlockOption getUnlockOption() {
        if (this.myUnlockAllButton.isSelected()) {
            UnlockOption unlockOption = UnlockOption.UNLOCK_ALL;
            if (unlockOption == null) {
                NonProjectFileWritingAccessDialog.$$$reportNull$$$0(2);
            }
            return unlockOption;
        }
        if (this.myUnlockDirButton.isSelected()) {
            UnlockOption unlockOption = UnlockOption.UNLOCK_DIR;
            if (unlockOption == null) {
                NonProjectFileWritingAccessDialog.$$$reportNull$$$0(3);
            }
            return unlockOption;
        }
        UnlockOption unlockOption = UnlockOption.UNLOCK;
        if (unlockOption == null) {
            NonProjectFileWritingAccessDialog.$$$reportNull$$$0(4);
        }
        return unlockOption;
    }

    protected String getHelpId() {
        return "Non-Project_Files_Access_Dialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonProjectFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessDialog";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnlockOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 1, null, null, null));
        this.myUnlockOneButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/IdeBundle", NonProjectFileWritingAccessDialog.class).getString("radio.button.unlock.one"));
        jPanel3.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUnlockAllButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/IdeBundle", NonProjectFileWritingAccessDialog.class).getString("radio.button.unlock.all"));
        jPanel3.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUnlockDirButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/IdeBundle", NonProjectFileWritingAccessDialog.class).getString("radio.button.unlock.dir"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myListTitle = jLabel = new JLabel();
        jLabel.setText("title");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myFileList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton3);
        buttonGroup2.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

