/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorNavigatable;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.TestEditorSplitter;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

final class TestEditorManagerImpl
extends FileEditorManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(TestEditorManagerImpl.class);
    private final TestEditorSplitter myTestEditorSplitter;
    private final Project myProject;
    private int counter;
    private final Map<VirtualFile, Editor> myVirtualFile2Editor;
    private VirtualFile myActiveFile;
    private static final MyLightVirtualFile LIGHT_VIRTUAL_FILE = new MyLightVirtualFile();

    TestEditorManagerImpl(@NotNull Project project) {
        if (project == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(0);
        }
        this.myTestEditorSplitter = new TestEditorSplitter();
        this.myVirtualFile2Editor = new HashMap<VirtualFile, Editor>();
        this.myProject = project;
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project == TestEditorManagerImpl.this.myProject) {
                    TestEditorManagerImpl.this.closeAllFiles();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$1", "projectClosed"));
            }
        });
        project.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                    for (VirtualFile file2 : TestEditorManagerImpl.this.getOpenFiles()) {
                        if (!VfsUtilCore.isAncestor((VirtualFile)((VFileDeleteEvent)vFileEvent).getFile(), (VirtualFile)file2, (boolean)false)) continue;
                        TestEditorManagerImpl.this.closeFile(file2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$2", "before"));
            }
        });
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, boolean searchForSplitter) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(1);
        }
        return this.openFileInCommand((FileEditorNavigatable)new OpenFileDescriptor(this.myProject, file2));
    }

    @NotNull
    private Pair<FileEditor[], FileEditorProvider[]> openFileImpl3(@NotNull FileEditorNavigatable openFileDescriptor) {
        Editor editor2;
        TextEditor fileEditor;
        VirtualFile file2;
        if (openFileDescriptor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(2);
        }
        boolean isNewEditor = !this.myVirtualFile2Editor.containsKey(file2 = openFileDescriptor.getFile());
        FileEditorProvider provider2 = (FileEditorProvider)file2.getUserData(FileEditorProvider.KEY);
        if (provider2 != null && provider2.accept(this.getProject(), file2)) {
            fileEditor = provider2.createEditor(this.getProject(), file2);
            if (fileEditor instanceof TextEditor) {
                editor2 = fileEditor.getEditor();
                TextEditorProvider.putTextEditor(editor2, fileEditor);
            } else {
                editor2 = null;
            }
        } else {
            editor2 = this.doOpenTextEditor(openFileDescriptor);
            fileEditor = TextEditorProvider.getInstance().getTextEditor(editor2);
            provider2 = TestEditorManagerImpl.getProvider();
        }
        Pair result2 = Pair.create((Object)new FileEditor[]{fileEditor}, (Object)new FileEditorProvider[]{provider2});
        this.myVirtualFile2Editor.put(file2, editor2);
        this.myActiveFile = file2;
        if (editor2 != null) {
            editor2.getSelectionModel().removeSelection();
            if (openFileDescriptor instanceof OpenFileDescriptor) {
                ((OpenFileDescriptor)openFileDescriptor).navigateIn(editor2);
            }
        }
        this.modifyTabWell(() -> {
            this.myTestEditorSplitter.openAndFocusTab(file2, ((FileEditor[])result2.first)[0], ((FileEditorProvider[])result2.second)[0]);
            if (isNewEditor) {
                this.eventPublisher().fileOpened((FileEditorManager)this, file2);
            }
        });
        Pair pair = result2;
        if (pair == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(3);
        }
        return pair;
    }

    private void modifyTabWell(@NotNull Runnable tabWellModification) {
        if (tabWellModification == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(4);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        FileEditor lastFocusedEditor = this.myTestEditorSplitter.getFocusedFileEditor();
        VirtualFile lastFocusedFile = this.myTestEditorSplitter.getFocusedFile();
        FileEditorProvider oldProvider = this.myTestEditorSplitter.getProviderFromFocused();
        tabWellModification.run();
        FileEditor currentlyFocusedEditor = this.myTestEditorSplitter.getFocusedFileEditor();
        VirtualFile currentlyFocusedFile = this.myTestEditorSplitter.getFocusedFile();
        FileEditorProvider newProvider = this.myTestEditorSplitter.getProviderFromFocused();
        FileEditorManagerEvent event = new FileEditorManagerEvent((FileEditorManager)this, lastFocusedFile, lastFocusedEditor, oldProvider, currentlyFocusedFile, currentlyFocusedEditor, newProvider);
        this.eventPublisher().selectionChanged(event);
    }

    @NotNull
    private FileEditorManagerListener eventPublisher() {
        FileEditorManagerListener fileEditorManagerListener = (FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
        if (fileEditorManagerListener == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(5);
        }
        return fileEditorManagerListener;
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, @NotNull EditorWindow window) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(6);
        }
        if (window == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(7);
        }
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileWithProviders(file2, focusEditor, false);
        if (pair == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(8);
        }
        return pair;
    }

    @Override
    public boolean isInsideChange() {
        return false;
    }

    @Override
    @NotNull
    public ActionCallback notifyPublisher(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(9);
        }
        runnable2.run();
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(10);
        }
        return actionCallback;
    }

    @Override
    public EditorsSplitters getSplittersFor(Component c) {
        return null;
    }

    @Override
    public void createSplitter(int orientation, EditorWindow window) {
        String containerName = this.createNewTabbedContainerName();
        this.myTestEditorSplitter.setActiveTabGroup(containerName);
    }

    private String createNewTabbedContainerName() {
        ++this.counter;
        return "SplitTabContainer" + this.counter;
    }

    @Override
    public void changeSplitterOrientation() {
    }

    @Override
    public boolean isInSplitter() {
        return false;
    }

    @Override
    public boolean hasOpenedFile() {
        return false;
    }

    @Override
    public VirtualFile getCurrentFile() {
        return this.myActiveFile;
    }

    @Override
    public FileEditorWithProvider getSelectedEditorWithProvider(@NotNull VirtualFile file2) {
        Editor editor2;
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(11);
        }
        if ((editor2 = this.getEditor(file2)) != null) {
            TextEditorProvider textEditorProvider = TextEditorProvider.getInstance();
            FileEditorProvider provider2 = Optional.ofNullable((FileEditorProvider)editor2.getUserData(FileEditorProvider.KEY)).orElse(textEditorProvider);
            TextEditor fileEditor = textEditorProvider.getTextEditor(editor2);
            return new FileEditorWithProvider((FileEditor)fileEditor, provider2);
        }
        return null;
    }

    @Override
    public boolean isChanged(@NotNull EditorComposite editor2) {
        if (editor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(12);
        }
        return false;
    }

    @Override
    public EditorWindow getNextWindow(@NotNull EditorWindow window) {
        if (window == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(13);
        }
        return null;
    }

    @Override
    public EditorWindow getPrevWindow(@NotNull EditorWindow window) {
        if (window == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(14);
        }
        return null;
    }

    public void addTopComponent(@NotNull FileEditor editor2, @NotNull JComponent component2) {
        if (editor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(15);
        }
        if (component2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(16);
        }
    }

    public void removeTopComponent(@NotNull FileEditor editor2, @NotNull JComponent component2) {
        if (editor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(17);
        }
        if (component2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(18);
        }
    }

    public void addBottomComponent(@NotNull FileEditor editor2, @NotNull JComponent component2) {
        if (editor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(19);
        }
        if (component2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(20);
        }
    }

    public void removeBottomComponent(@NotNull FileEditor editor2, @NotNull JComponent component2) {
        if (editor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(21);
        }
        if (component2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(22);
        }
    }

    @Override
    public void closeAllFiles() {
        for (VirtualFile file2 : this.getOpenFiles()) {
            this.closeFile(file2);
        }
    }

    private static FileEditorProvider getProvider() {
        return new FileEditorProvider(){

            public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return false;
            }

            @NotNull
            public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
                if (project == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    3.$$$reportNull$$$0(3);
                }
                throw new IncorrectOperationException();
            }

            public void disposeEditor(@NotNull FileEditor editor2) {
                if (editor2 == null) {
                    3.$$$reportNull$$$0(4);
                }
            }

            @NotNull
            public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file2) {
                if (sourceElement == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (project == null) {
                    3.$$$reportNull$$$0(6);
                }
                if (file2 == null) {
                    3.$$$reportNull$$$0(7);
                }
                throw new IncorrectOperationException();
            }

            @NotNull
            public String getEditorTypeId() {
                return "";
            }

            @NotNull
            public FileEditorPolicy getPolicy() {
                throw new IncorrectOperationException();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sourceElement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "accept";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createEditor";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "disposeEditor";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "readState";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public EditorWindow getCurrentWindow() {
        return null;
    }

    @Override
    @NotNull
    public Promise<EditorWindow> getActiveWindow() {
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(23);
        }
        return promise;
    }

    @Override
    public void setCurrentWindow(EditorWindow window) {
    }

    @Override
    public VirtualFile getFile(@NotNull FileEditor editor2) {
        if (editor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(24);
        }
        return LIGHT_VIRTUAL_FILE;
    }

    @Override
    public void unsplitWindow() {
    }

    @Override
    public void unsplitAllWindow() {
    }

    @Override
    public EditorWindow @NotNull [] getWindows() {
        return new EditorWindow[0];
    }

    public FileEditor getSelectedEditor(@NotNull VirtualFile file2) {
        Editor editor2;
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(25);
        }
        if ((editor2 = this.getEditor(file2)) != null) {
            return TextEditorProvider.getInstance().getTextEditor(editor2);
        }
        Pair<FileEditor, FileEditorProvider> editorAndProvider = this.myTestEditorSplitter.getEditorAndProvider(file2);
        if (editorAndProvider != null) {
            return (FileEditor)editorAndProvider.first;
        }
        return null;
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(26);
        }
        return this.getEditor(file2) != null;
    }

    public FileEditor @NotNull [] getEditors(@NotNull VirtualFile file2) {
        FileEditor e;
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(27);
        }
        if ((e = this.getSelectedEditor(file2)) == null) {
            if (FileEditor.EMPTY_ARRAY == null) {
                TestEditorManagerImpl.$$$reportNull$$$0(28);
            }
            return FileEditor.EMPTY_ARRAY;
        }
        FileEditor[] fileEditorArray = new FileEditor[]{e};
        if (fileEditorArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(29);
        }
        return fileEditorArray;
    }

    public FileEditor @NotNull [] getAllEditors(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(30);
        }
        FileEditor[] fileEditorArray = this.getEditors(file2);
        if (fileEditorArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(31);
        }
        return fileEditorArray;
    }

    @Override
    public VirtualFile @NotNull [] getSiblings(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(32);
        }
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        this.closeAllFiles();
        LIGHT_VIRTUAL_FILE.clearUserDataOnDispose();
    }

    public void closeFile(@NotNull VirtualFile file2) {
        Editor editor2;
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(33);
        }
        if ((editor2 = this.myVirtualFile2Editor.remove(file2)) != null) {
            TextEditorProvider editorProvider = TextEditorProvider.getInstance();
            editorProvider.disposeEditor((FileEditor)editorProvider.getTextEditor(editor2));
            if (!editor2.isDisposed()) {
                EditorFactory.getInstance().releaseEditor(editor2);
            }
            if (!this.myProject.isDisposed()) {
                this.eventPublisher().fileClosed((FileEditorManager)this, file2);
            }
        }
        if (Comparing.equal((Object)file2, (Object)this.myActiveFile)) {
            this.myActiveFile = null;
        }
        this.modifyTabWell(() -> this.myTestEditorSplitter.closeFile(file2));
    }

    @Override
    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(34);
        }
        if (window == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(35);
        }
        this.closeFile(file2);
    }

    public VirtualFile @NotNull [] getSelectedFiles() {
        VirtualFile[] virtualFileArray;
        if (this.myActiveFile == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = this.myActiveFile;
        }
        if (virtualFileArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(36);
        }
        return virtualFileArray;
    }

    public FileEditor @NotNull [] getSelectedEditors() {
        FileEditor[] fileEditorArray = this.myActiveFile == null ? FileEditor.EMPTY_ARRAY : this.getEditors(this.myActiveFile);
        if (fileEditorArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(37);
        }
        return fileEditorArray;
    }

    public Editor getSelectedTextEditor() {
        return this.myActiveFile != null ? this.getEditor(this.myActiveFile) : null;
    }

    @Override
    public JComponent getComponent() {
        return new JLabel();
    }

    public VirtualFile @NotNull [] getOpenFiles() {
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(this.myVirtualFile2Editor.keySet());
        if (virtualFileArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(38);
        }
        return virtualFileArray;
    }

    public Editor getEditor(VirtualFile file2) {
        return this.myVirtualFile2Editor.get(file2);
    }

    public FileEditor @NotNull [] getAllEditors() {
        FileEditor[] result2 = new FileEditor[this.myVirtualFile2Editor.size()];
        int i2 = 0;
        for (Map.Entry<VirtualFile, Editor> entry2 : this.myVirtualFile2Editor.entrySet()) {
            TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(entry2.getValue());
            result2[i2++] = textEditor;
        }
        if (result2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(39);
        }
        return result2;
    }

    public Editor openTextEditor(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor) {
        if (descriptor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(40);
        }
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileInCommand((FileEditorNavigatable)descriptor2);
        for (FileEditor editor2 : (FileEditor[])pair.first) {
            if (!(editor2 instanceof TextEditor)) continue;
            return ((TextEditor)editor2).getEditor();
        }
        return null;
    }

    @NotNull
    private Pair<FileEditor[], FileEditorProvider[]> openFileInCommand(@NotNull FileEditorNavigatable descriptor2) {
        if (descriptor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(41);
        }
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> result2.set(this.openFileImpl3(descriptor2)), "", null);
        Pair pair = (Pair)result2.get();
        if (pair == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(42);
        }
        return pair;
    }

    @NotNull
    private Editor doOpenTextEditor(@NotNull FileEditorNavigatable descriptor2) {
        VirtualFile file2;
        Editor editor2;
        if (descriptor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(43);
        }
        if ((editor2 = this.myVirtualFile2Editor.get(file2 = descriptor2.getFile())) == null) {
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            LOG.assertTrue(document != null, (Object)file2);
            EditorFactory editorFactory = EditorFactory.getInstance();
            editor2 = editorFactory.createEditor(document, this.myProject);
            try {
                EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)this.myProject, (VirtualFile)file2);
                Language language2 = TextEditorImpl.getDocumentLanguage(editor2);
                editor2.getSettings().setLanguageSupplier(() -> language2);
                EditorEx editorEx = (EditorEx)editor2;
                editorEx.setHighlighter(highlighter);
                editorEx.setFile(file2);
            }
            catch (Throwable e) {
                editorFactory.releaseEditor(editor2);
                throw e;
            }
        }
        Editor editor3 = editor2;
        if (editor3 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(44);
        }
        return editor3;
    }

    @NotNull
    public List<FileEditor> openFileEditor(@NotNull FileEditorNavigatable descriptor2, boolean focusEditor) {
        if (descriptor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(45);
        }
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileInCommand(descriptor2);
        List<FileEditor> list2 = Arrays.asList((FileEditor[])pair.first);
        if (list2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(46);
        }
        return list2;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(47);
        }
        return project;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(48);
        }
        Pair<FileEditor, FileEditorProvider> editorAndProvider = this.myTestEditorSplitter.getEditorAndProvider(file2);
        FileEditor[] fileEditor = FileEditor.EMPTY_ARRAY;
        FileEditorProvider[] fileEditorProvider = new FileEditorProvider[]{};
        if (editorAndProvider != null) {
            fileEditor = new FileEditor[]{(FileEditor)editorAndProvider.first};
            fileEditorProvider = new FileEditorProvider[]{(FileEditorProvider)editorAndProvider.second};
        }
        Pair pair = Pair.create((Object)fileEditor, (Object)fileEditorProvider);
        if (pair == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(49);
        }
        return pair;
    }

    @Override
    public int getWindowSplitCount() {
        return 0;
    }

    @Override
    public boolean hasSplitOrUndockedWindows() {
        return false;
    }

    @Override
    @NotNull
    public EditorsSplitters getSplitters() {
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(50);
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(51);
        }
        return actionCallback;
    }

    public void setSelectedEditor(@NotNull VirtualFile file2, @NotNull String fileEditorProviderId) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(52);
        }
        if (fileEditorProviderId == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(53);
        }
        if (this.myVirtualFile2Editor.containsKey(file2)) {
            this.modifyTabWell(() -> {
                this.myActiveFile = file2;
                this.myTestEditorSplitter.setFocusedFile(file2);
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 23: 
            case 28: 
            case 29: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 23: 
            case 28: 
            case 29: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openFileDescriptor";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 23: 
            case 28: 
            case 29: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabWellModification";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 40: 
            case 41: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorProviderId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileImpl3";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "eventPublisher";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileWithProviders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyPublisher";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 31: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEditors";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditors";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFiles";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileInCommand";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "doOpenTextEditor";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileEditor";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsWithProviders";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openFileWithProviders";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "openFileImpl3";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 23: 
            case 28: 
            case 29: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "modifyTabWell";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "notifyPublisher";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEditorWithProvider";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isChanged";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNextWindow";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPrevWindow";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addTopComponent";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeTopComponent";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addBottomComponent";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeBottomComponent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEditor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isFileOpen";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAllEditors";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getSiblings";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "closeFile";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "openTextEditor";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "openFileInCommand";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "doOpenTextEditor";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "openFileEditor";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsWithProviders";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 23: 
            case 28: 
            case 29: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLightVirtualFile
    extends LightVirtualFile {
        MyLightVirtualFile() {
            super("Dummy.java");
        }

        void clearUserDataOnDispose() {
            this.clearUserData();
        }
    }
}

