/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.LanguageSyntaxHighlighters;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterLanguageFactory;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.messages.MessageBusConnection;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class EditorHighlighterUpdater {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final EditorEx myEditor;
    @Nullable
    private final VirtualFile myFile;

    public EditorHighlighterUpdater(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull EditorEx editor2, @Nullable VirtualFile file2) {
        if (project == null) {
            EditorHighlighterUpdater.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            EditorHighlighterUpdater.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            EditorHighlighterUpdater.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myEditor = editor2;
        this.myFile = file2;
        MessageBusConnection connection = project.getMessageBus().connect(parentDisposable);
        connection.subscribe(FileTypeManager.TOPIC, (Object)new MyFileTypeListener());
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                EditorHighlighterUpdater.this.updateHighlighters();
            }

            public void exitDumbMode() {
                EditorHighlighterUpdater.this.updateHighlighters();
            }
        });
        this.updateHighlightersOnExtensionsChange(parentDisposable, LanguageSyntaxHighlighters.EP_NAME);
        this.updateHighlightersOnExtensionsChange(parentDisposable, SyntaxHighlighterLanguageFactory.EP_NAME);
        this.updateHighlightersOnExtensionsChange(parentDisposable, FileTypeEditorHighlighterProviders.EP_NAME);
        SyntaxHighlighter.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<KeyedFactoryEPBean>(){

            public void extensionAdded(@NotNull KeyedFactoryEPBean extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                EditorHighlighterUpdater.this.checkUpdateHighlighters(extension2.key, false);
            }

            public void extensionRemoved(@NotNull KeyedFactoryEPBean extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                EditorHighlighterUpdater.this.checkUpdateHighlighters(extension2.key, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/EditorHighlighterUpdater$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, parentDisposable);
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                FileType fileType;
                IdeaPluginDescriptor loadedPluginDescriptor;
                ClassLoader pluginClassLoader;
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                ClassLoader classLoader = pluginClassLoader = (loadedPluginDescriptor = PluginManagerCore.getPlugin(pluginDescriptor.getPluginId())) != null ? loadedPluginDescriptor.getPluginClassLoader() : null;
                if (EditorHighlighterUpdater.this.myFile != null && pluginClassLoader instanceof PluginAwareClassLoader && ((fileType = EditorHighlighterUpdater.this.myFile.getFileType()).getClass().getClassLoader() == pluginClassLoader || fileType instanceof LanguageFileType && ((LanguageFileType)fileType).getClass().getClassLoader() == pluginClassLoader)) {
                    EditorHighlighterUpdater.this.myEditor.setHighlighter(EditorHighlighterUpdater.this.createHighlighter(true));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/fileEditor/impl/text/EditorHighlighterUpdater$3", "beforePluginUnload"));
            }
        });
    }

    private <T> void updateHighlightersOnExtensionsChange(@NotNull Disposable parentDisposable, @NotNull ExtensionPointName<KeyedLazyInstance<T>> epName) {
        if (parentDisposable == null) {
            EditorHighlighterUpdater.$$$reportNull$$$0(3);
        }
        if (epName == null) {
            EditorHighlighterUpdater.$$$reportNull$$$0(4);
        }
        epName.addExtensionPointListener(new ExtensionPointListener<KeyedLazyInstance<T>>(){

            public void extensionAdded(@NotNull KeyedLazyInstance<T> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(1);
                }
                EditorHighlighterUpdater.this.checkUpdateHighlighters(extension2.getKey(), false);
            }

            public void extensionRemoved(@NotNull KeyedLazyInstance<T> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(3);
                }
                EditorHighlighterUpdater.this.checkUpdateHighlighters(extension2.getKey(), true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/EditorHighlighterUpdater$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, parentDisposable);
    }

    private void checkUpdateHighlighters(String key, boolean updateSynchronously) {
        if (this.myFile != null) {
            boolean needUpdate;
            FileType fileType = this.myFile.getFileType();
            boolean bl = needUpdate = fileType.getName().equals(key) || fileType instanceof LanguageFileType && ((LanguageFileType)fileType).getLanguage().getID().equals(key);
            if (!needUpdate) {
                return;
            }
        }
        if (ApplicationManager.getApplication().isDispatchThread() && updateSynchronously) {
            this.updateHighlightersSynchronously();
        } else {
            this.updateHighlighters();
        }
    }

    public void updateHighlightersAsync() {
        ReadAction.nonBlocking(() -> this.createHighlighter(false)).expireWith((Disposable)this.myProject).expireWhen(() -> this.myFile != null && !this.myFile.isValid() || this.myEditor.isDisposed()).coalesceBy(new Object[]{EditorHighlighterUpdater.class, this.myEditor}).finishOnUiThread(ModalityState.any(), highlighter -> this.myEditor.setHighlighter((EditorHighlighter)highlighter)).submit((Executor)NonUrgentExecutor.getInstance());
    }

    @NotNull
    protected EditorHighlighter createHighlighter(boolean forceEmpty) {
        EmptyEditorHighlighter highlighter = this.myFile != null && !forceEmpty ? EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, this.myFile) : new EmptyEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme(), HighlighterColors.TEXT);
        highlighter.setText(this.myEditor.getDocument().getImmutableCharSequence());
        EmptyEditorHighlighter emptyEditorHighlighter = highlighter;
        if (emptyEditorHighlighter == null) {
            EditorHighlighterUpdater.$$$reportNull$$$0(5);
        }
        return emptyEditorHighlighter;
    }

    public void updateHighlighters() {
        if (!this.myProject.isDisposed() && !this.myEditor.isDisposed()) {
            this.updateHighlightersAsync();
        }
    }

    private void updateHighlightersSynchronously() {
        if (!this.myProject.isDisposed() && !this.myEditor.isDisposed()) {
            this.myEditor.setHighlighter(this.createHighlighter(false));
        }
    }

    @TestOnly
    public static void completeAsyncTasks() {
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/EditorHighlighterUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/EditorHighlighterUpdater";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateHighlightersOnExtensionsChange";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyFileTypeListener
    implements FileTypeListener {
        private MyFileTypeListener() {
        }

        public void fileTypesChanged(@NotNull FileTypeEvent event) {
            if (event == null) {
                MyFileTypeListener.$$$reportNull$$$0(0);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            FileType type = event.getRemovedFileType();
            if (type != null && !(type instanceof AbstractFileType)) {
                EditorHighlighterUpdater.this.updateHighlightersSynchronously();
            } else {
                EditorHighlighterUpdater.this.updateHighlighters();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/text/EditorHighlighterUpdater$MyFileTypeListener", "fileTypesChanged"));
        }
    }
}

