/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.IdeView;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.InjectedDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.EditorDataProvider;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedCaret;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorPsiDataProvider
implements EditorDataProvider {
    @Nullable
    public Object getData(@NotNull String dataId, @NotNull Editor e, @NotNull Caret caret) {
        if (dataId == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(0);
        }
        if (e == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(1);
        }
        if (caret == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(2);
        }
        if (e.isDisposed() || !(e instanceof EditorEx)) {
            return null;
        }
        VirtualFile file2 = ((EditorEx)e).getVirtualFile();
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        if (LangDataKeys.HOST_EDITOR.is(dataId)) {
            return e instanceof EditorWindow ? ((EditorWindow)e).getDelegate() : e;
        }
        if (LangDataKeys.CARET.is(dataId)) {
            return caret;
        }
        if (LangDataKeys.PSI_FILE.is(dataId)) {
            return TextEditorPsiDataProvider.getPsiFile(e, file2);
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            PsiDirectory psiDirectory;
            Project project = e.getProject();
            PsiFile psiFile = project == null ? null : PsiManager.getInstance((Project)project).findFile(file2);
            PsiDirectory psiDirectory2 = psiDirectory = psiFile == null ? null : psiFile.getParent();
            if (psiDirectory != null && (psiDirectory.isPhysical() || ApplicationManager.getApplication().isUnitTestMode())) {
                return new IdeView(){

                    public void selectElement(PsiElement element2) {
                        NavigationUtil.activateFileWithPsiElement(element2);
                    }

                    public PsiDirectory @NotNull [] getDirectories() {
                        PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{psiDirectory};
                        if (psiDirectoryArray == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return psiDirectoryArray;
                    }

                    public PsiDirectory getOrChooseDirectory() {
                        return psiDirectory;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorPsiDataProvider$1", "getDirectories"));
                    }
                };
            }
        }
        if (PlatformCoreDataKeys.SLOW_DATA_PROVIDERS.is(dataId)) {
            return Collections.singletonList(o -> this.getSlowData(o, e, caret));
        }
        return null;
    }

    @Nullable
    private Object getSlowData(@NotNull String dataId, @NotNull Editor e, @NotNull Caret caret) {
        if (dataId == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(3);
        }
        if (e == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(4);
        }
        if (caret == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(5);
        }
        if (e.isDisposed() || !(e instanceof EditorEx)) {
            return null;
        }
        VirtualFile file2 = ((EditorEx)e).getVirtualFile();
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        Project project = e.getProject();
        if (LangDataKeys.PSI_FILE.is(dataId)) {
            return TextEditorPsiDataProvider.getPsiFile(e, file2);
        }
        if (InjectedDataKeys.EDITOR.is(dataId)) {
            if (project != null && PsiDocumentManager.getInstance((Project)project).isCommitted(e.getDocument()) && InjectedLanguageManager.getInstance((Project)project).mightHaveInjectedFragmentAtOffset(e.getDocument(), caret.getOffset())) {
                return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(e, caret, TextEditorPsiDataProvider.getPsiFile(e, file2));
            }
            return null;
        }
        if (InjectedDataKeys.CARET.is(dataId)) {
            return this.querySlowInjectedCaret(e, caret);
        }
        if (InjectedDataKeys.VIRTUAL_FILE.is(dataId)) {
            PsiFile psiFile = this.querySlowInjectedPsiFile(e, caret);
            if (psiFile == null) {
                return null;
            }
            return psiFile.getVirtualFile();
        }
        if (InjectedDataKeys.PSI_FILE.is(dataId)) {
            EditorWindow editor2 = this.querySlowInjectedEditor(e, caret);
            if (editor2 == null || project == null) {
                return null;
            }
            return PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        }
        if (InjectedDataKeys.PSI_ELEMENT.is(dataId)) {
            EditorWindow editor3 = this.querySlowInjectedEditor(e, caret);
            if (editor3 == null) {
                return null;
            }
            InjectedCaret injectedCaret = TextEditorPsiDataProvider.getInjectedCaret(editor3, caret);
            return injectedCaret == null ? null : TextEditorPsiDataProvider.getPsiElementIn(editor3, injectedCaret, file2);
        }
        if (LangDataKeys.PSI_ELEMENT.is(dataId)) {
            return TextEditorPsiDataProvider.getPsiElementIn(e, caret, file2);
        }
        if (InjectedDataKeys.LANGUAGE.is(dataId)) {
            PsiFile psiFile = this.querySlowInjectedPsiFile(e, caret);
            if (psiFile == null) {
                return null;
            }
            InjectedCaret injectedCaret = this.querySlowInjectedCaret(e, caret);
            return injectedCaret == null ? null : TextEditorPsiDataProvider.getLanguageAtCurrentPositionInEditor(injectedCaret, psiFile);
        }
        if (LangDataKeys.LANGUAGE.is(dataId)) {
            PsiFile psiFile = TextEditorPsiDataProvider.getPsiFile(e, file2);
            if (psiFile == null) {
                return null;
            }
            return TextEditorPsiDataProvider.getLanguageAtCurrentPositionInEditor(caret, psiFile);
        }
        if (LangDataKeys.CONTEXT_LANGUAGES.is(dataId)) {
            LinkedHashSet set2 = new LinkedHashSet(4);
            Language injectedLanguage = (Language)this.getSlowData(InjectedDataKeys.LANGUAGE.getName(), e, caret);
            ContainerUtil.addIfNotNull(set2, (Object)injectedLanguage);
            Language language2 = (Language)this.getSlowData(LangDataKeys.LANGUAGE.getName(), e, caret);
            ContainerUtil.addIfNotNull(set2, (Object)language2);
            PsiFile psiFile = (PsiFile)this.getData(LangDataKeys.PSI_FILE.getName(), e, caret);
            if (psiFile != null) {
                ContainerUtil.addIfNotNull(set2, (Object)psiFile.getViewProvider().getBaseLanguage());
            }
            return set2.toArray(new Language[0]);
        }
        return null;
    }

    private EditorWindow querySlowInjectedEditor(@NotNull Editor e, @NotNull Caret caret) {
        Object editor2;
        if (e == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(6);
        }
        if (caret == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(7);
        }
        return (editor2 = this.getSlowData(InjectedDataKeys.EDITOR.getName(), e, caret)) instanceof EditorWindow ? (EditorWindow)editor2 : null;
    }

    private InjectedCaret querySlowInjectedCaret(@NotNull Editor e, @NotNull Caret caret) {
        EditorWindow editor2;
        if (e == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(8);
        }
        if (caret == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(9);
        }
        return (editor2 = this.querySlowInjectedEditor(e, caret)) == null ? null : TextEditorPsiDataProvider.getInjectedCaret(editor2, caret);
    }

    private PsiFile querySlowInjectedPsiFile(@NotNull Editor e, @NotNull Caret caret) {
        if (e == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(10);
        }
        if (caret == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(11);
        }
        return (PsiFile)this.getSlowData(InjectedDataKeys.PSI_FILE.getName(), e, caret);
    }

    private static InjectedCaret getInjectedCaret(@NotNull EditorWindow editor2, @NotNull Caret hostCaret) {
        if (editor2 == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(12);
        }
        if (hostCaret == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(13);
        }
        if (hostCaret instanceof InjectedCaret) {
            return (InjectedCaret)hostCaret;
        }
        for (Caret caret : editor2.getCaretModel().getAllCarets()) {
            if (((InjectedCaret)caret).getDelegate() != hostCaret) continue;
            return (InjectedCaret)caret;
        }
        throw new IllegalArgumentException("Cannot find injected caret corresponding to " + hostCaret);
    }

    private static Language getLanguageAtCurrentPositionInEditor(Caret caret, PsiFile psiFile) {
        int mostProbablyCorrectLanguageOffset;
        int caretOffset = caret.getOffset();
        int n = mostProbablyCorrectLanguageOffset = caretOffset == caret.getSelectionStart() || caretOffset == caret.getSelectionEnd() ? caret.getSelectionStart() : caretOffset;
        if (caret.hasSelection()) {
            return TextEditorPsiDataProvider.getLanguageAtOffset(psiFile, mostProbablyCorrectLanguageOffset, caret.getSelectionEnd());
        }
        return PsiUtilCore.getLanguageAtOffset((PsiFile)psiFile, (int)mostProbablyCorrectLanguageOffset);
    }

    private static Language getLanguageAtOffset(PsiFile psiFile, int mostProbablyCorrectLanguageOffset, int end) {
        int incremented;
        PsiElement elt = psiFile.findElementAt(mostProbablyCorrectLanguageOffset);
        if (elt == null) {
            return psiFile.getLanguage();
        }
        if (elt instanceof PsiWhiteSpace && (incremented = elt.getTextRange().getEndOffset() + 1) <= end) {
            return TextEditorPsiDataProvider.getLanguageAtOffset(psiFile, incremented, end);
        }
        return PsiUtilCore.findLanguageFromElement((PsiElement)elt);
    }

    @Nullable
    private static PsiElement getPsiElementIn(@NotNull Editor editor2, @NotNull Caret caret, @NotNull VirtualFile file2) {
        PsiFile psiFile;
        if (editor2 == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(14);
        }
        if (caret == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(16);
        }
        if ((psiFile = TextEditorPsiDataProvider.getPsiFile(editor2, file2)) == null) {
            return null;
        }
        try {
            TargetElementUtil util = TargetElementUtil.getInstance();
            return util.findTargetElement(editor2, util.getReferenceSearchFlags(), caret.getOffset());
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Nullable
    private static PsiFile getPsiFile(@NotNull Editor e, @NotNull VirtualFile file2) {
        if (e == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            TextEditorPsiDataProvider.$$$reportNull$$$0(18);
        }
        if (!file2.isValid()) {
            return null;
        }
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        return psiFile != null && psiFile.isValid() ? psiFile : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostCaret";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/TextEditorPsiDataProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSlowData";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "querySlowInjectedEditor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "querySlowInjectedCaret";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "querySlowInjectedPsiFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getInjectedCaret";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiElementIn";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

