/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginConflictReporter;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.plugins.StartupAbortedException;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.ex.DetectedByContentFileType;
import com.intellij.openapi.fileTypes.ex.ExternalizableFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.ConflictingFileTypeMappingTracker;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.FileTypeBean;
import com.intellij.openapi.fileTypes.impl.FileTypeDetectionService;
import com.intellij.openapi.fileTypes.impl.FileTypeOverrider;
import com.intellij.openapi.fileTypes.impl.IgnoredFileCache;
import com.intellij.openapi.fileTypes.impl.IgnoredPatternSet;
import com.intellij.openapi.fileTypes.impl.RemovedMappingTracker;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserExtensionsStateService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.CachedFileType;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

@State(name="FileTypeManager", storages={@Storage(value="filetypes.xml")}, additionalExportDirectory="filetypes", category=SettingsCategory.CODE)
public class FileTypeManagerImpl
extends FileTypeManagerEx
implements PersistentStateComponent<Element>,
Disposable {
    static final ExtensionPointName<FileTypeBean> EP_NAME = new ExtensionPointName("com.intellij.fileType");
    private static final Logger LOG = Logger.getInstance(FileTypeManagerImpl.class);
    static final int VERSION = 18;
    static final String DEFAULT_IGNORED = "*.pyc;*.pyo;*.rbc;*.yarb;*~;.DS_Store;.git;.hg;.svn;CVS;__pycache__;_svn;vssver.scc;vssver2.scc";
    static final String FILE_SPEC = "filetypes";
    private static final String ELEMENT_EXTENSION_MAP = "extensionMap";
    private static final String ELEMENT_FILETYPE = "filetype";
    private static final String ELEMENT_IGNORE_FILES = "ignoreFiles";
    private static final String ATTRIBUTE_LIST = "list";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String[] FILE_TYPES_WITH_PREDEFINED_EXTENSIONS = new String[]{"JSP", "JSPX", "DTD", "HTML", "Properties", "XHTML"};
    private static final ThreadLocal<Pair<VirtualFile, FileType>> FILE_TYPE_FIXED_TEMPORARILY = new ThreadLocal();
    private final Set<FileTypeWithDescriptor> myDefaultTypes = CollectionFactory.createSmallMemoryFootprintSet();
    private final FileTypeDetectionService myDetectionService;
    private FileTypeIdentifiableByVirtualFile[] mySpecialFileTypes = FileTypeIdentifiableByVirtualFile.EMPTY_ARRAY;
    FileTypeAssocTable<FileTypeWithDescriptor> myPatternsTable = new FileTypeAssocTable();
    private final IgnoredPatternSet myIgnoredPatterns = new IgnoredPatternSet();
    private final IgnoredFileCache myIgnoredFileCache = new IgnoredFileCache(this.myIgnoredPatterns);
    private final FileTypeAssocTable<FileType> myInitialAssociations = new FileTypeAssocTable();
    private final Map<FileNameMatcher, String> myUnresolvedMappings = new HashMap<FileNameMatcher, String>();
    private final Map<String, String> myUnresolvedHashBangs = new HashMap<String, String>();
    private final RemovedMappingTracker myRemovedMappingTracker = new RemovedMappingTracker();
    private final ConflictingFileTypeMappingTracker myConflictingMappingTracker = new ConflictingFileTypeMappingTracker(this.myRemovedMappingTracker);
    private final Map<String, FileTypeBean> myPendingFileTypes = new LinkedHashMap<String, FileTypeBean>();
    private final FileTypeAssocTable<FileTypeBean> myPendingAssociations = new FileTypeAssocTable();
    private final ReadWriteLock myPendingInitializationLock = new ReentrantReadWriteLock();
    private final Map<PluginDescriptor, Map<String, FileTypeWithDescriptor>> myNames = new ConcurrentHashMap<PluginDescriptor, Map<String, FileTypeWithDescriptor>>();
    private final Map<PluginDescriptor, Map<String, FileTypeWithDescriptor>> myDescriptions = new ConcurrentHashMap<PluginDescriptor, Map<String, FileTypeWithDescriptor>>();
    private final Map<PluginDescriptor, Map<String, FileTypeWithDescriptor>> myDisplayNames = new ConcurrentHashMap<PluginDescriptor, Map<String, FileTypeWithDescriptor>>();
    @Nullable
    private Consumer<? super ConflictingFileTypeMappingTracker.ResolveConflictResult> myConflictResultConsumer;
    private final Map<String, StandardFileType> myStandardFileTypes = new LinkedHashMap<String, StandardFileType>();
    private final SchemeManager<FileTypeWithDescriptor> mySchemeManager;

    protected FileTypeManagerImpl() {
        NonLazySchemeProcessor<FileTypeWithDescriptor, FileTypeWithDescriptor> abstractTypesProcessor = new NonLazySchemeProcessor<FileTypeWithDescriptor, FileTypeWithDescriptor>(){

            @Override
            @NotNull
            public FileTypeWithDescriptor readScheme(@NotNull Element element2, boolean duringLoad) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                }
                IdeaPluginDescriptor pluginDescriptor = FileTypeManagerImpl.coreIdeaPluginDescriptor();
                AbstractFileType type = (AbstractFileType)FileTypeManagerImpl.this.loadFileType("filetypes.xml", element2, (PluginDescriptor)pluginDescriptor, false);
                if (!duringLoad) {
                    FileTypeManagerImpl.this.fireFileTypesChanged(type, null);
                }
                return new FileTypeWithDescriptor(type, (PluginDescriptor)pluginDescriptor);
            }

            @Override
            @NotNull
            public SchemeState getState(@NotNull FileTypeWithDescriptor ftd) {
                if (ftd == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(ftd.fileType instanceof AbstractFileType) || !FileTypeManagerImpl.shouldSave(ftd.fileType)) {
                    SchemeState schemeState = SchemeState.NON_PERSISTENT;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return schemeState;
                }
                if (!FileTypeManagerImpl.this.myDefaultTypes.contains(ftd)) {
                    SchemeState schemeState = SchemeState.POSSIBLY_CHANGED;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return schemeState;
                }
                SchemeState schemeState = ((AbstractFileType)ftd.fileType).isModified() ? SchemeState.POSSIBLY_CHANGED : SchemeState.NON_PERSISTENT;
                if (schemeState == null) {
                    1.$$$reportNull$$$0(4);
                }
                return schemeState;
            }

            @NotNull
            public Element writeScheme(@NotNull FileTypeWithDescriptor ftd) {
                if (ftd == null) {
                    1.$$$reportNull$$$0(5);
                }
                Element root2 = new Element(FileTypeManagerImpl.ELEMENT_FILETYPE);
                AbstractFileType fileType = (AbstractFileType)ftd.fileType;
                root2.setAttribute("binary", String.valueOf(fileType.isBinary()));
                if (!Strings.isEmpty((String)fileType.getDefaultExtension())) {
                    root2.setAttribute("default_extension", fileType.getDefaultExtension());
                }
                root2.setAttribute(FileTypeManagerImpl.ATTRIBUTE_DESCRIPTION, fileType.getDescription());
                root2.setAttribute(FileTypeManagerImpl.ATTRIBUTE_NAME, fileType.getName());
                fileType.writeExternal(root2);
                Element map2 = new Element(FileTypeManagerImpl.ELEMENT_EXTENSION_MAP);
                FileTypeManagerImpl.this.writeExtensionsMap(map2, ftd, false);
                if (!map2.getChildren().isEmpty()) {
                    root2.addContent(map2);
                }
                Element element2 = root2;
                if (element2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                return element2;
            }

            @Override
            public void onSchemeDeleted(@NotNull FileTypeWithDescriptor scheme2) {
                if (scheme2 == null) {
                    1.$$$reportNull$$$0(7);
                }
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.NON_MODAL, () -> {
                    Application app2 = ApplicationManager.getApplication();
                    app2.runWriteAction(() -> FileTypeManagerImpl.this.fireBeforeFileTypesChanged());
                    FileTypeManagerImpl.this.myPatternsTable.removeAllAssociations((Object)scheme2);
                    app2.runWriteAction(() -> FileTypeManagerImpl.this.fireFileTypesChanged(null, scheme2.fileType));
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ftd";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getState";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "writeScheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "readScheme";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getState";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "writeScheme";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "onSchemeDeleted";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.mySchemeManager = SchemeManagerFactory.getInstance().create(FILE_SPEC, abstractTypesProcessor);
        this.myDetectionService = new FileTypeDetectionService(this);
        Disposer.register((Disposable)this, (Disposable)this.myDetectionService);
        this.myIgnoredPatterns.setIgnoreMasks(DEFAULT_IGNORED);
        EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FileTypeBean>(){

            public void extensionAdded(@NotNull FileTypeBean fileTypeBean, @NotNull PluginDescriptor pluginDescriptor) {
                if (fileTypeBean == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                FileTypeManagerImpl.initializeMatchers(pluginDescriptor, fileTypeBean);
                FileTypeBean pendingFileTypeBean = (FileTypeBean)FileTypeManagerImpl.this.withReadLock(() -> FileTypeManagerImpl.this.myPendingFileTypes.get(fileTypeBean.name));
                if (pendingFileTypeBean != null) {
                    FileTypeManagerImpl.this.instantiateFileTypeBean(pendingFileTypeBean);
                }
                FileType fileType = FileTypeManagerImpl.this.mergeOrInstantiateFileTypeBean(fileTypeBean);
                FileTypeManagerImpl.this.fireFileTypesChanged(fileType, null);
            }

            public void extensionRemoved(@NotNull FileTypeBean extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (extension2.implementationClass != null) {
                    FileType fileType = FileTypeManagerImpl.this.findFileTypeByName(extension2.name);
                    if (fileType != null) {
                        FileTypeManagerImpl.this.doUnregisterFileType(fileType);
                    }
                } else {
                    StandardFileType stdFileType = FileTypeManagerImpl.this.myStandardFileTypes.get(extension2.name);
                    if (stdFileType != null) {
                        FileTypeManagerImpl.this.unregisterMatchers(stdFileType, extension2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileTypeBean";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    @NotNull
    static IdeaPluginDescriptor coreIdeaPluginDescriptor() {
        IdeaPluginDescriptor ideaPluginDescriptor = Objects.requireNonNull(PluginManagerCore.getPlugin(PluginManagerCore.CORE_ID), "The core plugin is amiss");
        if (ideaPluginDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(0);
        }
        return ideaPluginDescriptor;
    }

    private void unregisterMatchers(@NotNull StandardFileType stdFileType, @NotNull FileTypeBean extension2) {
        if (stdFileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(1);
        }
        if (extension2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            stdFileType.matchers.removeAll(extension2.getMatchers());
            for (FileNameMatcher matcher : extension2.getMatchers()) {
                this.myPatternsTable.removeAssociation(matcher, (Object)stdFileType.getDescriptor());
            }
            this.fireFileTypesChanged(stdFileType.fileType, null);
        });
    }

    private void initStandardFileTypes() {
        block7: {
            this.instantiatePendingFileTypes();
            this.loadFileTypeBeans();
            FileTypeFactory.FILE_TYPE_FACTORY_EP.processWithPluginDescriptor((factory2, pluginDescriptor) -> {
                try {
                    factory2.createFileTypes((FileTypeConsumer)new PluginFileTypeConsumer((PluginDescriptor)pluginDescriptor));
                }
                catch (StartupAbortedException | ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new StartupAbortedException("Cannot create file types", (Throwable)new PluginException(e, pluginDescriptor.getPluginId()));
                }
            });
            for (StandardFileType pair : this.myStandardFileTypes.values()) {
                if (this.mySchemeManager.findSchemeByName(pair.fileType.getName()) != null) continue;
                this.registerFileTypeWithoutNotification(pair.fileType, pair.pluginDescriptor, pair.matchers, true);
            }
            try {
                InputStream defaultFileTypeStream = FileTypeManagerImpl.class.getClassLoader().getResourceAsStream("defaultFileTypes.xml");
                if (defaultFileTypeStream == null) break block7;
                Element defaultFileTypesElement = JDOMUtil.load((InputStream)defaultFileTypeStream);
                IdeaPluginDescriptor coreIdeaPluginDescriptor = FileTypeManagerImpl.coreIdeaPluginDescriptor();
                for (Element e : defaultFileTypesElement.getChildren()) {
                    if (FILE_SPEC.equals(e.getName())) {
                        for (Element element2 : e.getChildren(ELEMENT_FILETYPE)) {
                            String fileTypeName = element2.getAttributeValue(ATTRIBUTE_NAME);
                            if (this.myPendingFileTypes.get(fileTypeName) != null) continue;
                            this.loadFileType("defaultFileTypes.xml", element2, (PluginDescriptor)coreIdeaPluginDescriptor, true);
                        }
                        continue;
                    }
                    if (!ELEMENT_EXTENSION_MAP.equals(e.getName())) continue;
                    this.readGlobalMappings(e, true);
                }
                if (PlatformUtils.isIdeaCommunity()) {
                    Element extensionMap = new Element(ELEMENT_EXTENSION_MAP);
                    extensionMap.addContent(new Element("mapping").setAttribute("ext", "jspx").setAttribute("type", "XML"));
                    extensionMap.addContent(new Element("mapping").setAttribute("ext", "tagx").setAttribute("type", "XML"));
                    this.readGlobalMappings(extensionMap, true);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @TestOnly
    void clearStandardFileTypesBeforeTest() {
        String name2;
        this.myPendingAssociations.clear();
        this.myPendingFileTypes.clear();
        for (Map.Entry<String, StandardFileType> entry2 : this.myStandardFileTypes.entrySet()) {
            name2 = entry2.getKey();
            StandardFileType stdType = entry2.getValue();
            FileType type = stdType.fileType;
            FileTypeWithDescriptor ftd = stdType.getDescriptor();
            for (FileNameMatcher matcher : stdType.matchers) {
                this.removeAssociation(ftd, matcher, false);
            }
            this.mySchemeManager.removeScheme(name2);
            this.removeFromDuplicates(type, ftd.pluginDescriptor);
        }
        this.myStandardFileTypes.clear();
        for (FileTypeWithDescriptor ftd : this.myDefaultTypes) {
            name2 = ftd.getName();
            FileType defaultType = ftd.fileType;
            List<FileNameMatcher> matchers = this.getAssociations(defaultType);
            for (FileNameMatcher matcher : matchers) {
                this.removeAssociation(ftd, matcher, false);
            }
            this.mySchemeManager.removeScheme(name2);
            this.removeFromDuplicates(defaultType, ftd.pluginDescriptor);
        }
        this.myDefaultTypes.clear();
    }

    private void removeFromDuplicates(@NotNull FileType type, @NotNull PluginDescriptor pluginDescriptor) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(3);
        }
        if (pluginDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(4);
        }
        this.myNames.computeIfAbsent(pluginDescriptor, __ -> new ConcurrentHashMap()).remove(type.getName());
        this.myDisplayNames.computeIfAbsent(pluginDescriptor, __ -> new ConcurrentHashMap()).remove(type.getDisplayName());
        this.myDescriptions.computeIfAbsent(pluginDescriptor, __ -> new ConcurrentHashMap()).remove(type.getDescription());
    }

    private void loadFileTypeBeans() {
        List fileTypeBeans = EP_NAME.getExtensionList();
        for (FileTypeBean bean : fileTypeBeans) {
            FileTypeManagerImpl.initializeMatchers(bean.getPluginDescriptor(), bean);
        }
        for (FileTypeBean bean : fileTypeBeans) {
            if (bean.implementationClass == null) continue;
            if (this.myPendingFileTypes.containsKey(bean.name)) {
                FileTypeManagerImpl.handleFileTypesConflict(bean, this.myPendingFileTypes.get(bean.name));
                continue;
            }
            this.myPendingFileTypes.put(bean.name, bean);
            for (FileNameMatcher matcher : bean.getMatchers()) {
                this.myPendingAssociations.addAssociation(matcher, (Object)bean);
            }
        }
        for (FileTypeBean bean : fileTypeBeans) {
            if (bean.implementationClass != null) continue;
            FileTypeBean oldBean = this.myPendingFileTypes.get(bean.name);
            if (oldBean == null) {
                LOG.error((Throwable)new PluginException("Trying to add extensions to non-registered file type " + bean.name, bean.getPluginId()));
                continue;
            }
            oldBean.addMatchers(bean.getMatchers());
            for (FileNameMatcher matcher : bean.getMatchers()) {
                this.myPendingAssociations.addAssociation(matcher, (Object)oldBean);
            }
        }
    }

    private static void handleFileTypesConflict(@NotNull FileTypeBean bean, @NotNull FileTypeBean otherBean) {
        PluginConflictReporter conflictReporter;
        Application application;
        if (bean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(5);
        }
        if (otherBean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(6);
        }
        if ((application = ApplicationManager.getApplication()) != null && (conflictReporter = (PluginConflictReporter)application.getService(PluginConflictReporter.class)) != null) {
            HashSet<PluginId> conflictingPlugins = new HashSet<PluginId>();
            conflictingPlugins.add(bean.getPluginId());
            conflictingPlugins.add(otherBean.getPluginId());
            boolean hasConflictWithPlatform = PluginManagerCore.CORE_ID.equals((Object)bean.getPluginId()) || PluginManagerCore.CORE_ID.equals((Object)otherBean.getPluginId());
            conflictReporter.reportConflict(conflictingPlugins, hasConflictWithPlatform);
            return;
        }
        LOG.error((Throwable)new PluginException("Trying to override already registered file type '" + bean.name + "'", bean.getPluginId()));
    }

    private static void initializeMatchers(@NotNull Object context2, @NotNull FileTypeBean bean) {
        if (context2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(7);
        }
        if (bean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(8);
        }
        bean.addMatchers(FileTypeManagerImpl.parseExtensions(context2, Strings.notNullize((String)bean.extensions)));
        bean.addMatchers(FileTypeManagerImpl.parse(context2, Strings.notNullize((String)bean.fileNames), token2 -> new ExactFileNameMatcher(token2)));
        bean.addMatchers(FileTypeManagerImpl.parse(context2, Strings.notNullize((String)bean.fileNamesCaseInsensitive), token2 -> new ExactFileNameMatcher(token2, true)));
        bean.addMatchers(FileTypeManagerImpl.parse(context2, Strings.notNullize((String)bean.patterns), token2 -> FileNameMatcherFactory.getInstance().createMatcher(token2)));
    }

    private void instantiatePendingFileTypes() {
        Collection fileTypes = (Collection)this.withReadLock(() -> new ArrayList<FileTypeBean>(this.myPendingFileTypes.values()));
        for (FileTypeBean fileTypeBean : fileTypes) {
            this.mergeOrInstantiateFileTypeBean(fileTypeBean);
        }
    }

    @NotNull
    private FileType mergeOrInstantiateFileTypeBean(@NotNull FileTypeBean fileTypeBean) {
        StandardFileType type;
        if (fileTypeBean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(9);
        }
        if ((type = (StandardFileType)this.withReadLock(() -> this.myStandardFileTypes.get(fileTypeBean.name))) == null) {
            return FileTypeManagerImpl.getFileTypeOrUnknown(this.instantiateFileTypeBean(fileTypeBean));
        }
        type.matchers.addAll(fileTypeBean.getMatchers());
        for (FileNameMatcher matcher : fileTypeBean.getMatchers()) {
            this.myPatternsTable.addAssociation(matcher, (Object)type.getDescriptor());
        }
        FileType fileType = type.fileType;
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(10);
        }
        return fileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private FileTypeWithDescriptor instantiateFileTypeBean(@NotNull FileTypeBean bean) {
        if (bean == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(11);
        }
        Lock writeLock = this.myPendingInitializationLock.writeLock();
        writeLock.lock();
        try {
            FileType fileType;
            FileTypeWithDescriptor ftd;
            String fileTypeName = bean.name;
            if (!this.myPendingFileTypes.containsKey(fileTypeName) && (ftd = this.mySchemeManager.findSchemeByName(fileTypeName)) != null && !(ftd.fileType instanceof AbstractFileType)) {
                FileTypeWithDescriptor fileTypeWithDescriptor = ftd;
                return fileTypeWithDescriptor;
            }
            PluginId pluginId = bean.getPluginDescriptor().getPluginId();
            try {
                if (bean.fieldName == null) {
                    fileType = (FileType)ApplicationManager.getApplication().instantiateClass(bean.implementationClass, bean.getPluginDescriptor());
                } else {
                    Field field = ApplicationManager.getApplication().loadClass(bean.implementationClass, bean.getPluginDescriptor()).getDeclaredField(bean.fieldName);
                    field.setAccessible(true);
                    fileType = (FileType)field.get(null);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                LOG.error((Throwable)new PluginException((Throwable)e, pluginId));
                FileTypeWithDescriptor fileTypeWithDescriptor = null;
                writeLock.unlock();
                return fileTypeWithDescriptor;
            }
            if (!fileType.getName().equals(fileTypeName)) {
                LOG.error((Throwable)new PluginException("Incorrect name specified in <fileType>, should be " + fileType.getName() + ", actual " + fileTypeName, pluginId));
            }
            if (fileType instanceof LanguageFileType) {
                Object expectedLanguage;
                LanguageFileType languageFileType = (LanguageFileType)fileType;
                Object object = expectedLanguage = languageFileType.isSecondary() ? null : languageFileType.getLanguage().getID();
                if (!Objects.equals(bean.language, expectedLanguage)) {
                    LOG.error((Throwable)new PluginException("Incorrect language specified in <fileType> for " + fileType.getName() + ", should be " + (String)expectedLanguage + ", actual " + bean.language, pluginId));
                }
            }
            StandardFileType standardFileType = new StandardFileType(fileType, bean.getPluginDescriptor(), bean.getMatchers());
            this.myStandardFileTypes.put(bean.name, standardFileType);
            this.registerFileTypeWithoutNotification(fileType, bean.getPluginDescriptor(), standardFileType.matchers, true);
            if (bean.hashBangs != null) {
                for (String hashBang : StringUtil.split((String)bean.hashBangs, (String)";")) {
                    this.myPatternsTable.addHashBangPattern(hashBang, (Object)new FileTypeWithDescriptor(fileType, bean.getPluginDescriptor()));
                    this.myInitialAssociations.addHashBangPattern(hashBang, (Object)fileType);
                }
            }
            PluginAdvertiserExtensionsStateService pluginAdvertiser = PluginAdvertiserExtensionsStateService.getInstance();
            for (FileNameMatcher matcher : standardFileType.matchers) {
                pluginAdvertiser.registerLocalPlugin(matcher, bean.getPluginDescriptor());
            }
            this.myPendingAssociations.removeAllAssociations((Object)bean);
            this.myPendingFileTypes.remove(fileTypeName);
            FileTypeWithDescriptor fileTypeWithDescriptor = new FileTypeWithDescriptor(fileType, bean.getPluginDescriptor());
            return fileTypeWithDescriptor;
        }
        finally {
            writeLock.unlock();
        }
    }

    boolean toLog() {
        return LOG.isDebugEnabled();
    }

    void log(String message2) {
        LOG.debug(message2 + " - " + Thread.currentThread());
    }

    @TestOnly
    public void drainReDetectQueue() {
        this.myDetectionService.drainReDetectQueue();
    }

    @TestOnly
    @NotNull
    Collection<VirtualFile> dumpReDetectQueue() {
        Collection<VirtualFile> collection = this.myDetectionService.dumpReDetectQueue();
        if (collection == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @TestOnly
    void reDetectAsync(boolean enable) {
        this.myDetectionService.reDetectAsync(enable);
    }

    @NotNull
    public FileType getStdFileType(@NotNull String name2) {
        if (name2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(13);
        }
        this.instantiatePendingFileTypeByName(name2);
        StandardFileType stdFileType = (StandardFileType)this.withReadLock(() -> this.myStandardFileTypes.get(name2));
        PlainTextFileType plainTextFileType = stdFileType != null ? stdFileType.fileType : PlainTextFileType.INSTANCE;
        if (plainTextFileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(14);
        }
        return plainTextFileType;
    }

    private void instantiatePendingFileTypeByName(@NotNull String name2) {
        FileTypeBean bean;
        if (name2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(15);
        }
        if ((bean = (FileTypeBean)this.withReadLock(() -> this.myPendingFileTypes.get(name2))) != null) {
            this.instantiateFileTypeBean(bean);
        }
    }

    public void initializeComponent() {
        this.initStandardFileTypes();
        if (!this.myUnresolvedMappings.isEmpty()) {
            this.instantiatePendingFileTypes();
        }
        if (!this.myUnresolvedMappings.isEmpty()) {
            for (StandardFileType standardFileType : this.myStandardFileTypes.values()) {
                this.registerReDetectedMappings(standardFileType);
            }
        }
        if (!this.myUnresolvedMappings.isEmpty()) {
            for (StandardFileType standardFileType : this.myStandardFileTypes.values()) {
                this.bindUnresolvedMappings(standardFileType);
            }
        }
        if (!this.myUnresolvedMappings.isEmpty()) {
            for (Map.Entry entry2 : this.myUnresolvedMappings.entrySet()) {
                this.tryToResolveMapping((String)entry2.getValue(), (FileNameMatcher)entry2.getKey());
            }
        }
        if (!this.myUnresolvedHashBangs.isEmpty()) {
            HashMap<String, String> hashBangs = new HashMap<String, String>(this.myUnresolvedHashBangs);
            this.myUnresolvedHashBangs.clear();
            this.registerHashBangs(hashBangs, false);
        }
        boolean isAtLeastOneStandardFileTypeHasBeenRead = false;
        for (FileTypeWithDescriptor ftd : this.mySchemeManager.loadSchemes()) {
            isAtLeastOneStandardFileTypeHasBeenRead |= this.myInitialAssociations.hasAssociationsFor((Object)ftd.fileType);
        }
        if (isAtLeastOneStandardFileTypeHasBeenRead) {
            this.restoreStandardFileExtensions();
        }
    }

    private void tryToResolveMapping(@NotNull String typeName, @NotNull FileNameMatcher matcher) {
        FileTypeWithDescriptor ftd;
        if (typeName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(16);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(17);
        }
        if ((ftd = this.getFileTypeWithDescriptorByName(typeName)) != null) {
            this.associate(ftd, matcher, false);
        }
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull String fileName) {
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(18);
        }
        FileType fileType = this.getFileTypeByFileName((CharSequence)fileName);
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(19);
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull CharSequence fileName) {
        FileTypeBean pendingFileType;
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(20);
        }
        if ((pendingFileType = (FileTypeBean)this.withReadLock(() -> (FileTypeBean)this.myPendingAssociations.findAssociatedFileType(fileName))) != null) {
            return FileTypeManagerImpl.getFileTypeOrUnknown(this.instantiateFileTypeBean(pendingFileType));
        }
        FileTypeWithDescriptor ftd = (FileTypeWithDescriptor)this.withReadLock(() -> (FileTypeWithDescriptor)this.myPatternsTable.findAssociatedFileType(fileName));
        return FileTypeManagerImpl.getFileTypeOrUnknown(ftd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freezeFileTypeTemporarilyIn(@NotNull VirtualFile file2, @NotNull Runnable runnable2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(21);
        }
        if (runnable2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(22);
        }
        FileType fileType = file2.isDirectory() ? null : file2.getFileType();
        Pair<VirtualFile, FileType> old = FILE_TYPE_FIXED_TEMPORARILY.get();
        FILE_TYPE_FIXED_TEMPORARILY.set((Pair<VirtualFile, FileType>)new Pair((Object)file2, (Object)fileType));
        if (this.toLog()) {
            this.log("F: freezeFileTypeTemporarilyIn(" + file2.getName() + ") to " + fileType + " in " + Thread.currentThread());
        }
        try {
            runnable2.run();
        }
        finally {
            if (old == null) {
                FILE_TYPE_FIXED_TEMPORARILY.remove();
            } else {
                FILE_TYPE_FIXED_TEMPORARILY.set(old);
            }
            if (this.toLog()) {
                this.log("F: unfreezeFileType(" + file2.getName() + ") in " + Thread.currentThread());
            }
        }
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(23);
        }
        FileType fileType = this.getFileTypeByFile(file2, null);
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(24);
        }
        return fileType;
    }

    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file2, byte @Nullable [] content2) {
        FileType overriddenFileType;
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(25);
        }
        if ((overriddenFileType = (FileType)FileTypeOverrider.EP_NAME.computeSafeIfAny(overrider -> overrider.getOverriddenFileType(file2))) != null) {
            FileType fileType = overriddenFileType;
            if (fileType == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(26);
            }
            return fileType;
        }
        FileType fileType = this.getByFile(file2);
        if (file2 instanceof StubVirtualFile) {
            if (fileType == null && content2 == null && file2 instanceof FakeVirtualFile && ScratchUtil.isScratch((VirtualFile)file2.getParent())) {
                PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
                if (plainTextFileType == null) {
                    FileTypeManagerImpl.$$$reportNull$$$0(27);
                }
                return plainTextFileType;
            }
        } else if (fileType == null || fileType == DetectedByContentFileType.INSTANCE) {
            FileType detected = this.detectFileTypeByFile(file2, content2);
            if (detected == UnknownFileType.INSTANCE && fileType == DetectedByContentFileType.INSTANCE) {
                DetectedByContentFileType detectedByContentFileType = DetectedByContentFileType.INSTANCE;
                if (detectedByContentFileType == null) {
                    FileTypeManagerImpl.$$$reportNull$$$0(28);
                }
                return detectedByContentFileType;
            }
            FileType fileType2 = detected;
            if (fileType2 == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(29);
            }
            return fileType2;
        }
        FileType fileType3 = (FileType)ObjectUtils.notNull((Object)fileType, (Object)UnknownFileType.INSTANCE);
        if (fileType3 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(30);
        }
        return fileType3;
    }

    @NotNull
    protected FileType detectFileTypeByFile(@NotNull VirtualFile file2, byte @Nullable [] content2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(31);
        }
        FileType fileType = this.myDetectionService.getOrDetectFromContent(file2, content2);
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(32);
        }
        return fileType;
    }

    @Override
    @Nullable
    public FileType getByFile(@NotNull VirtualFile file2) {
        FileType fileType;
        Pair<VirtualFile, FileType> fixedType;
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(33);
        }
        if ((fixedType = FILE_TYPE_FIXED_TEMPORARILY.get()) != null && ((VirtualFile)fixedType.getFirst()).equals(file2)) {
            FileType fileType2 = (FileType)fixedType.getSecond();
            if (this.toLog()) {
                this.log("F: getByFile(" + file2.getName() + ") was frozen to " + fileType2.getName() + " in " + Thread.currentThread());
            }
            return fileType2;
        }
        if (file2 instanceof LightVirtualFile && (fileType = ((LightVirtualFile)file2).getAssignedFileType()) != null) {
            return fileType;
        }
        for (FileType specialType : this.mySpecialFileTypes) {
            if (!specialType.isMyFileType(file2)) continue;
            if (this.toLog()) {
                this.log("getByFile(" + file2.getName() + "): Special file type: " + specialType.getName());
            }
            return specialType;
        }
        fileType = this.getFileTypeByFileName(file2.getNameSequence());
        if (fileType == UnknownFileType.INSTANCE) {
            fileType = null;
        }
        if (this.toLog()) {
            this.log("F: getByFile(" + file2.getName() + ") By name file type: " + (fileType == null ? null : fileType.getName()));
        }
        return fileType;
    }

    public FileType findFileTypeByName(@NotNull String fileTypeName) {
        FileType type;
        if (fileTypeName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(34);
        }
        if ((type = this.getStdFileType(fileTypeName)) != PlainTextFileType.INSTANCE || fileTypeName.equals(type.getName())) {
            return type;
        }
        for (FileTypeWithDescriptor ftd : this.getAllFileTypeWithDescriptors()) {
            if (!fileTypeName.equals(ftd.fileType.getName())) continue;
            return ftd.fileType;
        }
        return null;
    }

    @NotNull
    private List<FileTypeWithDescriptor> getAllFileTypeWithDescriptors() {
        List<FileTypeWithDescriptor> list2 = this.mySchemeManager.getAllSchemes();
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(35);
        }
        return list2;
    }

    @Nullable
    public LanguageFileType findFileTypeByLanguage(@NotNull Language language2) {
        FileTypeBean bean;
        if (language2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(36);
        }
        if ((bean = (FileTypeBean)this.withReadLock(() -> {
            for (FileTypeBean b : this.myPendingFileTypes.values()) {
                if (!language2.getID().equals(b.language)) continue;
                return b;
            }
            return null;
        })) != null) {
            FileTypeWithDescriptor descriptor2 = this.instantiateFileTypeBean(bean);
            return descriptor2 != null ? (LanguageFileType)descriptor2.fileType : null;
        }
        return (LanguageFileType)this.withReadLock(() -> language2.findMyFileType((FileType[])ContainerUtil.map2Array(this.getAllFileTypeWithDescriptors(), (Object[])FileType.EMPTY_ARRAY, ftd -> ftd.fileType)));
    }

    @NotNull
    public FileType getFileTypeByExtension(@NotNull String extension2) {
        if (extension2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(37);
        }
        FileType fileType = this.getFileTypeWithDescriptorByExtension((String)extension2).fileType;
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(38);
        }
        return fileType;
    }

    @NotNull
    FileTypeWithDescriptor getFileTypeWithDescriptorByExtension(@NotNull String extension2) {
        FileTypeBean pendingFileType;
        if (extension2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(39);
        }
        if ((pendingFileType = (FileTypeBean)this.withReadLock(() -> (FileTypeBean)this.myPendingAssociations.findByExtension((CharSequence)extension2))) != null) {
            FileTypeWithDescriptor type = this.instantiateFileTypeBean(pendingFileType);
            FileTypeWithDescriptor fileTypeWithDescriptor = type == null ? FileTypeManagerImpl.coreDescriptorFor(UnknownFileType.INSTANCE) : type;
            if (fileTypeWithDescriptor == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(40);
            }
            return fileTypeWithDescriptor;
        }
        FileTypeWithDescriptor ftd = (FileTypeWithDescriptor)this.withReadLock(() -> (FileTypeWithDescriptor)this.myPatternsTable.findByExtension((CharSequence)extension2));
        FileTypeWithDescriptor fileTypeWithDescriptor = ftd == null ? FileTypeManagerImpl.coreDescriptorFor(UnknownFileType.INSTANCE) : ftd;
        if (fileTypeWithDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(41);
        }
        return fileTypeWithDescriptor;
    }

    public void registerFileType(@NotNull FileType type, String ... defaultAssociatedExtensions) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(42);
        }
        PluginException.reportDeprecatedUsage((String)"FileTypeManager#registerFileType", (String)"Use `com.intellij.fileType` extension or `FileTypeFactory` instead.");
        ArrayList<ExtensionFileNameMatcher> matchers = new ArrayList<ExtensionFileNameMatcher>();
        if (defaultAssociatedExtensions != null) {
            for (String extension2 : defaultAssociatedExtensions) {
                matchers.add(new ExtensionFileNameMatcher(extension2));
            }
        }
        this.doRegisterFileType(type, matchers);
    }

    @TestOnly
    public void registerFileType(@NotNull FileType type, @NotNull List<? extends FileNameMatcher> defaultAssociations, @NotNull Disposable disposable2) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(43);
        }
        if (defaultAssociations == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(44);
        }
        if (disposable2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(45);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException();
        }
        this.doRegisterFileType(type, defaultAssociations);
        Disposer.register((Disposable)disposable2, () -> this.doUnregisterFileType(type));
    }

    private void doRegisterFileType(FileType type, List<? extends FileNameMatcher> defaultAssociations) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.fireBeforeFileTypesChanged();
            this.registerFileTypeWithoutNotification(type, FileTypeManagerImpl.detectPluginDescriptor((FileType)type).pluginDescriptor, defaultAssociations, true);
            this.fireFileTypesChanged(type, null);
        });
    }

    @TestOnly
    public void unregisterFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(46);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException();
        }
        this.doUnregisterFileType(fileType);
    }

    private void doUnregisterFileType(FileType fileType) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.fireBeforeFileTypesChanged();
            this.unregisterFileTypeWithoutNotification(fileType);
            this.myStandardFileTypes.remove(fileType.getName());
            if (fileType instanceof LanguageFileType) {
                Language language2 = ((LanguageFileType)fileType).getLanguage();
                if (fileType.getClass().getClassLoader().equals(language2.getClass().getClassLoader())) {
                    Language.unregisterLanguage((Language)language2);
                }
            }
            this.fireFileTypesChanged(null, fileType);
        });
    }

    private void unregisterFileTypeWithoutNotification(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(47);
        }
        PluginDescriptor pluginDescriptor = this.findPluginDescriptor(fileType);
        FileTypeWithDescriptor ftd = FileTypeWithDescriptor.allFor(fileType);
        List matchers = this.myPatternsTable.getAssociations((Object)ftd);
        this.myRemovedMappingTracker.removeIf(mapping2 -> mapping2.getFileTypeName().equals(fileType.getName()) || matchers.contains(mapping2.getFileNameMatcher()));
        this.myPatternsTable.removeAllAssociations((Object)ftd);
        this.myInitialAssociations.removeAllAssociations((Object)fileType);
        this.mySchemeManager.removeScheme(fileType.getName());
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            FileTypeIdentifiableByVirtualFile fakeFileType = (FileTypeIdentifiableByVirtualFile)fileType;
            this.mySpecialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.remove((Object[])this.mySpecialFileTypes, (Object)fakeFileType, (ArrayFactory)FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
        if (pluginDescriptor != null) {
            this.removeFromDuplicates(fileType, pluginDescriptor);
        }
    }

    public FileType @NotNull [] getRegisteredFileTypes() {
        this.instantiatePendingFileTypes();
        FileType[] fileTypeArray = (FileType[])ContainerUtil.map2Array(this.getAllFileTypeWithDescriptors(), FileType.class, ftd -> ftd.fileType);
        if (fileTypeArray == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(48);
        }
        return fileTypeArray;
    }

    @NotNull
    List<FileTypeWithDescriptor> getRegisteredFileTypeWithDescriptors() {
        this.instantiatePendingFileTypes();
        return this.getAllFileTypeWithDescriptors();
    }

    @Override
    @NotNull
    public String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(49);
        }
        String string = FileUtilRt.getExtension((String)fileName);
        if (string == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(50);
        }
        return string;
    }

    @NotNull
    public String getIgnoredFilesList() {
        Set masks = this.myIgnoredPatterns.getIgnoreMasks();
        String string = masks.isEmpty() ? "" : String.join((CharSequence)";", masks);
        if (string == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(51);
        }
        return string;
    }

    public void setIgnoredFilesList(@NotNull String list2) {
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(52);
        }
        this.makeFileTypesChange("ignored files list updated: " + list2, () -> {
            this.myIgnoredFileCache.clearCache();
            this.myIgnoredPatterns.setIgnoreMasks(list2);
        });
    }

    @Override
    public boolean isIgnoredFilesListEqualToCurrent(@NotNull String list2) {
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(53);
        }
        HashSet<String> tempSet = new HashSet<String>(list2.length() / 3);
        StringTokenizer tokenizer = new StringTokenizer(list2, ";");
        while (tokenizer.hasMoreTokens()) {
            tempSet.add(tokenizer.nextToken());
        }
        return tempSet.equals(this.myIgnoredPatterns.getIgnoreMasks());
    }

    public boolean isFileIgnored(@NotNull String name2) {
        if (name2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(54);
        }
        return this.myIgnoredPatterns.isIgnored((CharSequence)name2);
    }

    public boolean isFileIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(55);
        }
        return this.myIgnoredFileCache.isFileIgnored(file2);
    }

    public String @NotNull [] getAssociatedExtensions(@NotNull FileType type) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(56);
        }
        this.instantiatePendingFileTypeByName(type.getName());
        String[] stringArray = (String[])this.withReadLock(() -> this.myPatternsTable.getAssociatedExtensions((Object)FileTypeWithDescriptor.allFor(type)));
        if (stringArray == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(57);
        }
        return stringArray;
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(58);
        }
        this.instantiatePendingFileTypeByName(type.getName());
        List list2 = (List)this.withReadLock(() -> this.myPatternsTable.getAssociations((Object)FileTypeWithDescriptor.allFor(type)));
        if (list2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(59);
        }
        return list2;
    }

    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(60);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(61);
        }
        this.associate(FileTypeManagerImpl.detectPluginDescriptor(type), matcher, true);
    }

    @NotNull
    static FileTypeWithDescriptor detectPluginDescriptor(@NotNull FileType type) {
        PluginDescriptor pluginDescriptor;
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(62);
        }
        if ((pluginDescriptor = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(type.getClass().getName())) == null) {
            pluginDescriptor = FileTypeManagerImpl.coreIdeaPluginDescriptor();
        }
        return new FileTypeWithDescriptor(type, pluginDescriptor);
    }

    @NotNull
    private static FileType getFileTypeOrUnknown(@Nullable FileTypeWithDescriptor ftd) {
        FileType fileType = ftd != null ? ftd.fileType : UnknownFileType.INSTANCE;
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(63);
        }
        return fileType;
    }

    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(64);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(65);
        }
        this.removeAssociation(FileTypeManagerImpl.detectPluginDescriptor(type), matcher, true);
    }

    @Override
    public void fireBeforeFileTypesChanged() {
        FileTypeEvent event = new FileTypeEvent((Object)this, null, null);
        ((FileTypeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).beforeFileTypesChanged(event);
    }

    @Override
    public void fireFileTypesChanged() {
        this.fireFileTypesChanged(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeFileTypesChange(@NotNull String debugReasonMessage, @NotNull Runnable command) {
        PluginId pluginId;
        if (debugReasonMessage == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(66);
        }
        if (command == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(67);
        }
        LOG.info("File types changed: " + debugReasonMessage + (String)((pluginId = PluginUtil.getInstance().findPluginId(new Throwable())) != null ? ". Caused by plugin '" + pluginId.getIdString() + "'." : ""));
        this.fireBeforeFileTypesChanged();
        try {
            command.run();
        }
        finally {
            this.fireFileTypesChanged();
        }
    }

    private void fireFileTypesChanged(@Nullable FileType addedFileType, @Nullable FileType removedFileType) {
        this.myDetectionService.clearCaches();
        CachedFileType.clearCache();
        ((FileTypeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).fileTypesChanged(new FileTypeEvent((Object)this, addedFileType, removedFileType));
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(68);
        }
        int savedVersion = StringUtilRt.parseInt((String)state.getAttributeValue(ATTRIBUTE_VERSION), (int)0);
        for (Element element2 : state.getChildren()) {
            if (ELEMENT_IGNORE_FILES.equals(element2.getName())) {
                this.myIgnoredPatterns.setIgnoreMasks(Strings.notNullize((String)element2.getAttributeValue(ATTRIBUTE_LIST)));
                continue;
            }
            if (!ELEMENT_EXTENSION_MAP.equals(element2.getName())) continue;
            this.readGlobalMappings(element2, false);
        }
        this.migrateFromOldVersion(savedVersion);
        this.myIgnoredFileCache.clearCache();
        this.myDetectionService.loadState(state);
    }

    private void migrateFromOldVersion(int savedVersion) {
        if (savedVersion < 4) {
            if (savedVersion == 0) {
                this.addIgnore(".svn");
            }
            if (savedVersion < 2) {
                this.restoreStandardFileExtensions();
            }
            this.addIgnore("*.pyc");
            this.addIgnore("*.pyo");
            this.addIgnore(".git");
        }
        if (savedVersion < 6) {
            this.addIgnore("_svn");
        }
        if (savedVersion < 7) {
            this.addIgnore(".hg");
        }
        if (savedVersion < 8) {
            this.addIgnore("*~");
        }
        if (savedVersion < 9) {
            this.addIgnore("__pycache__");
        }
        if (savedVersion < 11) {
            this.addIgnore("*.rbc");
        }
        if (savedVersion < 13) {
            this.unignoreMask("*.lib");
        }
        if (savedVersion < 15) {
            this.unignoreMask(".bundle");
        }
        if (savedVersion < 16) {
            this.unignoreMask(".tox");
        }
        if (savedVersion < 17) {
            this.addIgnore("*.rbc");
        }
        if (savedVersion < 18) {
            this.unignoreMask("*.hprof");
        }
    }

    private void unignoreMask(@NotNull String maskToRemove) {
        if (maskToRemove == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(69);
        }
        LinkedHashSet masks = new LinkedHashSet(this.myIgnoredPatterns.getIgnoreMasks());
        masks.remove(maskToRemove);
        this.myIgnoredPatterns.clearPatterns();
        for (String each : masks) {
            this.myIgnoredPatterns.addIgnoreMask(each);
        }
    }

    private void readGlobalMappings(@NotNull Element e, boolean isAddToInit) {
        if (e == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(70);
        }
        this.myRemovedMappingTracker.load(e);
        for (Pair<FileNameMatcher, String> association : AbstractFileType.readAssociations(e)) {
            String fileTypeName = (String)association.getSecond();
            FileNameMatcher matcher = (FileNameMatcher)association.getFirst();
            FileTypeWithDescriptor ftd = this.getFileTypeWithDescriptorByName(fileTypeName);
            FileType type = ftd == null ? null : ftd.fileType;
            FileTypeBean pendingFileTypeBean = (FileTypeBean)this.myPendingAssociations.findAssociatedFileType(matcher);
            if (pendingFileTypeBean != null) {
                this.instantiateFileTypeBean(pendingFileTypeBean);
            }
            if (type == null) {
                this.myUnresolvedMappings.put(matcher, fileTypeName);
                continue;
            }
            if (((Object)((Object)PlainTextFileType.INSTANCE)).equals(type)) {
                FileType newFileType;
                FileTypeWithDescriptor textFtd = (FileTypeWithDescriptor)this.myPatternsTable.findAssociatedFileType(matcher);
                FileType fileType = newFileType = textFtd == null ? null : textFtd.fileType;
                if (newFileType != null && newFileType != PlainTextFileType.INSTANCE && newFileType != UnknownFileType.INSTANCE) {
                    this.myRemovedMappingTracker.add(matcher, newFileType.getName(), false);
                }
            }
            this.associate(ftd, matcher, false);
            if (!isAddToInit) continue;
            this.myInitialAssociations.addAssociation(matcher, (Object)type);
        }
        Map<String, String> hashBangs = FileTypeManagerImpl.readHashBangs(e);
        this.registerHashBangs(hashBangs, isAddToInit);
        for (RemovedMappingTracker.RemovedMapping mapping2 : this.myRemovedMappingTracker.getRemovedMappings()) {
            FileTypeWithDescriptor ftd = this.getFileTypeWithDescriptorByName(mapping2.getFileTypeName());
            if (ftd == null) continue;
            this.removeAssociation(ftd, mapping2.getFileNameMatcher(), false);
        }
    }

    private void registerHashBangs(@NotNull Map<String, String> hashBangs, boolean isAddToInit) {
        if (hashBangs == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(71);
        }
        for (Map.Entry<String, String> entry2 : hashBangs.entrySet()) {
            String hashBang = entry2.getKey();
            String typeName = entry2.getValue();
            FileTypeWithDescriptor ftd = this.getFileTypeWithDescriptorByName(typeName);
            if (ftd == null) {
                this.myUnresolvedHashBangs.put(hashBang, typeName);
                continue;
            }
            this.myPatternsTable.addHashBangPattern(hashBang, (Object)ftd);
            if (!isAddToInit) continue;
            this.myInitialAssociations.addHashBangPattern(hashBang, (Object)ftd.fileType);
        }
    }

    @NotNull
    private static Map<String, String> readHashBangs(@NotNull Element e) {
        if (e == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(72);
        }
        List children2 = e.getChildren("hashBang");
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (Element hashBangTag : children2) {
            String hashBangPattern;
            String typeName = hashBangTag.getAttributeValue("type");
            if (typeName == null || (hashBangPattern = hashBangTag.getAttributeValue("value")) == null) continue;
            result2.put(hashBangPattern, typeName);
        }
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(73);
        }
        return hashMap;
    }

    private void addIgnore(@NotNull String ignoreMask) {
        if (ignoreMask == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(74);
        }
        this.myIgnoredPatterns.addIgnoreMask(ignoreMask);
    }

    private void restoreStandardFileExtensions() {
        for (String name2 : FILE_TYPES_WITH_PREDEFINED_EXTENSIONS) {
            StandardFileType stdFileType = this.myStandardFileTypes.get(name2);
            if (stdFileType == null) continue;
            FileType fileType = stdFileType.fileType;
            for (FileNameMatcher matcher : this.myPatternsTable.getAssociations((Object)FileTypeWithDescriptor.allFor(fileType))) {
                FileType defaultFileType = (FileType)this.myInitialAssociations.findAssociatedFileType(matcher);
                if (defaultFileType == null || defaultFileType == fileType) continue;
                this.removeAssociation(FileTypeManagerImpl.coreDescriptorFor(fileType), matcher, false);
                this.associate(FileTypeManagerImpl.coreDescriptorFor(defaultFileType), matcher, false);
            }
            for (FileNameMatcher matcher : this.myInitialAssociations.getAssociations((Object)fileType)) {
                this.associate(FileTypeManagerImpl.coreDescriptorFor(fileType), matcher, false);
            }
        }
    }

    @NotNull
    public Element getState() {
        String typeName;
        Element state = new Element("state");
        String ignoreFiles = this.myIgnoredPatterns.getIgnoreMasks().stream().sorted().collect(Collectors.joining(";"));
        if (!ignoreFiles.equalsIgnoreCase(DEFAULT_IGNORED)) {
            state.addContent(new Element(ELEMENT_IGNORE_FILES).setAttribute(ATTRIBUTE_LIST, ignoreFiles));
        }
        Element extensionMap = new Element(ELEMENT_EXTENSION_MAP);
        ArrayList<FileTypeWithDescriptor> notExternalizableFileTypes = new ArrayList<FileTypeWithDescriptor>();
        for (FileTypeWithDescriptor ftd2 : this.getAllFileTypeWithDescriptors()) {
            if (ftd2.fileType instanceof AbstractFileType && !this.myDefaultTypes.contains(ftd2)) continue;
            notExternalizableFileTypes.add(ftd2);
        }
        if (!notExternalizableFileTypes.isEmpty()) {
            notExternalizableFileTypes.sort(Comparator.comparing(ftd -> ftd.fileType.getName()));
            for (FileTypeWithDescriptor ftd2 : notExternalizableFileTypes) {
                this.writeExtensionsMap(extensionMap, ftd2, true);
            }
        }
        this.myRemovedMappingTracker.save(extensionMap);
        if (!this.myUnresolvedMappings.isEmpty()) {
            ArrayList<Map.Entry<FileNameMatcher, String>> entries2 = new ArrayList<Map.Entry<FileNameMatcher, String>>(this.myUnresolvedMappings.entrySet());
            entries2.sort(Comparator.comparing(e -> ((FileNameMatcher)e.getKey()).getPresentableString()));
            for (Map.Entry entry2 : entries2) {
                FileNameMatcher fileNameMatcher = (FileNameMatcher)entry2.getKey();
                typeName = (String)entry2.getValue();
                Element content2 = AbstractFileType.writeMapping(typeName, fileNameMatcher, true);
                if (content2 == null) continue;
                extensionMap.addContent(content2);
            }
        }
        if (!this.myUnresolvedHashBangs.isEmpty()) {
            ArrayList<Map.Entry<String, String>> entries2 = new ArrayList<Map.Entry<String, String>>(this.myUnresolvedHashBangs.entrySet());
            entries2.sort(Map.Entry.comparingByKey());
            for (Map.Entry entry3 : entries2) {
                String pattern = (String)entry3.getKey();
                typeName = (String)entry3.getValue();
                FileTypeManagerImpl.writeHashBang(extensionMap, pattern, typeName);
            }
        }
        if (!extensionMap.getChildren().isEmpty()) {
            state.addContent(extensionMap);
        }
        if (!state.getChildren().isEmpty()) {
            state.setAttribute(ATTRIBUTE_VERSION, String.valueOf(18));
        }
        Element element2 = state;
        if (element2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(75);
        }
        return element2;
    }

    private void writeExtensionsMap(@NotNull Element extensionMap, @NotNull FileTypeWithDescriptor ftd, boolean specifyTypeName) {
        if (extensionMap == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(76);
        }
        if (ftd == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(77);
        }
        FileType type = ftd.fileType;
        List associations = this.myPatternsTable.getAssociations((Object)ftd);
        HashSet<FileNameMatcher> defaultAssociations = new HashSet<FileNameMatcher>(this.myInitialAssociations.getAssociations((Object)type));
        for (FileNameMatcher matcher2 : associations) {
            Element content2;
            boolean isDefaultAssociationContains = defaultAssociations.remove(matcher2);
            if (isDefaultAssociationContains || !FileTypeManagerImpl.shouldSave(type) || (content2 = AbstractFileType.writeMapping(type.getName(), matcher2, specifyTypeName)) == null) continue;
            extensionMap.addContent(content2);
        }
        List readOnlyHashBangs = this.myInitialAssociations.getHashBangPatterns((Object)type);
        List hashBangPatterns = this.myPatternsTable.getHashBangPatterns((Object)ftd);
        hashBangPatterns.sort(Comparator.naturalOrder());
        for (String hashBangPattern : hashBangPatterns) {
            if (readOnlyHashBangs.contains(hashBangPattern)) continue;
            FileTypeManagerImpl.writeHashBang(extensionMap, hashBangPattern, type.getName());
        }
        List<FileNameMatcher> removedMappings = this.myRemovedMappingTracker.getMappingsForFileType(type.getName());
        defaultAssociations.removeIf(matcher -> removedMappings.contains(matcher));
        this.myRemovedMappingTracker.saveRemovedMappingsForFileType(extensionMap, type.getName(), defaultAssociations, specifyTypeName);
    }

    private static void writeHashBang(@NotNull Element extensionMap, @NotNull String hashBangPattern, @NotNull String typeName) {
        if (extensionMap == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(78);
        }
        if (hashBangPattern == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(79);
        }
        if (typeName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(80);
        }
        Element hashBangTag = new Element("hashBang");
        hashBangTag.setAttribute("value", hashBangPattern);
        hashBangTag.setAttribute("type", typeName);
        extensionMap.addContent(hashBangTag);
    }

    private FileTypeWithDescriptor getFileTypeWithDescriptorByName(@NotNull String name2) {
        if (name2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(81);
        }
        this.instantiatePendingFileTypeByName(name2);
        return (FileTypeWithDescriptor)this.withReadLock(() -> this.mySchemeManager.findSchemeByName(name2));
    }

    @NotNull
    private static List<FileNameMatcher> parseExtensions(@NotNull Object context2, @NotNull String semicolonDelimitedExtensions) {
        if (context2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(82);
        }
        if (semicolonDelimitedExtensions == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(83);
        }
        return FileTypeManagerImpl.parse(context2, semicolonDelimitedExtensions, ext -> new ExtensionFileNameMatcher(ext));
    }

    @NotNull
    private static List<FileNameMatcher> parse(@NotNull Object context2, @NotNull String semicolonDelimitedTokens, @NotNull Function<? super String, ? extends FileNameMatcher> matcherFactory) {
        if (context2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(84);
        }
        if (semicolonDelimitedTokens == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(85);
        }
        if (matcherFactory == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(86);
        }
        if (semicolonDelimitedTokens.isEmpty()) {
            List<FileNameMatcher> list2 = Collections.emptyList();
            if (list2 == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(87);
            }
            return list2;
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimitedTokens, ";", false);
        ArrayList<FileNameMatcher> list3 = new ArrayList<FileNameMatcher>(StringUtil.countChars((CharSequence)semicolonDelimitedTokens, (char)';') + 1);
        while (tokenizer.hasMoreTokens()) {
            String ext = tokenizer.nextToken().trim();
            if (Strings.isEmpty((String)ext)) {
                throw new InvalidDataException("Token must not be empty but got: '" + semicolonDelimitedTokens + "' in " + context2);
            }
            list3.add(matcherFactory.apply(ext));
        }
        ArrayList<FileNameMatcher> arrayList = list3;
        if (arrayList == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(88);
        }
        return arrayList;
    }

    private void registerFileTypeWithoutNotification(@NotNull FileType newFileType, @NotNull PluginDescriptor newPluginDescriptor, @NotNull List<? extends FileNameMatcher> newMatchers, boolean addScheme) {
        if (newFileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(89);
        }
        if (newPluginDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(90);
        }
        if (newMatchers == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(91);
        }
        FileTypeWithDescriptor newFtd = new FileTypeWithDescriptor(newFileType, newPluginDescriptor);
        if (addScheme) {
            FileTypeWithDescriptor oldFileType = this.mySchemeManager.findSchemeByName(newFileType.getName());
            if (oldFileType != null && !(oldFileType.fileType instanceof AbstractFileType)) {
                throw new IllegalArgumentException(newFileType + " already registered");
            }
            this.mySchemeManager.addScheme(newFtd);
            this.myPendingFileTypes.remove(newFileType.getName());
            this.myPendingAssociations.removeAllAssociations(bean -> bean.name.equals(newFileType.getName()));
            this.checkFileTypeNamesUniqueness(newFtd);
        }
        List<FileNameMatcher> mappingsRemovedFromNew = this.myRemovedMappingTracker.getMappingsForFileType(newFileType.getName());
        for (FileNameMatcher fileNameMatcher : newMatchers) {
            FileType oldFileType;
            ConflictingFileTypeMappingTracker.ResolveConflictResult result2;
            List mappingsRemovedFromOld;
            if (mappingsRemovedFromNew.contains(fileNameMatcher)) continue;
            FileTypeWithDescriptor oldFtd = (FileTypeWithDescriptor)this.myPatternsTable.findAssociatedFileType(fileNameMatcher);
            List<Object> list2 = mappingsRemovedFromOld = oldFtd == null ? Collections.emptyList() : this.myRemovedMappingTracker.getMappingsForFileType(oldFtd.getName());
            if (mappingsRemovedFromOld.contains(fileNameMatcher)) {
                ConflictingFileTypeMappingTracker.ResolveConflictResult result3 = new ConflictingFileTypeMappingTracker.ResolveConflictResult(newFtd, "", "", true);
            } else {
                result2 = this.myConflictingMappingTracker.warnAndResolveConflict(fileNameMatcher, oldFtd, newFtd);
                if (oldFtd != null) {
                    LOG.debug(fileNameMatcher + " had a conflict between " + oldFtd + " and " + newFtd + " and the winner is ... ... ... " + result2);
                }
            }
            if (!result2.approved && this.myConflictResultConsumer != null) {
                this.myConflictResultConsumer.accept(result2);
            }
            FileTypeWithDescriptor resolvedFtd = result2.resolved;
            FileType fileType = oldFileType = oldFtd == null ? null : oldFtd.fileType;
            if (!resolvedFtd.equals(oldFtd)) {
                this.myPatternsTable.addAssociation(fileNameMatcher, (Object)resolvedFtd);
                if (result2.approved && oldFileType != null) {
                    this.myRemovedMappingTracker.add(fileNameMatcher, oldFileType.getName(), true);
                }
            } else if (oldFileType instanceof AbstractFileType && result2.approved) {
                this.myPatternsTable.addAssociation(fileNameMatcher, (Object)newFtd);
            }
            this.myInitialAssociations.addAssociation(fileNameMatcher, (Object)newFileType);
        }
        if (newFileType instanceof FileTypeIdentifiableByVirtualFile) {
            this.mySpecialFileTypes = (FileTypeIdentifiableByVirtualFile[])ArrayUtil.append((Object[])this.mySpecialFileTypes, (Object)((FileTypeIdentifiableByVirtualFile)newFileType), (ArrayFactory)FileTypeIdentifiableByVirtualFile.ARRAY_FACTORY);
        }
    }

    private void checkFileTypeNamesUniqueness(@NotNull FileTypeWithDescriptor newFtd) {
        if (newFtd == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(92);
        }
        FileTypeManagerImpl.checkUnique(newFtd, this.myNames.computeIfAbsent(newFtd.pluginDescriptor, __ -> new ConcurrentHashMap()), "getName", FileType::getName);
        FileTypeManagerImpl.checkUnique(newFtd, this.myDisplayNames.computeIfAbsent(newFtd.pluginDescriptor, __ -> new ConcurrentHashMap()), "getDisplayName", Scheme::getDisplayName);
        FileTypeManagerImpl.checkUnique(newFtd, this.myDescriptions.computeIfAbsent(newFtd.pluginDescriptor, __ -> new ConcurrentHashMap()), "getDescription", FileType::getDescription);
    }

    private static void checkUnique(@NotNull FileTypeWithDescriptor newFtd, @NotNull Map<String, FileTypeWithDescriptor> names2, @NotNull String getterName, @NotNull Function<? super FileType, String> nameExtractor) {
        FileType newFileType;
        String name2;
        FileTypeWithDescriptor prevFtd;
        if (newFtd == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(93);
        }
        if (names2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(94);
        }
        if (getterName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(95);
        }
        if (nameExtractor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(96);
        }
        if ((prevFtd = names2.put(name2 = nameExtractor.apply((FileType)(newFileType = newFtd.fileType)), newFtd)) != null && prevFtd.fileType instanceof AbstractFileType == newFileType instanceof AbstractFileType) {
            PluginDescriptor pluginToBlame;
            String error = "\n" + prevFtd + " (" + prevFtd.fileType.getClass() + ") and\n" + newFtd + " (" + newFileType.getClass() + ")\n both have the same ." + getterName + "(): '" + name2 + "'. Please override either one's " + getterName + "() to something unique.";
            PluginDescriptor pluginDescriptor = pluginToBlame = prevFtd.pluginDescriptor.isBundled() ? newFtd.pluginDescriptor : prevFtd.pluginDescriptor;
            if (prevFtd.pluginDescriptor.isBundled() || newFtd.pluginDescriptor.isBundled()) {
                LOG.error((Throwable)new PluginException(error, pluginToBlame.getPluginId()));
            } else {
                LOG.warn((Throwable)new PluginException(error, pluginToBlame.getPluginId()));
            }
        }
    }

    private void bindUnresolvedMappings(@NotNull StandardFileType standardFileType) {
        if (standardFileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(97);
        }
        for (FileNameMatcher matcher : new ArrayList<FileNameMatcher>(this.myUnresolvedMappings.keySet())) {
            String name2 = this.myUnresolvedMappings.get(matcher);
            if (!standardFileType.fileType.getName().equals(name2)) continue;
            this.myPatternsTable.addAssociation(matcher, (Object)standardFileType.getDescriptor());
            this.myUnresolvedMappings.remove(matcher);
        }
        for (FileNameMatcher matcher : this.myRemovedMappingTracker.getMappingsForFileType(standardFileType.fileType.getName())) {
            this.removeAssociation(FileTypeWithDescriptor.allFor(standardFileType.fileType), matcher, false);
        }
    }

    @NotNull
    static FileTypeWithDescriptor coreDescriptorFor(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(98);
        }
        return new FileTypeWithDescriptor(fileType, (PluginDescriptor)FileTypeManagerImpl.coreIdeaPluginDescriptor());
    }

    @NotNull
    private FileType loadFileType(@NotNull Object context2, @NotNull Element typeElement, @NotNull PluginDescriptor pluginDescriptor, boolean isDefault) {
        Object type;
        FileTypeWithDescriptor ftd;
        if (context2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(99);
        }
        if (typeElement == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(100);
        }
        if (pluginDescriptor == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(101);
        }
        String fileTypeName = typeElement.getAttributeValue(ATTRIBUTE_NAME);
        String extensionsStr = Objects.requireNonNullElse(typeElement.getAttributeValue("extensions"), "");
        if (isDefault && !extensionsStr.isEmpty()) {
            extensionsStr = this.filterAlreadyRegisteredExtensions(extensionsStr);
        }
        FileTypeWithDescriptor fileTypeWithDescriptor = ftd = isDefault && fileTypeName != null ? this.getFileTypeWithDescriptorByName(fileTypeName) : null;
        if (ftd != null) {
            FileType fileType = ftd.fileType;
            if (fileType == null) {
                FileTypeManagerImpl.$$$reportNull$$$0(102);
            }
            return fileType;
        }
        Element element2 = typeElement.getChild("highlighting");
        if (element2 == null) {
            type = UserBinaryFileType.INSTANCE;
        } else {
            SyntaxTable table = AbstractFileType.readSyntaxTable(element2);
            type = new AbstractFileType(table);
            ((AbstractFileType)type).initSupport();
        }
        @NlsSafe String fileTypeDescr = typeElement.getAttributeValue(ATTRIBUTE_DESCRIPTION);
        String iconPath = typeElement.getAttributeValue("icon");
        FileTypeManagerImpl.setFileTypeAttributes(type, fileTypeName, fileTypeDescr, iconPath);
        this.registerFileTypeWithoutNotification((FileType)type, pluginDescriptor, FileTypeManagerImpl.parseExtensions(context2, extensionsStr), isDefault);
        if (isDefault) {
            this.myDefaultTypes.add(new FileTypeWithDescriptor((FileType)type, pluginDescriptor));
            if (type instanceof ExternalizableFileType) {
                ((ExternalizableFileType)type).markDefaultSettings();
            }
        } else {
            Element extensions2 = typeElement.getChild(ELEMENT_EXTENSION_MAP);
            if (extensions2 != null) {
                FileTypeWithDescriptor newFtd = new FileTypeWithDescriptor((FileType)type, pluginDescriptor);
                for (Pair<FileNameMatcher, String> association : AbstractFileType.readAssociations(extensions2)) {
                    this.associate(newFtd, (FileNameMatcher)association.getFirst(), false);
                }
                for (RemovedMappingTracker.RemovedMapping removedAssociation : RemovedMappingTracker.readRemovedMappings(extensions2)) {
                    this.removeAssociation(newFtd, removedAssociation.getFileNameMatcher(), false);
                }
            }
        }
        Object object = type;
        if (object == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(103);
        }
        return object;
    }

    @NotNull
    private String filterAlreadyRegisteredExtensions(@NotNull String semicolonDelimited) {
        if (semicolonDelimited == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(104);
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        StringBuilder builder2 = null;
        while (tokenizer.hasMoreTokens()) {
            String extension2 = tokenizer.nextToken().trim();
            if (this.myPendingAssociations.findByExtension((CharSequence)extension2) != null || this.getFileTypeByExtension(extension2) != UnknownFileType.INSTANCE) continue;
            if (builder2 == null) {
                builder2 = new StringBuilder();
            } else if (builder2.length() > 0) {
                builder2.append(";");
            }
            builder2.append(extension2);
        }
        String string = builder2 == null ? "" : builder2.toString();
        if (string == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(105);
        }
        return string;
    }

    private static void setFileTypeAttributes(@NotNull UserFileType<?> fileType, @Nullable String name2, @Nullable @NlsContexts.Label String description, @Nullable String iconPath) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(106);
        }
        if (!Strings.isEmptyOrSpaces((CharSequence)iconPath)) {
            fileType.setIconPath(iconPath);
        }
        if (description != null) {
            fileType.setDescription(description);
        }
        if (name2 != null) {
            fileType.setName(name2);
        }
    }

    private static boolean shouldSave(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(107);
        }
        return fileType != UnknownFileType.INSTANCE && !fileType.isReadOnly();
    }

    @NotNull
    FileTypeAssocTable<FileTypeWithDescriptor> getExtensionMap() {
        this.instantiatePendingFileTypes();
        FileTypeAssocTable<FileTypeWithDescriptor> fileTypeAssocTable = this.myPatternsTable;
        if (fileTypeAssocTable == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(108);
        }
        return fileTypeAssocTable;
    }

    public void dispose() {
    }

    void setPatternsTable(@NotNull Set<? extends FileTypeWithDescriptor> fileTypes, @NotNull FileTypeAssocTable<FileTypeWithDescriptor> assocTable) {
        if (fileTypes == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(109);
        }
        if (assocTable == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(110);
        }
        Map removedMappings = this.getExtensionMap().getRemovedMappings(assocTable, fileTypes);
        String message2 = "set patterns table called: file types " + fileTypes + ", ass. table:" + assocTable;
        this.makeFileTypesChange(message2, () -> {
            for (FileTypeWithDescriptor existing : this.getRegisteredFileTypeWithDescriptors()) {
                if (fileTypes.contains(existing)) continue;
                this.mySchemeManager.removeScheme(existing);
            }
            for (FileTypeWithDescriptor ftd : fileTypes) {
                this.mySchemeManager.addScheme(ftd);
                if (!(ftd.fileType instanceof AbstractFileType)) continue;
                ((AbstractFileType)ftd.fileType).initSupport();
            }
            this.myPatternsTable = assocTable.copy();
        });
        this.myRemovedMappingTracker.removeIf(mapping2 -> {
            String fileTypeName = mapping2.getFileTypeName();
            FileTypeWithDescriptor fileType = this.getFileTypeWithDescriptorByName(fileTypeName);
            FileNameMatcher matcher = mapping2.getFileNameMatcher();
            return fileType != null && assocTable.isAssociatedWith((Object)fileType, matcher);
        });
        for (Map.Entry entry2 : removedMappings.entrySet()) {
            this.myRemovedMappingTracker.add((FileNameMatcher)entry2.getKey(), ((FileTypeWithDescriptor)entry2.getValue()).fileType.getName(), true);
        }
    }

    void associate(@NotNull FileTypeWithDescriptor ftd, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (ftd == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(111);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(112);
        }
        FileType fileType = ftd.fileType;
        this.myRemovedMappingTracker.removeIf(mapping2 -> matcher.equals(mapping2.getFileNameMatcher()) && fileType.getName().equals(mapping2.getFileTypeName()));
        if (!this.myPatternsTable.isAssociatedWith((Object)ftd, matcher)) {
            Runnable command = () -> this.myPatternsTable.addAssociation(matcher, (Object)ftd);
            if (fireChange) {
                this.makeFileTypesChange("file type '" + ftd.fileType + "' associated with '" + matcher + "'", command);
            } else {
                command.run();
            }
        }
    }

    private void removeAssociation(@NotNull FileTypeWithDescriptor ftd, @NotNull FileNameMatcher matcher, boolean fireChange) {
        if (ftd == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(113);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(114);
        }
        if (this.myPatternsTable.isAssociatedWith((Object)ftd, matcher)) {
            Runnable command = () -> this.myPatternsTable.removeAssociation(matcher, (Object)ftd);
            if (fireChange) {
                this.makeFileTypesChange("file type '" + ftd.fileType + "' association with '" + matcher + "' has been removed", command);
            } else {
                command.run();
            }
        }
    }

    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(115);
        }
        if (project == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(116);
        }
        return FileTypeChooser.getKnownFileTypeOrAssociate(file2, project);
    }

    private void registerReDetectedMappings(@NotNull StandardFileType pair) {
        FileType fileType;
        if (pair == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(117);
        }
        if ((fileType = pair.fileType) == PlainTextFileType.INSTANCE) {
            return;
        }
        for (FileNameMatcher matcher : pair.matchers) {
            this.registerReDetectedMapping(fileType.getName(), matcher);
            if (!(matcher instanceof ExtensionFileNameMatcher)) continue;
            ExtensionFileNameMatcher extMatcher = (ExtensionFileNameMatcher)matcher;
            this.registerReDetectedMapping(fileType.getName(), (FileNameMatcher)new ExactFileNameMatcher("." + extMatcher.getExtension()));
        }
    }

    private void registerReDetectedMapping(@NotNull String fileTypeName, @NotNull FileNameMatcher matcher) {
        String typeName;
        if (fileTypeName == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(118);
        }
        if (matcher == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(119);
        }
        if ((typeName = this.myUnresolvedMappings.get(matcher)) != null && !typeName.equals(fileTypeName)) {
            if (!this.myRemovedMappingTracker.hasRemovedMapping(matcher)) {
                this.myRemovedMappingTracker.add(matcher, fileTypeName, false);
            }
            this.myUnresolvedMappings.remove(matcher);
            this.tryToResolveMapping(typeName, matcher);
        }
    }

    private <T, E extends Throwable> T withReadLock(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(120);
        }
        return (T)ConcurrencyUtil.withLock((Lock)this.myPendingInitializationLock.readLock(), computable);
    }

    @NotNull
    RemovedMappingTracker getRemovedMappingTracker() {
        RemovedMappingTracker removedMappingTracker = this.myRemovedMappingTracker;
        if (removedMappingTracker == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(121);
        }
        return removedMappingTracker;
    }

    public PluginDescriptor findPluginDescriptor(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeManagerImpl.$$$reportNull$$$0(122);
        }
        for (FileTypeWithDescriptor ftd : this.getAllFileTypeWithDescriptors()) {
            if (!ftd.fileType.equals(fileType)) continue;
            return ftd.pluginDescriptor;
        }
        return null;
    }

    @TestOnly
    public void setConflictResultConsumer(@Nullable Consumer<? super ConflictingFileTypeMappingTracker.ResolveConflictResult> consumer2) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException();
        }
        this.myConflictResultConsumer = consumer2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 104: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 104: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdFileType";
                break;
            }
            case 2: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: 
            case 42: 
            case 43: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherBean";
                break;
            }
            case 7: 
            case 82: 
            case 84: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeBean";
                break;
            }
            case 13: 
            case 15: 
            case 54: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
            case 16: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 17: 
            case 61: 
            case 65: 
            case 112: 
            case 114: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 18: 
            case 20: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 31: 
            case 33: 
            case 55: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 34: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAssociations";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 46: 
            case 47: 
            case 98: 
            case 106: 
            case 107: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_LIST;
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugReasonMessage";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maskToRemove";
                break;
            }
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashBangs";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreMask";
                break;
            }
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_EXTENSION_MAP;
                break;
            }
            case 77: 
            case 111: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ftd";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashBangPattern";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolonDelimitedExtensions";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolonDelimitedTokens";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcherFactory";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileType";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPluginDescriptor";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMatchers";
                break;
            }
            case 92: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFtd";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getterName";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameExtractor";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardFileType";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolonDelimited";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assocTable";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "coreIdeaPluginDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 104: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeOrInstantiateFileTypeBean";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpReDetectQueue";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdFileType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFileName";
                break;
            }
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByFile";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFileTypeByFile";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFileTypeWithDescriptors";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByExtension";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeWithDescriptorByExtension";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredFileTypes";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesList";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedExtensions";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociations";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeOrUnknown";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "readHashBangs";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileType";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAlreadyRegisteredExtensions";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionMap";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemovedMappingTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unregisterMatchers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeFromDuplicates";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleFileTypesConflict";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "initializeMatchers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mergeOrInstantiateFileTypeBean";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "instantiateFileTypeBean";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStdFileType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "instantiatePendingFileTypeByName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryToResolveMapping";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFileName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "freezeFileTypeTemporarilyIn";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "detectFileTypeByFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getByFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findFileTypeByLanguage";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByExtension";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeWithDescriptorByExtension";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "registerFileType";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "unregisterFileType";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "unregisterFileTypeWithoutNotification";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredFilesList";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFilesListEqualToCurrent";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isFileIgnored";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedExtensions";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getAssociations";
                break;
            }
            case 60: 
            case 61: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "associate";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "detectPluginDescriptor";
                break;
            }
            case 64: 
            case 65: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "removeAssociation";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "makeFileTypesChange";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "unignoreMask";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "readGlobalMappings";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "registerHashBangs";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "readHashBangs";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "addIgnore";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "writeExtensionsMap";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "writeHashBang";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeWithDescriptorByName";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "parseExtensions";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypeWithoutNotification";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "checkFileTypeNamesUniqueness";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "checkUnique";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "bindUnresolvedMappings";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "coreDescriptorFor";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "loadFileType";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "filterAlreadyRegisteredExtensions";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "setFileTypeAttributes";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "shouldSave";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "setPatternsTable";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "getKnownFileTypeOrAssociate";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "registerReDetectedMappings";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "registerReDetectedMapping";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "withReadLock";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "findPluginDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 104: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PluginFileTypeConsumer
    implements FileTypeConsumer {
        private final PluginDescriptor myPluginDescriptor;

        PluginFileTypeConsumer(PluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(0);
            }
            this.myPluginDescriptor = pluginDescriptor;
        }

        public void consume(@NotNull FileType fileType) {
            if (fileType == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(1);
            }
            this.register(fileType, this.myPluginDescriptor, FileTypeManagerImpl.parseExtensions("filetypes.xml/" + fileType.getName(), fileType.getDefaultExtension()));
        }

        public void consume(@NotNull FileType fileType, @NotNull String semicolonDelimitedExtensions) {
            if (fileType == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(2);
            }
            if (semicolonDelimitedExtensions == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(3);
            }
            this.register(fileType, this.myPluginDescriptor, FileTypeManagerImpl.parseExtensions("filetypes.xml/" + fileType.getName(), semicolonDelimitedExtensions));
        }

        public void consume(@NotNull FileType fileType, FileNameMatcher ... matchers) {
            if (fileType == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(4);
            }
            if (matchers == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(5);
            }
            this.register(fileType, this.myPluginDescriptor, Arrays.asList(matchers));
        }

        public FileType getStandardFileTypeByName(@NotNull String name2) {
            StandardFileType type;
            if (name2 == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(6);
            }
            return (type = FileTypeManagerImpl.this.myStandardFileTypes.get(name2)) != null ? type.fileType : null;
        }

        private void register(@NotNull FileType fileType, @NotNull PluginDescriptor pluginDescriptor, @NotNull List<? extends FileNameMatcher> fileNameMatchers) {
            if (fileType == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(7);
            }
            if (pluginDescriptor == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(8);
            }
            if (fileNameMatchers == null) {
                PluginFileTypeConsumer.$$$reportNull$$$0(9);
            }
            String typeName = fileType.getName();
            FileTypeManagerImpl.this.instantiatePendingFileTypeByName(typeName);
            for (FileNameMatcher fileNameMatcher : fileNameMatchers) {
                PluginId pluginId;
                FileTypeBean fileTypeBean = (FileTypeBean)FileTypeManagerImpl.this.myPendingAssociations.findAssociatedFileType(fileNameMatcher);
                if (fileTypeBean == null || !PluginManagerCore.CORE_ID.equals((Object)(pluginId = fileTypeBean.getPluginId()))) continue;
                FileTypeManagerImpl.this.instantiateFileTypeBean(fileTypeBean);
            }
            StandardFileType type = FileTypeManagerImpl.this.myStandardFileTypes.get(typeName);
            if (type == null) {
                FileTypeManagerImpl.this.myStandardFileTypes.put(typeName, new StandardFileType(fileType, pluginDescriptor, fileNameMatchers));
                FileTypeManagerImpl.this.registerFileTypeWithoutNotification(fileType, pluginDescriptor, fileNameMatchers, true);
            } else {
                type.matchers.addAll(fileNameMatchers);
                for (FileNameMatcher fileNameMatcher : fileNameMatchers) {
                    FileTypeManagerImpl.this.myPatternsTable.addAssociation(fileNameMatcher, (Object)type.getDescriptor());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "semicolonDelimitedExtensions";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchers";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = FileTypeManagerImpl.ATTRIBUTE_NAME;
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileNameMatchers";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$PluginFileTypeConsumer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "consume";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getStandardFileTypeByName";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "register";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class FileTypeWithDescriptor
    implements Scheme {
        private static final PluginDescriptor WILD_CARD = new DefaultPluginDescriptor("WILD_CARD");
        @NotNull
        final FileType fileType;
        @NotNull
        final PluginDescriptor pluginDescriptor;

        FileTypeWithDescriptor(@NotNull FileType fileType, @NotNull PluginDescriptor pluginDescriptor) {
            if (fileType == null) {
                FileTypeWithDescriptor.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                FileTypeWithDescriptor.$$$reportNull$$$0(1);
            }
            this.fileType = fileType;
            this.pluginDescriptor = pluginDescriptor;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.fileType.equals(((FileTypeWithDescriptor)o).fileType);
        }

        public int hashCode() {
            return this.fileType.hashCode();
        }

        public String toString() {
            return this.fileType + " from '" + (this.pluginDescriptor == WILD_CARD ? "*" : this.pluginDescriptor) + "'";
        }

        @NotNull
        static FileTypeWithDescriptor allFor(@NotNull FileType fileType) {
            if (fileType == null) {
                FileTypeWithDescriptor.$$$reportNull$$$0(2);
            }
            return new FileTypeWithDescriptor(fileType, WILD_CARD);
        }

        @NotNull
        public String getName() {
            String string = this.fileType.getName();
            if (string == null) {
                FileTypeWithDescriptor.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$FileTypeWithDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$FileTypeWithDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "allFor";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class StandardFileType {
        @NotNull
        private final FileType fileType;
        @NotNull
        private final List<FileNameMatcher> matchers;
        @NotNull
        private final PluginDescriptor pluginDescriptor;

        private StandardFileType(@NotNull FileType fileType, @NotNull PluginDescriptor pluginDescriptor, @NotNull List<? extends FileNameMatcher> matchers) {
            if (fileType == null) {
                StandardFileType.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                StandardFileType.$$$reportNull$$$0(1);
            }
            if (matchers == null) {
                StandardFileType.$$$reportNull$$$0(2);
            }
            this.fileType = fileType;
            this.pluginDescriptor = pluginDescriptor;
            this.matchers = new ArrayList<FileNameMatcher>(matchers);
        }

        @NotNull
        private FileTypeWithDescriptor getDescriptor() {
            return new FileTypeWithDescriptor(this.fileType, this.pluginDescriptor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pluginDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "matchers";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$StandardFileType";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

