/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupStub;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionsTreeUtil {
    private static final Logger LOG = Logger.getInstance(ActionsTreeUtil.class);
    @NonNls
    private static final String EDITOR_PREFIX = "Editor";

    private ActionsTreeUtil() {
    }

    @NotNull
    public static Map<String, String> createPluginActionsMap() {
        HashSet<PluginId> visited = new HashSet<PluginId>();
        Map result2 = CollectionFactory.createSmallMemoryFootprintMap();
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
            PluginId id2 = descriptor2.getPluginId();
            visited.add(id2);
            if (PluginManagerCore.CORE_ID.equals((Object)id2)) continue;
            for (String actionId : actionManager.getPluginActions(id2)) {
                result2.put(actionId, descriptor2.getName());
            }
        }
        for (PluginId id3 : PluginId.getRegisteredIds()) {
            if (visited.contains(id3)) continue;
            for (String actionId : actionManager.getPluginActions(id3)) {
                result2.put(actionId, id3.getIdString());
            }
        }
        Map map2 = result2;
        if (map2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(0);
        }
        return map2;
    }

    @NotNull
    private static Group createPluginsActionsGroup(Condition<? super AnAction> filtered2) {
        Group pluginsGroup = new Group(KeyMapBundle.message((String)"plugins.group.title", (Object[])new Object[0]), null, null);
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        JBIterable plugins2 = JBIterable.of((Object[])PluginManagerCore.getPlugins()).sort(Comparator.comparing(PluginDescriptor::getName));
        Map pluginNames = plugins2.toMap(PluginDescriptor::getPluginId, PluginDescriptor::getName);
        List pluginsIds = plugins2.map(PluginDescriptor::getPluginId).append((Iterable)JBIterable.from((Iterable)PluginId.getRegisteredIds()).sort(PluginId::compareTo)).unique().toList();
        for (PluginId pluginId : pluginsIds) {
            String name2;
            Group pluginGroup;
            String[] pluginActions;
            if (PluginManagerCore.CORE_ID.equals((Object)pluginId) || (pluginActions = actionManager.getPluginActions(pluginId)).length == 0 || (pluginGroup = ActionsTreeUtil.createPluginActionsGroup(name2 = StringUtil.notNullize((String)((String)pluginNames.get(pluginId)), (String)pluginId.getIdString()), pluginActions, filtered2)).getSize() <= 0) continue;
            pluginsGroup.addGroup(pluginGroup);
        }
        Group group2 = pluginsGroup;
        if (group2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(1);
        }
        return group2;
    }

    @NotNull
    private static Group createPluginActionsGroup(@NlsActions.ActionText String name2, String[] pluginActions, Condition<? super AnAction> filtered2) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        Group pluginGroup = new Group(name2, null, null);
        Arrays.sort(pluginActions, Comparator.comparing(ActionsTreeUtil::getTextToCompare));
        for (String actionId : pluginActions) {
            AnAction action2 = actionManager.getActionOrStub(actionId);
            if (ActionsTreeUtil.isNonExecutableActionGroup(actionId, action2) || filtered2 != null && !filtered2.value((Object)action2)) continue;
            pluginGroup.addActionId(actionId);
        }
        Group group2 = pluginGroup;
        if (group2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(2);
        }
        return group2;
    }

    private static Group createMainMenuGroup(Condition<? super AnAction> filtered2) {
        ActionManager actionManager = ActionManager.getInstance();
        Group group2 = new Group(ActionsTreeUtil.getMainMenuTitle(), "MainMenu", AllIcons.Nodes.KeymapMainMenu);
        ActionGroup mainMenuGroup = (ActionGroup)actionManager.getActionOrStub("MainMenu");
        ActionsTreeUtil.fillGroupIgnorePopupFlag(mainMenuGroup, group2, filtered2, actionManager);
        return group2;
    }

    @NotNull
    private static Condition<AnAction> wrapFilter(@Nullable Condition<? super AnAction> filter, Keymap keymap2, ActionManager actionManager) {
        ActionShortcutRestrictions shortcutRestrictions = ActionShortcutRestrictions.getInstance();
        Condition condition = action2 -> {
            String id2;
            if (action2 == null) {
                return false;
            }
            String string = id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : actionManager.getId(action2);
            if (id2 != null) {
                if (!Registry.is((String)"keymap.show.alias.actions")) {
                    boolean bound;
                    String binding = KeymapManagerEx.getInstanceEx().getActionBinding(id2);
                    boolean bl = bound = binding != null && actionManager.getAction(binding) != null && !ActionsTreeUtil.hasAssociatedShortcutsInHierarchy(id2, keymap2);
                    if (bound) {
                        return false;
                    }
                }
                if (!shortcutRestrictions.getForActionId((String)id2).allowChanging) {
                    return false;
                }
            }
            return filter == null || filter.value(action2);
        };
        if (condition == null) {
            ActionsTreeUtil.$$$reportNull$$$0(3);
        }
        return condition;
    }

    private static boolean hasAssociatedShortcutsInHierarchy(String id2, Keymap keymap2) {
        while (keymap2 != null) {
            if (((KeymapImpl)keymap2).hasOwnActionId(id2)) {
                return true;
            }
            keymap2 = keymap2.getParent();
        }
        return false;
    }

    private static void fillGroupIgnorePopupFlag(ActionGroup actionGroup2, Group group2, Condition<? super AnAction> filtered2, ActionManager actionManager) {
        AnAction[] mainMenuTopGroups;
        for (AnAction action2 : mainMenuTopGroups = ActionsTreeUtil.getActions(actionGroup2, actionManager)) {
            Group subGroup;
            if (!(action2 instanceof ActionGroup) || (subGroup = ActionsTreeUtil.createGroup((ActionGroup)action2, false, filtered2)).getSize() <= 0) continue;
            group2.addGroup(subGroup);
        }
    }

    public static Group createGroup(ActionGroup actionGroup2, boolean ignore, Condition<? super AnAction> filtered2) {
        return ActionsTreeUtil.createGroup(actionGroup2, ActionsTreeUtil.getName((AnAction)actionGroup2), actionGroup2.getTemplatePresentation().getIcon(), null, ignore, filtered2);
    }

    @NlsActions.ActionText
    private static String getName(AnAction action2) {
        String id2;
        String name2 = action2.getTemplatePresentation().getText();
        if (name2 != null && !name2.isEmpty()) {
            return name2;
        }
        String string = id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : ActionManager.getInstance().getId(action2);
        if (id2 != null) {
            return id2;
        }
        if (action2 instanceof DefaultActionGroup) {
            AnAction[] children2;
            DefaultActionGroup group2 = (DefaultActionGroup)action2;
            if (group2.getChildrenCount() == 0) {
                return IdeBundle.message((String)"action.empty.group.text", (Object[])new Object[0]);
            }
            for (AnAction child2 : children2 = group2.getChildActionsOrStubs()) {
                if (child2 instanceof Separator) continue;
                return "group." + ActionsTreeUtil.getName(child2);
            }
            return IdeBundle.message((String)"action.empty.unnamed.group.text", (Object[])new Object[0]);
        }
        return action2.getClass().getName();
    }

    public static Group createGroup(ActionGroup actionGroup2, @NlsActions.ActionText String groupName, Icon icon2, Icon openIcon, boolean ignore, Condition<? super AnAction> filtered2) {
        return ActionsTreeUtil.createGroup(actionGroup2, groupName, icon2, openIcon, ignore, filtered2, true);
    }

    public static Group createGroup(ActionGroup actionGroup2, @NlsActions.ActionText String groupName, Icon icon2, Icon openIcon, boolean ignore, Condition<? super AnAction> filtered2, boolean normalizeSeparators) {
        AnAction[] children2;
        ActionManager actionManager = ActionManager.getInstance();
        Group group2 = new Group(groupName, actionManager.getId((AnAction)actionGroup2), icon2);
        for (AnAction action2 : children2 = ActionsTreeUtil.getActions(actionGroup2, actionManager)) {
            String id2;
            if (action2 == null) {
                LOG.error(groupName + " contains null actions");
                continue;
            }
            if (action2 instanceof ActionGroup) {
                Group subGroup = ActionsTreeUtil.createGroup((ActionGroup)action2, ActionsTreeUtil.getName(action2), null, null, ignore, filtered2, normalizeSeparators);
                if (!ignore && !((ActionGroup)action2).isPopup()) {
                    group2.addAll(subGroup);
                    continue;
                }
                if (subGroup.getSize() <= 0 && filtered2 != null && !filtered2.value((Object)action2)) continue;
                group2.addGroup(subGroup);
                continue;
            }
            if (action2 instanceof Separator) {
                group2.addSeparator();
                continue;
            }
            String string = id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : actionManager.getId(action2);
            if (id2 == null || filtered2 != null && !filtered2.value((Object)action2)) continue;
            group2.addActionId(id2);
        }
        if (normalizeSeparators) {
            group2.normalizeSeparators();
        }
        return group2;
    }

    @NotNull
    public static Group createCorrectedGroup(@NotNull ActionGroup actionGroup2, @NotNull @NlsActions.ActionText String groupName, @NotNull List<? super String> path2, @NotNull List<? extends ActionUrl> actionUrls) {
        if (actionGroup2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(4);
        }
        if (groupName == null) {
            ActionsTreeUtil.$$$reportNull$$$0(5);
        }
        if (path2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(6);
        }
        if (actionUrls == null) {
            ActionsTreeUtil.$$$reportNull$$$0(7);
        }
        path2.add(groupName);
        ActionManager actionManager = ActionManager.getInstance();
        Group group2 = new Group(groupName, actionManager.getId((AnAction)actionGroup2), null);
        ArrayList children2 = ContainerUtil.newArrayList((Object[])ActionsTreeUtil.getActions(actionGroup2, actionManager));
        for (ActionUrl actionUrl : actionUrls) {
            AnAction anAction2;
            AnAction componentAction;
            if (!path2.equals(actionUrl.getGroupPath()) || (componentAction = actionUrl.getComponentAction()) == null) continue;
            if (actionUrl.getActionType() == 1) {
                if (children2.size() > actionUrl.getAbsolutePosition()) {
                    children2.add(actionUrl.getAbsolutePosition(), componentAction);
                    continue;
                }
                children2.add(componentAction);
                continue;
            }
            if (actionUrl.getActionType() != -1 || children2.size() <= actionUrl.getAbsolutePosition() || ((anAction2 = (AnAction)children2.get(actionUrl.getAbsolutePosition())).getTemplatePresentation().getText() == null ? componentAction.getTemplatePresentation().getText() != null && componentAction.getTemplatePresentation().getText().length() > 0 : !anAction2.getTemplatePresentation().getText().equals(componentAction.getTemplatePresentation().getText()))) continue;
            children2.remove(actionUrl.getAbsolutePosition());
        }
        for (AnAction anAction2 : children2) {
            if (anAction2 instanceof ActionGroup) {
                group2.addGroup(ActionsTreeUtil.createCorrectedGroup((ActionGroup)anAction2, ActionsTreeUtil.getName(anAction2), path2, actionUrls));
                continue;
            }
            if (anAction2 instanceof Separator) {
                group2.addSeparator();
                continue;
            }
            String id2 = anAction2 instanceof ActionStub ? ((ActionStub)anAction2).getId() : actionManager.getId(anAction2);
            if (id2 == null) continue;
            group2.addActionId(id2);
        }
        path2.remove(path2.size() - 1);
        Group group3 = group2;
        if (group3 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(8);
        }
        return group3;
    }

    private static Group createEditorActionsGroup(Condition<? super AnAction> filtered2) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup editorGroup = (DefaultActionGroup)actionManager.getActionOrStub("EditorActions");
        if (editorGroup == null) {
            throw new AssertionError((Object)"EditorActions group not found");
        }
        ArrayList ids = new ArrayList();
        ActionsTreeUtil.addEditorActions(filtered2, editorGroup, ids);
        Collections.sort(ids);
        Group group2 = new Group(KeyMapBundle.message((String)"editor.actions.group.title", (Object[])new Object[0]), "EditorActions", AllIcons.Nodes.KeymapEditor);
        for (String id2 : ids) {
            group2.addActionId(id2);
        }
        return group2;
    }

    private static void addEditorActions(Condition<? super AnAction> filtered2, DefaultActionGroup editorGroup, ArrayList<? super String> ids) {
        AnAction[] editorActions = editorGroup.getChildActionsOrStubs();
        ActionManager actionManager = ActionManager.getInstance();
        for (AnAction editorAction : editorActions) {
            String actionId;
            if (editorAction instanceof DefaultActionGroup) {
                ActionsTreeUtil.addEditorActions(filtered2, (DefaultActionGroup)editorAction, ids);
                continue;
            }
            String string = actionId = editorAction instanceof ActionStub ? ((ActionStub)editorAction).getId() : actionManager.getId(editorAction);
            if (actionId == null || filtered2 != null && !filtered2.value((Object)editorAction)) continue;
            ids.add(actionId);
        }
    }

    private static Group createExtensionGroup(Condition<? super AnAction> filtered2, Project project, KeymapExtension provider2) {
        return (Group)provider2.createGroup(filtered2, project);
    }

    private static Group createMacrosGroup(Condition<? super AnAction> filtered2) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        List ids = actionManager.getActionIdList("Macro.");
        ids.sort(null);
        Group group2 = new Group(KeyMapBundle.message((String)"macros.group.title", (Object[])new Object[0]), null, null);
        for (String id2 : ids) {
            if (filtered2 != null && !filtered2.value((Object)actionManager.getActionOrStub(id2))) continue;
            group2.addActionId(id2);
        }
        return group2;
    }

    private static Group createQuickListsGroup(Condition<? super AnAction> filtered2, String filter, boolean forceFiltering, QuickList[] quickLists) {
        Arrays.sort(quickLists, Comparator.comparing(QuickList::getActionId));
        Group group2 = new Group(KeyMapBundle.message((String)"quick.lists.group.title", (Object[])new Object[0]), null, null);
        for (QuickList quickList : quickLists) {
            if ((filtered2 == null || !filtered2.value((Object)ActionManagerEx.getInstanceEx().getAction(quickList.getActionId()))) && !SearchUtil.isComponentHighlighted(quickList.getName(), filter, forceFiltering, null) && (filtered2 != null || !StringUtil.isEmpty((String)filter))) continue;
            group2.addQuickList(quickList);
        }
        return group2;
    }

    @NotNull
    private static Group createOtherGroup(@Nullable Condition<? super AnAction> filtered2, Group mainGroup, @Nullable Keymap keymap2) {
        mainGroup.initIds();
        HashSet<String> result2 = new HashSet<String>();
        ActionManagerImpl actionManager = (ActionManagerImpl)ActionManagerEx.getInstanceEx();
        if (keymap2 != null) {
            for (Object id2 : keymap2.getActionIdList()) {
                if (((String)id2).startsWith(EDITOR_PREFIX) && actionManager.getActionOrStub("$" + ((String)id2).substring(6)) != null || ((String)id2).startsWith("QuickList.") || mainGroup.containsId((String)id2)) continue;
                result2.add((String)id2);
            }
        }
        ArrayList<String> namedGroups = new ArrayList<String>();
        for (String string : actionManager.getActionIdList("")) {
            AnAction actionOrStub;
            if (ActionsTreeUtil.isNonExecutableActionGroup(string, actionOrStub = actionManager.getActionOrStub(string)) || string.startsWith("QuickList.") || mainGroup.containsId(string) || result2.contains(string)) continue;
            if (actionOrStub instanceof ActionGroup) {
                namedGroups.add(string);
                continue;
            }
            result2.add(string);
        }
        ActionsTreeUtil.filterOtherActionsGroup(result2);
        Group group2 = new Group(KeyMapBundle.message((String)"other.group.title", (Object[])new Object[0]), AllIcons.Nodes.KeymapOther);
        for (AnAction anAction2 : ActionsTreeUtil.getActions("Other.KeymapGroup")) {
            ActionsTreeUtil.addAction(group2, anAction2, (ActionManager)actionManager, filtered2, false);
        }
        Set<String> set2 = group2.initIds();
        JBTreeTraverser traverser = JBTreeTraverser.from(o -> actionManager.getParentGroupIds((String)o));
        for (String string : namedGroups) {
            if (((JBTreeTraverser)((JBTreeTraverser)traverser.withRoot((Object)string)).unique()).traverse().filter(o -> mainGroup.containsId((String)o) || group2.containsId((String)o)).isNotEmpty()) continue;
            result2.add(string);
        }
        ContainerUtil.sort(group2.getChildren(), Comparator.comparing(o -> ((Group)o).getName()));
        result2.removeAll(set2);
        for (String string : ContainerUtil.sorted(result2, Comparator.comparing(o -> ActionsTreeUtil.getTextToCompare(o)))) {
            if (filtered2 != null && !filtered2.value((Object)actionManager.getActionOrStub(string))) continue;
            group2.addActionId(string);
        }
        Group group3 = group2;
        if (group3 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(9);
        }
        return group3;
    }

    private static boolean isNonExecutableActionGroup(String id2, AnAction actionOrStub) {
        return actionOrStub instanceof ActionGroup && (((ActionGroup)actionOrStub).isPopup() || StringUtil.isEmpty((String)actionOrStub.getTemplateText()) || StringUtil.containsIgnoreCase((String)id2, (String)"Popup") || StringUtil.containsIgnoreCase((String)id2, (String)"Toolbar"));
    }

    private static String getTextToCompare(String id2) {
        AnAction action2 = ActionManager.getInstance().getActionOrStub(id2);
        if (action2 == null) {
            return id2;
        }
        String text2 = action2.getTemplatePresentation().getText();
        return text2 != null ? text2 : id2;
    }

    private static void filterOtherActionsGroup(Set<String> actions2) {
        ActionsTreeUtil.filterOutGroup(actions2, "GenerateGroup");
        ActionsTreeUtil.filterOutGroup(actions2, "NewGroup");
        ActionsTreeUtil.filterOutGroup(actions2, "ChangeScheme");
    }

    private static void filterOutGroup(Set<String> actions2, String groupId2) {
        if (groupId2 == null) {
            throw new IllegalArgumentException();
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action2 = actionManager.getActionOrStub(groupId2);
        if (action2 instanceof DefaultActionGroup) {
            AnAction[] children2;
            DefaultActionGroup group2 = (DefaultActionGroup)action2;
            for (AnAction child2 : children2 = group2.getChildActionsOrStubs()) {
                String childId;
                String string = childId = child2 instanceof ActionStub ? ((ActionStub)child2).getId() : actionManager.getId(child2);
                if (childId == null) continue;
                if (child2 instanceof DefaultActionGroup) {
                    ActionsTreeUtil.filterOutGroup(actions2, childId);
                    continue;
                }
                actions2.remove(childId);
            }
        }
    }

    public static DefaultMutableTreeNode createNode(Group group2) {
        DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(group2);
        for (Object child2 : group2.getChildren()) {
            if (child2 instanceof Group) {
                DefaultMutableTreeNode childNode = ActionsTreeUtil.createNode((Group)child2);
                node2.add(childNode);
                continue;
            }
            LOG.assertTrue(child2 != null);
            node2.add(new DefaultMutableTreeNode(child2));
        }
        return node2;
    }

    public static Group createMainGroup(Project project, Keymap keymap2, QuickList[] quickLists) {
        return ActionsTreeUtil.createMainGroup(project, keymap2, quickLists, null, false, null);
    }

    public static Group createMainGroup(Project project, Keymap keymap2, QuickList[] quickLists, String filter, boolean forceFiltering, Condition<? super AnAction> filtered2) {
        Condition<AnAction> wrappedFilter = ActionsTreeUtil.wrapFilter(filtered2, keymap2, ActionManager.getInstance());
        Group mainGroup = new Group(KeyMapBundle.message((String)"all.actions.group.title", (Object[])new Object[0]), null, null);
        mainGroup.addGroup(ActionsTreeUtil.createEditorActionsGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createMainMenuGroup(wrappedFilter));
        for (KeymapExtension extension2 : KeymapExtension.EXTENSION_POINT_NAME.getExtensionList()) {
            Group group2 = ActionsTreeUtil.createExtensionGroup(wrappedFilter, project, extension2);
            if (group2 == null) continue;
            mainGroup.addGroup(group2);
        }
        mainGroup.addGroup(ActionsTreeUtil.createMacrosGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createQuickListsGroup(wrappedFilter, filter, forceFiltering, quickLists));
        mainGroup.addGroup(ActionsTreeUtil.createPluginsActionsGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createOtherGroup(wrappedFilter, mainGroup, keymap2));
        if (!StringUtil.isEmpty((String)filter) || filtered2 != null) {
            ArrayList<Object> list2 = mainGroup.getChildren();
            Iterator<Object> i2 = list2.iterator();
            while (i2.hasNext()) {
                Group group3;
                Object o = i2.next();
                if (!(o instanceof Group) || (group3 = (Group)o).getSize() != 0 || SearchUtil.isComponentHighlighted(group3.getName(), filter, forceFiltering, null)) continue;
                i2.remove();
            }
        }
        return mainGroup;
    }

    private static Condition<AnAction> isActionFiltered(String filter, boolean force) {
        return action2 -> {
            String id2;
            if (filter == null) {
                return true;
            }
            if (action2 == null) {
                return false;
            }
            action2 = ActionsTreeUtil.tryUnstubAction(action2);
            String insensitiveFilter = StringUtil.toLowerCase((String)filter);
            ArrayList<String> options2 = new ArrayList<String>();
            options2.add(action2.getTemplatePresentation().getText());
            options2.add(action2.getTemplatePresentation().getDescription());
            for (Supplier synonym : action2.getSynonyms()) {
                options2.add((String)synonym.get());
            }
            String string = id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : ActionManager.getInstance().getId(action2);
            if (id2 != null) {
                options2.add(id2);
                options2.addAll(AbbreviationManager.getInstance().getAbbreviations(id2));
            }
            for (String text2 : options2) {
                String lowerText;
                if (text2 == null || !SearchUtil.isComponentHighlighted(lowerText = StringUtil.toLowerCase((String)text2), insensitiveFilter, force, null) && !lowerText.contains(insensitiveFilter)) continue;
                return true;
            }
            return false;
        };
    }

    private static Condition<AnAction> isActionFiltered(ActionManager actionManager, Keymap keymap2, Shortcut shortcut) {
        return ActionsTreeUtil.isActionFiltered(actionManager, keymap2, (Condition<? super Shortcut>)((Condition)sc -> sc != null && sc.startsWith(shortcut)));
    }

    public static Condition<AnAction> isActionFiltered(ActionManager actionManager, Keymap keymap2, Condition<? super Shortcut> predicat) {
        return action2 -> {
            Shortcut[] actionShortcuts;
            if (action2 == null) {
                return false;
            }
            for (Shortcut actionShortcut : actionShortcuts = keymap2.getShortcuts(action2 instanceof ActionStub ? ((ActionStub)action2).getId() : actionManager.getId(action2))) {
                if (!predicat.value((Object)actionShortcut)) continue;
                return true;
            }
            return false;
        };
    }

    public static Condition<AnAction> isActionFiltered(ActionManager actionManager, Keymap keymap2, Shortcut shortcut, String filter, boolean force) {
        return filter != null && filter.length() > 0 ? ActionsTreeUtil.isActionFiltered(filter, force) : (shortcut != null ? ActionsTreeUtil.isActionFiltered(actionManager, keymap2, shortcut) : null);
    }

    public static void addAction(KeymapGroup group2, AnAction action2, Condition<? super AnAction> filtered2) {
        ActionsTreeUtil.addAction(group2, action2, filtered2, false);
    }

    public static void addAction(KeymapGroup group2, AnAction action2, Condition<? super AnAction> filtered2, boolean forceNonPopup) {
        ActionsTreeUtil.addAction(group2, action2, ActionManager.getInstance(), filtered2, forceNonPopup);
    }

    private static void addAction(KeymapGroup group2, AnAction action2, ActionManager actionManager, Condition<? super AnAction> filtered2, boolean forceNonPopup) {
        if (action2 instanceof ActionGroup) {
            if (forceNonPopup) {
                AnAction[] actions2;
                for (AnAction childAction : actions2 = ActionsTreeUtil.getActions((ActionGroup)action2, actionManager)) {
                    ActionsTreeUtil.addAction(group2, childAction, actionManager, filtered2, true);
                }
            } else {
                Group subGroup = ActionsTreeUtil.createGroup((ActionGroup)action2, false, filtered2);
                if (subGroup.getSize() > 0) {
                    group2.addGroup((KeymapGroup)subGroup);
                }
            }
        } else if (action2 instanceof Separator) {
            if (group2 instanceof Group) {
                ((Group)group2).addSeparator();
            }
        } else if (filtered2 == null || filtered2.value((Object)action2)) {
            String id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : actionManager.getId(action2);
            group2.addActionId(id2);
        }
    }

    public static AnAction @NotNull [] getActions(@NonNls String actionGroup2) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction group2 = actionManager.getActionOrStub(actionGroup2);
        LOG.assertTrue(group2 instanceof ActionGroup, (Object)(actionGroup2 + " is " + (group2 == null ? "not found" : "not a group")));
        return ActionsTreeUtil.getActions((ActionGroup)group2, actionManager);
    }

    private static AnAction @NotNull [] getActions(@NotNull ActionGroup group2, @NotNull ActionManager actionManager) {
        if (group2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(10);
        }
        if (actionManager == null) {
            ActionsTreeUtil.$$$reportNull$$$0(11);
        }
        ActionGroup adjusted = group2 instanceof ActionGroupStub ? (ActionGroup)actionManager.getAction(((ActionGroupStub)group2).getId()) : group2;
        AnAction[] anActionArray = adjusted instanceof DefaultActionGroup ? ((DefaultActionGroup)adjusted).getChildActionsOrStubs() : adjusted.getChildren(null);
        if (anActionArray == null) {
            ActionsTreeUtil.$$$reportNull$$$0(12);
        }
        return anActionArray;
    }

    @NotNull
    private static AnAction tryUnstubAction(@NotNull AnAction action2) {
        AnAction newAction;
        if (action2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(13);
        }
        if (action2 instanceof ActionStub && (newAction = ActionManager.getInstance().getActionOrStub(((ActionStub)action2).getId())) != null) {
            AnAction anAction2 = newAction;
            if (anAction2 == null) {
                ActionsTreeUtil.$$$reportNull$$$0(14);
            }
            return anAction2;
        }
        AnAction anAction3 = action2;
        if (anAction3 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(15);
        }
        return anAction3;
    }

    @Nls
    public static String getMainMenuTitle() {
        return KeyMapBundle.message((String)"main.menu.action.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getMainToolbar() {
        return KeyMapBundle.message((String)"main.toolbar.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getExperimentalToolbar() {
        return KeyMapBundle.message((String)"experimental.toolbar.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getEditorPopup() {
        return KeyMapBundle.message((String)"editor.popup.menu.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getEditorGutterPopupMenu() {
        return KeyMapBundle.message((String)"editor.gutter.popup.menu", (Object[])new Object[0]);
    }

    @Nls
    public static String getScopeViewPopupMenu() {
        return KeyMapBundle.message((String)"scope.view.popup.menu", (Object[])new Object[0]);
    }

    @Nls
    public static String getNavigationBarPopupMenu() {
        return KeyMapBundle.message((String)"navigation.bar.popup.menu", (Object[])new Object[0]);
    }

    @Nls
    public static String getNavigationBarToolbar() {
        return KeyMapBundle.message((String)"navigation.bar.toolbar", (Object[])new Object[0]);
    }

    @Nls
    public static String getEditorTabPopup() {
        return KeyMapBundle.message((String)"editor.tab.popup.menu.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getFavoritesPopup() {
        return KeyMapBundle.message((String)"favorites.popup.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getProjectViewPopup() {
        return KeyMapBundle.message((String)"project.view.popup.menu.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getCommanderPopup() {
        return KeyMapBundle.message((String)"commender.view.popup.menu.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getJ2EEPopup() {
        return KeyMapBundle.message((String)"j2ee.view.popup.menu.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/ActionsTreeUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionUrls";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginActionsMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginsActionsGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginActionsGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapFilter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/ActionsTreeUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCorrectedGroup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createOtherGroup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "tryUnstubAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCorrectedGroup";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tryUnstubAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

