/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SchemeImportUtil {
    @Nullable
    public static VirtualFile selectImportSource(String @NotNull [] sourceExtensions, @NotNull Component parent, @Nullable VirtualFile preselect, @Nullable @NlsContexts.Label String description) {
        VirtualFile[] preselectFiles;
        FileChooserDialog fileChooser;
        VirtualFile[] virtualFiles;
        if (parent == null) {
            SchemeImportUtil.$$$reportNull$$$0(0);
        }
        if (sourceExtensions == null) {
            SchemeImportUtil.$$$reportNull$$$0(1);
        }
        final Set extensions2 = ContainerUtil.set((Object[])sourceExtensions);
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, SchemeImportUtil.canSelectJarFile(sourceExtensions), false, false, false){

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                return !(!file2.isDirectory() && !extensions2.contains(file2.getExtension()) || !showHiddenFiles && FileElement.isFileHidden((VirtualFile)file2));
            }

            public boolean isFileSelectable(@Nullable VirtualFile file2) {
                return file2 != null && !file2.isDirectory() && extensions2.contains(file2.getExtension());
            }
        };
        if (description != null) {
            descriptor2.setDescription(description);
        }
        if ((virtualFiles = (fileChooser = FileChooserFactory.getInstance().createFileChooser(descriptor2, null, parent)).choose(null, preselectFiles = preselect != null ? new VirtualFile[]{preselect} : VirtualFile.EMPTY_ARRAY)).length != 1) {
            return null;
        }
        virtualFiles[0].refresh(false, false);
        return virtualFiles[0];
    }

    private static boolean canSelectJarFile(String @NotNull [] sourceExtensions) {
        if (sourceExtensions == null) {
            SchemeImportUtil.$$$reportNull$$$0(2);
        }
        for (String ext : sourceExtensions) {
            if (!"jar".equals(ext)) continue;
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static Element loadSchemeDom(@NotNull VirtualFile file2) throws SchemeImportException {
        Element element2;
        InputStream inputStream2;
        block10: {
            if (file2 == null) {
                SchemeImportUtil.$$$reportNull$$$0(3);
            }
            inputStream2 = file2.getInputStream();
            element2 = JDOMUtil.load((InputStream)inputStream2);
            if (inputStream2 == null) break block10;
            inputStream2.close();
        }
        Element element3 = element2;
        if (element3 == null) {
            SchemeImportUtil.$$$reportNull$$$0(4);
        }
        return element3;
        {
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | JDOMException e) {
                    throw new SchemeImportException();
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceExtensions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/SchemeImportUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/SchemeImportUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSchemeDom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectImportSource";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canSelectJarFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadSchemeDom";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

