/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.binding;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.binding.BeanValueAccessor;
import com.intellij.openapi.options.binding.BindControl;
import com.intellij.openapi.options.binding.ControlValueAccessor;
import com.intellij.openapi.options.binding.ValueAccessor;
import com.intellij.openapi.options.binding.ValueTypeConverter;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.EditorTextField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class ControlBinder {
    private static final Logger LOG = Logger.getInstance(ControlBinder.class);
    private final Object myBean;
    private final List<Pair<ControlValueAccessor, BeanValueAccessor>> myBindings = new ArrayList<Pair<ControlValueAccessor, BeanValueAccessor>>();

    public ControlBinder(Object bean) {
        this.myBean = bean;
    }

    public void bindControl(JComponent control2, String propertyName, boolean instant) {
        ControlValueAccessor controlAccessor;
        if (control2 instanceof JCheckBox) {
            controlAccessor = ValueAccessor.checkBoxAccessor((JCheckBox)control2);
        } else if (control2 instanceof JTextField) {
            controlAccessor = ValueAccessor.textFieldAccessor((JTextField)control2);
        } else if (control2 instanceof EditorTextField) {
            controlAccessor = ValueAccessor.editorTextFieldAccessor((EditorTextField)((Object)control2));
        } else {
            throw new IllegalArgumentException("Cannot bind control of type " + control2.getClass() + ".\nUse bindControl(ControlValueAccessor, String) instead.");
        }
        this.bindControl(controlAccessor, propertyName, instant);
    }

    public synchronized void bindControl(ControlValueAccessor controlAccessor, String propertyName, boolean instant) {
        BeanValueAccessor beanAccessor = BeanValueAccessor.createAccessor(this.myBean, propertyName);
        Pair binding = Pair.create((Object)controlAccessor, (Object)beanAccessor);
        this.myBindings.add((Pair<ControlValueAccessor, BeanValueAccessor>)binding);
        if (instant) {
            controlAccessor.addChangeListener(() -> this.apply((Pair<ControlValueAccessor, BeanValueAccessor>)binding));
        }
    }

    public synchronized void reset() {
        for (Pair<ControlValueAccessor, BeanValueAccessor> binding : this.myBindings) {
            if (!((ControlValueAccessor)binding.first).isEnabled()) continue;
            Object value2 = ((BeanValueAccessor)binding.second).getValue();
            try {
                value2 = this.convert(value2, ((ControlValueAccessor)binding.first).getType());
                ((ControlValueAccessor)binding.first).setValue(value2);
            }
            catch (IllegalArgumentException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    public synchronized void apply() {
        for (Pair<ControlValueAccessor, BeanValueAccessor> binding : this.myBindings) {
            this.apply(binding);
        }
    }

    private void apply(Pair<ControlValueAccessor, BeanValueAccessor> binding) {
        if (!((ControlValueAccessor)binding.first).isEnabled()) {
            return;
        }
        Object value2 = ((ControlValueAccessor)binding.first).getValue();
        try {
            value2 = this.convert(value2, ((BeanValueAccessor)binding.second).getType());
            ((BeanValueAccessor)binding.second).setValue(value2);
        }
        catch (IllegalArgumentException e) {
            LOG.debug((Throwable)e);
        }
    }

    public synchronized boolean isModified() {
        for (Pair<ControlValueAccessor, BeanValueAccessor> binding : this.myBindings) {
            if (!((ControlValueAccessor)binding.first).isEnabled()) continue;
            Object value2 = ((ControlValueAccessor)binding.first).getValue();
            try {
                if ((value2 = this.convert(value2, ((BeanValueAccessor)binding.second).getType())).equals(((BeanValueAccessor)binding.second).getValue())) continue;
                return true;
            }
            catch (IllegalArgumentException e) {
                LOG.debug((Throwable)e);
            }
        }
        return false;
    }

    protected Object convert(Object value2, Class to) {
        Class<?> from2 = value2.getClass();
        if (!to.isAssignableFrom(from2)) {
            if (to.isPrimitive() && to.equals(Integer.TYPE)) {
                to = Integer.class;
            }
            for (ValueTypeConverter converter : ValueTypeConverter.STANDARD) {
                if (from2.equals(converter.getSourceType()) && to.equals(converter.getTargetType())) {
                    return converter.from(value2);
                }
                if (!to.equals(converter.getSourceType()) || !from2.equals(converter.getTargetType())) continue;
                return converter.to(value2);
            }
        }
        return value2;
    }

    public void bindAnnotations(Object form) {
        Field[] fields2;
        for (Field field : fields2 = form.getClass().getDeclaredFields()) {
            BindControl annotation = field.getAnnotation(BindControl.class);
            if (annotation == null) continue;
            String name2 = annotation.value();
            if (name2.length() == 0) {
                name2 = field.getName();
            }
            try {
                field.setAccessible(true);
                this.bindControl((JComponent)field.get(form), name2, annotation.instant());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

