/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.ui.CoreAwareIconManager;
import com.intellij.ui.IconManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractProgressIndicatorBase
extends UserDataHolderBase
implements ProgressIndicator {
    private static final Logger LOG = Logger.getInstance(AbstractProgressIndicatorBase.class);
    private volatile @NlsContexts.ProgressText String myText;
    private volatile double myFraction;
    private volatile @NlsContexts.ProgressDetails String myText2;
    private volatile boolean myCanceled;
    private volatile boolean myRunning;
    private volatile boolean myStopped;
    private volatile boolean myIndeterminate = Boolean.parseBoolean(System.getProperty("ide.progress.indeterminate.by.default", "true"));
    private volatile Runnable myMacActivity;
    private volatile boolean myShouldStartActivity = SystemInfoRt.isMac && Boolean.parseBoolean(System.getProperty("idea.mac.prevent.app.nap", "true"));
    private Stack<State> myStateStack;
    private volatile ProgressIndicator myModalityProgress;
    private volatile ModalityState myModalityState = ModalityState.NON_MODAL;
    private volatile int myNonCancelableSectionCount;
    private final Object lock = ObjectUtils.sentinel((String)"APIB lock");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isRunning()) {
                this.throwInvalidState("Attempt to start ProgressIndicator which is already running");
            }
            if (this.myStopped) {
                if (this.myCanceled && !this.isReuseable()) {
                    this.throwInvalidState("Attempt to start ProgressIndicator which is cancelled and already stopped");
                }
                this.myCanceled = false;
                this.myStopped = false;
            }
            this.myText = "";
            this.myFraction = 0.0;
            this.myText2 = "";
            if (this.myShouldStartActivity) {
                IconManager iconManager = IconManager.getInstance();
                if (iconManager instanceof CoreAwareIconManager) {
                    this.myMacActivity = ((CoreAwareIconManager)iconManager).wakeUpNeo((Object)this);
                }
            } else {
                this.myMacActivity = null;
            }
            this.myRunning = true;
        }
    }

    protected boolean isReuseable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.myStopped) {
                this.throwInvalidState("Attempt to stop ProgressIndicator which is already stopped");
            }
            if (!this.myRunning) {
                this.throwInvalidState("stop() should be called only if start() called before");
            }
            this.myRunning = false;
            this.myStopped = true;
            this.stopSystemActivity();
        }
    }

    private void throwInvalidState(@NotNull String message2) {
        if (message2 == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(0);
        }
        LOG.error(message2 + ": " + (Object)((Object)this) + "," + ((Object)((Object)this)).getClass(), (Throwable)new IllegalStateException());
    }

    void stopSystemActivity() {
        Runnable macActivity = this.myMacActivity;
        if (macActivity != null) {
            macActivity.run();
            this.myMacActivity = null;
        }
    }

    public boolean isRunning() {
        return this.myRunning;
    }

    public void cancel() {
        this.myCanceled = true;
        this.stopSystemActivity();
        if (ApplicationManager.getApplication() != null) {
            ProgressManager.canceled((ProgressIndicator)this);
        }
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }

    public void checkCanceled() {
        this.throwIfCanceled();
        if (CoreProgressManager.runCheckCanceledHooks(this)) {
            this.throwIfCanceled();
        }
    }

    private void throwIfCanceled() {
        if (this.isCanceled() && this.isCancelable()) {
            Throwable trace = this.getCancellationTrace();
            throw trace instanceof ProcessCanceledException ? (ProcessCanceledException)trace : new ProcessCanceledException(trace);
        }
    }

    @Nullable
    protected Throwable getCancellationTrace() {
        return this instanceof Disposable ? Disposer.getDisposalTrace((Disposable)((Disposable)this)) : null;
    }

    public void setText(String text2) {
        this.myText = text2;
    }

    public String getText() {
        return this.myText;
    }

    public void setText2(String text2) {
        this.myText2 = text2;
    }

    public String getText2() {
        return this.myText2;
    }

    public double getFraction() {
        return this.myFraction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFraction(double fraction) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.isIndeterminate()) {
                String message2 = "This progress indicator is indeterminate, this may lead to visual inconsistency. Please call setIndeterminate(false) before you start progress. " + ((Object)((Object)this)).getClass();
                LOG.warn(message2, (Throwable)new IllegalStateException());
                this.setIndeterminate(false);
            }
            this.myFraction = fraction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushState() {
        Object object = this.getLock();
        synchronized (object) {
            this.getStateStack().push((Object)this.getState());
        }
    }

    @NotNull
    private State getState() {
        return new State(this.getText(), this.getText2(), this.getFraction(), this.isIndeterminate());
    }

    private void restoreFrom(@NotNull State state) {
        if (state == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(1);
        }
        this.setText(state.myText);
        this.setText2(state.myText2);
        this.setIndeterminate(state.myIndeterminate);
        if (!this.isIndeterminate()) {
            this.setFraction(state.myFraction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popState() {
        Object object = this.getLock();
        synchronized (object) {
            State state = (State)this.myStateStack.pop();
            this.restoreFrom(state);
        }
    }

    public void startNonCancelableSection() {
        PluginException.reportDeprecatedUsage((String)"ProgressIndicator#startNonCancelableSection", (String)"Use `ProgressManager.executeNonCancelableSection()` instead");
        ++this.myNonCancelableSectionCount;
    }

    public void finishNonCancelableSection() {
        --this.myNonCancelableSectionCount;
    }

    protected boolean isCancelable() {
        return this.myNonCancelableSectionCount == 0 && !ProgressManager.getInstance().isInNonCancelableSection();
    }

    public final boolean isModal() {
        return this.myModalityProgress != null;
    }

    final boolean isModalEntity() {
        return this.myModalityProgress == this;
    }

    @NotNull
    public ModalityState getModalityState() {
        ModalityState modalityState = this.myModalityState;
        if (modalityState == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(2);
        }
        return modalityState;
    }

    public void setModalityProgress(@Nullable ProgressIndicator modalityProgress) {
        if (this.isRunning()) {
            this.throwInvalidState("setModalityProgress() must not be called on already running indicator");
        }
        this.myModalityProgress = modalityProgress;
        this.setModalityState(modalityProgress);
    }

    private void setModalityState(@Nullable ProgressIndicator modalityProgress) {
        ModalityState modalityState = ModalityState.defaultModalityState();
        if (modalityProgress != null) {
            modalityState = ((ModalityStateEx)modalityState).appendProgress(modalityProgress);
            ((TransactionGuardImpl)TransactionGuard.getInstance()).enteredModality(modalityState);
        }
        this.myModalityState = modalityState;
    }

    public boolean isIndeterminate() {
        return this.myIndeterminate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndeterminate(boolean indeterminate) {
        Object object = this.getLock();
        synchronized (object) {
            this.myIndeterminate = indeterminate;
            if (indeterminate && this.getFraction() != 0.0) {
                this.myFraction = 0.0;
            }
        }
    }

    public String toString() {
        return "ProgressIndicator " + System.identityHashCode((Object)this) + ": running=" + this.isRunning() + "; canceled=" + this.isCanceled();
    }

    public boolean isPopupWasShown() {
        return true;
    }

    public boolean isShowing() {
        return this.isModal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initStateFrom(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(3);
        }
        Object object = this.getLock();
        synchronized (object) {
            this.myRunning = indicator2.isRunning();
            this.myCanceled = indicator2.isCanceled();
            boolean indeterminate = indicator2.isIndeterminate();
            this.setIndeterminate(indeterminate);
            if (!indeterminate || indicator2.getFraction() != 0.0) {
                this.setFraction(indicator2.getFraction());
            }
            this.setText(indicator2.getText());
            this.setText2(indicator2.getText2());
            if (indicator2 instanceof AbstractProgressIndicatorBase) {
                AbstractProgressIndicatorBase stacked = (AbstractProgressIndicatorBase)indicator2;
                this.myStateStack = stacked.myStateStack == null ? null : new Stack(stacked.getStateStack());
            }
            this.dontStartActivity();
        }
    }

    protected void dontStartActivity() {
        this.myShouldStartActivity = false;
    }

    @NotNull
    private Stack<State> getStateStack() {
        Stack stack = this.myStateStack;
        if (stack == null) {
            this.myStateStack = stack = new Stack(2);
        }
        Stack stack2 = stack;
        if (stack2 == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(4);
        }
        return stack2;
    }

    @NotNull
    protected Object getLock() {
        Object object = this.lock;
        if (object == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(5);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/AbstractProgressIndicatorBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/AbstractProgressIndicatorBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateStack";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "throwInvalidState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "restoreFrom";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initStateFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class State {
        private final @NlsContexts.ProgressText String myText;
        private final @NlsContexts.ProgressDetails String myText2;
        private final double myFraction;
        private final boolean myIndeterminate;

        private State(@NlsContexts.ProgressText String text2, @NlsContexts.ProgressDetails String text22, double fraction, boolean indeterminate) {
            this.myText = text2;
            this.myText2 = text22;
            this.myFraction = fraction;
            this.myIndeterminate = indeterminate;
        }
    }
}

