/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkRequirement;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkRequirements;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.util.lang.JavaVersion;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ2\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000eJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements;", "", "()V", "JAVA_VERSION_REGEX", "Lkotlin/text/Regex;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "parseRequirement", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirement;", "request", "", "namePredicate", "versionStringPredicate", "Ljava/util/function/Predicate;", "homePredicate", "sameMajorVersionMatcher", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements$VersionMatcher;", "parsed", "Lcom/intellij/util/lang/JavaVersion;", "strictVersionMatcher", "VersionMatcher", "VersionRequirement", "intellij.platform.lang.impl"})
public final class JdkRequirements {
    private static final Logger LOG;
    private static final Regex JAVA_VERSION_REGEX;
    @NotNull
    public static final JdkRequirements INSTANCE;

    private final VersionMatcher sameMajorVersionMatcher(JavaVersion parsed) {
        return new VersionMatcher(parsed){
            final /* synthetic */ JavaVersion $parsed;

            @NotNull
            public String toString() {
                return "it >= " + this.$parsed + " && same major version";
            }

            public boolean matchVersion(@NotNull String versionString) {
                Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
                JavaVersion javaVersion = JavaVersion.tryParse((String)versionString);
                if (javaVersion == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(ver\u2026onString) ?: return false");
                JavaVersion it = javaVersion;
                return it.compareTo(this.$parsed) >= 0 && it.feature == this.$parsed.feature;
            }
            {
                this.$parsed = $captured_local_variable$0;
            }
        };
    }

    private final VersionMatcher strictVersionMatcher(JavaVersion parsed) {
        return new VersionMatcher(parsed){
            final /* synthetic */ JavaVersion $parsed;

            @NotNull
            public String toString() {
                return "it == " + this.$parsed;
            }

            public boolean matchVersion(@NotNull String versionString) {
                Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
                JavaVersion javaVersion = JavaVersion.tryParse((String)versionString);
                if (javaVersion == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(ver\u2026onString) ?: return false");
                JavaVersion it = javaVersion;
                return Intrinsics.areEqual((Object)it, (Object)this.$parsed);
            }
            {
                this.$parsed = $captured_local_variable$0;
            }
        };
    }

    @Nullable
    public final JdkRequirement parseRequirement(@Nullable String namePredicate, @Nullable Predicate<String> versionStringPredicate, @Nullable Predicate<String> homePredicate) {
        JdkRequirement nameFilter;
        JdkRequirement jdkRequirement;
        String string = namePredicate;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            jdkRequirement = INSTANCE.parseRequirement(it);
        } else {
            jdkRequirement = nameFilter = null;
        }
        if (versionStringPredicate == null && nameFilter == null) {
            return null;
        }
        return new JdkRequirement(nameFilter, homePredicate, versionStringPredicate){
            final /* synthetic */ JdkRequirement $nameFilter;
            final /* synthetic */ Predicate $homePredicate;
            final /* synthetic */ Predicate $versionStringPredicate;

            public boolean matches(@NotNull Sdk sdk2) {
                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                if (this.$nameFilter != null && !this.$nameFilter.matches(sdk2)) {
                    return false;
                }
                if (this.$homePredicate != null) {
                    String string = sdk2.getHomePath();
                    if (string == null) {
                        return false;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdk.homePath ?: return false");
                    String homePath = string;
                    if (!this.$homePredicate.test(homePath)) {
                        return false;
                    }
                }
                if (this.$versionStringPredicate != null) {
                    String string = sdk2.getVersionString();
                    if (string == null) {
                        return false;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdk.versionString ?: return false");
                    String versionString = string;
                    if (!this.$versionStringPredicate.test(versionString)) {
                        return false;
                    }
                }
                return true;
            }

            public boolean matches(@NotNull JdkItem sdk2) {
                String versionString;
                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                if (this.$nameFilter != null && !this.$nameFilter.matches(sdk2)) {
                    return false;
                }
                return this.$versionStringPredicate == null || this.$versionStringPredicate.test(versionString = sdk2.getVersionString());
            }

            public boolean matches(@NotNull UnknownSdkLocalSdkFix sdk2) {
                Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                if (this.$nameFilter != null && !this.$nameFilter.matches(sdk2)) {
                    return false;
                }
                if (this.$homePredicate != null) {
                    String string = sdk2.getExistingSdkHome();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdk.existingSdkHome");
                    String homePath = string;
                    if (!this.$homePredicate.test(homePath)) {
                        return false;
                    }
                }
                if (this.$versionStringPredicate != null) {
                    String string = sdk2.getVersionString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdk.versionString");
                    String versionString = string;
                    if (!this.$versionStringPredicate.test(versionString)) {
                        return false;
                    }
                }
                return true;
            }

            @NotNull
            public String toString() {
                return SequencesKt.joinToString$default((Sequence)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(this, null){
                    private /* synthetic */ Object L$0;
                    int label;
                    final /* synthetic */ parseRequirement.1 this$0;

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$sequence = (SequenceScope)this.L$0;
                                if (this.this$0.$nameFilter != null) {
                                    this.L$0 = $this$sequence;
                                    this.label = 1;
                                    v0 = $this$sequence.yield((Object)String.valueOf(this.this$0.$nameFilter), (Continuation)this);
                                    if (v0 == var3_2) {
                                        return var3_2;
                                    }
                                }
                                ** GOTO lbl17
                            }
                            case 1: {
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl17:
                                // 2 sources

                                if (this.this$0.$homePredicate != null) {
                                    this.L$0 = $this$sequence;
                                    this.label = 2;
                                    v1 = $this$sequence.yield((Object)("homePredicate: " + this.this$0.$homePredicate), (Continuation)this);
                                    if (v1 == var3_2) {
                                        return var3_2;
                                    }
                                }
                                ** GOTO lbl28
                            }
                            case 2: {
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl28:
                                // 2 sources

                                if (this.this$0.$versionStringPredicate != null) {
                                    this.L$0 = null;
                                    this.label = 3;
                                    v2 = $this$sequence.yield((Object)("versionPredicate: " + this.this$0.$versionStringPredicate), (Continuation)this);
                                    if (v2 == var3_2) {
                                        return var3_2;
                                    }
                                }
                                ** GOTO lbl38
                            }
                            case 3: {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl38:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        Object object = function2.L$0 = value2;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                })), (CharSequence)", ", (CharSequence)"JdkRequirement:{ ", (CharSequence)"}", (int)0, null, null, (int)56, null);
            }
            {
                this.$nameFilter = $captured_local_variable$0;
                this.$homePredicate = $captured_local_variable$1;
                this.$versionStringPredicate = $captured_local_variable$2;
            }
        };
    }

    @Nullable
    public final JdkRequirement parseRequirement(@NotNull String request2) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            try {
                Object version2;
                String string = request2;
                boolean bl = false;
                Object versionMatcher2 = StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)"=", (boolean)false, (int)2, null) ? new Function1<JavaVersion, VersionMatcher>(this){

                    @NotNull
                    public final VersionMatcher invoke(@NotNull JavaVersion p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return JdkRequirements.access$strictVersionMatcher((JdkRequirements)this.receiver, p1);
                    }
                } : new Function1<JavaVersion, VersionMatcher>(this){

                    @NotNull
                    public final VersionMatcher invoke(@NotNull JavaVersion p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return JdkRequirements.access$sameMajorVersionMatcher((JdkRequirements)this.receiver, p1);
                    }
                };
                Object object = StringsKt.substringBefore$default((String)StringsKt.trimStart((String)request2, (char[])new char[]{'='}), (String)"(", null, (int)2, null);
                boolean bl2 = false;
                String string2 = object;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String text2 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                object = this;
                bl2 = false;
                boolean bl3 = false;
                JdkRequirements $this$run = (JdkRequirements)object;
                boolean bl4 = false;
                int idx22 = StringsKt.lastIndexOfAny$default((CharSequence)text2, (char[])new char[]{'-', ' '}, (int)0, (boolean)false, (int)6, null);
                if (idx22 >= 0 && idx22 + 1 < text2.length()) {
                    String string3 = text2;
                    int n = 0;
                    int n2 = 0;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n, idx22);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String vendor = string5;
                    CharSequence charSequence = text2;
                    n2 = idx22 + 1;
                    boolean bl5 = false;
                    String string6 = charSequence;
                    if (string6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                    version2 = string7;
                    charSequence = (CharSequence)version2;
                    Regex regex = JAVA_VERSION_REGEX;
                    bl5 = false;
                    if (regex.matches(charSequence)) {
                        JavaVersion javaVersion = JavaVersion.tryParse((String)version2);
                        if (javaVersion == null) {
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(version) ?: return@run");
                            JavaVersion javaVersion2 = javaVersion;
                            VersionMatcher matcher = (VersionMatcher)((Function1)versionMatcher2).invoke((Object)javaVersion2);
                            return new VersionRequirement(vendor, matcher, matcher){
                                final /* synthetic */ String $vendor;
                                final /* synthetic */ VersionMatcher $matcher;

                                @Nullable
                                public final JdkItem findJdkItem(@NotNull String home2) {
                                    Intrinsics.checkNotNullParameter((Object)home2, (String)"home");
                                    return JdkInstaller.Companion.getInstance().findJdkItemForInstalledJdk(home2);
                                }

                                @Nullable
                                public final JdkItem findJdkItem(@NotNull Sdk sdk2) {
                                    JdkItem jdkItem;
                                    Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                                    String string = sdk2.getHomePath();
                                    if (string != null) {
                                        String string2 = string;
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        String it = string2;
                                        boolean bl3 = false;
                                        String string3 = it;
                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
                                        jdkItem = this.findJdkItem(string3);
                                    } else {
                                        jdkItem = null;
                                    }
                                    return jdkItem;
                                }

                                @Nullable
                                public final JdkItem findJdkItem(@NotNull UnknownSdkLocalSdkFix sdk2) {
                                    Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                                    String string = sdk2.getExistingSdkHome();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdk.existingSdkHome");
                                    return this.findJdkItem(string);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public boolean matches(@NotNull Sdk sdk2) {
                                    Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                                    if (!super.matches(sdk2)) return false;
                                    JdkItem jdkItem = this.findJdkItem(sdk2);
                                    if (jdkItem == null) return false;
                                    if (!jdkItem.matchesVendor(this.$vendor)) return false;
                                    return true;
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public boolean matches(@NotNull UnknownSdkLocalSdkFix sdk2) {
                                    Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                                    if (!super.matches(sdk2)) return false;
                                    JdkItem jdkItem = this.findJdkItem(sdk2);
                                    if (jdkItem == null) return false;
                                    if (!jdkItem.matchesVendor(this.$vendor)) return false;
                                    return true;
                                }

                                public boolean matches(@NotNull JdkItem sdk2) {
                                    Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                                    return super.matches(sdk2) && sdk2.matchesVendor(this.$vendor);
                                }

                                @NotNull
                                public String toString() {
                                    return "JdkRequirement { " + this.$vendor + " && " + this.$matcher + " }";
                                }
                                {
                                    this.$vendor = $captured_local_variable$0;
                                    this.$matcher = $captured_local_variable$1;
                                    super($super_call_param$2);
                                }
                            };
                        }
                    }
                }
                object = this;
                bl2 = false;
                bl3 = false;
                $this$run = (JdkRequirements)object;
                boolean bl6 = false;
                CharSequence idx22 = text2;
                version2 = JAVA_VERSION_REGEX;
                boolean bl7 = false;
                if (!version2.matches(idx22)) break block10;
                JavaVersion javaVersion = JavaVersion.tryParse((String)text2);
                if (javaVersion == null) {
                    break block10;
                }
                Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(text) ?: return@run");
                JavaVersion javaVersion3 = javaVersion;
                VersionMatcher matcher = (VersionMatcher)((Function1)versionMatcher2).invoke((Object)javaVersion3);
                return new VersionRequirement(matcher, matcher){
                    final /* synthetic */ VersionMatcher $matcher;

                    @NotNull
                    public String toString() {
                        return "JdkRequirement { " + this.$matcher + " }";
                    }
                    {
                        this.$matcher = $captured_local_variable$0;
                        super($super_call_param$1);
                    }
                };
            }
            catch (Throwable t) {
                LOG.warn("Failed to parse requirement " + request2 + ". " + t.getMessage(), t);
            }
        }
        return null;
    }

    private JdkRequirements() {
    }

    static {
        JdkRequirements jdkRequirements;
        INSTANCE = jdkRequirements = new JdkRequirements();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JdkRequirements.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        JAVA_VERSION_REGEX = new Regex("^(9|[1-9][1-9]|)(\\.0(\\.\\d+)?)?|1\\.\\d(\\.0(_\\d+)?)?|8$");
    }

    public static final /* synthetic */ VersionMatcher access$strictVersionMatcher(JdkRequirements $this, JavaVersion parsed) {
        return $this.strictVersionMatcher(parsed);
    }

    public static final /* synthetic */ VersionMatcher access$sameMajorVersionMatcher(JdkRequirements $this, JavaVersion parsed) {
        return $this.sameMajorVersionMatcher(parsed);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements$VersionMatcher;", "", "matchVersion", "", "versionString", "", "toString", "intellij.platform.lang.impl"})
    private static interface VersionMatcher {
        public boolean matchVersion(@NotNull String var1);

        @NotNull
        public String toString();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements$VersionRequirement;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirement;", "matcher", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements$VersionMatcher;", "(Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements$VersionMatcher;)V", "getMatcher", "()Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkRequirements$VersionMatcher;", "matches", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "Lcom/intellij/openapi/roots/ui/configuration/UnknownSdkLocalSdkFix;", "version", "", "intellij.platform.lang.impl"})
    private static class VersionRequirement
    implements JdkRequirement {
        @NotNull
        private final VersionMatcher matcher;

        public final boolean matches(@NotNull String version2) {
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            return this.matcher.matchVersion(version2);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(@NotNull Sdk sdk2) {
            void var4_7;
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            Object object = this;
            boolean bl = false;
            try {
                Result.Companion companion = Result.Companion;
                Object $this$runCatching = object;
                boolean bl2 = false;
                $this$runCatching = sdk2.getVersionString();
                bl2 = false;
                Object object2 = Result.constructor-impl((Object)$this$runCatching);
            }
            catch (Throwable $this$runCatching) {
                Result.Companion bl2 = Result.Companion;
                boolean bl3 = false;
                Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
            }
            object = var4_7;
            bl = false;
            String string = (String)(Result.isFailure-impl((Object)object) ? null : object);
            if (string == null) return false;
            object = string;
            bl = false;
            boolean bl4 = false;
            Object it = object;
            boolean bl5 = false;
            Object object4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"it");
            if (!this.matches((String)object4)) return false;
            return true;
        }

        @Override
        public boolean matches(@NotNull JdkItem sdk2) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            return this.matches(sdk2.getVersionString());
        }

        @Override
        public boolean matches(@NotNull UnknownSdkLocalSdkFix sdk2) {
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            String string = sdk2.getVersionString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdk.versionString");
            return this.matcher.matchVersion(string);
        }

        @NotNull
        public final VersionMatcher getMatcher() {
            return this.matcher;
        }

        public VersionRequirement(@NotNull VersionMatcher matcher) {
            Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
            this.matcher = matcher;
        }
    }
}

