/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class FilesScanExecutor {
    private static final int THREAD_COUNT = Math.max(UnindexedFilesUpdater.getNumberOfScanningThreads() - 1, 1);
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Scanning", (int)THREAD_COUNT);

    public static void runOnAllThreads(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            FilesScanExecutor.$$$reportNull$$$0(0);
        }
        ProgressIndicator progress2 = ProgressManager.getInstance().getProgressIndicator();
        ArrayList results = new ArrayList();
        for (int i2 = 0; i2 < THREAD_COUNT; ++i2) {
            results.add(ourExecutor.submit(() -> ProgressManager.getInstance().runProcess(runnable2, (ProgressIndicator)ProgressWrapper.wrap(progress2))));
        }
        runnable2.run();
        for (Future future2 : results) {
            ((FutureTask)future2).run();
            ProgressIndicatorUtils.awaitWithCheckCanceled(future2);
        }
    }

    public static <T> boolean processDequeOnAllThreads(@NotNull ConcurrentLinkedDeque<T> deque, @NotNull Processor<? super T> processor2) {
        if (deque == null) {
            FilesScanExecutor.$$$reportNull$$$0(1);
        }
        if (processor2 == null) {
            FilesScanExecutor.$$$reportNull$$$0(2);
        }
        ProgressManager.checkCanceled();
        if (deque.isEmpty()) {
            return true;
        }
        AtomicInteger runnersCount = new AtomicInteger();
        AtomicInteger idleCount = new AtomicInteger();
        AtomicReference error = new AtomicReference();
        AtomicBoolean stopped = new AtomicBoolean();
        AtomicBoolean exited = new AtomicBoolean();
        FilesScanExecutor.runOnAllThreads(() -> {
            runnersCount.incrementAndGet();
            boolean idle = false;
            while (idleCount.get() != runnersCount.get() && !stopped.get()) {
                Object item;
                ProgressManager.checkCanceled();
                if (deque.peek() == null) {
                    if (!idle) {
                        idle = true;
                        idleCount.incrementAndGet();
                    }
                    TimeoutUtil.sleep((long)1L);
                    continue;
                }
                if (idle) {
                    idle = false;
                    idleCount.decrementAndGet();
                }
                if ((item = deque.poll()) == null) continue;
                try {
                    if (!processor2.process(item)) {
                        stopped.set(true);
                    }
                    if (exited.get() && !stopped.get()) {
                        throw new AssertionError((Object)"early exit");
                    }
                }
                catch (ProcessCanceledException ex) {
                    deque.addFirst(item);
                }
                catch (Throwable ex) {
                    error.compareAndSet(null, ex);
                }
            }
            exited.set(true);
            if (!deque.isEmpty() && !stopped.get()) {
                throw new AssertionError((Object)"early exit");
            }
        });
        ExceptionUtil.rethrowAllAsUnchecked((Throwable)((Throwable)error.get()));
        return !stopped.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deque";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/impl/FilesScanExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runOnAllThreads";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processDequeOnAllThreads";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

