/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.roots.ui.UiUtils;
import com.intellij.openapi.roots.ui.UiUtils$getKeyStrokes$;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.DocumentAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a%\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0007\"\u00020\u0001\u00a2\u0006\u0002\u0010\b\u001a7\u0010\t\u001a\u00020\n*\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u00052\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\u0002\u0010\u0010\u001a,\u0010\t\u001a\u00020\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000e\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a#\u0010\u0016\u001a\u00020\n*\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0017\u001a\u0018\u0010\u0016\u001a\u00020\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\u0018\u0010\u0018\u001a\u00020\n*\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001a\u001a\u0018\u0010\u001b\u001a\u00020\n*\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001a\u001a*\u0010\u001c\u001a\u00020\n\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u001e2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\n0\u000e\u001a\u0018\u0010\u001f\u001a\u00020\n*\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001a\u00a8\u0006 "}, d2={"getActionShortcutText", "", "actionId", "getKeyStrokes", "", "Ljavax/swing/KeyStroke;", "actionIds", "", "([Ljava/lang/String;)Ljava/util/List;", "addKeyboardAction", "", "Ljavax/swing/JComponent;", "keyStrokes", "action", "Lkotlin/Function1;", "Ljava/awt/event/ActionEvent;", "(Ljavax/swing/JComponent;[Ljavax/swing/KeyStroke;Lkotlin/jvm/functions/Function1;)V", "isTextUnderMouse", "", "Ljavax/swing/text/JTextComponent;", "e", "Ljava/awt/event/MouseEvent;", "removeKeyboardAction", "(Ljavax/swing/JComponent;[Ljavax/swing/KeyStroke;)V", "whenFirstFocusGained", "listener", "Lkotlin/Function0;", "whenFocusGained", "whenItemSelected", "E", "Lcom/intellij/openapi/ui/ComboBox;", "whenTextModified", "intellij.platform.lang.impl"})
@JvmName(name="UiUtils")
public final class UiUtils {
    public static final boolean isTextUnderMouse(@NotNull JTextComponent $this$isTextUnderMouse, @NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)$this$isTextUnderMouse, (String)"$this$isTextUnderMouse");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int position = $this$isTextUnderMouse.viewToModel2D(e.getPoint());
        int n = position;
        return 1 <= n && $this$isTextUnderMouse.getText().length() > n;
    }

    @NotNull
    public static final String getActionShortcutText(@NotNull String actionId) {
        KeymapManager keymapManager2;
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        KeymapManager keymapManager3 = keymapManager2 = KeymapManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)keymapManager3, (String)"keymapManager");
        Keymap keymap2 = keymapManager3.getActiveKeymap();
        Intrinsics.checkNotNullExpressionValue((Object)keymap2, (String)"keymapManager.activeKeymap");
        Keymap activeKeymap = keymap2;
        Shortcut[] shortcuts = activeKeymap.getShortcuts(actionId);
        String string = KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KeymapUtil.getShortcutsText(shortcuts)");
        return string;
    }

    @NotNull
    public static final List<KeyStroke> getKeyStrokes(String ... actionIds) {
        KeymapManager keymapManager2;
        Intrinsics.checkNotNullParameter((Object)actionIds, (String)"actionIds");
        KeymapManager keymapManager3 = keymapManager2 = KeymapManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)keymapManager3, (String)"keymapManager");
        Keymap keymap2 = keymapManager3.getActiveKeymap();
        Intrinsics.checkNotNullExpressionValue((Object)keymap2, (String)"keymapManager.activeKeymap");
        Keymap activeKeymap = keymap2;
        Sequence $this$filterIsInstance$iv = SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])actionIds), (Function1)((Function1)new Function1<String, Sequence<? extends Shortcut>>(activeKeymap){
            final /* synthetic */ Keymap $activeKeymap;

            @NotNull
            public final Sequence<Shortcut> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object[] objectArray = this.$activeKeymap.getShortcuts(it);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"activeKeymap.getShortcuts(it)");
                return ArraysKt.asSequence((Object[])objectArray);
            }
            {
                this.$activeKeymap = keymap2;
                super(1);
            }
        }));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getKeyStrokes$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.flatMap((Sequence)sequence, (Function1)getKeyStrokes.2.INSTANCE)));
    }

    public static final void removeKeyboardAction(@NotNull JComponent $this$removeKeyboardAction, KeyStroke ... keyStrokes) {
        Intrinsics.checkNotNullParameter((Object)$this$removeKeyboardAction, (String)"$this$removeKeyboardAction");
        Intrinsics.checkNotNullParameter((Object)keyStrokes, (String)"keyStrokes");
        UiUtils.removeKeyboardAction($this$removeKeyboardAction, ArraysKt.toList((Object[])keyStrokes));
    }

    public static final void removeKeyboardAction(@NotNull JComponent $this$removeKeyboardAction, @NotNull List<? extends KeyStroke> keyStrokes) {
        Intrinsics.checkNotNullParameter((Object)$this$removeKeyboardAction, (String)"$this$removeKeyboardAction");
        Intrinsics.checkNotNullParameter(keyStrokes, (String)"keyStrokes");
        for (InputMap map2 = $this$removeKeyboardAction.getInputMap(); map2 != null; map2 = map2.getParent()) {
            for (KeyStroke keyStroke : keyStrokes) {
                map2.remove(keyStroke);
            }
        }
    }

    public static final void addKeyboardAction(@NotNull JComponent $this$addKeyboardAction, @NotNull KeyStroke[] keyStrokes, @NotNull Function1<? super ActionEvent, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)$this$addKeyboardAction, (String)"$this$addKeyboardAction");
        Intrinsics.checkNotNullParameter((Object)keyStrokes, (String)"keyStrokes");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        UiUtils.addKeyboardAction($this$addKeyboardAction, ArraysKt.toList((Object[])keyStrokes), action2);
    }

    public static final void addKeyboardAction(@NotNull JComponent $this$addKeyboardAction, @NotNull List<? extends KeyStroke> keyStrokes, @NotNull Function1<? super ActionEvent, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)$this$addKeyboardAction, (String)"$this$addKeyboardAction");
        Intrinsics.checkNotNullParameter(keyStrokes, (String)"keyStrokes");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        for (KeyStroke keyStroke : keyStrokes) {
            Object object = action2;
            if (object != null) {
                Function1<? super ActionEvent, Unit> function1 = object;
                object = new ActionListener(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        this.function = function1;
                    }

                    public final /* synthetic */ void actionPerformed(ActionEvent p0) {
                        Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke((Object)p0), (String)"invoke(...)");
                    }
                };
            }
            $this$addKeyboardAction.registerKeyboardAction((ActionListener)object, keyStroke, 0);
        }
    }

    public static final <E> void whenItemSelected(@NotNull ComboBox<E> $this$whenItemSelected, @NotNull Function1<? super E, Unit> listener2) {
        Intrinsics.checkNotNullParameter($this$whenItemSelected, (String)"$this$whenItemSelected");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        $this$whenItemSelected.addItemListener(new ItemListener(listener2){
            final /* synthetic */ Function1 $listener;

            public final void itemStateChanged(ItemEvent it) {
                ItemEvent itemEvent = it;
                Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"it");
                if (itemEvent.getStateChange() == 1) {
                    this.$listener.invoke(it.getItem());
                }
            }
            {
                this.$listener = function1;
            }
        });
    }

    public static final void whenTextModified(@NotNull JTextComponent $this$whenTextModified, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)$this$whenTextModified, (String)"$this$whenTextModified");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        $this$whenTextModified.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(listener2){
            final /* synthetic */ Function0 $listener;

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.invoke();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    public static final void whenFocusGained(@NotNull JComponent $this$whenFocusGained, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)$this$whenFocusGained, (String)"$this$whenFocusGained");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        $this$whenFocusGained.addFocusListener(new FocusAdapter(listener2){
            final /* synthetic */ Function0 $listener;

            public void focusGained(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.invoke();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    public static final void whenFirstFocusGained(@NotNull JComponent $this$whenFirstFocusGained, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)$this$whenFirstFocusGained, (String)"$this$whenFirstFocusGained");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        $this$whenFirstFocusGained.addFocusListener(new FocusAdapter($this$whenFirstFocusGained, listener2){
            final /* synthetic */ JComponent $this_whenFirstFocusGained;
            final /* synthetic */ Function0 $listener;

            public void focusGained(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$this_whenFirstFocusGained.removeFocusListener(this);
                this.$listener.invoke();
            }
            {
                this.$this_whenFirstFocusGained = $receiver;
                this.$listener = $captured_local_variable$1;
            }
        });
    }
}

