/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.UpdateData;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.BuildRange;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0014\u0010&\u001a\u0004\u0018\u00010\u001b2\b\u0010%\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010'\u001a\u00020\u0005H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0016\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\u0013\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\r\u00a8\u0006("}, d2={"Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "", "node", "Lorg/jdom/Element;", "productCode", "", "(Lorg/jdom/Element;Ljava/lang/String;)V", "apiVersion", "Lcom/intellij/openapi/util/BuildNumber;", "getApiVersion", "()Lcom/intellij/openapi/util/BuildNumber;", "blogPost", "getBlogPost", "()Ljava/lang/String;", "downloadUrl", "getDownloadUrl", "message", "Lcom/intellij/openapi/util/NlsSafe;", "getMessage", "number", "getNumber", "patches", "", "Lcom/intellij/openapi/updateSettings/impl/PatchInfo;", "getPatches", "()Ljava/util/List;", "releaseDate", "Ljava/util/Date;", "getReleaseDate", "()Ljava/util/Date;", "target", "Lcom/intellij/openapi/util/BuildRange;", "getTarget", "()Lcom/intellij/openapi/util/BuildRange;", "version", "getVersion", "parseBuildNumber", "value", "parseDate", "toString", "intellij.platform.ide.impl"})
public final class BuildInfo {
    @NotNull
    private final BuildNumber number;
    @NotNull
    private final BuildNumber apiVersion;
    @NotNull
    private final String version;
    @NotNull
    private final String message;
    @Nullable
    private final String blogPost;
    @Nullable
    private final Date releaseDate;
    @Nullable
    private final BuildRange target;
    @NotNull
    private final List<PatchInfo> patches;
    @Nullable
    private final String downloadUrl;

    @NotNull
    public final BuildNumber getNumber() {
        return this.number;
    }

    @NotNull
    public final BuildNumber getApiVersion() {
        return this.apiVersion;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Nullable
    public final String getBlogPost() {
        return this.blogPost;
    }

    @Nullable
    public final Date getReleaseDate() {
        return this.releaseDate;
    }

    @Nullable
    public final BuildRange getTarget() {
        return this.target;
    }

    @NotNull
    public final List<PatchInfo> getPatches() {
        return this.patches;
    }

    @Nullable
    public final String getDownloadUrl() {
        return this.downloadUrl;
    }

    private final BuildNumber parseBuildNumber(String value2, String productCode) {
        BuildNumber buildNumber;
        BuildNumber buildNumber2 = BuildNumber.fromString((String)value2);
        Intrinsics.checkNotNull((Object)buildNumber2);
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber2, (String)"BuildNumber.fromString(value)!!");
        BuildNumber buildNumber3 = buildNumber2;
        String string = buildNumber3.getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buildNumber.productCode");
        CharSequence charSequence = string;
        boolean bl = false;
        if (charSequence.length() > 0) {
            buildNumber = buildNumber3;
        } else {
            int[] nArray = buildNumber3.getComponents();
            buildNumber = new BuildNumber(productCode, Arrays.copyOf(nArray, nArray.length));
        }
        return buildNumber;
    }

    private final Date parseDate(String value2) {
        Date date;
        if (value2 == null) {
            date = null;
        } else {
            Date date2;
            try {
                date2 = new SimpleDateFormat("yyyyMMdd", Locale.US).parse(value2);
            }
            catch (ParseException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(BuildInfo.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.info("invalid build release date: " + value2);
                date2 = null;
            }
            date = date2;
        }
        return date;
    }

    @NotNull
    public String toString() {
        return this.number + '/' + this.version;
    }

    /*
     * WARNING - void declaration
     */
    public BuildInfo(@NotNull Element node2, @NotNull String productCode) {
        Iterator iterator2;
        Object object;
        block7: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object2;
            String string;
            BuildInfo buildInfo;
            boolean bl;
            Object object3;
            block9: {
                Object object4;
                BuildInfo buildInfo2;
                block8: {
                    void it;
                    Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
                    this.number = this.parseBuildNumber(UpdateData.access$getMandatoryAttributeValue(node2, "fullNumber", "number"), productCode);
                    buildInfo2 = this;
                    object4 = node2.getAttributeValue("apiVersion");
                    if (object4 == null) break block8;
                    object3 = object4;
                    bl = false;
                    boolean bl2 = false;
                    String string2 = object3;
                    buildInfo = buildInfo2;
                    boolean bl3 = false;
                    object = BuildNumber.fromStringWithProductCode((String)it, (String)this.number.getProductCode());
                    buildInfo2 = buildInfo;
                    object4 = object;
                    if (object4 != null) break block9;
                }
                object4 = buildInfo2.apiVersion = this.number;
            }
            if ((string = node2.getAttributeValue("version")) == null) {
                string = this.version = "";
            }
            if ((object2 = node2.getChild("message")) == null || (object2 = object2.getValue()) == null) {
                object2 = "";
            }
            this.message = object2;
            Element element2 = node2.getChild("blogPost");
            this.blogPost = element2 != null ? element2.getAttributeValue("url") : null;
            this.releaseDate = this.parseDate(node2.getAttributeValue("releaseDate"));
            this.target = BuildRange.fromStrings((String)node2.getAttributeValue("targetSince"), (String)node2.getAttributeValue("targetUntil"));
            List list2 = node2.getChildren("patch");
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"node.getChildren(\"patch\")");
            object3 = list2;
            buildInfo = this;
            boolean $i$f$map = false;
            Object object5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                Element element3 = (Element)item$iv$iv;
                object = destination$iv$iv;
                boolean bl4 = false;
                PatchInfo patchInfo = new PatchInfo((Element)p1);
                object.add(patchInfo);
            }
            object = (List)destination$iv$iv;
            buildInfo.patches = object;
            List list3 = node2.getChildren("button");
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"node.getChildren(\"button\")");
            object3 = list3;
            buildInfo = this;
            bl = false;
            object5 = object3;
            boolean bl5 = false;
            Iterator iterator3 = object5.iterator();
            while (iterator3.hasNext()) {
                Iterator iterator4 = iterator3.next();
                Element it = (Element)iterator4;
                boolean bl6 = false;
                if (!(it.getAttributeValue("download") != null)) continue;
                iterator2 = iterator4;
                break block7;
            }
            iterator2 = null;
        }
        object = iterator2;
        Element element4 = (Element)object;
        buildInfo.downloadUrl = element4 != null ? UpdateData.access$getMandatoryAttributeValue(element4, "url") : null;
    }
}

