/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginLoadingError;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplacePluginDownloadService;
import com.intellij.ide.plugins.marketplace.PluginSignatureChecker;
import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableNotNullBiFunction;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Urls;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginDownloader {
    private static final Logger LOG = Logger.getInstance(PluginDownloader.class);
    @NotNull
    private final PluginId myPluginId;
    @Nullable
    private final String myPluginName;
    @Nullable
    private final String myProductCode;
    private final Date myReleaseDate;
    private final int myReleaseVersion;
    private final boolean myLicenseOptional;
    private final String myDescription;
    @NotNull
    private final List<? extends IdeaPluginDependency> myDependencies;
    @NotNull
    private final String myPluginUrl;
    private final BuildNumber myBuildNumber;
    @NlsSafe
    private String myPluginVersion;
    private IdeaPluginDescriptor myDescriptor;
    private File myFile;
    private Path myOldFile;
    private MarketplacePluginDownloadService myDownloadService;
    private boolean myShownErrors;
    @Nullable
    private List<String> myErrors;

    private PluginDownloader(@NotNull IdeaPluginDescriptor descriptor2, @NotNull String url, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginDownloader.$$$reportNull$$$0(0);
        }
        if (url == null) {
            PluginDownloader.$$$reportNull$$$0(1);
        }
        this.myPluginId = descriptor2.getPluginId();
        this.myPluginName = descriptor2.getName();
        this.myProductCode = descriptor2.getProductCode();
        this.myReleaseDate = descriptor2.getReleaseDate();
        this.myReleaseVersion = descriptor2.getReleaseVersion();
        this.myLicenseOptional = descriptor2.isLicenseOptional();
        this.myDescription = descriptor2.getDescription();
        this.myDependencies = descriptor2.getDependencies();
        this.myPluginUrl = url;
        this.myBuildNumber = buildNumber;
        this.myPluginVersion = descriptor2.getVersion();
        this.myDescriptor = descriptor2;
    }

    public void setDownloadFunction(final @NotNull ThrowableNotNullBiFunction<? super String, ? super ProgressIndicator, ? extends File, ? extends IOException> downloadFunction) {
        if (downloadFunction == null) {
            PluginDownloader.$$$reportNull$$$0(2);
        }
        this.myDownloadService = new MarketplacePluginDownloadService(){

            @Override
            @NotNull
            public File downloadPlugin(@NotNull String pluginUrl, @NotNull ProgressIndicator indicator2) throws IOException {
                if (pluginUrl == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                File file2 = (File)downloadFunction.fun((Object)pluginUrl, (Object)indicator2);
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return file2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginUrl";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginDownloader$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginDownloader$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "downloadPlugin";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "downloadPlugin";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Deprecated
    @NotNull
    public String getPluginId() {
        String string = this.myPluginId.getIdString();
        if (string == null) {
            PluginDownloader.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public PluginId getId() {
        PluginId pluginId = this.myPluginId;
        if (pluginId == null) {
            PluginDownloader.$$$reportNull$$$0(4);
        }
        return pluginId;
    }

    @NlsSafe
    public String getPluginVersion() {
        return this.myPluginVersion;
    }

    @NlsSafe
    @NotNull
    public String getPluginName() {
        String string = this.myPluginName != null ? this.myPluginName : this.myPluginId.getIdString();
        if (string == null) {
            PluginDownloader.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public String getProductCode() {
        return this.myProductCode;
    }

    public Date getReleaseDate() {
        return this.myReleaseDate;
    }

    public int getReleaseVersion() {
        return this.myReleaseVersion;
    }

    public boolean isFromMarketplace() {
        try {
            URL pluginURL = new URL(this.myPluginUrl);
            URL defaultPluginsHost = new URL("https://plugins.jetbrains.com");
            return pluginURL.getHost().equals(defaultPluginsHost.getHost());
        }
        catch (MalformedURLException ignored) {
            return false;
        }
    }

    public boolean isLicenseOptional() {
        return this.myLicenseOptional;
    }

    @Nullable
    public BuildNumber getBuildNumber() {
        return this.myBuildNumber;
    }

    @NotNull
    public IdeaPluginDescriptor getDescriptor() {
        IdeaPluginDescriptor ideaPluginDescriptor = this.myDescriptor;
        if (ideaPluginDescriptor == null) {
            PluginDownloader.$$$reportNull$$$0(6);
        }
        return ideaPluginDescriptor;
    }

    public File getFile() {
        return this.myFile;
    }

    public boolean isShownErrors() {
        return this.myShownErrors;
    }

    public void setErrorsCollector(@Nullable List<String> errors2) {
        this.myErrors = errors2;
    }

    public boolean prepareToInstall(@NotNull ProgressIndicator indicator2) throws IOException {
        if (indicator2 == null) {
            PluginDownloader.$$$reportNull$$$0(7);
        }
        return this.prepareToInstallAndLoadDescriptor(indicator2) != null;
    }

    @Nullable
    public IdeaPluginDescriptorImpl prepareToInstallAndLoadDescriptor(@NotNull ProgressIndicator indicator2) throws IOException {
        if (indicator2 == null) {
            PluginDownloader.$$$reportNull$$$0(8);
        }
        return this.prepareToInstallAndLoadDescriptor(indicator2, true);
    }

    @Nullable
    public IdeaPluginDescriptorImpl prepareToInstallAndLoadDescriptor(@NotNull ProgressIndicator indicator2, boolean showMessageOnError) throws IOException {
        boolean certified;
        if (indicator2 == null) {
            PluginDownloader.$$$reportNull$$$0(9);
        }
        this.myShownErrors = false;
        if (this.myFile != null) {
            IdeaPluginDescriptorImpl actualDescriptor = PluginDescriptorLoader.loadDescriptorFromArtifact(this.myFile.toPath(), this.myBuildNumber);
            if (actualDescriptor == null) {
                this.reportError(showMessageOnError, IdeBundle.message((String)"error.descriptor.load.failed", (Object[])new Object[]{this.myFile.getPath()}));
            }
            this.myDescriptor = actualDescriptor;
            return actualDescriptor;
        }
        IdeaPluginDescriptor descriptor2 = null;
        if (!Boolean.getBoolean("StartupWizardMode") && PluginManagerCore.isPluginInstalled(this.myPluginId)) {
            descriptor2 = PluginManagerCore.getPlugin(this.myPluginId);
            LOG.assertTrue(descriptor2 != null);
            if (this.myPluginVersion != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(this.myPluginVersion, descriptor2) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return null;
            }
            this.myOldFile = descriptor2.isBundled() ? null : descriptor2.getPluginPath();
        }
        this.myFile = this.tryDownloadPlugin(indicator2, showMessageOnError);
        if (this.myFile == null) {
            return null;
        }
        if (this.requiresSignatureCheck() && !(certified = PluginSignatureChecker.verify(this.myDescriptor, this.myFile, showMessageOnError))) {
            this.myShownErrors = true;
            return null;
        }
        IdeaPluginDescriptorImpl actualDescriptor = PluginDescriptorLoader.loadDescriptorFromArtifact(this.myFile.toPath(), this.myBuildNumber);
        if (actualDescriptor != null) {
            InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
            if (state != null && state.wasUpdated(actualDescriptor.getPluginId())) {
                this.reportError(showMessageOnError, IdeBundle.message((String)"error.pending.update", (Object[])new Object[]{this.getPluginName()}));
                return null;
            }
            this.myPluginVersion = actualDescriptor.getVersion();
            if (descriptor2 != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(this.myPluginVersion, descriptor2) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                this.reportError(showMessageOnError, IdeBundle.message((String)"error.older.update", (Object[])new Object[]{this.myPluginVersion, descriptor2.getVersion()}));
                return null;
            }
            this.myDescriptor = actualDescriptor;
            PluginLoadingError incompatibleError = PluginManagerCore.checkBuildNumberCompatibility(actualDescriptor, this.myBuildNumber != null ? this.myBuildNumber : PluginManagerCore.getBuildNumber());
            if (incompatibleError != null) {
                LOG.info("Plugin " + this.myPluginId + " is incompatible with current installation (since:" + actualDescriptor.getSinceBuild() + " until:" + actualDescriptor.getUntilBuild() + ")");
                this.reportError(showMessageOnError, IdeBundle.message((String)"error.incompatible.update", (Object[])new Object[]{XmlStringUtil.escapeString((String)incompatibleError.getDetailedMessage())}));
                return null;
            }
        } else {
            this.reportError(showMessageOnError, IdeBundle.message((String)"error.downloaded.descriptor.load.failed", (Object[])new Object[0]));
        }
        return actualDescriptor;
    }

    private boolean requiresSignatureCheck() {
        if (ApplicationManager.getApplication() == null) {
            return false;
        }
        if (this.isFromMarketplace()) {
            return Registry.is((String)"marketplace.certificate.signature.check");
        }
        return Registry.is((String)"custom-repository.certificate.signature.check");
    }

    private boolean isPluginFromBuiltinRepo() {
        String builtinPluginsUrlPluginsXml = ApplicationInfoImpl.getShadowInstance().getBuiltinPluginsUrl();
        String builtinPluginsUrl = null;
        if (builtinPluginsUrlPluginsXml != null) {
            builtinPluginsUrl = StringUtil.substringBeforeLast((String)builtinPluginsUrlPluginsXml, (String)"/");
        }
        if (builtinPluginsUrl != null) {
            try {
                URL builtinPluginsUrlURL = new URL(builtinPluginsUrl);
                URL myPluginUrlURL = new URL(this.myPluginUrl);
                if (!myPluginUrlURL.getHost().equals(builtinPluginsUrlURL.getHost())) {
                    return false;
                }
                return myPluginUrlURL.getPath().startsWith(builtinPluginsUrlURL.getPath());
            }
            catch (MalformedURLException ignored) {
                return false;
            }
        }
        return false;
    }

    private void reportError(boolean showMessageOnError, @Nullable @Nls String errorMessage) {
        LOG.info("PluginDownloader error: " + errorMessage);
        Application app2 = ApplicationManager.getApplication();
        if (app2 != null) {
            this.myShownErrors = true;
            if (showMessageOnError || this.myErrors != null) {
                if (errorMessage == null) {
                    errorMessage = IdeBundle.message((String)"unknown.error", (Object[])new Object[0]);
                }
                String text2 = IdeBundle.message((String)"error.plugin.was.not.installed", (Object[])new Object[]{this.getPluginName(), errorMessage});
                if (this.myErrors != null) {
                    this.myErrors.add(text2);
                } else if (showMessageOnError) {
                    String title2 = IdeBundle.message((String)"title.plugin.installation", (Object[])new Object[0]);
                    app2.invokeLater(() -> Messages.showErrorDialog((String)text2, (String)title2), ModalityState.any());
                }
            }
        }
    }

    public static String getMarketplaceDownloadsUUID() {
        try {
            return DeviceIdManager.getOrGenerateId((DeviceIdManager.DeviceIdToken)new DeviceIdManager.DeviceIdToken(){}, (String)"MarketplaceDownloads");
        }
        catch (DeviceIdManager.InvalidDeviceIdTokenException e) {
            return "";
        }
    }

    public static int compareVersionsSkipBrokenAndIncompatible(String newPluginVersion, @NotNull IdeaPluginDescriptor existingPlugin) {
        if (existingPlugin == null) {
            PluginDownloader.$$$reportNull$$$0(10);
        }
        return PluginDownloader.compareVersionsSkipBrokenAndIncompatible(newPluginVersion, existingPlugin, null);
    }

    public static int compareVersionsSkipBrokenAndIncompatible(String newPluginVersion, @NotNull IdeaPluginDescriptor existingPlugin, @Nullable BuildNumber newBuildNumber) {
        int state;
        if (existingPlugin == null) {
            PluginDownloader.$$$reportNull$$$0(11);
        }
        if ((state = VersionComparatorUtil.compare((String)newPluginVersion, (String)existingPlugin.getVersion())) < 0 && (PluginManagerCore.isBrokenPlugin(existingPlugin) || PluginManagerCore.isIncompatible(existingPlugin, newBuildNumber))) {
            state = 1;
        }
        return state;
    }

    public void install() throws IOException {
        if (this.myFile == null) {
            throw new IOException("Plugin '" + this.getPluginName() + "' was not successfully downloaded");
        }
        boolean deletePluginSource = !Registry.is((String)"ide.plugins.keep.archive", (boolean)true);
        PluginInstaller.installAfterRestart(this.myFile.toPath(), deletePluginSource, this.myOldFile, this.myDescriptor);
        InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
        if (state != null) {
            state.onPluginInstall(this.myDescriptor, PluginManagerCore.isPluginInstalled(this.myDescriptor.getPluginId()), true);
        } else {
            InstalledPluginsState.addPreInstalledPlugin(this.myDescriptor);
        }
    }

    public boolean tryInstallWithoutRestart(@Nullable JComponent ownerComponent) {
        IdeaPluginDescriptorImpl installedPlugin;
        assert (this.myDescriptor instanceof IdeaPluginDescriptorImpl);
        IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)this.myDescriptor;
        if (!DynamicPlugins.allowLoadUnloadWithoutRestart(descriptor2)) {
            return false;
        }
        if (!(this.myOldFile == null || (installedPlugin = (IdeaPluginDescriptorImpl)PluginManagerCore.getPlugin(this.myDescriptor.getPluginId())) != null && DynamicPlugins.allowLoadUnloadWithoutRestart(installedPlugin) && DynamicPlugins.INSTANCE.unloadPlugin(installedPlugin, new DynamicPlugins.UnloadPluginOptions().withDisable(false).withUpdate(true).withWaitForClassloaderUnload(true)))) {
            return false;
        }
        return PluginInstaller.installAndLoadDynamicPlugin(this.myFile.toPath(), ownerComponent, descriptor2);
    }

    @Nullable
    private File tryDownloadPlugin(@NotNull ProgressIndicator indicator2, boolean showMessageOnError) {
        if (indicator2 == null) {
            PluginDownloader.$$$reportNull$$$0(12);
        }
        indicator2.checkCanceled();
        indicator2.setText2(IdeBundle.message((String)"progress.downloading.plugin", (Object[])new Object[]{this.getPluginName()}));
        MarketplacePluginDownloadService downloader = this.myDownloadService != null ? this.myDownloadService : MarketplacePluginDownloadService.getInstance();
        try {
            return this.myOldFile != null ? downloader.downloadPluginViaBlockMap(this.myPluginUrl, this.myOldFile, indicator2) : downloader.downloadPlugin(this.myPluginUrl, indicator2);
        }
        catch (IOException ex) {
            LOG.warn((Throwable)ex);
            this.reportError(showMessageOnError, ex.getMessage());
            return null;
        }
    }

    @NotNull
    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor2) throws IOException {
        if (descriptor2 == null) {
            PluginDownloader.$$$reportNull$$$0(13);
        }
        return PluginDownloader.createDownloader(descriptor2, null, null);
    }

    @NotNull
    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor2, @Nullable String host, @Nullable BuildNumber buildNumber) throws IOException {
        if (descriptor2 == null) {
            PluginDownloader.$$$reportNull$$$0(14);
        }
        String url = descriptor2 instanceof PluginNode && host != null ? PluginDownloader.getDownloadUrl((PluginNode)descriptor2, host) : PluginDownloader.getUrl(descriptor2.getPluginId(), buildNumber);
        return new PluginDownloader(descriptor2, url, buildNumber);
    }

    @NotNull
    public PluginNode toPluginNode() {
        PluginNode pluginNode = this.toPluginNode(null);
        if (pluginNode == null) {
            PluginDownloader.$$$reportNull$$$0(15);
        }
        return pluginNode;
    }

    @NotNull
    public PluginNode toPluginNode(@Nullable String host) {
        IdeaPluginDescriptor descriptor2 = this.getDescriptor();
        if (descriptor2 instanceof PluginNode) {
            PluginNode pluginNode = (PluginNode)descriptor2;
            if (pluginNode == null) {
                PluginDownloader.$$$reportNull$$$0(16);
            }
            return pluginNode;
        }
        PluginNode node2 = new PluginNode(this.getId());
        node2.setName(this.getPluginName());
        node2.setProductCode(this.getProductCode());
        node2.setReleaseDate(this.getReleaseDate());
        node2.setReleaseVersion(this.getReleaseVersion());
        node2.setLicenseOptional(this.isLicenseOptional());
        node2.setVersion(this.getPluginVersion());
        node2.setRepositoryName(host);
        node2.setDownloadUrl(this.myPluginUrl);
        node2.setDependencies(this.myDependencies);
        node2.setDescription(this.myDescription);
        PluginNode pluginNode = node2;
        if (pluginNode == null) {
            PluginDownloader.$$$reportNull$$$0(17);
        }
        return pluginNode;
    }

    private static String getDownloadUrl(PluginNode pluginNode, String host) throws IOException {
        String url = pluginNode.getDownloadUrl();
        try {
            return new URI(url).isAbsolute() ? url : new URL(new URL(host), url).toExternalForm();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private static String getUrl(PluginId pluginId, @Nullable BuildNumber buildNumber) {
        return Urls.newFromEncoded((String)ApplicationInfoImpl.getShadowInstance().getPluginsDownloadUrl()).addParameters(Map.of("id", pluginId.getIdString(), "build", ApplicationInfoImpl.orFromPluginsCompatibleBuild(buildNumber), "uuid", PluginDownloader.getMarketplaceDownloadsUUID())).toExternalForm();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadFunction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginDownloader";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingPlugin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginDownloader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toPluginNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDownloadFunction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstall";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstallAndLoadDescriptor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "compareVersionsSkipBrokenAndIncompatible";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryDownloadPlugin";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDownloader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

