/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.org.PluginManagerFilters;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.updateSettings.impl.DetectedPluginsPanel;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginsAdvertiserDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(PluginsAdvertiserDialog.class);
    private final Collection<PluginDownloader> myPluginToInstall;
    @Nullable
    private final Project myProject;
    @NotNull
    private final List<PluginNode> myCustomPlugins;
    @Nullable
    private final Consumer<? super Boolean> myFinishFunction;
    private final boolean mySelectAllSuggestions;
    @Nullable
    private DetectedPluginsPanel myPanel;

    PluginsAdvertiserDialog(@Nullable Project project, @NotNull Collection<PluginDownloader> pluginsToInstall, @NotNull List<PluginNode> customPlugins, boolean selectAllSuggestions, @Nullable Consumer<? super Boolean> finishFunction) {
        if (pluginsToInstall == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(0);
        }
        if (customPlugins == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.myProject = project;
        this.myPluginToInstall = pluginsToInstall;
        this.myCustomPlugins = customPlugins;
        this.myFinishFunction = finishFunction;
        this.mySelectAllSuggestions = selectAllSuggestions;
        this.setTitle(IdeBundle.message((String)"dialog.title.choose.plugins.to.install.or.enable", (Object[])new Object[0]));
        this.init();
    }

    PluginsAdvertiserDialog(@Nullable Project project, @NotNull Collection<PluginDownloader> pluginsToInstall, @NotNull List<PluginNode> customPlugins) {
        if (pluginsToInstall == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(2);
        }
        if (customPlugins == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(3);
        }
        this(project, pluginsToInstall, customPlugins, false, null);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        if (this.myPanel == null) {
            this.myPanel = new DetectedPluginsPanel(this.myProject);
            Iterator<PluginDownloader> iterator2 = this.myPluginToInstall.iterator();
            this.myPanel.addAll(this.myPluginToInstall, this.mySelectAllSuggestions || !iterator2.hasNext() ? null : iterator2.next());
        }
        DetectedPluginsPanel detectedPluginsPanel = this.myPanel;
        if (detectedPluginsPanel == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(4);
        }
        return detectedPluginsPanel;
    }

    protected void doOKAction() {
        assert (this.myPanel != null);
        if (this.doInstallPlugins(this.myPanel::isChecked, ModalityState.stateForComponent((Component)((Object)this.myPanel)))) {
            super.doOKAction();
        }
    }

    public void doInstallPlugins(boolean showDialog) {
        if (showDialog) {
            this.showAndGet();
        } else {
            this.doInstallPlugins(__ -> true, ModalityState.NON_MODAL);
        }
    }

    private boolean doInstallPlugins(@NotNull Predicate<? super PluginDownloader> predicate2, @NotNull ModalityState modalityState) {
        if (predicate2 == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(5);
        }
        if (modalityState == null) {
            PluginsAdvertiserDialog.$$$reportNull$$$0(6);
        }
        ArrayList<IdeaPluginDescriptor> pluginsToEnable = new ArrayList<IdeaPluginDescriptor>();
        ArrayList<PluginNode> nodes = new ArrayList<PluginNode>();
        for (PluginDownloader downloader : this.myPluginToInstall) {
            if (!predicate2.test(downloader)) continue;
            IdeaPluginDescriptor plugin2 = downloader.getDescriptor();
            pluginsToEnable.add(plugin2);
            if (!plugin2.isEnabled()) continue;
            nodes.add(downloader.toPluginNode());
        }
        if (!PluginManagerMain.checkThirdPartyPluginsAllowed(nodes)) {
            return false;
        }
        PluginManagerFilters org = PluginManagerFilters.getInstance();
        TreeSet notAllowedToInstallPlugins = nodes.stream().filter(descriptor2 -> !org.allowInstallingPlugin((IdeaPluginDescriptor)descriptor2)).map(e -> e.getPluginId().getIdString()).collect(Collectors.toCollection(TreeSet::new));
        if (!notAllowedToInstallPlugins.isEmpty()) {
            LOG.warn("Some advertised plugins were not allowed to install for the organization: " + StringUtil.join((Collection)notAllowedToInstallPlugins, (String)", "));
            return false;
        }
        PluginManagerMain.suggestToEnableInstalledDependantPlugins(PluginEnabler.HEADLESS, nodes);
        Runnable notifyRunnable = () -> {
            boolean notInstalled = nodes.stream().map(PluginNode::getPluginId).map(PluginManagerCore::getPlugin).anyMatch(Objects::isNull);
            if (notInstalled) {
                PluginManagerMain.notifyPluginsUpdated(this.myProject);
            }
        };
        PluginEnabler.HEADLESS.enable(pluginsToEnable);
        if (!nodes.isEmpty()) {
            try {
                PluginManagerMain.downloadPlugins(nodes, this.myCustomPlugins, true, notifyRunnable, PluginEnabler.HEADLESS, modalityState, this.myFinishFunction);
            }
            catch (IOException e2) {
                LOG.error((Throwable)e2);
            }
        } else if (!pluginsToEnable.isEmpty()) {
            notifyRunnable.run();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToInstall";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customPlugins";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiserDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiserDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doInstallPlugins";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

