/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.vcs.actions.ActiveAnnotationGutter;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import java.awt.Color;
import java.awt.Cursor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotationGutterLineConvertorProxy
implements ActiveAnnotationGutter {
    private final UpToDateLineNumberProvider myGetUpToDateLineNumber;
    private final ActiveAnnotationGutter myDelegate;

    public AnnotationGutterLineConvertorProxy(UpToDateLineNumberProvider getUpToDateLineNumber, ActiveAnnotationGutter delegate2) {
        this.myGetUpToDateLineNumber = getUpToDateLineNumber;
        this.myDelegate = delegate2;
    }

    @NotNull
    public ActiveAnnotationGutter getDelegate() {
        ActiveAnnotationGutter activeAnnotationGutter = this.myDelegate;
        if (activeAnnotationGutter == null) {
            AnnotationGutterLineConvertorProxy.$$$reportNull$$$0(0);
        }
        return activeAnnotationGutter;
    }

    public String getLineText(int line, Editor editor2) {
        int currentLine = this.myGetUpToDateLineNumber.getLineNumber(line);
        if (!AnnotationGutterLineConvertorProxy.canBeAnnotated(currentLine)) {
            return "";
        }
        return this.myDelegate.getLineText(currentLine, editor2);
    }

    public String getToolTip(int line, Editor editor2) {
        int currentLine = this.myGetUpToDateLineNumber.getLineNumber(line);
        if (!AnnotationGutterLineConvertorProxy.canBeAnnotated(currentLine)) {
            return "";
        }
        return this.myDelegate.getToolTip(currentLine, editor2);
    }

    public EditorFontType getStyle(int line, Editor editor2) {
        int currentLine = this.myGetUpToDateLineNumber.getLineNumber(line);
        if (!AnnotationGutterLineConvertorProxy.canBeAnnotated(currentLine)) {
            return EditorFontType.PLAIN;
        }
        return this.myDelegate.getStyle(currentLine, editor2);
    }

    public ColorKey getColor(int line, Editor editor2) {
        int currentLine = this.myGetUpToDateLineNumber.getLineNumber(line);
        if (!AnnotationGutterLineConvertorProxy.canBeAnnotated(currentLine)) {
            return AnnotationSource.LOCAL.getColor();
        }
        return this.myDelegate.getColor(currentLine, editor2);
    }

    public Color getBgColor(int line, Editor editor2) {
        int currentLine = this.myGetUpToDateLineNumber.getLineNumber(line);
        if (!AnnotationGutterLineConvertorProxy.canBeAnnotated(currentLine)) {
            return null;
        }
        return this.myDelegate.getBgColor(currentLine, editor2);
    }

    public List<AnAction> getPopupActions(int line, Editor editor2) {
        return this.myDelegate.getPopupActions(line, editor2);
    }

    public void gutterClosed() {
        this.myDelegate.gutterClosed();
    }

    public void doAction(int lineNum) {
        int currentLine = this.myGetUpToDateLineNumber.getLineNumber(lineNum);
        if (!AnnotationGutterLineConvertorProxy.canBeAnnotated(currentLine)) {
            return;
        }
        this.myDelegate.doAction(currentLine);
    }

    public Cursor getCursor(int lineNum) {
        int currentLine = this.myGetUpToDateLineNumber.getLineNumber(lineNum);
        if (!AnnotationGutterLineConvertorProxy.canBeAnnotated(currentLine)) {
            return Cursor.getDefaultCursor();
        }
        return this.myDelegate.getCursor(currentLine);
    }

    private static boolean canBeAnnotated(int currentLine) {
        return currentLine >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotationGutterLineConvertorProxy", "getDelegate"));
    }
}

