/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractShowDiffAction;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContextUtil;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.util.Consumer;
import com.intellij.util.TreeItem;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.ListTableModel;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareWithSelectedRevisionAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(0);
        }
        if ((file2 = VcsContextUtil.selectedFile(e.getDataContext())) != null && file2.isDirectory()) {
            Project project = e.getProject();
            e.getPresentation().setVisible(CompareWithSelectedRevisionAction.isVisibleForDirectory(project));
            e.getPresentation().setEnabled(CompareWithSelectedRevisionAction.isEnabledForDirectory(project, file2));
        } else {
            AbstractShowDiffAction.updateDiffAction(e.getPresentation(), e.getDataContext());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(1);
        }
        VirtualFile file2 = Objects.requireNonNull(VcsContextUtil.selectedFile(e.getDataContext()));
        Project project = Objects.requireNonNull(e.getProject());
        AbstractVcs vcs = Objects.requireNonNull(ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file2));
        VcsCachingHistory.collectInBackground(vcs, VcsUtil.getFilePath((VirtualFile)file2), VcsBackgroundableActions.COMPARE_WITH, (Consumer<? super VcsHistorySession>)((Consumer)session2 -> {
            if (session2 == null) {
                return;
            }
            List revisions = session2.getRevisionList();
            HistoryAsTreeProvider treeHistoryProvider = session2.getHistoryAsTreeProvider();
            if (treeHistoryProvider != null) {
                CompareWithSelectedRevisionAction.showTreePopup(treeHistoryProvider.createTreeOn(revisions), project, (Consumer<? super VcsFileRevision>)((Consumer)selected2 -> this.showSelectedRevision(selected2.getRevisionNumber(), vcs, file2, project)));
            } else {
                CompareWithSelectedRevisionAction.showListPopup(revisions, project, (Consumer<? super VcsFileRevision>)((Consumer)selected2 -> this.showSelectedRevision(selected2.getRevisionNumber(), vcs, file2, project)), true);
            }
        }));
    }

    protected void showSelectedRevision(@NotNull VcsRevisionNumber selected2, @NotNull AbstractVcs vcs, @NotNull VirtualFile file2, @NotNull Project project) {
        if (selected2 == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(2);
        }
        if (vcs == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(4);
        }
        if (project == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(5);
        }
        if (file2.isDirectory()) {
            DiffProvider diffProvider = Objects.requireNonNull(vcs.getDiffProvider());
            VcsDiffUtil.showChangesWithWorkingDirLater(project, file2, selected2, diffProvider);
        } else {
            DiffActionExecutor.showDiff(vcs.getDiffProvider(), selected2, file2, project);
        }
    }

    private static void showTreePopup(List<TreeItem<VcsFileRevision>> roots2, Project project, Consumer<? super VcsFileRevision> selectedRevisionConsumer) {
        TreeTableView treeTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)new TreeNodeAdapter(null, null, roots2), new ColumnInfo[]{Holder.BRANCH_COLUMN, Holder.REVISION_COLUMN, Holder.DATE_COLUMN, Holder.AUTHOR_COLUMN}));
        Runnable runnable2 = () -> {
            int index2 = treeTable.getSelectionModel().getMinSelectionIndex();
            if (index2 == -1) {
                return;
            }
            VcsFileRevision revision = CompareWithSelectedRevisionAction.getRevisionAt(treeTable, index2);
            if (revision != null) {
                selectedRevisionConsumer.consume((Object)revision);
            }
        };
        treeTable.setSelectionMode(0);
        new PopupChooserBuilder((JTable)treeTable).setTitle(VcsBundle.message((String)"lookup.title.vcs.file.revisions", (Object[])new Object[0])).setItemChoosenCallback(runnable2).setSouthComponent((JComponent)CompareWithSelectedRevisionAction.createCommentsPanel(treeTable)).setResizable(true).setDimensionServiceKey("Vcs.CompareWithSelectedRevision.Popup").createPopup().showCenteredInCurrentWindow(project);
        int lastRow = treeTable.getRowCount() - 1;
        if (lastRow < 0) {
            return;
        }
        treeTable.getSelectionModel().addSelectionInterval(lastRow, lastRow);
        treeTable.scrollRectToVisible(treeTable.getCellRect(lastRow, 0, true));
    }

    @Nullable
    private static VcsFileRevision getRevisionAt(TreeTableView treeTable, int index2) {
        List items = treeTable.getItems();
        if (items.size() <= index2) {
            return null;
        }
        return ((TreeNodeAdapter)items.get(index2)).getRevision();
    }

    private static JPanel createCommentsPanel(final TreeTableView treeTable) {
        JPanel panel2 = new JPanel(new BorderLayout());
        final JTextArea textArea2 = CompareWithSelectedRevisionAction.createTextArea();
        treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                int index2;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((index2 = treeTable.getSelectionModel().getMinSelectionIndex()) == -1) {
                    textArea2.setText("");
                } else {
                    VcsFileRevision revision = CompareWithSelectedRevisionAction.getRevisionAt(treeTable, index2);
                    if (revision != null) {
                        textArea2.setText(revision.getCommitMessage());
                    } else {
                        textArea2.setText("");
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/CompareWithSelectedRevisionAction$1", "valueChanged"));
            }
        });
        JScrollPane textScrollPane = ScrollPaneFactory.createScrollPane((Component)textArea2);
        panel2.add((Component)textScrollPane, "Center");
        textScrollPane.setBorder((Border)IdeBorderFactory.createTitledBorder((String)VcsBundle.message((String)"border.selected.revision.commit.message", (Object[])new Object[0]), (boolean)false));
        return panel2;
    }

    private static JTextArea createTextArea() {
        JTextArea textArea2 = new JTextArea();
        textArea2.setRows(5);
        textArea2.setEditable(false);
        textArea2.setWrapStyleWord(true);
        textArea2.setLineWrap(true);
        return textArea2;
    }

    public static void showListPopup(final List<VcsFileRevision> revisions, Project project, Consumer<? super VcsFileRevision> selectedRevisionConsumer, boolean showComments) {
        ColumnInfo[] columns = new ColumnInfo[]{Holder.REVISION_TABLE_COLUMN, Holder.DATE_TABLE_COLUMN, Holder.AUTHOR_TABLE_COLUMN};
        for (VcsFileRevision revision : revisions) {
            if (revision.getBranchName() == null) continue;
            columns = new ColumnInfo[]{Holder.REVISION_TABLE_COLUMN, Holder.BRANCH_TABLE_COLUMN, Holder.DATE_TABLE_COLUMN, Holder.AUTHOR_TABLE_COLUMN};
            break;
        }
        final TableView table = new TableView(new ListTableModel(columns, revisions, 0));
        table.setShowHorizontalLines(false);
        table.setTableHeader(null);
        Runnable runnable2 = () -> {
            VcsFileRevision revision = (VcsFileRevision)table.getSelectedObject();
            if (revision != null) {
                selectedRevisionConsumer.consume((Object)revision);
            }
        };
        if (table.getModel().getRowCount() == 0) {
            table.clearSelection();
        }
        new SpeedSearchBase<TableView>(table){

            @Override
            protected int getSelectedIndex() {
                return table.getSelectedRow();
            }

            @Override
            protected int getElementCount() {
                return revisions.size();
            }

            @Override
            protected Object getElementAt(int viewIndex) {
                return revisions.get(table.convertRowIndexToModel(viewIndex));
            }

            @Override
            protected String getElementText(Object element2) {
                VcsFileRevision revision = (VcsFileRevision)element2;
                return revision.getRevisionNumber().asString() + " " + revision.getBranchName() + " " + revision.getAuthor();
            }

            @Override
            protected void selectElement(Object element2, String selectedText) {
                VcsFileRevision revision = (VcsFileRevision)element2;
                TableUtil.selectRows((JTable)((JTable)this.myComponent), (int[])new int[]{((TableView)this.myComponent).convertRowIndexToView(revisions.indexOf(revision))});
                TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
            }
        };
        table.setMinimumSize((Dimension)new JBDimension(300, 50));
        PopupChooserBuilder builder2 = new PopupChooserBuilder((JTable)table);
        if (showComments) {
            builder2.setSouthComponent((JComponent)CompareWithSelectedRevisionAction.createCommentsPanel((TableView<VcsFileRevision>)table));
        }
        builder2.setTitle(VcsBundle.message((String)"lookup.title.vcs.file.revisions", (Object[])new Object[0])).setItemChoosenCallback(runnable2).setResizable(true).setDimensionServiceKey("Vcs.CompareWithSelectedRevision.Popup").setMinSize((Dimension)new JBDimension(300, 300));
        JBPopup popup2 = builder2.createPopup();
        popup2.showCenteredInCurrentWindow(project);
    }

    private static JPanel createCommentsPanel(final TableView<VcsFileRevision> table) {
        final JTextArea textArea2 = CompareWithSelectedRevisionAction.createTextArea();
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                VcsFileRevision revision;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((revision = (VcsFileRevision)table.getSelectedObject()) == null) {
                    textArea2.setText("");
                } else {
                    textArea2.setText(revision.getCommitMessage());
                    textArea2.select(0, 0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/CompareWithSelectedRevisionAction$3", "valueChanged"));
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JScrollPane textScrollPane = ScrollPaneFactory.createScrollPane((Component)textArea2);
        JLabel commentLabel = new JLabel(VcsBundle.message((String)"border.selected.revision.commit.message", (Object[])new Object[0]));
        jPanel2.add((Component)commentLabel, "North");
        commentLabel.setBorder(IdeBorderFactory.createBorder((int)11));
        textScrollPane.setBorder(null);
        jPanel2.add((Component)textScrollPane, "Center");
        jPanel2.setPreferredSize((Dimension)new JBDimension(300, 100));
        return jPanel2;
    }

    private static boolean isVisibleForDirectory(@Nullable Project project) {
        return project != null;
    }

    private static boolean isEnabledForDirectory(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            CompareWithSelectedRevisionAction.$$$reportNull$$$0(6);
        }
        if (project == null) {
            return false;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file2);
        DiffProvider diffProvider = vcs != null ? vcs.getDiffProvider() : null;
        return diffProvider != null && diffProvider.canCompareWithWorkingDir();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/CompareWithSelectedRevisionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showSelectedRevision";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TreeNodeAdapter
    extends DefaultMutableTreeNode {
        private final TreeItem<VcsFileRevision> myRevision;

        TreeNodeAdapter(TreeNodeAdapter parent, TreeItem<VcsFileRevision> revision, List<TreeItem<VcsFileRevision>> children2) {
            if (parent != null) {
                parent.add(this);
            }
            this.myRevision = revision;
            for (TreeItem<VcsFileRevision> treeItem : children2) {
                new TreeNodeAdapter(this, treeItem, treeItem.getChildren());
            }
        }

        public VcsFileRevision getRevision() {
            return (VcsFileRevision)this.myRevision.getData();
        }
    }

    private static class Holder {
        private static final ColumnInfo<TreeNodeAdapter, String> BRANCH_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revisions.list.branch", (Object[])new Object[0])){

            public String valueOf(TreeNodeAdapter object) {
                return object.getRevision().getBranchName();
            }
        };
        private static final ColumnInfo<TreeNodeAdapter, String> REVISION_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revision.list.revision", (Object[])new Object[0])){

            public String valueOf(TreeNodeAdapter object) {
                return object.getRevision().getRevisionNumber().asString();
            }
        };
        private static final ColumnInfo<TreeNodeAdapter, String> DATE_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revisions.list.filter", (Object[])new Object[0])){

            public String valueOf(TreeNodeAdapter object) {
                return DateFormatUtil.formatPrettyDateTime((Date)object.getRevision().getRevisionDate());
            }
        };
        private static final ColumnInfo<TreeNodeAdapter, String> AUTHOR_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0])){

            public String valueOf(TreeNodeAdapter object) {
                return object.getRevision().getAuthor();
            }
        };
        private static final ColumnInfo<VcsFileRevision, String> REVISION_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revision.list.revision", (Object[])new Object[0])){

            public String valueOf(VcsFileRevision vcsFileRevision) {
                return vcsFileRevision.getRevisionNumber().asString();
            }
        };
        private static final ColumnInfo<VcsFileRevision, String> DATE_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revision.list.revision", (Object[])new Object[0])){

            public String valueOf(VcsFileRevision vcsFileRevision) {
                Date date = vcsFileRevision.getRevisionDate();
                return date == null ? "" : DateFormatUtil.formatPrettyDateTime((Date)date);
            }
        };
        private static final ColumnInfo<VcsFileRevision, String> AUTHOR_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0])){

            public String valueOf(VcsFileRevision vcsFileRevision) {
                return vcsFileRevision.getAuthor();
            }
        };
        private static final ColumnInfo<VcsFileRevision, String> BRANCH_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revisions.list.branch", (Object[])new Object[0])){

            public String valueOf(VcsFileRevision vcsFileRevision) {
                return vcsFileRevision.getBranchName();
            }
        };

        private Holder() {
        }
    }
}

