/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.DiffVcsDataKeys;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffActionExecutor {
    protected final DiffProvider myDiffProvider;
    protected final VirtualFile mySelectedFile;
    protected final Project myProject;
    private final Integer mySelectedLine;

    protected DiffActionExecutor(@NotNull DiffProvider diffProvider, @NotNull VirtualFile selectedFile, @NotNull Project project, @Nullable Editor editor2) {
        if (diffProvider == null) {
            DiffActionExecutor.$$$reportNull$$$0(0);
        }
        if (selectedFile == null) {
            DiffActionExecutor.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DiffActionExecutor.$$$reportNull$$$0(2);
        }
        this.myDiffProvider = diffProvider;
        this.mySelectedFile = selectedFile;
        this.myProject = project;
        this.mySelectedLine = DiffActionExecutor.getSelectedLine(project, this.mySelectedFile, editor2);
    }

    @Nullable
    private static Integer getSelectedLine(@NotNull Project project, @NotNull VirtualFile file2, @Nullable Editor contextEditor) {
        FileEditor fileEditor;
        VirtualFile contextFile;
        if (project == null) {
            DiffActionExecutor.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            DiffActionExecutor.$$$reportNull$$$0(4);
        }
        Editor editor2 = null;
        if (contextEditor != null && Comparing.equal((Object)(contextFile = FileDocumentManager.getInstance().getFile(contextEditor.getDocument())), (Object)file2)) {
            editor2 = contextEditor;
        }
        if (editor2 == null && (fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file2)) instanceof TextEditor) {
            editor2 = ((TextEditor)fileEditor).getEditor();
        }
        if (editor2 == null) {
            return null;
        }
        return editor2.getCaretModel().getLogicalPosition().line;
    }

    @NotNull
    protected DiffContent createRemote(@NotNull ContentRevision fileRevision) throws IOException, VcsException {
        DocumentContent diffContent;
        if (fileRevision == null) {
            DiffActionExecutor.$$$reportNull$$$0(5);
        }
        DiffContentFactoryEx contentFactory = DiffContentFactoryEx.getInstanceEx();
        if (fileRevision instanceof ByteBackedContentRevision) {
            byte[] content2 = ((ByteBackedContentRevision)fileRevision).getContentAsBytes();
            if (content2 == null) {
                throw new VcsException(VcsBundle.message((String)"vcs.error.failed.to.load.file.content.from.vcs", (Object[])new Object[0]));
            }
            diffContent = contentFactory.createFromBytes(this.myProject, content2, fileRevision.getFile());
        } else {
            String content3 = fileRevision.getContent();
            if (content3 == null) {
                throw new VcsException(VcsBundle.message((String)"vcs.error.failed.to.load.file.content.from.vcs", (Object[])new Object[0]));
            }
            diffContent = contentFactory.create(this.myProject, content3, fileRevision.getFile());
        }
        diffContent.putUserData(DiffVcsDataKeys.REVISION_INFO, (Object)Pair.create((Object)fileRevision.getFile(), (Object)fileRevision.getRevisionNumber()));
        DocumentContent documentContent = diffContent;
        if (documentContent == null) {
            DiffActionExecutor.$$$reportNull$$$0(6);
        }
        return documentContent;
    }

    public void showDiff() {
        SimpleDiffRequestChain chain = SimpleDiffRequestChain.fromProducer((DiffRequestProducer)new MyDiffProducer());
        DiffManager.getInstance().showDiff(this.myProject, (DiffRequestChain)chain, DiffDialogHints.DEFAULT);
    }

    public static void showDiff(DiffProvider diffProvider, VcsRevisionNumber revisionNumber, VirtualFile selectedFile, Project project) {
        CompareToFixedExecutor executor = new CompareToFixedExecutor(diffProvider, selectedFile, project, null, revisionNumber);
        executor.showDiff();
    }

    @Nullable
    protected abstract ContentRevision getContentRevision();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileRevision";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/DiffActionExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/DiffActionExecutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRemote";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DeletionAwareExecutor
    extends DiffActionExecutor {
        private boolean myFileStillExists;

        public DeletionAwareExecutor(@NotNull DiffProvider diffProvider, @NotNull VirtualFile selectedFile, @NotNull Project project, @Nullable Editor editor2) {
            if (diffProvider == null) {
                DeletionAwareExecutor.$$$reportNull$$$0(0);
            }
            if (selectedFile == null) {
                DeletionAwareExecutor.$$$reportNull$$$0(1);
            }
            if (project == null) {
                DeletionAwareExecutor.$$$reportNull$$$0(2);
            }
            super(diffProvider, selectedFile, project, editor2);
        }

        @Override
        @Nullable
        protected ContentRevision getContentRevision() {
            ItemLatestState itemState = this.myDiffProvider.getLastRevision(this.mySelectedFile);
            if (itemState == null) {
                return null;
            }
            this.myFileStillExists = itemState.isItemExists();
            return this.myDiffProvider.createFileContent(itemState.getNumber(), this.mySelectedFile);
        }

        @Override
        @NotNull
        protected DiffContent createRemote(@NotNull ContentRevision fileRevision) throws IOException, VcsException {
            if (fileRevision == null) {
                DeletionAwareExecutor.$$$reportNull$$$0(3);
            }
            if (this.myFileStillExists) {
                DiffContent diffContent = super.createRemote(fileRevision);
                if (diffContent == null) {
                    DeletionAwareExecutor.$$$reportNull$$$0(4);
                }
                return diffContent;
            }
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            if (emptyContent == null) {
                DeletionAwareExecutor.$$$reportNull$$$0(5);
            }
            return emptyContent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diffProvider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileRevision";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/actions/DiffActionExecutor$DeletionAwareExecutor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/actions/DiffActionExecutor$DeletionAwareExecutor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRemote";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createRemote";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CompareToCurrentExecutor
    extends DiffActionExecutor {
        public CompareToCurrentExecutor(@NotNull DiffProvider diffProvider, @NotNull VirtualFile selectedFile, @NotNull Project project, @Nullable Editor editor2) {
            if (diffProvider == null) {
                CompareToCurrentExecutor.$$$reportNull$$$0(0);
            }
            if (selectedFile == null) {
                CompareToCurrentExecutor.$$$reportNull$$$0(1);
            }
            if (project == null) {
                CompareToCurrentExecutor.$$$reportNull$$$0(2);
            }
            super(diffProvider, selectedFile, project, editor2);
        }

        @Override
        @Nullable
        protected ContentRevision getContentRevision() {
            return this.myDiffProvider.createCurrentFileContent(this.mySelectedFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "diffProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectedFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/DiffActionExecutor$CompareToCurrentExecutor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CompareToFixedExecutor
    extends DiffActionExecutor {
        private final VcsRevisionNumber myNumber;

        public CompareToFixedExecutor(@NotNull DiffProvider diffProvider, @NotNull VirtualFile selectedFile, @NotNull Project project, @Nullable Editor editor2, @NotNull VcsRevisionNumber number) {
            if (diffProvider == null) {
                CompareToFixedExecutor.$$$reportNull$$$0(0);
            }
            if (selectedFile == null) {
                CompareToFixedExecutor.$$$reportNull$$$0(1);
            }
            if (project == null) {
                CompareToFixedExecutor.$$$reportNull$$$0(2);
            }
            if (number == null) {
                CompareToFixedExecutor.$$$reportNull$$$0(3);
            }
            super(diffProvider, selectedFile, project, editor2);
            this.myNumber = number;
        }

        @Override
        @Nullable
        protected ContentRevision getContentRevision() {
            return this.myDiffProvider.createFileContent(this.myNumber, this.mySelectedFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "diffProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectedFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "number";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/DiffActionExecutor$CompareToFixedExecutor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDiffProducer
    implements DiffRequestProducer {
        private final FilePath myFilePath;

        private MyDiffProducer() {
            this.myFilePath = VcsUtil.getFilePath((VirtualFile)DiffActionExecutor.this.mySelectedFile);
        }

        @NotNull
        public String getName() {
            String string = this.myFilePath.getPresentableUrl();
            if (string == null) {
                MyDiffProducer.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException {
            SimpleDiffRequest simpleDiffRequest;
            String title2;
            String title1;
            String title3;
            DiffContent content2;
            DiffContent content1;
            block12: {
                VcsRevisionNumber currentRevision;
                ContentRevision contentRevision;
                if (context2 == null) {
                    MyDiffProducer.$$$reportNull$$$0(1);
                }
                if (indicator2 == null) {
                    MyDiffProducer.$$$reportNull$$$0(2);
                }
                if ((contentRevision = DiffActionExecutor.this.getContentRevision()) == null) {
                    throw new DiffRequestProducerException(VcsBundle.message((String)"diff.producer.error.cant.get.revision.content", (Object[])new Object[0]));
                }
                content1 = DiffActionExecutor.this.createRemote(contentRevision);
                content2 = DiffContentFactory.getInstance().create(DiffActionExecutor.this.myProject, DiffActionExecutor.this.mySelectedFile);
                title3 = DiffRequestFactory.getInstance().getTitle(DiffActionExecutor.this.mySelectedFile);
                VcsRevisionNumber revisionNumber = contentRevision.getRevisionNumber();
                boolean inverted = false;
                FileStatus status = ChangeListManager.getInstance((Project)DiffActionExecutor.this.myProject).getStatus(DiffActionExecutor.this.mySelectedFile);
                boolean noLocalChanges = FileStatus.NOT_CHANGED.equals(status) || FileStatus.UNKNOWN.equals(status) || FileStatus.IGNORED.equals(status);
                VcsRevisionNumber vcsRevisionNumber = currentRevision = noLocalChanges ? DiffActionExecutor.this.myDiffProvider.getCurrentRevision(DiffActionExecutor.this.mySelectedFile) : null;
                if (currentRevision != null) {
                    inverted = revisionNumber.compareTo((Object)currentRevision) > 0;
                    title1 = revisionNumber.asString();
                    title2 = VcsBundle.message((String)"diff.title.local.with.number", (Object[])new Object[]{currentRevision.asString()});
                } else {
                    title1 = revisionNumber.asString();
                    title2 = VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]);
                }
                if (!inverted) break block12;
                SimpleDiffRequest request2 = new SimpleDiffRequest(title3, content2, content1, title2, title1);
                if (DiffActionExecutor.this.mySelectedLine != null) {
                    request2.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.LEFT, (Object)DiffActionExecutor.this.mySelectedLine));
                }
                request2.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.LEFT);
                SimpleDiffRequest simpleDiffRequest2 = request2;
                if (simpleDiffRequest2 == null) {
                    MyDiffProducer.$$$reportNull$$$0(3);
                }
                return simpleDiffRequest2;
            }
            try {
                SimpleDiffRequest request3 = new SimpleDiffRequest(title3, content1, content2, title1, title2);
                if (DiffActionExecutor.this.mySelectedLine != null) {
                    request3.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)DiffActionExecutor.this.mySelectedLine));
                }
                request3.putUserData(DiffUserDataKeys.MASTER_SIDE, (Object)Side.RIGHT);
                simpleDiffRequest = request3;
            }
            catch (VcsException | IOException e) {
                throw new DiffRequestProducerException(e);
            }
            if (simpleDiffRequest == null) {
                MyDiffProducer.$$$reportNull$$$0(4);
            }
            return simpleDiffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/actions/DiffActionExecutor$MyDiffProducer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/actions/DiffActionExecutor$MyDiffProducer";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

