/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.TextAnnotationPresentation;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.awt.Color;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class HistoryIdColumn
extends AnnotationFieldGutter {
    private final Map<VcsRevisionNumber, Integer> myHistoryIds;

    HistoryIdColumn(FileAnnotation annotation, TextAnnotationPresentation presentation2, Couple<Map<VcsRevisionNumber, Color>> colorScheme, Map<VcsRevisionNumber, Integer> ids) {
        super(annotation, presentation2, colorScheme);
        this.myHistoryIds = ids;
    }

    public String getLineText(int line, Editor editor2) {
        Integer num;
        if (!this.isAvailable()) {
            return "";
        }
        VcsRevisionNumber revisionNumber = this.myAnnotation.getLineRevisionNumber(line);
        if (revisionNumber != null && (num = this.myHistoryIds.get(revisionNumber)) != null) {
            String size = String.valueOf(this.myHistoryIds.size());
            Object value2 = num.toString();
            while (((String)value2).length() < size.length()) {
                value2 = " " + (String)value2;
            }
            return value2;
        }
        return "";
    }

    @Override
    public boolean isShowByDefault() {
        return false;
    }

    @Override
    public String getID() {
        return "Commit number";
    }

    @Override
    @NlsContexts.ListItem
    @Nullable
    public String getDisplayName() {
        return VcsBundle.message((String)"annotation.commit.number", (Object[])new Object[0]);
    }
}

