/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.codeInsight.hints.VcsCodeAuthorInlayHintsProviderKt;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.AnnotationsPreloader;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.CacheableAnnotationProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/annotate/AnnotationsPreloader;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "refreshSelectedFiles", "", "schedulePreloading", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "AnnotationsPreloaderFileEditorManagerListener", "Companion", "intellij.platform.vcs.impl"})
public final class AnnotationsPreloader {
    private final MergingUpdateQueue updateQueue;
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void schedulePreloading(@NotNull VirtualFile file2) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                if (this.project.isDisposed()) break block2;
                FileType fileType = file2.getFileType();
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"file.fileType");
                if (!fileType.isBinary()) break block3;
            }
            return;
        }
        this.updateQueue.queue((Update)new DisposableUpdate(this, file2, (Disposable)this.project, file2){
            final /* synthetic */ AnnotationsPreloader this$0;
            final /* synthetic */ VirtualFile $file;

            protected void doRun() {
                try {
                    Application app$iv;
                    long start2;
                    long l = start2 = AnnotationsPreloader.access$getLOG$cp().isDebugEnabled() ? System.currentTimeMillis() : 0L;
                    if (!FileEditorManager.getInstance((Project)AnnotationsPreloader.access$getProject$p(this.this$0)).isFileOpen(this.$file)) {
                        return;
                    }
                    FileStatus fileStatus = ChangeListManager.getInstance((Project)AnnotationsPreloader.access$getProject$p(this.this$0)).getStatus(this.$file);
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"ChangeListManager.getIns\u2026(project).getStatus(file)");
                    FileStatus fileStatus2 = fileStatus;
                    if (Intrinsics.areEqual((Object)fileStatus2, (Object)FileStatus.UNKNOWN) || Intrinsics.areEqual((Object)fileStatus2, (Object)FileStatus.ADDED) || Intrinsics.areEqual((Object)fileStatus2, (Object)FileStatus.IGNORED)) {
                        return;
                    }
                    AbstractVcs abstractVcs = ProjectLevelVcsManager.getInstance((Project)AnnotationsPreloader.access$getProject$p(this.this$0)).getVcsFor(this.$file);
                    if (abstractVcs == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)abstractVcs, (String)"ProjectLevelVcsManager.g\u2026getVcsFor(file) ?: return");
                    AbstractVcs vcs = abstractVcs;
                    AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
                    if (!(annotationProvider instanceof CacheableAnnotationProvider)) {
                        annotationProvider = null;
                    }
                    CacheableAnnotationProvider cacheableAnnotationProvider = (CacheableAnnotationProvider)annotationProvider;
                    if (cacheableAnnotationProvider == null) {
                        return;
                    }
                    CacheableAnnotationProvider annotationProvider2 = cacheableAnnotationProvider;
                    annotationProvider2.populateCache(this.$file);
                    Logger $this$debug$iv = AnnotationsPreloader.access$getLOG$cp();
                    Exception e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        Logger logger = $this$debug$iv;
                        boolean bl = false;
                        String string = "Preloaded VCS annotations for " + this.$file.getName() + " in " + (System.currentTimeMillis() - start2) + " ms";
                        logger.debug(string, (Throwable)e$iv);
                    }
                    ModalityState modalityState$iv = null;
                    boolean $i$f$runInEdt = false;
                    Application application = app$iv = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                    if (application.isDispatchThread()) {
                        boolean bl = false;
                        VcsCodeAuthorInlayHintsProviderKt.refreshCodeAuthorInlayHints(AnnotationsPreloader.access$getProject$p(this.this$0), this.$file);
                    } else {
                        boolean $i$f$invokeLater = false;
                        Application application2 = ApplicationManager.getApplication();
                        Runnable runnable2 = new Runnable(this){
                            final /* synthetic */ schedulePreloading.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void run() {
                                boolean bl = false;
                                VcsCodeAuthorInlayHintsProviderKt.refreshCodeAuthorInlayHints(AnnotationsPreloader.access$getProject$p(this.this$0.this$0), this.this$0.$file);
                            }
                        };
                        ModalityState modalityState = ModalityState.defaultModalityState();
                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                        application2.invokeLater(runnable2, modalityState);
                    }
                }
                catch (VcsException e) {
                    AnnotationsPreloader.access$getLOG$cp().info((Throwable)e);
                }
            }
            {
                this.this$0 = this$0;
                this.$file = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        });
    }

    private final void refreshSelectedFiles() {
        VirtualFile[] selectedFiles;
        if (!AnnotationsPreloader.Companion.isEnabled()) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
        VirtualFile[] virtualFileArray = selectedFiles = fileEditorManager.getSelectedFiles();
        int n = virtualFileArray.length;
        for (int j = 0; j < n; ++j) {
            VirtualFile file2;
            VirtualFile virtualFile2 = file2 = virtualFileArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file");
            this.schedulePreloading(virtualFile2);
        }
    }

    public AnnotationsPreloader(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.updateQueue = new MergingUpdateQueue("Annotations preloader queue", 1000, true, null, (Disposable)this.project, null, false);
        this.project.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)new VcsListener(){

            public final void directoryMappingChanged() {
                this.refreshSelectedFiles();
            }
        });
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AnnotationsPreloader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ Project access$getProject$p(AnnotationsPreloader $this) {
        return $this.project;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/annotate/AnnotationsPreloader$AnnotationsPreloaderFileEditorManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.platform.vcs.impl"})
    public static final class AnnotationsPreloaderFileEditorManagerListener
    implements FileEditorManagerListener {
        private final Project project;

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!Companion.isEnabled()) {
                return;
            }
            VirtualFile virtualFile2 = event.getNewFile();
            if (virtualFile2 == null) {
                return;
            }
            VirtualFile file2 = virtualFile2;
            Project $this$service$iv = this.project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(AnnotationsPreloader.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            ((AnnotationsPreloader)object).schedulePreloading(file2);
        }

        public AnnotationsPreloaderFileEditorManagerListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/annotate/AnnotationsPreloader$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isEnabled", "", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private final boolean isEnabled() {
            return (VcsCodeAuthorInlayHintsProviderKt.isCodeAuthorInlayHintsEnabled() || AdvancedSettings.Companion.getBoolean("vcs.annotations.preload")) && !PowerSaveMode.isEnabled();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

