/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.TreeDiffProvider;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesOnServerTracker;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RemoteRevisionsStateCache
implements ChangesOnServerTracker {
    private static final long DISCRETE = 3600000L;
    @NotNull
    private final Map<String, Pair<Boolean, VcsRoot>> myChanged;
    @NotNull
    private final MultiMap<VcsRoot, String> myQueries;
    @NotNull
    private final Map<VcsRoot, Long> myTs;
    @NotNull
    private final Object myLock;
    @NotNull
    private final Project myProject;

    RemoteRevisionsStateCache(@NotNull Project project) {
        if (project == null) {
            RemoteRevisionsStateCache.$$$reportNull$$$0(0);
        }
        this.myChanged = new HashMap<String, Pair<Boolean, VcsRoot>>();
        this.myQueries = new MultiMap();
        this.myTs = new HashMap<VcsRoot, Long>();
        this.myLock = new Object();
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Collection<String> paths2) {
        Object object = this.myLock;
        synchronized (object) {
            for (String path2 : paths2) {
                this.myChanged.remove(path2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUpToDate(@NotNull Change change, @NotNull AbstractVcs vcs) {
        if (change == null) {
            RemoteRevisionsStateCache.$$$reportNull$$$0(1);
        }
        if (vcs == null) {
            RemoteRevisionsStateCache.$$$reportNull$$$0(2);
        }
        if (!RemoteRevisionsStateCache.isSupportedFor(vcs)) {
            return true;
        }
        List files2 = ChangesUtil.getIoFilesFromChanges(Collections.singletonList(change));
        Object object = this.myLock;
        synchronized (object) {
            for (File file2 : files2) {
                String path2 = file2.getAbsolutePath();
                Pair<Boolean, VcsRoot> data2 = this.myChanged.get(path2);
                if (data2 == null || !Boolean.TRUE.equals(data2.getFirst())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeUpdated(@NotNull String path2, @NotNull AbstractVcs vcs) {
        if (path2 == null) {
            RemoteRevisionsStateCache.$$$reportNull$$$0(3);
        }
        if (vcs == null) {
            RemoteRevisionsStateCache.$$$reportNull$$$0(4);
        }
        if (!RemoteRevisionsStateCache.isSupportedFor(vcs)) {
            return;
        }
        VirtualFile root2 = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)VcsUtil.getFilePath((String)path2, (boolean)false));
        if (root2 == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myQueries.putValue((Object)new VcsRoot(vcs, root2), (Object)path2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeRemoved(@NotNull String path2, @NotNull AbstractVcs vcs) {
        if (path2 == null) {
            RemoteRevisionsStateCache.$$$reportNull$$$0(5);
        }
        if (vcs == null) {
            RemoteRevisionsStateCache.$$$reportNull$$$0(6);
        }
        if (!RemoteRevisionsStateCache.isSupportedFor(vcs)) {
            return;
        }
        VirtualFile root2 = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)VcsUtil.getFilePath((String)path2, (boolean)false));
        if (root2 == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            VcsRoot key = new VcsRoot(vcs, root2);
            if (this.myQueries.containsKey((Object)key)) {
                this.myQueries.remove((Object)key, (Object)path2);
            }
            this.myChanged.remove(path2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void directoryMappingChanged() {
        Object object = this.myLock;
        synchronized (object) {
            this.myChanged.clear();
            this.myTs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateStep() {
        MultiMap dirty = new MultiMap();
        int interval = VcsConfiguration.getInstance((Project)this.myProject).CHANGED_ON_SERVER_INTERVAL;
        long oldPoint = System.currentTimeMillis() - (interval > 0 ? (long)interval * 60000L : 3600000L);
        Object object = this.myLock;
        synchronized (object) {
            for (Object root2 : this.myQueries.keySet()) {
                Collection object2 = this.myQueries.get(root2);
                for (String s : object2) {
                    dirty.putValue(root2, (Object)s);
                }
            }
            this.myQueries.clear();
            HashSet<VcsRoot> roots2 = new HashSet<VcsRoot>();
            for (Map.Entry entry2 : this.myTs.entrySet()) {
                Long ts;
                if (!dirty.get((Object)((VcsRoot)entry2.getKey())).isEmpty() || (ts = (Long)entry2.getValue()) != null && oldPoint <= ts) continue;
                roots2.add((VcsRoot)entry2.getKey());
            }
            for (Map.Entry entry3 : this.myChanged.entrySet()) {
                VcsRoot vcsRoot = (VcsRoot)((Pair)entry3.getValue()).getSecond();
                if (dirty.get((Object)vcsRoot).isEmpty() && !roots2.contains(vcsRoot)) continue;
                dirty.putValue((Object)vcsRoot, (Object)((String)entry3.getKey()));
            }
        }
        if (dirty.isEmpty()) {
            return false;
        }
        HashMap<String, Pair> results = new HashMap<String, Pair>();
        for (VcsRoot vcsRoot : dirty.keySet()) {
            TreeDiffProvider treeDiffProvider;
            if (!vcsRoot.getVcs().isVcsBackgroundOperationsAllowed(vcsRoot.getPath()) || (treeDiffProvider = vcsRoot.getVcs().getTreeDiffProvider()) == null) continue;
            Collection paths2 = dirty.get((Object)vcsRoot);
            Collection remotelyChanged = treeDiffProvider.getRemotelyChanged(vcsRoot.getPath(), paths2);
            for (String path2 : paths2) {
                results.put(path2, new Pair((Object)remotelyChanged.contains(path2), (Object)vcsRoot));
            }
        }
        long curTime = System.currentTimeMillis();
        Object object2 = this.myLock;
        synchronized (object2) {
            this.myChanged.putAll(results);
            for (VcsRoot vcsRoot : dirty.keySet()) {
                this.myTs.put(vcsRoot, curTime);
            }
        }
        return true;
    }

    private static boolean isSupportedFor(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            RemoteRevisionsStateCache.$$$reportNull$$$0(7);
        }
        return vcs.getTreeDiffProvider() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/RemoteRevisionsStateCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isUpToDate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "changeUpdated";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "changeRemoved";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

