/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.FileHolderComposite;
import com.intellij.openapi.vcs.changes.FoldersCutDownWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.SwitchedFileHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

final class UpdatingChangeListBuilder
implements ChangelistBuilder {
    private static final Logger LOG = Logger.getInstance(UpdatingChangeListBuilder.class);
    private final ChangeListWorker.ChangeListUpdater myChangeListUpdater;
    private final FileHolderComposite myComposite;
    private final Supplier<Boolean> myDisposedGetter;
    private final ProjectLevelVcsManager myVcsManager;
    private VcsDirtyScope myScope;
    private FoldersCutDownWorker myFoldersCutDownWorker;
    private Factory<JComponent> myAdditionalInfo;

    UpdatingChangeListBuilder(ChangeListWorker.ChangeListUpdater changeListUpdater, FileHolderComposite composite2, Supplier<Boolean> disposedGetter) {
        this.myChangeListUpdater = changeListUpdater;
        this.myComposite = composite2;
        this.myDisposedGetter = disposedGetter;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)changeListUpdater.getProject());
    }

    private void checkIfDisposed() {
        if (this.myDisposedGetter.get().booleanValue()) {
            throw new ProcessCanceledException();
        }
    }

    public void setCurrent(VcsDirtyScope scope2) {
        this.myScope = scope2;
        this.myFoldersCutDownWorker = new FoldersCutDownWorker();
    }

    public void processChange(Change change, VcsKey vcsKey) {
        this.processChangeInList(change, (ChangeList)null, vcsKey);
    }

    public void processChangeInList(Change change, @Nullable ChangeList changeList, VcsKey vcsKey) {
        this.checkIfDisposed();
        LOG.debug("[processChangeInList-1] entering, cl name: " + (changeList == null ? null : changeList.getName()) + " change: " + ChangesUtil.getFilePath((Change)change).getPath());
        String fileName = ChangesUtil.getFilePath((Change)change).getName();
        if (FileTypeManager.getInstance().isFileIgnored(fileName)) {
            LOG.debug("[processChangeInList-1] file type ignored");
            return;
        }
        if (ChangeListManagerImpl.isUnder(change, this.myScope)) {
            AbstractVcs vcs;
            AbstractVcs abstractVcs = vcs = vcsKey != null ? this.myVcsManager.findVcsByName(vcsKey.getName()) : null;
            if (changeList != null) {
                LOG.debug("[processChangeInList-1] to add change to cl");
                this.myChangeListUpdater.addChangeToList(changeList.getName(), change, vcs);
            } else {
                LOG.debug("[processChangeInList-1] to add to corresponding list");
                this.myChangeListUpdater.addChangeToCorrespondingList(change, vcs);
            }
        } else {
            LOG.debug("[processChangeInList-1] not under scope");
        }
    }

    public void processChangeInList(Change change, String changeListName, VcsKey vcsKey) {
        this.checkIfDisposed();
        LocalChangeList list2 = null;
        if (changeListName != null) {
            list2 = this.myChangeListUpdater.findOrCreateList(changeListName, null);
        }
        this.processChangeInList(change, (ChangeList)list2, vcsKey);
    }

    public void removeRegisteredChangeFor(FilePath path2) {
        this.myChangeListUpdater.removeRegisteredChangeFor(path2);
    }

    public void processUnversionedFile(FilePath filePath) {
        if (this.acceptFilePath(filePath, false)) {
            VirtualFile file2;
            this.myComposite.getUnversionedFileHolder().addFile(this.myScope.getVcs(), filePath);
            SwitchedFileHolder switchedFileHolder = this.myComposite.getSwitchedFileHolder();
            if (!switchedFileHolder.isEmpty() && (file2 = filePath.getVirtualFile()) != null) {
                switchedFileHolder.removeFile(file2);
            }
        }
    }

    public void processLocallyDeletedFile(FilePath file2) {
        this.processLocallyDeletedFile(new LocallyDeletedChange(file2));
    }

    public void processLocallyDeletedFile(LocallyDeletedChange locallyDeletedChange) {
        this.checkIfDisposed();
        FilePath file2 = locallyDeletedChange.getPath();
        if (FileTypeManager.getInstance().isFileIgnored(file2.getName())) {
            return;
        }
        if (this.myScope.belongsTo(file2)) {
            this.myComposite.getDeletedFileHolder().addFile(locallyDeletedChange);
        }
    }

    public void processModifiedWithoutCheckout(VirtualFile file2) {
        if (this.acceptFile(file2, false)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("processModifiedWithoutCheckout " + file2);
            }
            this.myComposite.getModifiedWithoutEditingFileHolder().addFile(file2);
        }
    }

    public void processIgnoredFile(FilePath filePath) {
        if (this.acceptFilePath(filePath, false)) {
            this.myComposite.getIgnoredFileHolder().addFile(this.myScope.getVcs(), filePath);
        }
    }

    public void processLockedFolder(VirtualFile file2) {
        if (this.acceptFile(file2, true) && this.myFoldersCutDownWorker.addCurrent(file2)) {
            this.myComposite.getLockedFileHolder().addFile(file2);
        }
    }

    public void processLogicallyLockedFolder(VirtualFile file2, LogicalLock logicalLock) {
        if (this.acceptFile(file2, true)) {
            this.myComposite.getLogicallyLockedFileHolder().add(file2, logicalLock);
        }
    }

    public void processSwitchedFile(VirtualFile file2, String branch, boolean recursive) {
        if (this.acceptFile(file2, false)) {
            this.myComposite.getSwitchedFileHolder().addFile(file2, branch, recursive);
        }
    }

    public void processRootSwitch(VirtualFile file2, String branch) {
        if (this.acceptFile(file2, true)) {
            this.myComposite.getRootSwitchFileHolder().addFile(file2, branch, false);
        }
    }

    public boolean reportChangesOutsideProject() {
        return false;
    }

    public void reportAdditionalInfo(@NlsContexts.Label String text2) {
        this.reportAdditionalInfo(ChangesViewManager.createTextStatusFactory(text2, true));
    }

    public void reportAdditionalInfo(Factory<JComponent> infoComponent) {
        if (this.myAdditionalInfo == null) {
            this.myAdditionalInfo = infoComponent;
        }
    }

    public Factory<JComponent> getAdditionalInfo() {
        return this.myAdditionalInfo;
    }

    private boolean acceptFile(@Nullable VirtualFile file2, boolean allowIgnored) {
        this.checkIfDisposed();
        if (file2 == null) {
            return false;
        }
        if (!allowIgnored && ((Boolean)ReadAction.compute(() -> this.myVcsManager.isIgnored(file2))).booleanValue()) {
            return false;
        }
        return this.myScope.belongsTo(VcsUtil.getFilePath((VirtualFile)file2));
    }

    private boolean acceptFilePath(@Nullable FilePath filePath, boolean allowIgnored) {
        this.checkIfDisposed();
        if (filePath == null) {
            return false;
        }
        if (!allowIgnored && ((Boolean)ReadAction.compute(() -> this.myVcsManager.isIgnored(filePath))).booleanValue()) {
            return false;
        }
        return this.myScope.belongsTo(filePath);
    }
}

