/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsMappingListener;
import com.intellij.openapi.vcs.changes.VcsIgnoreFilesChecker;
import com.intellij.openapi.vcs.changes.VcsIgnoreFilesCheckerKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0013\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f*\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsIgnoreFilesChecker;", "Lcom/intellij/openapi/vcs/VcsMappingListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "directoryMappingChanged", "", "generateVcsIgnoreFileInRootIfNeeded", "getProjectConfigDirOrProjectFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "intellij.platform.vcs.impl"})
public final class VcsIgnoreFilesChecker
implements VcsMappingListener {
    @NotNull
    private final Project project;

    public void directoryMappingChanged() {
        ProjectLevelVcsManager.getInstance((Project)this.project).runAfterInitialization(new Runnable(this){
            final /* synthetic */ VcsIgnoreFilesChecker this$0;

            public final void run() {
                BackgroundTaskUtil.executeOnPooledThread((Disposable)this.this$0.getProject(), new Runnable(this){
                    final /* synthetic */ directoryMappingChanged.1 this$0;

                    public final void run() {
                        VcsIgnoreFilesChecker.access$generateVcsIgnoreFileInRootIfNeeded(this.this$0.this$0, this.this$0.this$0.getProject());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = vcsIgnoreFilesChecker;
            }
        });
    }

    private final void generateVcsIgnoreFileInRootIfNeeded(Project project) {
        if (project.isDisposed()) {
            return;
        }
        VirtualFile virtualFile2 = this.getProjectConfigDirOrProjectFile(project);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile projectFile = virtualFile2;
        VirtualFile virtualFile3 = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)projectFile);
        if (virtualFile3 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"VcsUtil.getVcsRootFor(pr\u2026t, projectFile) ?: return");
        VirtualFile projectFileVcsRoot = virtualFile3;
        AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)project, (VirtualFile)projectFileVcsRoot);
        if (abstractVcs == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcs, (String)"VcsUtil.getVcsFor(projec\u2026ectFileVcsRoot) ?: return");
        AbstractVcs vcs = abstractVcs;
        VcsIgnoreFilesCheckerKt.access$getLOG$p().debug("Propose manage VCS ignore in " + projectFileVcsRoot.getPath() + " for vcs " + vcs.getName());
        VcsImplUtil.proposeUpdateIgnoreFile(project, vcs, projectFileVcsRoot);
    }

    private final VirtualFile getProjectConfigDirOrProjectFile(Project $this$getProjectConfigDirOrProjectFile) {
        VirtualFile virtualFile2;
        if (ProjectKt.isDirectoryBased($this$getProjectConfigDirOrProjectFile)) {
            Path path2 = ProjectKt.getStateStore($this$getProjectConfigDirOrProjectFile).getDirectoryStorePath();
            if (path2 != null) {
                Path path3 = path2;
                LocalFileSystem localFileSystem2 = LocalFileSystem.getInstance();
                boolean bl = false;
                boolean bl2 = false;
                Path p1 = path3;
                boolean bl3 = false;
                virtualFile2 = localFileSystem2.findFileByNioFile(p1);
            } else {
                virtualFile2 = null;
            }
        } else {
            virtualFile2 = $this$getProjectConfigDirOrProjectFile.getProjectFile();
        }
        return virtualFile2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public VcsIgnoreFilesChecker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public static final /* synthetic */ void access$generateVcsIgnoreFileInRootIfNeeded(VcsIgnoreFilesChecker $this, Project project) {
        $this.generateVcsIgnoreFileInRootIfNeeded(project);
    }
}

