/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.Ignored;
import com.intellij.openapi.vcs.IgnoredCheckResult;
import com.intellij.openapi.vcs.NotIgnored;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsIgnoreChecker;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.io.PathKt;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0004H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "RUN_CONFIGURATIONS_DIRECTORY", "", "checkConfigurationVcsIgnored", "Lcom/intellij/openapi/vcs/IgnoredCheckResult;", "project", "Lcom/intellij/openapi/project/Project;", "configurationFileName", "checkProjectNotDefault", "", "configurationNameToFileName", "configurationName", "getCheckerForFile", "Lcom/intellij/openapi/vcs/VcsIgnoreChecker;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "removeConfigurationFromVcsIgnore", "intellij.platform.vcs.impl"})
public final class VcsIgnoreManagerImplKt {
    private static final Logger LOG;
    private static final String RUN_CONFIGURATIONS_DIRECTORY = "runConfigurations";

    private static final void removeConfigurationFromVcsIgnore(Project project, String configurationName) {
        VirtualFile virtualFile2;
        if (ProjectKt.isDirectoryBased(project)) {
            Path path2 = ProjectKt.getStateStore(project).getDirectoryStorePath();
            Intrinsics.checkNotNull((Object)path2);
            VirtualFile virtualFile3 = VfsUtil.findFile((Path)path2, (boolean)true);
            virtualFile2 = virtualFile3;
            Intrinsics.checkNotNull((Object)virtualFile3);
        } else {
            VirtualFile virtualFile4 = project.getProjectFile();
            virtualFile2 = virtualFile4;
            Intrinsics.checkNotNull((Object)virtualFile4);
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"if (project.isDirectoryB\u2026oject.projectFile!!\n    }");
        VirtualFile projectFileOrConfigDir = virtualFile2;
        VirtualFile virtualFile5 = VcsUtil.getVcsRootFor((Project)project, (VirtualFile)projectFileOrConfigDir);
        if (virtualFile5 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile5, (String)"VcsUtil.getVcsRootFor(pr\u2026ileOrConfigDir) ?: return");
        VirtualFile projectVcsRoot = virtualFile5;
        AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (VirtualFile)projectVcsRoot);
        if (vcs == null) {
            LOG.debug("Cannot get VCS for root " + projectVcsRoot.getPath());
            return;
        }
        IgnoredFileContentProvider ignoreContentProvider = VcsImplUtil.findIgnoredFileContentProvider(vcs);
        if (ignoreContentProvider == null) {
            LOG.debug("Cannot get ignore content provider for vcs " + vcs.getName());
            return;
        }
        IgnoredCheckResult checkResult = VcsIgnoreManagerImplKt.checkConfigurationVcsIgnored(project, configurationName);
        if (checkResult instanceof Ignored) {
            File ignoreFile = ((Ignored)checkResult).getIgnoreFile();
            FileUtil.appendToFile((File)ignoreFile, (String)ignoreContentProvider.buildUnignoreContent(((Ignored)checkResult).getMatchedPattern()));
        }
    }

    private static final IgnoredCheckResult checkConfigurationVcsIgnored(Project project, String configurationFileName) {
        IProjectStore stateStore = ProjectKt.getStateStore(project);
        Path dotIdea = stateStore.getDirectoryStorePath();
        if (dotIdea != null) {
            FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePath(dotIdea, true);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsContextFactory.SERVIC\u2026teFilePath(dotIdea, true)");
            FilePath dotIdeaVcsPath = filePath;
            VirtualFile virtualFile2 = VcsUtil.getVcsRootFor((Project)project, (FilePath)dotIdeaVcsPath);
            if (virtualFile2 == null) {
                return (IgnoredCheckResult)NotIgnored.INSTANCE;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"VcsUtil.getVcsRootFor(pr\u2026ath) ?: return NotIgnored");
            VirtualFile vcsRootForIgnore = virtualFile2;
            String filePattern = PathKt.getSystemIndependentPath((Path)dotIdea) + "/runConfigurations/" + configurationFileName + "*.xml";
            VcsIgnoreChecker vcsIgnoreChecker = VcsIgnoreManagerImplKt.getCheckerForFile(project, dotIdeaVcsPath);
            if (vcsIgnoreChecker == null || (vcsIgnoreChecker = vcsIgnoreChecker.isFilePatternIgnored(vcsRootForIgnore, filePattern)) == null) {
                vcsIgnoreChecker = (IgnoredCheckResult)NotIgnored.INSTANCE;
            }
            return vcsIgnoreChecker;
        }
        Path path2 = stateStore.getProjectFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"stateStore.projectFilePath");
        Path projectFile = path2;
        FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePath(projectFile, false);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsContextFactory.SERVIC\u2026ePath(projectFile, false)");
        FilePath projectFileVcsPath = filePath;
        VirtualFile virtualFile3 = VcsUtil.getVcsRootFor((Project)project, (FilePath)projectFileVcsPath);
        if (virtualFile3 == null) {
            return (IgnoredCheckResult)NotIgnored.INSTANCE;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"VcsUtil.getVcsRootFor(pr\u2026ath) ?: return NotIgnored");
        VirtualFile vcsRootForIgnore = virtualFile3;
        VcsIgnoreChecker vcsIgnoreChecker = VcsIgnoreManagerImplKt.getCheckerForFile(project, projectFileVcsPath);
        if (vcsIgnoreChecker == null || (vcsIgnoreChecker = vcsIgnoreChecker.isIgnored(vcsRootForIgnore, projectFile)) == null) {
            vcsIgnoreChecker = (IgnoredCheckResult)NotIgnored.INSTANCE;
        }
        return vcsIgnoreChecker;
    }

    private static final VcsIgnoreChecker getCheckerForFile(Project project, FilePath filePath) {
        AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)project, (FilePath)filePath);
        if (abstractVcs == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcs, (String)"VcsUtil.getVcsFor(projec\u2026 filePath) ?: return null");
        AbstractVcs vcs = abstractVcs;
        return (VcsIgnoreChecker)VcsIgnoreManagerImpl.Companion.getEP_NAME().findFirstSafe(new Predicate(vcs){
            final /* synthetic */ AbstractVcs $vcs;

            public final boolean test(VcsIgnoreChecker checker) {
                VcsIgnoreChecker vcsIgnoreChecker = checker;
                Intrinsics.checkNotNullExpressionValue((Object)vcsIgnoreChecker, (String)"checker");
                return Intrinsics.areEqual((Object)vcsIgnoreChecker.getSupportedVcs(), (Object)this.$vcs.getKeyInstanceMethod());
            }
            {
                this.$vcs = abstractVcs;
            }
        });
    }

    private static final String configurationNameToFileName(String configurationName) {
        return (String)Scheme_implKt.getOLD_NAME_CONVERTER().invoke((Object)configurationName);
    }

    private static final void checkProjectNotDefault(Project project) {
        if (project.isDefault()) {
            throw (Throwable)new UnsupportedOperationException(VcsBundle.message((String)"changes.error.default.project.not.supported", (Object[])new Object[0]));
        }
    }

    static {
        Logger logger = Logger.getInstance(VcsIgnoreManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(VcsIg\u2026eManagerImpl::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ VcsIgnoreChecker access$getCheckerForFile(Project project, FilePath filePath) {
        return VcsIgnoreManagerImplKt.getCheckerForFile(project, filePath);
    }

    public static final /* synthetic */ String access$configurationNameToFileName(String configurationName) {
        return VcsIgnoreManagerImplKt.configurationNameToFileName(configurationName);
    }

    public static final /* synthetic */ IgnoredCheckResult access$checkConfigurationVcsIgnored(Project project, String configurationFileName) {
        return VcsIgnoreManagerImplKt.checkConfigurationVcsIgnored(project, configurationFileName);
    }

    public static final /* synthetic */ void access$removeConfigurationFromVcsIgnore(Project project, String configurationName) {
        VcsIgnoreManagerImplKt.removeConfigurationFromVcsIgnore(project, configurationName);
    }

    public static final /* synthetic */ void access$checkProjectNotDefault(Project project) {
        VcsIgnoreManagerImplKt.checkProjectNotDefault(project);
    }
}

