/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff.lst;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangeListDiffRequest
extends ContentDiffRequest {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final String myChangelistId;
    @NotNull
    @NlsSafe
    private final String myChangelistName;
    @NotNull
    private final ContentDiffRequest myRequest;
    private int myAssignments;
    private boolean myInstalled;

    public LocalChangeListDiffRequest(@NotNull Project project, @NotNull VirtualFile virtualFile2, @NotNull String changelistId, @NotNull String changelistName, @NotNull ContentDiffRequest request2) {
        if (project == null) {
            LocalChangeListDiffRequest.$$$reportNull$$$0(0);
        }
        if (virtualFile2 == null) {
            LocalChangeListDiffRequest.$$$reportNull$$$0(1);
        }
        if (changelistId == null) {
            LocalChangeListDiffRequest.$$$reportNull$$$0(2);
        }
        if (changelistName == null) {
            LocalChangeListDiffRequest.$$$reportNull$$$0(3);
        }
        if (request2 == null) {
            LocalChangeListDiffRequest.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myVirtualFile = virtualFile2;
        this.myChangelistId = changelistId;
        this.myChangelistName = changelistName;
        this.myRequest = request2;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            LocalChangeListDiffRequest.$$$reportNull$$$0(5);
        }
        return project;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile2 = this.myVirtualFile;
        if (virtualFile2 == null) {
            LocalChangeListDiffRequest.$$$reportNull$$$0(6);
        }
        return virtualFile2;
    }

    @NotNull
    public String getChangelistId() {
        String string = this.myChangelistId;
        if (string == null) {
            LocalChangeListDiffRequest.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getChangelistName() {
        String string = this.myChangelistName;
        if (string == null) {
            LocalChangeListDiffRequest.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public ContentDiffRequest getRequest() {
        ContentDiffRequest contentDiffRequest = this.myRequest;
        if (contentDiffRequest == null) {
            LocalChangeListDiffRequest.$$$reportNull$$$0(9);
        }
        return contentDiffRequest;
    }

    @Nullable
    public LineStatusTracker getLineStatusTracker() {
        return LineStatusTrackerManager.getInstance(this.myProject).getLineStatusTracker(this.myVirtualFile);
    }

    @NlsContexts.DialogTitle
    @Nullable
    public String getTitle() {
        return VcsBundle.message((String)"change.dialog.title.change.list.name", (Object[])new Object[]{this.myRequest.getTitle(), this.myChangelistName});
    }

    @NotNull
    public List<DiffContent> getContents() {
        List list2 = this.myRequest.getContents();
        if (list2 == null) {
            LocalChangeListDiffRequest.$$$reportNull$$$0(10);
        }
        return list2;
    }

    public @NotNull List<@Nls String> getContentTitles() {
        List titles = this.myRequest.getContentTitles();
        String title1 = (String)titles.get(0);
        String title2 = (String)titles.get(1);
        String ourTitle2 = title2 != null ? VcsBundle.message((String)"change.dialog.title.in.change.list.name", (Object[])new Object[]{title2, this.myChangelistName}) : null;
        List<String> list2 = Arrays.asList(title1, ourTitle2);
        if (list2 == null) {
            LocalChangeListDiffRequest.$$$reportNull$$$0(11);
        }
        return list2;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            LocalChangeListDiffRequest.$$$reportNull$$$0(12);
        }
        return (T)this.myRequest.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            LocalChangeListDiffRequest.$$$reportNull$$$0(13);
        }
        this.myRequest.putUserData(key, value2);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void onAssigned(boolean bl) {
        void isAssigned;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myRequest.onAssigned((boolean)isAssigned);
        if (isAssigned != false) {
            if (!this.myInstalled) {
                this.myInstalled = this.installTracker();
            }
            ++this.myAssignments;
        } else {
            if (this.myAssignments == 1 && this.myInstalled) {
                this.releaseTracker();
                this.myInstalled = false;
            }
            --this.myAssignments;
        }
        assert (this.myAssignments >= 0);
    }

    private boolean installTracker() {
        Document document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
        if (document == null) {
            return false;
        }
        LineStatusTrackerManager.getInstance(this.myProject).requestTrackerFor(document, (Object)this);
        DocumentContent beforeContent = (DocumentContent)this.getContents().get(0);
        CharSequence beforeText = beforeContent.getDocument().getImmutableCharSequence();
        LineStatusTrackerManager.getInstanceImpl(this.myProject).offerTrackerContent(document, beforeText);
        return true;
    }

    private void releaseTracker() {
        Document document = FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile);
        if (document == null) {
            return;
        }
        LineStatusTrackerManager.getInstance(this.myProject).releaseTrackerFor(document, (Object)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changelistId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changelistName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/lst/LocalChangeListDiffRequest";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/lst/LocalChangeListDiffRequest";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangelistId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangelistName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequest";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentTitles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

