/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.changes.ignore.cache.IgnorePatternsMatchedFilesCache;
import com.intellij.openapi.vcs.changes.ignore.cache.PatternCache;
import com.intellij.openapi.vcs.changes.ignore.util.RegexUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002Rf\u0010\u0005\u001aZ\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t \b*,\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/cache/IgnorePatternsMatchedFilesCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "dispose", "", "doSearch", "", "pattern", "Ljava/util/regex/Pattern;", "getFilesForPattern", "runSearchRequest", "key", "Companion", "intellij.platform.vcs.impl"})
public final class IgnorePatternsMatchedFilesCache
implements Disposable {
    private final ProjectFileIndex projectFileIndex;
    private final Cache<String, Collection<VirtualFile>> cache;
    private final MergingUpdateQueue updateQueue;
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void dispose() {
        this.cache.invalidateAll();
        this.updateQueue.cancelAllUpdates();
    }

    @NotNull
    public final Collection<VirtualFile> getFilesForPattern(@NotNull Pattern pattern) {
        Collection files2;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string = pattern.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pattern.toString()");
        String key = string;
        Collection collection = (Collection)this.cache.getIfPresent((Object)key);
        if (collection == null) {
            collection = files2 = (Collection)CollectionsKt.emptyList();
        }
        if (files2.isEmpty()) {
            this.runSearchRequest(key, pattern);
        }
        return files2;
    }

    private final void runSearchRequest(String key, Pattern pattern) {
        this.updateQueue.queue((Update)new DisposableUpdate(this, key, pattern, (Disposable)this.project, key){
            final /* synthetic */ IgnorePatternsMatchedFilesCache this$0;
            final /* synthetic */ String $key;
            final /* synthetic */ Pattern $pattern;

            public boolean canEat(@NotNull Update update2) {
                Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
                return true;
            }

            protected void doRun() {
                IgnorePatternsMatchedFilesCache.access$getCache$p(this.this$0).put((Object)this.$key, (Object)IgnorePatternsMatchedFilesCache.access$doSearch(this.this$0, this.$pattern));
            }
            {
                this.this$0 = this$0;
                this.$key = $captured_local_variable$1;
                this.$pattern = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        });
    }

    private final Set<VirtualFile> doSearch(Pattern pattern) {
        HashSet files2 = new HashSet(1000);
        String[] parts = RegexUtil.getParts(pattern);
        Intrinsics.checkNotNullExpressionValue((Object)parts, (String)"parts");
        String[] stringArray = parts;
        boolean bl = false;
        if (stringArray.length == 0) {
            return files2;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.projectScope(project)");
        GlobalSearchScope projectScope = globalSearchScope;
        this.projectFileIndex.iterateContent(new ContentIterator(parts, projectScope, files2){
            final /* synthetic */ String[] $parts;
            final /* synthetic */ GlobalSearchScope $projectScope;
            final /* synthetic */ HashSet $files;

            public final boolean processFile(@NotNull VirtualFile fileOrDir) {
                Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                ProgressManager.checkCanceled();
                String string = fileOrDir.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileOrDir.name");
                String name2 = string;
                if (RegexUtil.matchAnyPart(this.$parts, name2)) {
                    boolean $i$f$runReadAction = false;
                    Iterator<E> iterator2 = ((Collection)ApplicationManager.getApplication().runReadAction(new Computable(this, name2){
                        final /* synthetic */ doSearch.1 this$0;
                        final /* synthetic */ String $name$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$name$inlined = string;
                        }

                        public final T compute() {
                            boolean bl = false;
                            return (T)FilenameIndex.getVirtualFilesByName((String)this.$name$inlined, (GlobalSearchScope)this.this$0.$projectScope);
                        }
                    })).iterator();
                    while (iterator2.hasNext()) {
                        VirtualFile file2;
                        VirtualFile virtualFile2 = file2 = (VirtualFile)iterator2.next();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file");
                        if (!virtualFile2.isValid() || !RegexUtil.matchAllParts(this.$parts, file2.getPath())) continue;
                        this.$files.add(file2);
                    }
                }
                return true;
            }
            {
                this.$parts = stringArray;
                this.$projectScope = globalSearchScope;
                this.$files = hashSet;
            }
        });
        return files2;
    }

    public IgnorePatternsMatchedFilesCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
        this.projectFileIndex = projectFileIndex;
        this.cache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
        this.updateQueue = new MergingUpdateQueue("IgnorePatternsMatchedFilesCacheUpdateQueue", 500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                if (cache.estimatedSize() == 0L) {
                    return;
                }
                for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileDeleteEvent || vFileEvent instanceof VFileCopyEvent) {
                        String string = vFileEvent.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.path");
                        this.cleanupCache(string);
                        continue;
                    }
                    if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).isRename()) {
                        String string = ((VFilePropertyChangeEvent)vFileEvent).getOldPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.oldPath");
                        this.cleanupCache(string);
                        String string2 = ((VFilePropertyChangeEvent)vFileEvent).getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.path");
                        this.cleanupCache(string2);
                        continue;
                    }
                    if (!(vFileEvent instanceof VFileMoveEvent)) continue;
                    String string = ((VFileMoveEvent)vFileEvent).getOldPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.oldPath");
                    this.cleanupCache(string);
                    String string3 = ((VFileMoveEvent)vFileEvent).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"event.path");
                    this.cleanupCache(string3);
                }
            }

            private final void cleanupCache(String path2) {
                ConcurrentMap cacheMap = cache.asMap();
                PatternCache globCache = PatternCache.getInstance(project);
                for (String key : cacheMap.keySet()) {
                    Pattern pattern;
                    if (globCache.getPattern(key) == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"globCache.getPattern(key) ?: continue");
                    String[] parts = RegexUtil.getParts(pattern);
                    if (!RegexUtil.matchAnyPart(parts, path2)) continue;
                    cacheMap.remove(key);
                }
            }
        });
    }

    public static final /* synthetic */ Set access$doSearch(IgnorePatternsMatchedFilesCache $this, Pattern pattern) {
        return $this.doSearch(pattern);
    }

    @JvmStatic
    @NotNull
    public static final IgnorePatternsMatchedFilesCache getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/cache/IgnorePatternsMatchedFilesCache$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/vcs/changes/ignore/cache/IgnorePatternsMatchedFilesCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IgnorePatternsMatchedFilesCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(IgnorePatternsMatchedFilesCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Ignor\u2026edFilesCache::class.java)");
            return (IgnorePatternsMatchedFilesCache)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

