/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeLinkMouseListener
extends LinkMouseListenerBase {
    private final ColoredTreeCellRenderer myRenderer;
    protected WeakReference<TreeNode> myLastHitNode;

    public TreeLinkMouseListener(ColoredTreeCellRenderer renderer2) {
        this.myRenderer = renderer2;
    }

    protected void showTooltip(JTree tree, MouseEvent e, HaveTooltip launcher) {
        String newText;
        String text2 = tree.getToolTipText(e);
        String string = newText = launcher == null ? null : launcher.getTooltip();
        if (!Objects.equals(text2, newText)) {
            tree.setToolTipText(newText);
        }
    }

    @Nullable
    protected Object getTagAt(@NotNull MouseEvent e) {
        if (e == null) {
            TreeLinkMouseListener.$$$reportNull$$$0(0);
        }
        JTree tree = (JTree)e.getSource();
        Object tag2 = null;
        HaveTooltip haveTooltip = null;
        TreePath path2 = tree.getPathForLocation(e.getX(), e.getY());
        if (path2 != null) {
            int dx = this.getRendererRelativeX(e, tree, path2);
            TreeNode treeNode2 = (TreeNode)path2.getLastPathComponent();
            AppUIUtil.targetToDevice((Component)this.myRenderer, tree);
            if (this.myLastHitNode == null || this.myLastHitNode.get() != treeNode2 || e.getButton() != 0) {
                if (this.doCacheLastNode()) {
                    this.myLastHitNode = new WeakReference<TreeNode>(treeNode2);
                }
                this.myRenderer.getTreeCellRendererComponent(tree, (Object)treeNode2, false, false, treeNode2.isLeaf(), tree.getRowForPath(path2), false);
            }
            if ((tag2 = this.myRenderer.getFragmentTagAt(dx)) != null && treeNode2 instanceof HaveTooltip) {
                haveTooltip = (HaveTooltip)((Object)treeNode2);
            }
        }
        this.showTooltip(tree, e, haveTooltip);
        return tag2;
    }

    protected int getRendererRelativeX(@NotNull MouseEvent e, @NotNull JTree tree, @NotNull TreePath path2) {
        if (e == null) {
            TreeLinkMouseListener.$$$reportNull$$$0(1);
        }
        if (tree == null) {
            TreeLinkMouseListener.$$$reportNull$$$0(2);
        }
        if (path2 == null) {
            TreeLinkMouseListener.$$$reportNull$$$0(3);
        }
        Rectangle rectangle = tree.getPathBounds(path2);
        assert (rectangle != null);
        return e.getX() - rectangle.x;
    }

    protected boolean doCacheLastNode() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/issueLinks/TreeLinkMouseListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagAt";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRendererRelativeX";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface HaveTooltip {
        @NlsContexts.Tooltip
        public String getTooltip();
    }
}

