/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.DiffManager;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.ImportToShelfExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplyPatchAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(ApplyPatchAction.class);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ApplyPatchAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            e.getPresentation().setEnabledAndVisible(project != null && PatchFileType.isPatchFile(vFile));
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(project != null);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ApplyPatchAction.$$$reportNull$$$0(1);
        }
        if (ChangeListManager.getInstance((Project)(project = (Project)e.getRequiredData(CommonDataKeys.PROJECT))).isFreezedWithNotification(VcsBundle.message((String)"patch.apply.cannot.apply.now", (Object[])new Object[0]))) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile vFile = null;
        String place = e.getPlace();
        if (ActionPlaces.isPopupPlace((String)e.getPlace()) || "MainMenu".equals(place)) {
            vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        }
        if (PatchFileType.isPatchFile(vFile)) {
            ApplyPatchAction.showApplyPatch(project, vFile);
        } else {
            FileChooserDescriptor descriptor2 = ApplyPatchDifferentiatedDialog.createSelectPatchDescriptor();
            VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
            VirtualFile toSelect2 = settings.PATCH_STORAGE_LOCATION == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(settings.PATCH_STORAGE_LOCATION));
            FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)project, (VirtualFile)toSelect2, file2 -> {
                VirtualFile parent = file2.getParent();
                if (parent != null) {
                    settings.PATCH_STORAGE_LOCATION = parent.getPath();
                }
                ApplyPatchAction.showApplyPatch(project, file2);
            });
        }
    }

    public static void showApplyPatch(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            ApplyPatchAction.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(3);
        }
        ApplyPatchDifferentiatedDialog dialog2 = new ApplyPatchDifferentiatedDialog(project, new ApplyPatchDefaultExecutor(project), Collections.singletonList(new ImportToShelfExecutor(project)), ApplyPatchMode.APPLY, file2);
        dialog2.show();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static Boolean showAndGetApplyPatch(@NotNull Project project, @NotNull File file2) {
        void file3;
        Project project2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(4);
        }
        if (file3 == null) {
            ApplyPatchAction.$$$reportNull$$$0(5);
        }
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file3, (boolean)true);
        String patchPath = file3.getPath();
        if (vFile == null) {
            VcsNotifier.getInstance(project2).notifyWeakError("vcs.patch.apply.cannot.find.patch.file", VcsBundle.message((String)"patch.apply.can.t.find.patch.file.warning", (Object[])new Object[]{patchPath}));
            return false;
        }
        if (!PatchFileType.isPatchFile(vFile)) {
            VcsNotifier.getInstance(project2).notifyWeakError("vcs.patch.apply.not.patch.type.file", VcsBundle.message((String)"patch.apply.not.patch.type.file.error", (Object[])new Object[]{patchPath}));
            return false;
        }
        ApplyPatchDifferentiatedDialog dialog2 = new ApplyPatchDifferentiatedDialog(project2, new ApplyPatchDefaultExecutor(project2), Collections.emptyList(), ApplyPatchMode.APPLY_PATCH_IN_MEMORY, vFile);
        dialog2.setModal(true);
        return dialog2.showAndGet();
    }

    public static void applySkipDirs(List<? extends FilePatch> patches2, int skipDirs) {
        if (skipDirs < 1) {
            return;
        }
        for (FilePatch filePatch : patches2) {
            filePatch.setBeforeName(ApplyPatchAction.skipN(filePatch.getBeforeName(), skipDirs));
            filePatch.setAfterName(ApplyPatchAction.skipN(filePatch.getAfterName(), skipDirs));
        }
    }

    private static String skipN(String path2, int num) {
        String[] pieces = path2.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i2 = num; i2 < pieces.length; ++i2) {
            String piece = pieces[i2];
            sb.append('/').append(piece);
        }
        return sb.toString();
    }

    @NotNull
    public static ApplyPatchStatus applyContent(@NotNull Project project, @NotNull ApplyFilePatchBase<?> patch2, @Nullable ApplyPatchContext context2, @NotNull VirtualFile file2, @Nullable CommitContext commitContext, boolean reverse, @Nullable String leftPanelTitle, @Nullable String rightPanelTitle) {
        ApplyPatchStatus applyPatchStatus;
        ApplyFilePatch.Result result2;
        ApplyPatchStatus status;
        if (project == null) {
            ApplyPatchAction.$$$reportNull$$$0(6);
        }
        if (patch2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(8);
        }
        if (ApplyPatchStatus.ALREADY_APPLIED.equals((Object)(status = (result2 = ApplyPatchAction.tryApplyPatch(project, patch2, context2, file2, commitContext)).getStatus())) || ApplyPatchStatus.SUCCESS.equals((Object)status)) {
            ApplyPatchStatus applyPatchStatus2 = status;
            if (applyPatchStatus2 == null) {
                ApplyPatchAction.$$$reportNull$$$0(9);
            }
            return applyPatchStatus2;
        }
        ApplyPatchForBaseRevisionTexts mergeData = result2.getMergeData();
        if (mergeData == null) {
            ApplyPatchStatus applyPatchStatus3 = status;
            if (applyPatchStatus3 == null) {
                ApplyPatchAction.$$$reportNull$$$0(10);
            }
            return applyPatchStatus3;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            ApplyPatchStatus applyPatchStatus4 = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus4 == null) {
                ApplyPatchAction.$$$reportNull$$$0(11);
            }
            return applyPatchStatus4;
        }
        String baseContent = ApplyPatchAction.convertLineSeparators(mergeData.getBase());
        String localContent = ApplyPatchAction.convertLineSeparators(mergeData.getLocal());
        String patchedContent = mergeData.getPatched();
        Ref applyPatchStatusReference = new Ref();
        Consumer callback2 = result13 -> {
            FileDocumentManager.getInstance().saveDocument(document);
            applyPatchStatusReference.setIfNull((Object)(result13 != MergeResult.CANCEL ? ApplyPatchStatus.SUCCESS : ApplyPatchStatus.FAILURE));
        };
        try {
            MergeRequest request2;
            if (baseContent != null) {
                if (reverse) {
                    if (leftPanelTitle == null) {
                        leftPanelTitle = VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0]);
                    }
                    if (rightPanelTitle == null) {
                        rightPanelTitle = VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]);
                    }
                    List<String> contents = Arrays.asList(patchedContent, baseContent, localContent);
                    List<String> titles = Arrays.asList(leftPanelTitle, null, rightPanelTitle);
                    request2 = PatchDiffRequestFactory.createMergeRequest(project, document, file2, contents, null, titles, (Consumer<? super MergeResult>)callback2);
                } else {
                    request2 = PatchDiffRequestFactory.createMergeRequest(project, document, file2, baseContent, localContent, patchedContent, (Consumer<? super MergeResult>)callback2);
                }
            } else {
                TextFilePatch textPatch = (TextFilePatch)patch2.getPatch();
                GenericPatchApplier applier = new GenericPatchApplier(localContent, textPatch.getHunks());
                applier.execute();
                AppliedTextPatch appliedTextPatch = AppliedTextPatch.create(applier.getAppliedInfo());
                request2 = PatchDiffRequestFactory.createBadMergeRequest(project, document, file2, localContent, appliedTextPatch, (Consumer<? super MergeResult>)callback2);
            }
            request2.putUserData(DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS, result12 -> result12.equals((Object)MergeResult.CANCEL) ? VcsBundle.message((String)"patch.apply.abort.action", (Object[])new Object[0]) : null);
            request2.putUserData(DiffUserDataKeysEx.MERGE_CANCEL_HANDLER, viewer -> {
                String message2 = VcsBundle.message((String)"patch.apply.abort.and.rollback.prompt", (Object[])new Object[0]);
                String title2 = VcsBundle.message((String)"patch.apply.abort.title", (Object[])new Object[0]);
                String yesText = VcsBundle.message((String)"patch.apply.abort.and.rollback.action", (Object[])new Object[0]);
                String noText = VcsBundle.message((String)"patch.apply.skip.action", (Object[])new Object[0]);
                String cancelText = VcsBundle.message((String)"patch.apply.continue.resolve.action", (Object[])new Object[0]);
                int result1 = 0;
                result1 = Messages.canShowMacSheetPanel() ? Messages.showYesNoCancelDialog((Component)viewer.getComponent().getRootPane(), (String)"", (String)message2, (String)yesText, (String)noText, (String)cancelText, (Icon)Messages.getQuestionIcon()) : Messages.showYesNoCancelDialog((Component)viewer.getComponent().getRootPane(), (String)message2, (String)title2, (String)yesText, (String)noText, (String)cancelText, (Icon)Messages.getQuestionIcon());
                if (result1 == 0) {
                    applyPatchStatusReference.set((Object)ApplyPatchStatus.ABORT);
                } else if (result1 == 1) {
                    applyPatchStatusReference.set((Object)ApplyPatchStatus.SKIP);
                }
                return result1 != 2;
            });
            DiffManager.getInstance().showMerge(project, request2);
            applyPatchStatus = (ApplyPatchStatus)((Object)applyPatchStatusReference.get());
        }
        catch (InvalidDiffRequestException e) {
            LOG.warn((Throwable)e);
            ApplyPatchStatus applyPatchStatus5 = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus5 == null) {
                ApplyPatchAction.$$$reportNull$$$0(13);
            }
            return applyPatchStatus5;
        }
        if (applyPatchStatus == null) {
            ApplyPatchAction.$$$reportNull$$$0(12);
        }
        return applyPatchStatus;
    }

    @NotNull
    private static ApplyFilePatch.Result tryApplyPatch(@NotNull Project project, @NotNull ApplyFilePatchBase<?> patch2, @Nullable ApplyPatchContext context2, @NotNull VirtualFile file2, @Nullable CommitContext commitContext) {
        if (project == null) {
            ApplyPatchAction.$$$reportNull$$$0(14);
        }
        if (patch2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(16);
        }
        Object patchBase = patch2.getPatch();
        ApplyFilePatch.Result result2 = (ApplyFilePatch.Result)WriteAction.compute(() -> {
            try {
                return patch2.apply(file2, context2, project, VcsUtil.getFilePath((VirtualFile)file2), () -> {
                    BaseRevisionTextPatchEP baseRevisionTextPatchEP = (BaseRevisionTextPatchEP)PatchEP.EP_NAME.findExtensionOrFail(BaseRevisionTextPatchEP.class);
                    String path2 = (String)ObjectUtils.chooseNotNull((Object)patchBase.getBeforeName(), (Object)patchBase.getAfterName());
                    return baseRevisionTextPatchEP.provideContent(project, path2, commitContext);
                }, commitContext);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return ApplyFilePatch.FAILURE;
            }
        });
        if (result2 == null) {
            ApplyPatchAction.$$$reportNull$$$0(17);
        }
        return result2;
    }

    @Nullable
    private static String convertLineSeparators(@Nullable String charSequence) {
        return charSequence != null ? StringUtil.convertLineSeparators((String)charSequence) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchAction";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "applyContent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "tryApplyPatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showApplyPatch";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showAndGetApplyPatch";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyContent";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tryApplyPatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

