/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RestoreShelvedChange
extends DumbAwareAction {
    public RestoreShelvedChange() {
        super(ActionsBundle.messagePointer((String)"action.RestoreShelvedChange.text", (Object[])new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RestoreShelvedChange.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Presentation presentation2 = e.getPresentation();
        if (project == null || project.isDisposed()) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        List deletedLists = ContainerUtil.notNullize((List)((List)e.getData(ShelvedChangesViewManager.SHELVED_DELETED_CHANGELIST_KEY)));
        presentation2.setText(VcsBundle.messagePointer((String)"vcs.shelf.action.restore.text", (Object[])new Object[0]));
        presentation2.setDescription(VcsBundle.messagePointer((String)"vcs.shelf.action.restore.description", (Object[])new Object[]{deletedLists.size()}));
        presentation2.setEnabled(!ContainerUtil.isEmpty((Collection)deletedLists));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RestoreShelvedChange.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ShelveChangesManager shelveChangesManager = ShelveChangesManager.getInstance(project);
        List lists = (List)e.getRequiredData(ShelvedChangesViewManager.SHELVED_DELETED_CHANGELIST_KEY);
        Date currentDate = new Date(System.currentTimeMillis());
        lists.forEach(l -> shelveChangesManager.restoreList((ShelvedChangeList)l, currentDate));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/RestoreShelvedChange";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

