/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.PlainSimplePatchApplier;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.openapi.vcs.changes.shelf.DiffShelvedChangesActionProvider;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedWrapperDiffRequestProducer
implements DiffRequestProducer {
    private final Project myProject;
    private final ShelvedWrapper myChange;

    public ShelvedWrapperDiffRequestProducer(@NotNull Project project, @NotNull ShelvedWrapper change) {
        if (project == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(0);
        }
        if (change == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myChange = change;
    }

    @NotNull
    public ShelvedWrapper getWrapper() {
        ShelvedWrapper shelvedWrapper = this.myChange;
        if (shelvedWrapper == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(2);
        }
        return shelvedWrapper;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.myChange.getRequestName();
        if (string == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShelvedWrapperDiffRequestProducer producer = (ShelvedWrapperDiffRequestProducer)o;
        return Objects.equals(this.myChange, producer.myChange);
    }

    public int hashCode() {
        return Objects.hash(this.myChange);
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException, ProcessCanceledException {
        if (context2 == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(4);
        }
        if (indicator2 == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(5);
        }
        String title2 = this.myChange.getRequestName();
        try {
            ShelvedChange shelvedChange = this.myChange.getShelvedChange();
            if (shelvedChange != null) {
                return this.createTextShelveRequest(shelvedChange, context2, title2);
            }
            ShelvedBinaryFile binaryFile = this.myChange.getBinaryFile();
            if (binaryFile != null) {
                return this.createBinaryShelveRequest(binaryFile, title2);
            }
            throw new IllegalStateException("Empty shelved wrapper: " + this.myChange);
        }
        catch (VcsException | IOException e) {
            throw new DiffRequestProducerException(VcsBundle.message((String)"changes.error.can.t.show.diff.for", (Object[])new Object[]{title2}), e);
        }
    }

    @NotNull
    private DiffRequest createTextShelveRequest(@NotNull ShelvedChange shelvedChange, @NotNull UserDataHolder context2, @Nullable @Nls String title2) throws VcsException {
        String patchedContent;
        if (shelvedChange == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(7);
        }
        DiffContentFactoryEx factory2 = DiffContentFactoryEx.getInstanceEx();
        DiffShelvedChangesActionProvider.PatchesPreloader preloader = DiffShelvedChangesActionProvider.PatchesPreloader.getPatchesPreloader(this.myProject, context2);
        Pair<TextFilePatch, CommitContext> pair = preloader.getPatchWithContext(shelvedChange);
        TextFilePatch patch2 = (TextFilePatch)pair.first;
        CommitContext commitContext = (CommitContext)pair.second;
        FilePath contextFilePath = ShelvedWrapperDiffRequestProducer.getContextFilePath(shelvedChange);
        if (patch2.isDeletedFile() || patch2.isNewFile()) {
            DocumentContent shelfContent = factory2.create(this.myProject, patch2.getSingleHunkPatchText(), contextFilePath);
            EmptyContent emptyContent = factory2.createEmpty();
            DocumentContent leftContent = patch2.isDeletedFile() ? shelfContent : emptyContent;
            DocumentContent rightContent = !patch2.isDeletedFile() ? shelfContent : emptyContent;
            String leftTitle = DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]);
            String rightTitle = VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]);
            return new SimpleDiffRequest(title2, (DiffContent)leftContent, (DiffContent)rightContent, leftTitle, rightTitle);
        }
        String path2 = (String)ObjectUtils.chooseNotNull((Object)patch2.getAfterName(), (Object)patch2.getBeforeName());
        CharSequence baseContents = ((BaseRevisionTextPatchEP)PatchEP.EP_NAME.findExtensionOrFail(BaseRevisionTextPatchEP.class)).provideContent(this.myProject, path2, commitContext);
        if (baseContents != null && (patchedContent = PlainSimplePatchApplier.apply(baseContents, patch2.getHunks())) != null) {
            DocumentContent leftContent = factory2.create(this.myProject, baseContents.toString(), contextFilePath);
            DocumentContent rightContent = factory2.create(this.myProject, patchedContent, contextFilePath);
            String leftTitle = DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]);
            String rightTitle = VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]);
            return new SimpleDiffRequest(title2, (DiffContent)leftContent, (DiffContent)rightContent, leftTitle, rightTitle);
        }
        return new PatchDiffRequest(DiffShelvedChangesActionProvider.createAppliedTextPatch(patch2), title2, null);
    }

    @NotNull
    private static FilePath getContextFilePath(@NotNull ShelvedChange shelvedChange) {
        Change change;
        if (shelvedChange == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(8);
        }
        if ((change = shelvedChange.getChange()).getType() == Change.Type.MOVED) {
            FilePath bPath = Objects.requireNonNull(ChangesUtil.getBeforePath((Change)change));
            FilePath aPath = Objects.requireNonNull(ChangesUtil.getAfterPath((Change)change));
            if (bPath.getVirtualFile() != null) {
                FilePath filePath = bPath;
                if (filePath == null) {
                    ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(9);
                }
                return filePath;
            }
            if (aPath.getVirtualFile() != null) {
                FilePath filePath = aPath;
                if (filePath == null) {
                    ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(10);
                }
                return filePath;
            }
            FilePath filePath = bPath;
            if (filePath == null) {
                ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(11);
            }
            return filePath;
        }
        FilePath filePath = ChangesUtil.getFilePath((Change)change);
        if (filePath == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(12);
        }
        return filePath;
    }

    @NotNull
    private SimpleDiffRequest createBinaryShelveRequest(@NotNull ShelvedBinaryFile binaryFile, @Nullable @Nls String title2) throws DiffRequestProducerException, VcsException, IOException {
        if (binaryFile == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(13);
        }
        DiffContentFactory factory2 = DiffContentFactory.getInstance();
        if (binaryFile.AFTER_PATH == null) {
            throw new DiffRequestProducerException(VcsBundle.message((String)"changes.error.content.for.0.was.removed", (Object[])new Object[]{title2}));
        }
        byte[] binaryContent = binaryFile.createBinaryContentRevision(this.myProject).getBinaryContent();
        FilePath filePath = VcsUtil.getFilePath((String)binaryFile.SHELVED_PATH);
        DiffContent shelfContent = factory2.createFromBytes(this.myProject, binaryContent, filePath);
        return new SimpleDiffRequest(title2, (DiffContent)factory2.createEmpty(), shelfContent, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedWrapperDiffRequestProducer";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChange";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedWrapperDiffRequestProducer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTextShelveRequest";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContextFilePath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryShelveRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

