/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.dnd.DnDAware;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.VcsCurrentRevisionProxy;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.HoverChangesTree;
import com.intellij.openapi.vcs.changes.ui.HoverIcon;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.commit.ChangesViewCommitPanelKt;
import com.intellij.vcs.commit.EditedCommitNode;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesListView
extends HoverChangesTree
implements DataProvider,
DnDAware {
    @NonNls
    public static final String HELP_ID = "ideaInterface.changes";
    @NonNls
    public static final DataKey<ChangesListView> DATA_KEY = DataKey.create("ChangeListView");
    @NonNls
    public static final DataKey<Iterable<FilePath>> UNVERSIONED_FILE_PATHS_DATA_KEY = DataKey.create("ChangeListView.UnversionedFiles");
    @NonNls
    public static final DataKey<Iterable<VirtualFile>> EXACTLY_SELECTED_FILES_DATA_KEY = DataKey.create("ChangeListView.ExactlySelectedFiles");
    @NonNls
    public static final DataKey<Iterable<FilePath>> IGNORED_FILE_PATHS_DATA_KEY = DataKey.create("ChangeListView.IgnoredFiles");
    @NonNls
    public static final DataKey<List<FilePath>> MISSING_FILES_DATA_KEY = DataKey.create("ChangeListView.MissingFiles");
    @NonNls
    public static final DataKey<List<LocallyDeletedChange>> LOCALLY_DELETED_CHANGES = DataKey.create("ChangeListView.LocallyDeletedChanges");

    public ChangesListView(@NotNull Project project, boolean showCheckboxes) {
        if (project == null) {
            ChangesListView.$$$reportNull$$$0(0);
        }
        super(project, showCheckboxes, true);
        this.setDragEnabled(true);
    }

    @Override
    @NotNull
    protected ChangesGroupingSupport installGroupingSupport() {
        return new ChangesGroupingSupport(this.myProject, this, true);
    }

    @Override
    public int getToggleClickCount() {
        return 2;
    }

    @Override
    protected boolean isInclusionVisible(@NotNull ChangesBrowserNode<?> node2) {
        Object subtreeRootObject;
        if (node2 == null) {
            ChangesListView.$$$reportNull$$$0(1);
        }
        if ((subtreeRootObject = ChangesViewCommitPanelKt.subtreeRootObject(node2)) instanceof LocalChangeList) {
            return !((LocalChangeList)subtreeRootObject).getChanges().isEmpty();
        }
        return subtreeRootObject == ChangesBrowserNode.UNVERSIONED_FILES_TAG;
    }

    @Override
    @Nullable
    public HoverIcon getHoverIcon(@NotNull ChangesBrowserNode<?> node2) {
        if (node2 == null) {
            ChangesListView.$$$reportNull$$$0(2);
        }
        return null;
    }

    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    public void updateModel(@NotNull DefaultTreeModel newModel) {
        if (newModel == null) {
            ChangesListView.$$$reportNull$$$0(3);
        }
        TreeState state = TreeState.createOn((JTree)((Object)this), this.getRoot());
        state.setScrollToSelection(false);
        ChangesBrowserNode<?> oldRoot = this.getRoot();
        this.setModel(newModel);
        ChangesBrowserNode<?> newRoot = this.getRoot();
        state.applyTo((JTree)((Object)this), newRoot);
        this.initTreeStateIfNeeded(oldRoot, newRoot);
    }

    @Override
    public void rebuildTree() {
    }

    private void initTreeStateIfNeeded(ChangesBrowserNode<?> oldRoot, ChangesBrowserNode<?> newRoot) {
        ChangesBrowserNode<?> defaultListNode = ChangesListView.getDefaultChangelistNode(newRoot);
        if (defaultListNode == null) {
            return;
        }
        if (this.getSelectionCount() == 0) {
            TreeUtil.selectNode((JTree)((Object)this), defaultListNode);
        }
        if (oldRoot.getFileCount() == 0 && TreeUtil.collectExpandedPaths((JTree)((Object)this)).size() == 0) {
            this.expandSafe(defaultListNode);
        }
    }

    @Nullable
    private static ChangesBrowserNode<?> getDefaultChangelistNode(@NotNull ChangesBrowserNode<?> root2) {
        if (root2 == null) {
            ChangesListView.$$$reportNull$$$0(4);
        }
        Enumeration<TreeNode> children2 = root2.children();
        Iterator nodes = ContainerUtil.iterate(children2);
        return (ChangesBrowserNode)ContainerUtil.find((Iterator)nodes, node2 -> {
            if (node2 instanceof ChangesBrowserChangeListNode) {
                ChangeList list2 = (ChangeList)((ChangesBrowserChangeListNode)node2).getUserObject();
                return list2 instanceof LocalChangeList && ((LocalChangeList)list2).isDefault();
            }
            return false;
        });
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            ChangesListView.$$$reportNull$$$0(5);
        }
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            return this.getSelectedChanges().toList().toArray(Change[]::new);
        }
        if (VcsDataKeys.CHANGE_LEAD_SELECTION.is(dataId)) {
            return this.getLeadSelection().toList().toArray(Change[]::new);
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            return this.getSelectedChangeLists().toList().toArray(ChangeList[]::new);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return this.getSelectedFiles().toList().toArray(VirtualFile[]::new);
        }
        if (VcsDataKeys.VIRTUAL_FILES.is(dataId)) {
            return this.getSelectedFiles();
        }
        if (VcsDataKeys.FILE_PATHS.is(dataId)) {
            return this.getSelectedFilePaths();
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            VirtualFile file2 = (VirtualFile)this.getNavigatableFiles().single();
            return file2 != null && !file2.isDirectory() ? PsiNavigationSupport.getInstance().createNavigatable(this.myProject, file2, 0) : null;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return ChangesUtil.getNavigatableArray((Project)this.myProject, (Stream)StreamEx.of((Iterator)this.getNavigatableFiles().iterator()));
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.getSelectionObjects().find(userObject -> !(userObject instanceof ChangeList)) != null ? new VirtualFileDeleteProvider() : null;
        }
        if (UNVERSIONED_FILE_PATHS_DATA_KEY.is(dataId)) {
            return this.getSelectedUnversionedFiles();
        }
        if (EXACTLY_SELECTED_FILES_DATA_KEY.is(dataId)) {
            return ChangesListView.getExactlySelectedVirtualFiles((JTree)((Object)this));
        }
        if (IGNORED_FILE_PATHS_DATA_KEY.is(dataId)) {
            return this.getSelectedIgnoredFiles();
        }
        if (VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY.is(dataId)) {
            return this.getSelectedModifiedWithoutEditing().toList();
        }
        if (LOCALLY_DELETED_CHANGES.is(dataId)) {
            return this.getSelectedLocallyDeletedChanges().toList();
        }
        if (MISSING_FILES_DATA_KEY.is(dataId)) {
            return this.getSelectedMissingFiles().toList();
        }
        if (VcsDataKeys.HAVE_LOCALLY_DELETED.is(dataId)) {
            return this.getSelectedMissingFiles().isNotEmpty();
        }
        if (VcsDataKeys.HAVE_MODIFIED_WITHOUT_EDITING.is(dataId)) {
            return this.getSelectedModifiedWithoutEditing().isNotEmpty();
        }
        if (VcsDataKeys.HAVE_SELECTED_CHANGES.is(dataId)) {
            return this.getSelectedChanges().isNotEmpty();
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    @NotNull
    public Stream<FilePath> getUnversionedFiles() {
        ChangesBrowserUnversionedFilesNode node2 = (ChangesBrowserUnversionedFilesNode)TreeUtil.nodeChildren(this.getRoot()).filter(ChangesBrowserUnversionedFilesNode.class).first();
        if (node2 == null) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                ChangesListView.$$$reportNull$$$0(6);
            }
            return streamEx;
        }
        Stream<FilePath> stream = node2.getFilePathsUnderStream();
        if (stream == null) {
            ChangesListView.$$$reportNull$$$0(7);
        }
        return stream;
    }

    @NotNull
    static JBIterable<FilePath> getSelectedUnversionedFiles(@NotNull JTree tree) {
        if (tree == null) {
            ChangesListView.$$$reportNull$$$0(8);
        }
        return ChangesListView.getSelectedFilePaths(tree, ChangesBrowserNode.UNVERSIONED_FILES_TAG);
    }

    @NotNull
    public JBIterable<FilePath> getSelectedUnversionedFiles() {
        return ChangesListView.getSelectedUnversionedFiles((JTree)((Object)this));
    }

    @NotNull
    private JBIterable<FilePath> getSelectedIgnoredFiles() {
        JBIterable<FilePath> jBIterable = this.getSelectedFilePaths(ChangesBrowserNode.IGNORED_FILES_TAG);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<VirtualFile> getSelectedModifiedWithoutEditing() {
        JBIterable<VirtualFile> jBIterable = this.getSelectedVirtualFiles(ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @NotNull
    protected JBIterable<VirtualFile> getSelectedVirtualFiles(@Nullable Object tag2) {
        JBIterable jBIterable = ChangesListView.getSelectionNodes((JTree)((Object)this), tag2).flatMap(node2 -> JBIterable.create(() -> node2.getFilesUnderStream().iterator())).unique();
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @NotNull
    protected JBIterable<FilePath> getSelectedFilePaths(@Nullable Object tag2) {
        return ChangesListView.getSelectedFilePaths((JTree)((Object)this), tag2);
    }

    @NotNull
    private static JBIterable<FilePath> getSelectedFilePaths(@NotNull JTree tree, @Nullable Object tag2) {
        if (tree == null) {
            ChangesListView.$$$reportNull$$$0(12);
        }
        JBIterable jBIterable = ChangesListView.getSelectionNodes(tree, tag2).flatMap(node2 -> JBIterable.create(() -> node2.getFilePathsUnderStream().iterator())).unique();
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @NotNull
    static JBIterable<VirtualFile> getExactlySelectedVirtualFiles(@NotNull JTree tree) {
        if (tree == null) {
            ChangesListView.$$$reportNull$$$0(14);
        }
        VcsTreeModelData exactlySelected = VcsTreeModelData.exactlySelected(tree);
        JBIterable jBIterable = JBIterable.create(() -> exactlySelected.rawUserObjectsStream().iterator()).map(object -> {
            if (object instanceof VirtualFile) {
                return (VirtualFile)object;
            }
            if (object instanceof FilePath) {
                return ((FilePath)object).getVirtualFile();
            }
            return null;
        }).filter(Objects::nonNull);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(15);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<ChangesBrowserNode<?>> getSelectionNodes() {
        return ChangesListView.getSelectionNodes((JTree)((Object)this), null);
    }

    @NotNull
    private static JBIterable<ChangesBrowserNode<?>> getSelectionNodes(@NotNull JTree tree, @Nullable Object tag2) {
        if (tree == null) {
            ChangesListView.$$$reportNull$$$0(16);
        }
        JBIterable jBIterable = JBIterable.of((Object[])tree.getSelectionPaths()).filter(path2 -> ChangesListView.isUnderTag(path2, tag2)).map(TreePath::getLastPathComponent).map(node2 -> (ChangesBrowserNode)node2);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(17);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<Object> getSelectionObjects() {
        JBIterable jBIterable = this.getSelectionNodes().map(ChangesBrowserNode::getUserObject);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(18);
        }
        return jBIterable;
    }

    @NotNull
    static JBIterable<VirtualFile> getVirtualFiles(TreePath @Nullable [] paths2, @Nullable Object tag2) {
        JBIterable jBIterable = JBIterable.of((Object[])paths2).filter(path2 -> ChangesListView.isUnderTag(path2, tag2)).map(TreePath::getLastPathComponent).map(node2 -> (ChangesBrowserNode)node2).flatMap(node2 -> JBIterable.create(() -> node2.getFilesUnderStream().iterator())).unique();
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(19);
        }
        return jBIterable;
    }

    @NotNull
    static JBIterable<FilePath> getFilePaths(TreePath @Nullable [] paths2, @Nullable Object tag2) {
        JBIterable jBIterable = JBIterable.of((Object[])paths2).filter(path2 -> ChangesListView.isUnderTag(path2, tag2)).map(TreePath::getLastPathComponent).map(node2 -> (ChangesBrowserNode)node2).flatMap(node2 -> JBIterable.create(() -> node2.getFilePathsUnderStream().iterator())).unique();
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    static boolean isUnderTag(@NotNull TreePath path2, @Nullable Object tag2) {
        if (path2 == null) {
            ChangesListView.$$$reportNull$$$0(21);
        }
        boolean result2 = true;
        if (tag2 != null) {
            result2 = path2.getPathCount() > 1 && ((ChangesBrowserNode)path2.getPathComponent(1)).getUserObject() == tag2;
        }
        return result2;
    }

    @NotNull
    static JBIterable<Change> getChanges(@NotNull Project project, TreePath @Nullable [] paths2) {
        if (project == null) {
            ChangesListView.$$$reportNull$$$0(22);
        }
        JBIterable changes = JBIterable.of((Object[])paths2).map(TreePath::getLastPathComponent).map(node2 -> (ChangesBrowserNode)node2).flatMap(node2 -> node2.traverseObjectsUnder()).filter(Change.class);
        JBIterable hijackedChanges = ChangesListView.getVirtualFiles(paths2, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG).map(file2 -> ChangesListView.toHijackedChange(project, file2)).filter(Objects::nonNull);
        JBIterable jBIterable = changes.append((Iterable)hijackedChanges).filter((Condition)new DistinctChangePredicate());
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(23);
        }
        return jBIterable;
    }

    @NotNull
    static JBIterable<ChangesBrowserNode<?>> getChangesNodes(TreePath @Nullable [] paths2) {
        JBIterable jBIterable = JBIterable.of((Object[])paths2).map(TreePath::getLastPathComponent).map(node2 -> (ChangesBrowserNode)node2).flatMap(node2 -> node2.traverse()).unique();
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(24);
        }
        return jBIterable;
    }

    @Nullable
    public static Change toHijackedChange(@NotNull Project project, @NotNull VirtualFile file2) {
        VcsCurrentRevisionProxy before;
        if (project == null) {
            ChangesListView.$$$reportNull$$$0(25);
        }
        if (file2 == null) {
            ChangesListView.$$$reportNull$$$0(26);
        }
        if ((before = VcsCurrentRevisionProxy.create(file2, project)) != null) {
            CurrentContentRevision afterRevision = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)file2));
            return new Change((ContentRevision)before, (ContentRevision)afterRevision, FileStatus.HIJACKED);
        }
        return null;
    }

    @NotNull
    private JBIterable<LocallyDeletedChange> getSelectedLocallyDeletedChanges() {
        JBIterable jBIterable = ChangesListView.getSelectionNodes((JTree)((Object)this), ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG).flatMap(node2 -> node2.traverseObjectsUnder()).filter(LocallyDeletedChange.class).unique();
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(27);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<FilePath> getSelectedMissingFiles() {
        JBIterable jBIterable = this.getSelectedLocallyDeletedChanges().map(LocallyDeletedChange::getPath);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(28);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<FilePath> getSelectedFilePaths() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getSelectedChanges().map(ChangesUtil::getFilePath)).append((Iterable)this.getSelectedVirtualFiles(null).map(VcsUtil::getFilePath)).append(this.getSelectedFilePaths(null)).unique();
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(29);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<VirtualFile> getSelectedFiles() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getSelectedChanges().filterMap(ChangesUtil::getAfterPath).filterMap(FilePath::getVirtualFile)).append(this.getSelectedVirtualFiles(null)).append((Iterable)this.getSelectedFilePaths(null).filterMap(FilePath::getVirtualFile)).unique();
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(30);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<VirtualFile> getNavigatableFiles() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getSelectedChanges().flatMap(o -> JBIterable.create(() -> ChangesUtil.getPathsCaseSensitive((Change)o).iterator())).filterMap(FilePath::getVirtualFile)).append(this.getSelectedVirtualFiles(null)).append((Iterable)this.getSelectedFilePaths(null).filterMap(FilePath::getVirtualFile)).unique();
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(31);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<Change> getLeadSelection() {
        JBIterable jBIterable = this.getSelectionNodes().filter(node2 -> node2 instanceof ChangesBrowserChangeNode).map(ChangesBrowserChangeNode.class::cast).map(ChangesBrowserNode::getUserObject).filter((Condition)new DistinctChangePredicate());
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(32);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<Change> getChanges() {
        JBIterable jBIterable = this.getRoot().traverseObjectsUnder().filter(Change.class);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(33);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ChangesBrowserChangeNode> getChangesNodes() {
        JBIterable jBIterable = TreeUtil.treeNodeTraverser(this.getRoot()).traverse().filter(ChangesBrowserChangeNode.class);
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(34);
        }
        return jBIterable;
    }

    @Nullable
    public List<Change> getAllChangesFromSameChangelist(@NotNull Change change) {
        if (change == null) {
            ChangesListView.$$$reportNull$$$0(35);
        }
        return this.getAllChangesUnder(change, ChangesBrowserChangeListNode.class);
    }

    @Nullable
    public List<Change> getAllChangesFromSameAmendNode(@NotNull Change change) {
        if (change == null) {
            ChangesListView.$$$reportNull$$$0(36);
        }
        return this.getAllChangesUnder(change, EditedCommitNode.class);
    }

    @Nullable
    public List<Change> getAllChangesUnder(@NotNull Change change, Class<? extends ChangesBrowserNode<?>> ... nodeClasses) {
        if (change == null) {
            ChangesListView.$$$reportNull$$$0(37);
        }
        if (nodeClasses == null) {
            ChangesListView.$$$reportNull$$$0(38);
        }
        boolean changeListNodeRequested = ArrayUtil.contains(ChangesBrowserChangeListNode.class, (Object[])nodeClasses);
        for (DefaultMutableTreeNode node2 = this.findNodeInTree(change); node2 != null; node2 = (DefaultMutableTreeNode)node2.getParent()) {
            if (ArrayUtil.contains(node2.getClass(), (Object[])nodeClasses)) {
                return ((ChangesBrowserNode)node2).getAllChangesUnder();
            }
            if (node2 != this.getRoot() || !changeListNodeRequested || !Registry.is((String)"vcs.skip.single.default.changelist") && ChangeListManager.getInstance((Project)this.myProject).areChangeListsEnabled()) continue;
            return this.getRoot().getAllChangesUnder();
        }
        return null;
    }

    @NotNull
    public JBIterable<Change> getSelectedChanges() {
        return ChangesListView.getChanges(this.myProject, this.getSelectionPaths());
    }

    @NotNull
    public JBIterable<ChangesBrowserNode<?>> getSelectedChangesNodes() {
        return ChangesListView.getChangesNodes(this.getSelectionPaths());
    }

    @NotNull
    private JBIterable<ChangeList> getSelectedChangeLists() {
        JBIterable jBIterable = this.getSelectionObjects().filter(userObject -> userObject instanceof ChangeList).map(ChangeList.class::cast).unique();
        if (jBIterable == null) {
            ChangesListView.$$$reportNull$$$0(39);
        }
        return jBIterable;
    }

    @Override
    public void installPopupHandler(@NotNull ActionGroup group2) {
        if (group2 == null) {
            ChangesListView.$$$reportNull$$$0(40);
        }
        PopupHandler.installPopupMenu((JComponent)((Object)this), (ActionGroup)group2, (String)"ChangesViewPopup");
    }

    @NotNull
    public JComponent getComponent() {
        ChangesListView changesListView = this;
        if (changesListView == null) {
            ChangesListView.$$$reportNull$$$0(41);
        }
        return changesListView;
    }

    public void processMouseEvent(MouseEvent e) {
        if (!(502 != e.getID() || this.isSelectionEmpty() || e.isShiftDown() || e.isControlDown() || e.isMetaDown() || e.isPopupTrigger() || !this.isOverSelection(e.getPoint()))) {
            this.clearSelection();
            TreePath path2 = this.getPathForLocation(e.getPoint().x, e.getPoint().y);
            if (path2 != null) {
                this.setSelectionPath(path2);
            }
        }
        super.processMouseEvent(e);
    }

    public boolean isOverSelection(Point point) {
        return TreeUtil.isOverSelection((JTree)((Object)this), (Point)point);
    }

    public void dropSelectionButUnderPoint(Point point) {
        TreeUtil.dropSelectionButUnderPoint((JTree)((Object)this), (Point)point);
    }

    @Nullable
    public DefaultMutableTreeNode findNodeInTree(@Nullable Object userObject) {
        return this.findNodeInTree(userObject, null);
    }

    @Nullable
    public DefaultMutableTreeNode findNodeInTree(@Nullable Object userObject, @Nullable Object tag2) {
        ChangesBrowserNode<?> fromNode;
        DefaultMutableTreeNode defaultMutableTreeNode = fromNode = tag2 != null ? (DefaultMutableTreeNode)ObjectUtils.notNull(VcsTreeModelData.findTagNode((JTree)((Object)this), tag2), this.getRoot()) : this.getRoot();
        if (userObject instanceof LocalChangeList) {
            return (DefaultMutableTreeNode)TreeUtil.nodeChildren(fromNode).filter(DefaultMutableTreeNode.class).find(node2 -> userObject.equals(node2.getUserObject()));
        }
        if (userObject instanceof ChangeListChange) {
            return TreeUtil.findNode(fromNode, node2 -> ChangeListChange.HASHING_STRATEGY.equals(node2.getUserObject(), userObject));
        }
        return TreeUtil.findNodeWithObject(fromNode, (Object)userObject);
    }

    @Nullable
    public TreePath findNodePathInTree(@Nullable Object userObject) {
        return this.findNodePathInTree(userObject, null);
    }

    @Nullable
    public TreePath findNodePathInTree(@Nullable Object userObject, @Nullable Object tag2) {
        DefaultMutableTreeNode node2 = this.findNodeInTree(userObject, tag2);
        return node2 != null ? TreeUtil.getPathFromRoot((TreeNode)node2) : null;
    }

    public void expandSafe(@NotNull DefaultMutableTreeNode node2) {
        if (node2 == null) {
            ChangesListView.$$$reportNull$$$0(42);
        }
        if (node2.getChildCount() <= 10000) {
            this.expandPath(TreeUtil.getPathFromRoot((TreeNode)node2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesListView";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeClasses";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesListView";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedIgnoredFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModifiedWithoutEditing";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedVirtualFiles";
                break;
            }
            case 13: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFilePaths";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExactlySelectedVirtualFiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionNodes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionObjects";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePaths";
                break;
            }
            case 23: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 24: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesNodes";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLocallyDeletedChanges";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedMissingFiles";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatableFiles";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelection";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChangeLists";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInclusionVisible";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHoverIcon";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultChangelistNode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 41: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedUnversionedFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFilePaths";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExactlySelectedVirtualFiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionNodes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isUnderTag";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getChanges";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "toHijackedChange";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getAllChangesFromSameChangelist";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAllChangesFromSameAmendNode";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getAllChangesUnder";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "expandSafe";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DistinctChangePredicate
    extends JBIterable.SCond<Change> {
        private Set<Object> seen;

        private DistinctChangePredicate() {
        }

        public boolean value(Change change) {
            if (this.seen == null) {
                this.seen = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)ChangeListChange.HASHING_STRATEGY);
            }
            return this.seen.add(change);
        }
    }
}

