/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui.browser;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Function;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingChangesPanel
extends JPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance(LoadingChangesPanel.class);
    @Nullable
    private final StatusText myEmptyText;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @Nullable
    private ProgressIndicator myIndicator;

    public LoadingChangesPanel(@NotNull JComponent panel2, @Nullable StatusText emptyText, @NotNull Disposable disposable2) {
        if (panel2 == null) {
            LoadingChangesPanel.$$$reportNull$$$0(0);
        }
        if (disposable2 == null) {
            LoadingChangesPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myEmptyText = emptyText;
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), disposable2);
        this.myLoadingPanel.add((Component)panel2, (Object)"Center");
        this.add((Component)this.myLoadingPanel, "Center");
        Disposer.register((Disposable)disposable2, (Disposable)this);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public <T> void loadChangesInBackground(@NotNull ThrowableComputable<? extends T, ? extends VcsException> throwableComputable, @NotNull Consumer<@Nullable T> consumer2) {
        void applyResult;
        void loadChanges;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (loadChanges == null) {
            LoadingChangesPanel.$$$reportNull$$$0(2);
        }
        if (applyResult == null) {
            LoadingChangesPanel.$$$reportNull$$$0(3);
        }
        if (this.myIndicator != null) {
            this.myIndicator.cancel();
        }
        this.myIndicator = BackgroundTaskUtil.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)arg_0 -> this.lambda$loadChangesInBackground$0((ThrowableComputable)loadChanges, (Consumer)applyResult, arg_0)), this::startLoadingProgress);
    }

    protected void startLoadingProgress() {
        this.myLoadingPanel.startLoading();
        if (this.myEmptyText != null) {
            this.myEmptyText.setText("");
        }
    }

    @NotNull
    private <T> Runnable doLoadChanges(@NotNull ThrowableComputable<? extends T, ? extends VcsException> loadChanges, @NotNull Consumer<@Nullable T> applyResult) {
        Runnable runnable2;
        if (loadChanges == null) {
            LoadingChangesPanel.$$$reportNull$$$0(4);
        }
        if (applyResult == null) {
            LoadingChangesPanel.$$$reportNull$$$0(5);
        }
        try {
            Object changes = loadChanges.compute();
            runnable2 = () -> {
                this.myLoadingPanel.stopLoading();
                if (this.myEmptyText != null) {
                    this.myEmptyText.setText(DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{0}));
                }
                applyResult.accept(changes);
            };
        }
        catch (ProcessCanceledException e) {
            Runnable runnable3 = EmptyRunnable.INSTANCE;
            if (runnable3 == null) {
                LoadingChangesPanel.$$$reportNull$$$0(7);
            }
            return runnable3;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            Runnable runnable4 = () -> {
                this.myLoadingPanel.stopLoading();
                if (this.myEmptyText != null) {
                    this.myEmptyText.setText(StringUtilRt.notNullize((String)e.getMessage(), (String)VcsBundle.message((String)"changes.cant.load.changes", (Object[])new Object[0])), SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
                applyResult.accept(null);
            };
            if (runnable4 == null) {
                LoadingChangesPanel.$$$reportNull$$$0(8);
            }
            return runnable4;
        }
        if (runnable2 == null) {
            LoadingChangesPanel.$$$reportNull$$$0(6);
        }
        return runnable2;
    }

    public void dispose() {
        if (this.myIndicator != null) {
            this.myIndicator.cancel();
        }
    }

    private /* synthetic */ Runnable lambda$loadChangesInBackground$0(ThrowableComputable loadChanges, Consumer applyResult, ProgressIndicator indicator2) {
        return this.doLoadChanges(loadChanges, applyResult);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadChanges";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyResult";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/browser/LoadingChangesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/browser/LoadingChangesPanel";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadChangesInBackground";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doLoadChanges";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

