/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.configurable.VcsMappingConfigurationDialog;
import com.intellij.openapi.vcs.configurable.VcsUpdateInfoScopeFilterConfigurable;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.roots.VcsRootErrorsFinder;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirectoryConfigurationPanel
extends JPanel
implements Disposable {
    private static final int POSTPONE_MAPPINGS_LOADING_PANEL = 300;
    private final Project myProject;
    @Nls
    private final String myProjectMessage;
    private final ProjectLevelVcsManager myVcsManager;
    private final TableView<MapInfo> myDirectoryMappingTable;
    private final ComboBox<AbstractVcs> myVcsComboBox;
    private final MyDirectoryRenderer myDirectoryRenderer;
    private final ColumnInfo<MapInfo, MapInfo> DIRECTORY;
    private ListTableModel<MapInfo> myModel;
    private final List<AbstractVcs> myAllVcss;
    private final boolean myIsDisabled;
    private final VcsConfiguration myVcsConfiguration;
    @NotNull
    private final Map<String, VcsRootChecker> myCheckers;
    private final VcsUpdateInfoScopeFilterConfigurable myScopeFilterConfig;
    private JBLoadingPanel myLoadingPanel;
    private final ColumnInfo<MapInfo, String> VCS_SETTING;

    @NotNull
    private static SimpleTextAttributes getAttributes(@NotNull MapInfo info2) {
        if (info2 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(0);
        }
        if (info2 == MapInfo.SEPARATOR) {
            return new SimpleTextAttributes(129, null);
        }
        if (info2.type == MapInfo.Type.INVALID) {
            return new SimpleTextAttributes(0, (Color)JBColor.RED);
        }
        if (info2.type == MapInfo.Type.UNREGISTERED) {
            return new SimpleTextAttributes(1, (Color)JBColor.GRAY);
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (simpleTextAttributes == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(1);
        }
        return simpleTextAttributes;
    }

    public VcsDirectoryConfigurationPanel(@NotNull Project project) {
        if (project == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(2);
        }
        this.VCS_SETTING = new ColumnInfo<MapInfo, String>(VcsBundle.message((String)"column.name.configure.vcses.vcs", (Object[])new Object[0])){

            public String valueOf(MapInfo object) {
                return object.mapping.getVcs();
            }

            public boolean isCellEditable(MapInfo info2) {
                return info2 != MapInfo.SEPARATOR && info2.type != MapInfo.Type.UNREGISTERED;
            }

            public void setValue(MapInfo o, String aValue) {
                Collection<AbstractVcs> activeVcses = VcsDirectoryConfigurationPanel.this.getActiveVcses();
                o.mapping = new VcsDirectoryMapping(o.mapping.getDirectory(), aValue, o.mapping.getRootSettings());
            }

            public TableCellRenderer getRenderer(final MapInfo info2) {
                return new ColoredTableCellRenderer(){

                    protected void customizeCellRenderer(@NotNull JTable table, Object value2, boolean selected2, boolean hasFocus, int row2, int column2) {
                        AbstractVcs vcs;
                        String vcsName;
                        if (table == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (info2 == MapInfo.SEPARATOR) {
                            if (!selected2) {
                                this.setBackground(UIUtil.getDecoratedRowColor());
                            }
                            return;
                        }
                        if (info2.type == MapInfo.Type.UNREGISTERED && !selected2) {
                            this.setBackground(UIUtil.getDecoratedRowColor());
                        }
                        String text2 = (vcsName = info2.mapping.getVcs()).isEmpty() ? VcsBundle.message((String)"none.vcs.presentation", (Object[])new Object[0]) : ((vcs = (AbstractVcs)ContainerUtil.find(VcsDirectoryConfigurationPanel.this.myAllVcss, it -> vcsName.equals(it.getName()))) != null ? vcs.getDisplayName() : VcsBundle.message((String)"unknown.vcs.presentation", (Object[])new Object[]{vcsName}));
                        this.append(text2, VcsDirectoryConfigurationPanel.getAttributes(info2));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$1$1", "customizeCellRenderer"));
                    }
                };
            }

            public TableCellEditor getEditor(MapInfo o) {
                return new AbstractTableCellEditor(){

                    public Object getCellEditorValue() {
                        AbstractVcs selectedVcs = (AbstractVcs)VcsDirectoryConfigurationPanel.this.myVcsComboBox.getItem();
                        return selectedVcs == null ? "" : selectedVcs.getName();
                    }

                    public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row2, int column2) {
                        VcsDirectoryConfigurationPanel.this.myVcsComboBox.setSelectedItem(value2);
                        return VcsDirectoryConfigurationPanel.this.myVcsComboBox;
                    }
                };
            }

            @Nullable
            public String getMaxStringValue() {
                String maxString = null;
                for (AbstractVcs vcs : VcsDirectoryConfigurationPanel.this.myAllVcss) {
                    String name2 = vcs.getDisplayName();
                    if (maxString != null && maxString.length() >= name2.length()) continue;
                    maxString = name2;
                }
                return maxString;
            }

            public int getAdditionalWidth() {
                return 10;
            }
        };
        this.myProject = project;
        this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myProjectMessage = new HtmlBuilder().append((String)VcsDirectoryMapping.PROJECT_CONSTANT.get()).append(" - ").append(DefaultVcsRootPolicy.getInstance(this.myProject).getProjectConfigurationMessage().replace('\n', ' ')).wrapWithHtmlBody().toString();
        this.myIsDisabled = this.myProject.isDefault();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myAllVcss = Arrays.asList(this.myVcsManager.getAllSupportedVcss());
        this.myDirectoryMappingTable = new TableView();
        this.myDirectoryMappingTable.setShowGrid(false);
        this.myDirectoryMappingTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.myScopeFilterConfig = new VcsUpdateInfoScopeFilterConfigurable(this.myProject, this.myVcsConfiguration);
        this.myCheckers = new HashMap<String, VcsRootChecker>();
        this.updateRootCheckers();
        this.setLayout(new BorderLayout());
        this.add(this.createMainComponent());
        this.myDirectoryRenderer = new MyDirectoryRenderer(this.myProject);
        this.DIRECTORY = new ColumnInfo<MapInfo, MapInfo>(VcsBundle.message((String)"column.info.configure.vcses.directory", (Object[])new Object[0])){

            public MapInfo valueOf(MapInfo mapping2) {
                return mapping2;
            }

            public TableCellRenderer getRenderer(MapInfo vcsDirectoryMapping) {
                return VcsDirectoryConfigurationPanel.this.myDirectoryRenderer;
            }
        };
        this.initializeModel();
        this.myVcsComboBox = VcsDirectoryConfigurationPanel.buildVcsesComboBox(this.myProject);
        this.myVcsComboBox.addItemListener(e -> {
            if (this.myDirectoryMappingTable.isEditing()) {
                this.myDirectoryMappingTable.stopEditing();
            }
        });
        this.myDirectoryMappingTable.setRowHeight(this.myVcsComboBox.getPreferredSize().height);
        if (this.myIsDisabled) {
            this.myDirectoryMappingTable.setEnabled(false);
        }
    }

    public void dispose() {
        this.myScopeFilterConfig.disposeUIResources();
    }

    private void updateRootCheckers() {
        this.myCheckers.clear();
        for (VcsRootChecker checker : VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList()) {
            VcsKey key = checker.getSupportedVcs();
            AbstractVcs vcs = this.myVcsManager.findVcsByName(key.getName());
            if (vcs == null) continue;
            this.myCheckers.put(key.getName(), checker);
        }
    }

    private void initializeModel() {
        this.myScopeFilterConfig.reset();
        ArrayList<MapInfo> mappings = new ArrayList<MapInfo>();
        for (VcsDirectoryMapping mapping2 : ProjectLevelVcsManager.getInstance((Project)this.myProject).getDirectoryMappings()) {
            mappings.add(MapInfo.registered(new VcsDirectoryMapping(mapping2.getDirectory(), mapping2.getVcs(), mapping2.getRootSettings()), this.isMappingValid(mapping2)));
        }
        this.myModel = new ListTableModel(new ColumnInfo[]{this.DIRECTORY, this.VCS_SETTING}, mappings, 0);
        BackgroundTaskUtil.executeAndTryWait((Function<? super ProgressIndicator, ? extends Runnable>)((Function)indicator2 -> {
            Collection<VcsRootError> errors2 = this.findUnregisteredRoots();
            return () -> {
                if (!errors2.isEmpty()) {
                    ArrayList<MapInfo> newMappings = new ArrayList<MapInfo>(mappings);
                    newMappings.add(MapInfo.SEPARATOR);
                    for (VcsRootError error : errors2) {
                        newMappings.add(MapInfo.unregistered(error.getMapping()));
                    }
                    this.myModel.setItems(newMappings);
                }
                this.myDirectoryMappingTable.setModelAndUpdateColumns(this.myModel);
                this.myLoadingPanel.stopLoading();
            };
        }), () -> this.myLoadingPanel.startLoading(), 300L, false);
    }

    @NotNull
    private Collection<VcsRootError> findUnregisteredRoots() {
        List list2 = ContainerUtil.filter(VcsRootErrorsFinder.getInstance(this.myProject).getOrFind(), error -> error.getType() == VcsRootError.Type.UNREGISTERED_ROOT);
        if (list2 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private boolean isMappingValid(@NotNull VcsDirectoryMapping mapping2) {
        if (mapping2 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(4);
        }
        if (mapping2.isDefaultMapping()) {
            return true;
        }
        VcsRootChecker checker = this.myCheckers.get(mapping2.getVcs());
        return checker == null || checker.isRoot(mapping2.getDirectory());
    }

    @NotNull
    public static ComboBox<AbstractVcs> buildVcsesComboBox(@NotNull Project project) {
        if (project == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(5);
        }
        Object[] allVcses = ProjectLevelVcsManager.getInstance((Project)project).getAllSupportedVcss();
        ComboBox comboBox2 = new ComboBox((Object[])((AbstractVcs[])ArrayUtil.append((Object[])allVcses, null)));
        comboBox2.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)VcsBundle.message((String)"none.vcs.presentation", (Object[])new Object[0]), AbstractVcs::getDisplayName));
        ComboBox comboBox3 = comboBox2;
        if (comboBox3 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(6);
        }
        return comboBox3;
    }

    private void addMapping() {
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.myProject, VcsBundle.message((String)"directory.mapping.add.title", (Object[])new Object[0]));
        if (dlg.showAndGet()) {
            this.addMapping(dlg.getMapping());
        }
    }

    private void addMapping(VcsDirectoryMapping mapping2) {
        ArrayList<MapInfo> items = new ArrayList<MapInfo>(this.myModel.getItems());
        items.add(MapInfo.registered(new VcsDirectoryMapping(mapping2.getDirectory(), mapping2.getVcs(), mapping2.getRootSettings()), this.isMappingValid(mapping2)));
        items.sort(MapInfo.COMPARATOR);
        this.myModel.setItems(items);
    }

    private void addSelectedUnregisteredMappings(List<MapInfo> infos) {
        ArrayList<MapInfo> items = new ArrayList<MapInfo>(this.myModel.getItems());
        for (MapInfo info2 : infos) {
            items.remove(info2);
            items.add(MapInfo.registered(info2.mapping, this.isMappingValid(info2.mapping)));
        }
        VcsDirectoryConfigurationPanel.sortAndAddSeparatorIfNeeded(items);
        this.myModel.setItems(items);
    }

    @Contract(pure=false)
    private static void sortAndAddSeparatorIfNeeded(@NotNull List<MapInfo> items) {
        if (items == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(7);
        }
        boolean hasUnregistered = false;
        boolean hasSeparator = false;
        for (MapInfo item : items) {
            if (item.type == MapInfo.Type.UNREGISTERED) {
                hasUnregistered = true;
                continue;
            }
            if (item.type != MapInfo.Type.SEPARATOR) continue;
            hasSeparator = true;
        }
        if (!hasUnregistered && hasSeparator) {
            items.remove(MapInfo.SEPARATOR);
        } else if (hasUnregistered && !hasSeparator) {
            items.add(MapInfo.SEPARATOR);
        }
        items.sort(MapInfo.COMPARATOR);
    }

    private void editMapping() {
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.myProject, VcsBundle.message((String)"directory.mapping.remove.title", (Object[])new Object[0]));
        int row2 = this.myDirectoryMappingTable.getSelectedRow();
        VcsDirectoryMapping mapping2 = ((MapInfo)this.myDirectoryMappingTable.getRow((int)row2)).mapping;
        dlg.setMapping(mapping2);
        if (dlg.showAndGet()) {
            this.setMapping(row2, dlg.getMapping());
        }
    }

    private void setMapping(int row2, @NotNull VcsDirectoryMapping mapping2) {
        if (mapping2 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(8);
        }
        ArrayList<MapInfo> items = new ArrayList<MapInfo>(this.myModel.getItems());
        items.set(row2, MapInfo.registered(mapping2, this.isMappingValid(mapping2)));
        items.sort(MapInfo.COMPARATOR);
        this.myModel.setItems(items);
    }

    private void removeMapping() {
        Collection<AbstractVcs> activeVcses = this.getActiveVcses();
        ArrayList<MapInfo> mappings = new ArrayList<MapInfo>(this.myModel.getItems());
        int index2 = this.myDirectoryMappingTable.getSelectionModel().getMinSelectionIndex();
        Collection selection = this.myDirectoryMappingTable.getSelection();
        mappings.removeAll(selection);
        List removedValidRoots = ContainerUtil.mapNotNull((Collection)selection, info2 -> info2.type == MapInfo.Type.NORMAL && this.myCheckers.get(info2.mapping.getVcs()) != null ? MapInfo.unregistered(info2.mapping) : null);
        mappings.addAll(removedValidRoots);
        VcsDirectoryConfigurationPanel.sortAndAddSeparatorIfNeeded(mappings);
        this.myModel.setItems(mappings);
        if (mappings.size() > 0) {
            if (index2 >= mappings.size()) {
                index2 = mappings.size() - 1;
            }
            this.myDirectoryMappingTable.getSelectionModel().setSelectionInterval(index2, index2);
        }
    }

    protected JComponent createMainComponent() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBag gb = new GridBag().setDefaultInsets(new Insets(0, 0, 4, 10)).setDefaultWeightX(1.0).setDefaultFill(2);
        JComponent mappingsTable = this.createMappingsTable();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 600);
        this.myLoadingPanel.add((Component)mappingsTable);
        panel2.add((Component)this.myLoadingPanel, gb.nextLine().next().fillCell().weighty(1.0));
        panel2.add((Component)this.createProjectMappingDescription(), gb.nextLine().next());
        if (!AbstractCommonUpdateAction.showsCustomNotification(Arrays.asList(this.myVcsManager.getAllActiveVcss()))) {
            panel2.add((Component)this.myScopeFilterConfig.createComponent(), gb.nextLine().next());
        }
        return panel2;
    }

    private JComponent createMappingsTable() {
        JPanel panelForTable = ToolbarDecorator.createDecorator(this.myDirectoryMappingTable, null).setAddActionUpdater(e -> !this.myIsDisabled && this.rootsOfOneKindInSelection()).setAddAction(button4 -> {
            List<MapInfo> unregisteredRoots = this.getSelectedUnregisteredRoots();
            if (unregisteredRoots.isEmpty()) {
                this.addMapping();
            } else {
                this.addSelectedUnregisteredMappings(unregisteredRoots);
            }
            this.updateRootCheckers();
        }).setEditActionUpdater(e -> !this.myIsDisabled && this.onlyRegisteredRootsInSelection()).setEditAction(button4 -> {
            this.editMapping();
            this.updateRootCheckers();
        }).setRemoveActionUpdater(e -> !this.myIsDisabled && this.onlyRegisteredRootsInSelection()).setRemoveAction(button4 -> {
            this.removeMapping();
            this.updateRootCheckers();
        }).disableUpDownActions().createPanel();
        panelForTable.setPreferredSize((Dimension)new JBDimension(-1, 200));
        return panelForTable;
    }

    @NotNull
    private List<MapInfo> getSelectedUnregisteredRoots() {
        List list2 = ContainerUtil.filter((Collection)this.myDirectoryMappingTable.getSelection(), info2 -> info2.type == MapInfo.Type.UNREGISTERED);
        if (list2 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private boolean rootsOfOneKindInSelection() {
        Collection selection = this.myDirectoryMappingTable.getSelection();
        if (selection.isEmpty()) {
            return true;
        }
        if (selection.size() == 1 && ((MapInfo)selection.iterator().next()).type == MapInfo.Type.SEPARATOR) {
            return true;
        }
        List<MapInfo> selectedRegisteredRoots = this.getSelectedRegisteredRoots();
        return selectedRegisteredRoots.size() == selection.size() || selectedRegisteredRoots.size() == 0;
    }

    @NotNull
    private List<MapInfo> getSelectedRegisteredRoots() {
        Collection selection = this.myDirectoryMappingTable.getSelection();
        List list2 = ContainerUtil.filter((Collection)selection, info2 -> info2.type == MapInfo.Type.NORMAL || info2.type == MapInfo.Type.INVALID);
        if (list2 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(10);
        }
        return list2;
    }

    private boolean onlyRegisteredRootsInSelection() {
        return this.getSelectedRegisteredRoots().size() == this.myDirectoryMappingTable.getSelection().size();
    }

    private JComponent createProjectMappingDescription() {
        JBLabel label2 = new JBLabel(this.myProjectMessage);
        label2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        label2.setFontColor(UIUtil.FontColor.BRIGHTER);
        label2.setBorder((Border)JBUI.Borders.empty((int)2, (int)5, (int)2, (int)0));
        return label2;
    }

    public void reset() {
        this.initializeModel();
    }

    public void apply() throws ConfigurationException {
        this.adjustIgnoredRootsSettings();
        this.myVcsManager.setDirectoryMappings(this.getModelMappings());
        this.myScopeFilterConfig.apply();
        this.initializeModel();
    }

    private void adjustIgnoredRootsSettings() {
        List<VcsDirectoryMapping> newMappings = this.getModelMappings();
        List previousMappings = this.myVcsManager.getDirectoryMappings();
        this.myVcsConfiguration.addIgnoredUnregisteredRoots((Collection)previousMappings.stream().filter(mapping2 -> !newMappings.contains(mapping2)).map(mapping2 -> mapping2.isDefaultMapping() ? ProjectUtil.guessProjectDir((Project)this.myProject).getPath() : mapping2.getDirectory()).collect(Collectors.toList()));
        this.myVcsConfiguration.removeFromIgnoredUnregisteredRoots((Collection)ContainerUtil.map(newMappings, VcsDirectoryMapping::getDirectory));
    }

    public boolean isModified() {
        if (this.myScopeFilterConfig.isModified()) {
            return true;
        }
        return !this.getModelMappings().equals(this.myVcsManager.getDirectoryMappings());
    }

    @NotNull
    private List<VcsDirectoryMapping> getModelMappings() {
        List list2 = ContainerUtil.mapNotNull((Collection)this.myModel.getItems(), info2 -> info2 == MapInfo.SEPARATOR || info2.type == MapInfo.Type.UNREGISTERED ? null : info2.mapping);
        if (list2 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(11);
        }
        return list2;
    }

    public Collection<AbstractVcs> getActiveVcses() {
        HashSet<AbstractVcs> vcses = new HashSet<AbstractVcs>();
        for (VcsDirectoryMapping mapping2 : this.getModelMappings()) {
            if (mapping2.getVcs().length() <= 0) continue;
            vcses.add(this.myVcsManager.findVcsByName(mapping2.getVcs()));
        }
        return vcses;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUnregisteredRoots";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVcsesComboBox";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUnregisteredRoots";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRegisteredRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMappingValid";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildVcsesComboBox";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sortAndAddSeparatorIfNeeded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDirectoryRenderer
    extends ColoredTableCellRenderer {
        private final Project myProject;

        MyDirectoryRenderer(Project project) {
            this.myProject = project;
        }

        protected void customizeCellRenderer(@NotNull JTable table, Object value2, boolean selected2, boolean hasFocus, int row2, int column2) {
            if (table == null) {
                MyDirectoryRenderer.$$$reportNull$$$0(0);
            }
            if (value2 instanceof MapInfo) {
                MapInfo info2 = (MapInfo)value2;
                if (!(selected2 || info2 != MapInfo.SEPARATOR && info2.type != MapInfo.Type.UNREGISTERED)) {
                    this.setBackground(UIUtil.getDecoratedRowColor());
                }
                if (info2 == MapInfo.SEPARATOR) {
                    this.append(VcsBundle.message((String)"unregistered.roots.label", (Object[])new Object[0]), VcsDirectoryConfigurationPanel.getAttributes(info2));
                    return;
                }
                if (info2.mapping.isDefaultMapping()) {
                    this.append((String)VcsDirectoryMapping.PROJECT_CONSTANT.get(), VcsDirectoryConfigurationPanel.getAttributes(info2));
                    return;
                }
                String directory = info2.mapping.getDirectory();
                VirtualFile baseDir = this.myProject.getBaseDir();
                if (baseDir != null) {
                    File directoryFile = new File(StringUtil.trimEnd((String)UriUtil.trimTrailingSlashes(directory), (String)"\\") + "/");
                    File ioBase = new File(baseDir.getPath());
                    if (directoryFile.isAbsolute() && !FileUtil.isAncestor((File)ioBase, (File)directoryFile, (boolean)false)) {
                        this.append(new File(directory).getPath(), VcsDirectoryConfigurationPanel.getAttributes(info2));
                        return;
                    }
                    String relativePath = FileUtil.getRelativePath((File)ioBase, (File)directoryFile);
                    if (".".equals(relativePath) || relativePath == null) {
                        this.append(ioBase.getPath(), VcsDirectoryConfigurationPanel.getAttributes(info2));
                    } else {
                        this.append(relativePath, VcsDirectoryConfigurationPanel.getAttributes(info2));
                        this.append(" (" + ioBase + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyDirectoryRenderer", "customizeCellRenderer"));
        }
    }

    private static final class MapInfo {
        static final MapInfo SEPARATOR = new MapInfo(new VcsDirectoryMapping("SEPARATOR", "SEP"), Type.SEPARATOR);
        static final Comparator<MapInfo> COMPARATOR = (o1, o2) -> {
            if (o1.type.isRegistered() && o2.type.isRegistered() || o1.type == Type.UNREGISTERED && o2.type == Type.UNREGISTERED) {
                return Comparing.compare((Comparable)((Object)o1.mapping.getDirectory()), (Comparable)((Object)o2.mapping.getDirectory()));
            }
            return o1.type.compareTo(o2.type);
        };
        private final Type type;
        private VcsDirectoryMapping mapping;

        static MapInfo unregistered(@NotNull VcsDirectoryMapping mapping2) {
            if (mapping2 == null) {
                MapInfo.$$$reportNull$$$0(0);
            }
            return new MapInfo(mapping2, Type.UNREGISTERED);
        }

        static MapInfo registered(@NotNull VcsDirectoryMapping mapping2, boolean valid) {
            if (mapping2 == null) {
                MapInfo.$$$reportNull$$$0(1);
            }
            return new MapInfo(mapping2, valid ? Type.NORMAL : Type.INVALID);
        }

        private MapInfo(@NotNull VcsDirectoryMapping mapping2, @NotNull Type type) {
            if (mapping2 == null) {
                MapInfo.$$$reportNull$$$0(2);
            }
            if (type == null) {
                MapInfo.$$$reportNull$$$0(3);
            }
            this.mapping = mapping2;
            this.type = type;
        }

        public String toString() {
            if (this.type == Type.SEPARATOR) {
                return "";
            }
            return this.mapping.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MapInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unregistered";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registered";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static enum Type {
            NORMAL,
            INVALID,
            SEPARATOR,
            UNREGISTERED;


            boolean isRegistered() {
                return this == NORMAL || this == INVALID;
            }
        }
    }
}

