/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.history.FileHistoryPanelImpl;
import com.intellij.openapi.vcs.history.TreeNodeOnVcsRevision;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.HtmlPanel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetailsPanel
extends HtmlPanel
implements DataProvider,
CopyProvider {
    @NotNull
    private final Project myProject;
    @NotNull
    private final StatusText myStatusText;
    @Nullable
    private List<? extends TreeNodeOnVcsRevision> mySelection;

    DetailsPanel(@NotNull Project project) {
        if (project == null) {
            DetailsPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myStatusText = new StatusText(){

            protected boolean isStatusVisible() {
                return DetailsPanel.this.mySelection == null || DetailsPanel.this.mySelection.isEmpty();
            }
        };
        this.myStatusText.setText(VcsBundle.message((String)"file.history.details.empty.status", (Object[])new Object[0]));
        this.myStatusText.attachTo((Component)this);
        this.setPreferredSize((Dimension)new JBDimension(150, 100));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myStatusText.paint((Component)this, g);
    }

    public void update(@NotNull List<? extends TreeNodeOnVcsRevision> selection) {
        if (selection == null) {
            DetailsPanel.$$$reportNull$$$0(1);
        }
        this.mySelection = selection;
        this.update();
    }

    @Override
    @NotNull
    protected String getBody() {
        if (this.mySelection == null || this.mySelection.isEmpty()) {
            return "";
        }
        boolean addRevisionInfo = this.mySelection.size() > 1;
        @Nls StringBuilder html = new StringBuilder();
        for (TreeNodeOnVcsRevision treeNodeOnVcsRevision : this.mySelection) {
            String message2 = treeNodeOnVcsRevision.getRevision().getCommitMessage();
            if (StringUtil.isEmpty((String)message2)) continue;
            if (html.length() > 0) {
                html.append("<br/><br/>");
            }
            if (addRevisionInfo) {
                String revisionInfo = FileHistoryPanelImpl.getPresentableText(treeNodeOnVcsRevision.getRevision(), false);
                html.append("<font color=\"").append(ColorUtil.toHtmlColor((Color)JBColor.gray).substring(2)).append("\">").append(FontUtil.getHtmlWithFonts(revisionInfo)).append("</font><br/>");
            }
            html.append(FontUtil.getHtmlWithFonts(IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, message2)));
        }
        String string = html.toString();
        if (string == null) {
            DetailsPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public Color getBackground() {
        return UIUtil.getEditorPaneBackground();
    }

    public void performCopy(@NotNull DataContext dataContext) {
        String selectedText;
        if (dataContext == null) {
            DetailsPanel.$$$reportNull$$$0(3);
        }
        if ((selectedText = this.getSelectedText()) == null || selectedText.isEmpty()) {
            selectedText = StringUtil.removeHtmlTags((String)this.getText());
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(selectedText));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DetailsPanel.$$$reportNull$$$0(4);
        }
        return true;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DetailsPanel.$$$reportNull$$$0(5);
        }
        return true;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DetailsPanel.$$$reportNull$$$0(6);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/DetailsPanel";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/DetailsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

