/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.ModuleVcsDetector;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "vcsManager", "Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl;", "getVcsManager", "()Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl;", "vcsManager$delegate", "Lkotlin/Lazy;", "autoDetectModuleVcsMapping", "", "module", "Lcom/intellij/openapi/module/Module;", "autoDetectVcsMappings", "tryMapPieces", "", "getMappings", "", "Lcom/intellij/openapi/vcs/VcsDirectoryMapping;", "MyModulesListener", "MyPostStartUpActivity", "intellij.platform.vcs.impl"})
public final class ModuleVcsDetector {
    private final Lazy vcsManager$delegate;
    private final Project project;

    private final ProjectLevelVcsManagerImpl getVcsManager() {
        Lazy lazy = this.vcsManager$delegate;
        ModuleVcsDetector moduleVcsDetector = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ProjectLevelVcsManagerImpl)((Object)lazy.getValue());
    }

    /*
     * WARNING - void declaration
     */
    private final void autoDetectVcsMappings(boolean tryMapPieces) {
        Iterable $this$map$iv;
        if (this.getVcsManager().haveDefaultMapping() != null) {
            return;
        }
        boolean bl = false;
        Set usedVcses = new LinkedHashSet();
        boolean bl2 = false;
        Set detectedRoots = new LinkedHashSet();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Object[] objectArray = moduleManager.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ModuleManager.getInstance(project).modules");
        List roots2 = SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)autoDetectVcsMappings.roots.1.INSTANCE), (Function1)autoDetectVcsMappings.roots.2.INSTANCE)));
        for (VirtualFile root2 : roots2) {
            AbstractVcs moduleVcs = this.getVcsManager().findVersioningVcs(root2);
            if (moduleVcs != null) {
                detectedRoots.add(new Pair((Object)root2, (Object)moduleVcs));
            }
            usedVcses.add(moduleVcs);
        }
        AbstractVcs commonVcs = (AbstractVcs)CollectionsKt.singleOrNull((Iterable)usedVcses);
        if (commonVcs != null) {
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv;
            $this$map$iv = roots2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                void v2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                String string = v2.getPath();
                collection.add(string);
            }
            Set rootPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            List<VcsDirectoryMapping> list2 = this.getVcsManager().getDirectoryMappings();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"vcsManager.directoryMappings");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VcsDirectoryMapping it = (VcsDirectoryMapping)element$iv$iv;
                boolean bl4 = false;
                VcsDirectoryMapping vcsDirectoryMapping = it;
                Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping, (String)"it");
                if (!(!rootPaths.contains(vcsDirectoryMapping.getDirectory()))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List additionalMappings = (List)destination$iv$iv2;
            this.getVcsManager().setAutoDirectoryMappings(CollectionsKt.plus((Collection)additionalMappings, (Object)VcsDirectoryMapping.createDefault((String)commonVcs.getName())));
        } else if (tryMapPieces) {
            void $this$mapTo$iv$iv;
            $this$map$iv = detectedRoots;
            boolean $i$f$map = false;
            Iterable $i$f$filter = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void root3;
                void $dstr$root$vcs;
                Pair element$iv$iv = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                VirtualFile bl4 = (VirtualFile)$dstr$root$vcs.component1();
                AbstractVcs vcs = (AbstractVcs)$dstr$root$vcs.component2();
                VcsDirectoryMapping vcsDirectoryMapping = new VcsDirectoryMapping(root3.getPath(), vcs.getName());
                collection.add(vcsDirectoryMapping);
            }
            List newMappings = (List)destination$iv$iv;
            ProjectLevelVcsManagerImpl projectLevelVcsManagerImpl = this.getVcsManager();
            List<VcsDirectoryMapping> list3 = this.getVcsManager().getDirectoryMappings();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"vcsManager.directoryMappings");
            projectLevelVcsManagerImpl.setAutoDirectoryMappings(CollectionsKt.plus((Collection)list3, (Iterable)newMappings));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void autoDetectModuleVcsMapping(Module module) {
        void $this$filterTo$iv$iv;
        if (this.getVcsManager().haveDefaultMapping() != null) {
            return;
        }
        boolean bl = false;
        List newMappings = new ArrayList();
        VirtualFile[] virtualFileArray = ProjectUtil.getRootManager((Module)module).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"module.rootManager.contentRoots");
        VirtualFile[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var8_10 = $this$filterTo$iv$iv;
        int n = ((void)var8_10).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var8_10[j];
            boolean bl2 = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            if (!v1.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file2 = (VirtualFile)element$iv;
            boolean bl3 = false;
            AbstractVcs vcs = this.getVcsManager().findVersioningVcs(file2);
            if (vcs == null || vcs == this.getVcsManager().getVcsFor(file2)) continue;
            VirtualFile virtualFile2 = file2;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file");
            newMappings.add(new VcsDirectoryMapping(virtualFile2.getPath(), vcs.getName()));
        }
        Collection collection = newMappings;
        boolean bl4 = false;
        if (!collection.isEmpty()) {
            ProjectLevelVcsManagerImpl projectLevelVcsManagerImpl = this.getVcsManager();
            List<VcsDirectoryMapping> list2 = this.getVcsManager().getDirectoryMappings();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"vcsManager.directoryMappings");
            projectLevelVcsManagerImpl.setAutoDirectoryMappings(CollectionsKt.plus((Collection)list2, (Iterable)newMappings));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<VcsDirectoryMapping> getMappings(Module module) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        VirtualFile[] virtualFileArray = ProjectUtil.getRootManager((Module)module).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"module.rootManager.contentRoots");
        VirtualFile[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var7_7[j];
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            if (!v1.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VcsDirectoryMapping vcsDirectoryMapping;
            Object v6;
            block3: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                VirtualFile root2 = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                List<VcsDirectoryMapping> list2 = this.getVcsManager().getDirectoryMappings();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"vcsManager.directoryMappings");
                Iterable $this$firstOrNull$iv = list2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    VcsDirectoryMapping it = (VcsDirectoryMapping)element$iv;
                    boolean bl3 = false;
                    VcsDirectoryMapping vcsDirectoryMapping2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping2, (String)"it");
                    String string = vcsDirectoryMapping2.getDirectory();
                    VirtualFile virtualFile2 = root2;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"root");
                    if (!Intrinsics.areEqual((Object)string, (Object)virtualFile2.getPath())) continue;
                    v6 = element$iv;
                    break block3;
                }
                v6 = null;
            }
            if ((VcsDirectoryMapping)v6 == null) continue;
            boolean bl = false;
            boolean bl4 = false;
            VcsDirectoryMapping it$iv$iv = vcsDirectoryMapping;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public ModuleVcsDetector(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.vcsManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<ProjectLevelVcsManagerImpl>(this){
            final /* synthetic */ ModuleVcsDetector this$0;

            @NotNull
            public final ProjectLevelVcsManagerImpl invoke() {
                ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)ModuleVcsDetector.access$getProject$p(this.this$0));
                if (projectLevelVcsManager == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl");
                }
                return (ProjectLevelVcsManagerImpl)projectLevelVcsManager;
            }
            {
                this.this$0 = moduleVcsDetector;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ Project access$getProject$p(ModuleVcsDetector $this) {
        return $this.project;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector$MyPostStartUpActivity;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class MyPostStartUpActivity
    implements StartupActivity.DumbAware {
        public void runActivity(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(ModuleVcsDetector.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            ModuleVcsDetector vcsDetector = (ModuleVcsDetector)object;
            MyModulesListener listener2 = vcsDetector.new MyModulesListener();
            MessageBusConnection messageBusConnection2 = project.getMessageBus().connect();
            Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection2, (String)"project.messageBus.connect()");
            MessageBusConnection busConnection = messageBusConnection2;
            busConnection.subscribe(ProjectTopics.MODULES, (Object)listener2);
            busConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)listener2);
            busConnection.subscribe(AdditionalLibraryRootsListener.TOPIC, (Object)listener2);
            if (vcsDetector.getVcsManager().needAutodetectMappings()) {
                vcsDetector.autoDetectVcsMappings(true);
            }
        }

        public MyPostStartUpActivity() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"ExtensionNotApplicableException.INSTANCE");
                throw (Throwable)extensionNotApplicableException;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J?\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00152\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00152\u000b\u0010\u0018\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u001b\u001a\u00020\tH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector$MyModulesListener;", "Lcom/intellij/openapi/roots/ModuleRootListener;", "Lcom/intellij/openapi/project/ModuleListener;", "Lcom/intellij/openapi/roots/AdditionalLibraryRootsListener;", "(Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector;)V", "myMappingsForRemovedModules", "", "Lcom/intellij/openapi/vcs/VcsDirectoryMapping;", "beforeModuleRemoved", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "beforeRootsChange", "event", "Lcom/intellij/openapi/roots/ModuleRootEvent;", "libraryRootsChanged", "presentableLibraryName", "", "oldRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "newRoots", "libraryNameForDebug", "Lorg/jetbrains/annotations/NotNull;", "moduleAdded", "onRootsChanged", "rootsChanged", "intellij.platform.vcs.impl"})
    private final class MyModulesListener
    implements ModuleRootListener,
    ModuleListener,
    AdditionalLibraryRootsListener {
        private final List<VcsDirectoryMapping> myMappingsForRemovedModules;

        public void beforeRootsChange(@NotNull ModuleRootEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.myMappingsForRemovedModules.clear();
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.onRootsChanged();
        }

        private final void onRootsChanged() {
            Iterable $this$forEach$iv = this.myMappingsForRemovedModules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VcsDirectoryMapping mapping2 = (VcsDirectoryMapping)element$iv;
                boolean bl = false;
                ModuleVcsDetector.this.getVcsManager().removeDirectoryMapping(mapping2);
            }
            if (ModuleVcsDetector.this.getVcsManager().needAutodetectMappings()) {
                ModuleVcsDetector.this.autoDetectVcsMappings(false);
            }
        }

        public void moduleAdded(@NotNull Project project, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.myMappingsForRemovedModules.removeAll(ModuleVcsDetector.this.getMappings(module));
            ModuleVcsDetector.this.autoDetectModuleVcsMapping(module);
        }

        public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.myMappingsForRemovedModules.addAll(ModuleVcsDetector.this.getMappings(module));
        }

        public void libraryRootsChanged(@Nullable String presentableLibraryName, @NotNull Collection<? extends VirtualFile> oldRoots, @NotNull Collection<? extends VirtualFile> newRoots, @NotNull String libraryNameForDebug) {
            Intrinsics.checkNotNullParameter(oldRoots, (String)"oldRoots");
            Intrinsics.checkNotNullParameter(newRoots, (String)"newRoots");
            Intrinsics.checkNotNullParameter((Object)libraryNameForDebug, (String)"libraryNameForDebug");
            this.onRootsChanged();
        }

        public MyModulesListener() {
            boolean bl = false;
            this.myMappingsForRemovedModules = new ArrayList();
        }
    }
}

