/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyDirectoryImpl;
import com.intellij.openapi.vfs.ex.dummy.DummyFileBase;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

class DummyFileImpl
extends DummyFileBase {
    private byte[] myContents;
    private long myModificationStamp;

    DummyFileImpl(@NotNull DummyFileSystem fileSystem, @NotNull DummyDirectoryImpl parent, @NotNull String name2) {
        if (fileSystem == null) {
            DummyFileImpl.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            DummyFileImpl.$$$reportNull$$$0(1);
        }
        if (name2 == null) {
            DummyFileImpl.$$$reportNull$$$0(2);
        }
        super(fileSystem, parent, name2);
        this.myContents = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        this.myModificationStamp = LocalTimeCounter.currentTime();
    }

    public boolean isDirectory() {
        return false;
    }

    public long getLength() {
        return this.myContents.length;
    }

    public VirtualFile[] getChildren() {
        return null;
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        InputStream inputStream2 = VfsUtilCore.byteStreamSkippingBOM((byte[])this.myContents, (VirtualFile)this);
        if (inputStream2 == null) {
            DummyFileImpl.$$$reportNull$$$0(3);
        }
        return inputStream2;
    }

    @NotNull
    public OutputStream getOutputStream(final Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM((OutputStream)new ByteArrayOutputStream(){

            @Override
            public void close() {
                DummyFileSystem fs = (DummyFileSystem)DummyFileImpl.this.getFileSystem();
                fs.fireBeforeContentsChange(requestor, DummyFileImpl.this);
                long oldModStamp = DummyFileImpl.this.myModificationStamp;
                DummyFileImpl.this.myContents = this.toByteArray();
                DummyFileImpl.this.myModificationStamp = newModificationStamp >= 0L ? newModificationStamp : LocalTimeCounter.currentTime();
                fs.fireContentsChanged(requestor, DummyFileImpl.this, oldModStamp);
            }
        }, (VirtualFile)this);
        if (outputStream == null) {
            DummyFileImpl.$$$reportNull$$$0(4);
        }
        return outputStream;
    }

    public byte @NotNull [] contentsToByteArray() throws IOException {
        if (this.myContents == null) {
            DummyFileImpl.$$$reportNull$$$0(5);
        }
        return this.myContents;
    }

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    public void setModificationStamp(long modificationStamp, Object requestor) {
        this.myModificationStamp = modificationStamp;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/ex/dummy/DummyFileImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/ex/dummy/DummyFileImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

