/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.local.CanonicalPathMap;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.WatchRootsUtil;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.jetbrains.annotations.SystemIndependent;

final class WatchRootsManager {
    private static final Logger LOG = Logger.getInstance(WatchRootsManager.class);
    private final FileWatcher myFileWatcher;
    private final NavigableMap<String, List<LocalFileSystem.WatchRequest>> myRecursiveWatchRoots;
    private final NavigableMap<String, List<LocalFileSystem.WatchRequest>> myFlatWatchRoots;
    private final NavigableSet<String> myOptimizedRecursiveWatchRoots;
    private final NavigableMap<String, SymlinkData> mySymlinksByPath;
    private final Int2ObjectMap<SymlinkData> mySymlinksById;
    private final NavigableSet<Pair<String, String>> myPathMappings;
    private boolean myWatcherRequiresUpdate;
    private final Object myLock;

    WatchRootsManager(@NotNull FileWatcher fileWatcher, @NotNull Disposable parent) {
        if (fileWatcher == null) {
            WatchRootsManager.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            WatchRootsManager.$$$reportNull$$$0(1);
        }
        this.myRecursiveWatchRoots = WatchRootsUtil.createFileNavigableMap();
        this.myFlatWatchRoots = WatchRootsUtil.createFileNavigableMap();
        this.myOptimizedRecursiveWatchRoots = WatchRootsUtil.createFileNavigableSet();
        this.mySymlinksByPath = WatchRootsUtil.createFileNavigableMap();
        this.mySymlinksById = new Int2ObjectOpenHashMap();
        this.myPathMappings = WatchRootsUtil.createMappingsNavigableSet();
        this.myLock = new Object();
        this.myFileWatcher = fileWatcher;
        ApplicationManager.getApplication().getMessageBus().connect(parent).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                Object object = WatchRootsManager.this.myLock;
                synchronized (object) {
                    if (WatchRootsManager.this.myWatcherRequiresUpdate) {
                        WatchRootsManager.this.updateFileWatcher();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/impl/local/WatchRootsManager$1", "after"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> requestsToRemove, @NotNull Collection<String> recursiveRootsToAdd, @NotNull Collection<String> flatRootsToAdd) {
        if (requestsToRemove == null) {
            WatchRootsManager.$$$reportNull$$$0(2);
        }
        if (recursiveRootsToAdd == null) {
            WatchRootsManager.$$$reportNull$$$0(3);
        }
        if (flatRootsToAdd == null) {
            WatchRootsManager.$$$reportNull$$$0(4);
        }
        HashSet<LocalFileSystem.WatchRequest> recursiveRequestsToRemove = new HashSet<LocalFileSystem.WatchRequest>();
        HashSet<LocalFileSystem.WatchRequest> flatRequestsToRemove = new HashSet<LocalFileSystem.WatchRequest>();
        requestsToRemove.forEach(req -> (req.isToWatchRecursively() ? recursiveRequestsToRemove : flatRequestsToRemove).add(req));
        HashSet<LocalFileSystem.WatchRequest> result2 = new HashSet<LocalFileSystem.WatchRequest>(recursiveRootsToAdd.size() + flatRootsToAdd.size());
        Object object = this.myLock;
        synchronized (object) {
            this.updateWatchRoots(recursiveRootsToAdd, recursiveRequestsToRemove, result2, this.myRecursiveWatchRoots, true);
            this.updateWatchRoots(flatRootsToAdd, flatRequestsToRemove, result2, this.myFlatWatchRoots, false);
            if (this.myWatcherRequiresUpdate) {
                this.updateFileWatcher();
            }
        }
        HashSet<LocalFileSystem.WatchRequest> hashSet = result2;
        if (hashSet == null) {
            WatchRootsManager.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.myLock;
        synchronized (object) {
            this.myRecursiveWatchRoots.clear();
            this.myOptimizedRecursiveWatchRoots.clear();
            this.myFlatWatchRoots.clear();
            this.myPathMappings.clear();
            this.mySymlinksById.values().forEach(SymlinkData::clear);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSymlink(int fileId, @NotNull String linkPath, @Nullable String linkTarget) {
        if (linkPath == null) {
            WatchRootsManager.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            SymlinkData data2 = (SymlinkData)this.mySymlinksById.get(fileId);
            if (data2 != null) {
                if (FileUtil.pathsEqual((String)data2.path, (String)linkPath) && FileUtil.pathsEqual((String)data2.target, (String)linkTarget)) {
                    return;
                }
                this.mySymlinksById.remove(fileId);
                this.mySymlinksByPath.remove(data2.path);
                data2.removeRequest(this);
            }
            data2 = new SymlinkData(fileId, linkPath, linkTarget);
            SymlinkData existing = (SymlinkData)this.mySymlinksByPath.get(linkPath);
            if (existing != null) {
                LOG.error("Path conflict. Existing symlink: " + existing + " vs. new symlink: " + data2);
                return;
            }
            this.mySymlinksByPath.put(data2.path, data2);
            this.mySymlinksById.put(data2.id, (Object)data2);
            if (data2.hasValidTarget() && WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, data2.path)) {
                this.addWatchSymlinkRequest(data2.getWatchRequest());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSymlink(int fileId) {
        Object object = this.myLock;
        synchronized (object) {
            SymlinkData data2 = (SymlinkData)this.mySymlinksById.remove(fileId);
            if (data2 != null) {
                this.mySymlinksByPath.remove(data2.path);
                data2.removeRequest(this);
            }
        }
    }

    private void updateFileWatcher() {
        this.myFileWatcher.setWatchRoots(() -> {
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myWatcherRequiresUpdate) {
                    return null;
                }
                this.myWatcherRequiresUpdate = false;
                return WatchRootsManager.createCanonicalPathMap(this.myFlatWatchRoots.navigableKeySet(), this.myOptimizedRecursiveWatchRoots, this.myPathMappings, File.separatorChar == '\\');
            }
        });
    }

    @NotNull
    static CanonicalPathMap createCanonicalPathMap(@NotNull Set<String> flatWatchRoots, @NotNull Set<String> optimizedRecursiveWatchRoots, @NotNull Collection<Pair<String, String>> pathMappings, boolean convertToForwardSlashes) {
        if (flatWatchRoots == null) {
            WatchRootsManager.$$$reportNull$$$0(7);
        }
        if (optimizedRecursiveWatchRoots == null) {
            WatchRootsManager.$$$reportNull$$$0(8);
        }
        if (pathMappings == null) {
            WatchRootsManager.$$$reportNull$$$0(9);
        }
        NavigableSet<@SystemDependent String> optimizedRecursiveWatchRootsCopy = WatchRootsUtil.createFileNavigableSet();
        ArrayList<Pair<@SystemDependent String, @SystemDependent String>> initialMappings = new ArrayList<Pair<String, String>>(pathMappings.size());
        if (!convertToForwardSlashes) {
            optimizedRecursiveWatchRootsCopy.addAll(optimizedRecursiveWatchRoots);
            initialMappings.addAll(pathMappings);
        } else {
            for (String string : optimizedRecursiveWatchRoots) {
                optimizedRecursiveWatchRootsCopy.add(string.replace('/', '\\'));
            }
            for (Pair pair : pathMappings) {
                initialMappings.add((Pair<String, String>)new Pair((Object)((String)pair.first).replace('/', '\\'), (Object)((String)pair.second).replace('/', '\\')));
            }
        }
        NavigableSet<@SystemDependent String> optimizedFlatWatchRoots = WatchRootsUtil.optimizeFlatRoots(flatWatchRoots, optimizedRecursiveWatchRootsCopy, convertToForwardSlashes);
        return new CanonicalPathMap(optimizedRecursiveWatchRootsCopy, optimizedFlatWatchRoots, initialMappings);
    }

    private void updateWatchRoots(@NotNull Collection<String> rootsToAdd, @NotNull Set<LocalFileSystem.WatchRequest> requestsToRemove, @NotNull Set<LocalFileSystem.WatchRequest> result2, @NotNull Map<String, List<LocalFileSystem.WatchRequest>> roots2, boolean recursiveWatchRoots) {
        if (rootsToAdd == null) {
            WatchRootsManager.$$$reportNull$$$0(10);
        }
        if (requestsToRemove == null) {
            WatchRootsManager.$$$reportNull$$$0(11);
        }
        if (result2 == null) {
            WatchRootsManager.$$$reportNull$$$0(12);
        }
        if (roots2 == null) {
            WatchRootsManager.$$$reportNull$$$0(13);
        }
        SmartList watchSymlinkRequestsToAdd = new SmartList();
        for (String root2 : rootsToAdd) {
            String watchRoot = WatchRootsManager.prepareWatchRoot(root2);
            if (watchRoot == null) continue;
            List requests2 = roots2.computeIfAbsent(watchRoot, key -> new SmartList());
            boolean foundSameRequest = false;
            if (!requestsToRemove.isEmpty()) {
                for (LocalFileSystem.WatchRequest currentRequest : requests2) {
                    if (!requestsToRemove.remove(currentRequest)) continue;
                    foundSameRequest = true;
                    result2.add(currentRequest);
                }
            }
            if (foundSameRequest) continue;
            WatchRequestImpl newRequest = new WatchRequestImpl(watchRoot, recursiveWatchRoots);
            requests2.add(newRequest);
            result2.add(newRequest);
            if (recursiveWatchRoots) {
                this.collectSymlinkRequests(newRequest, (Collection<WatchSymlinkRequest>)watchSymlinkRequestsToAdd);
            }
            if (requests2.size() != 1 || WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, watchRoot)) continue;
            this.myWatcherRequiresUpdate = true;
            if (!recursiveWatchRoots) continue;
            WatchRootsUtil.insertRecursivePath(this.myOptimizedRecursiveWatchRoots, watchRoot);
        }
        SmartList watchSymlinkRequestsToRemove = new SmartList();
        for (LocalFileSystem.WatchRequest request2 : requestsToRemove) {
            this.removeWatchRequest(request2);
            if (!recursiveWatchRoots) continue;
            this.collectSymlinkRequests((WatchRequestImpl)request2, (Collection<WatchSymlinkRequest>)watchSymlinkRequestsToRemove);
        }
        if (recursiveWatchRoots) {
            this.addWatchSymlinkRequests((List<WatchSymlinkRequest>)watchSymlinkRequestsToAdd);
            this.removeWatchSymlinkRequests((List<WatchSymlinkRequest>)watchSymlinkRequestsToRemove);
        }
    }

    @Nullable
    private static String prepareWatchRoot(@NotNull String root2) {
        int index2;
        if (root2 == null) {
            WatchRootsManager.$$$reportNull$$$0(14);
        }
        if ((index2 = root2.indexOf("!/")) >= 0) {
            root2 = root2.substring(0, index2);
        }
        try {
            Path rootPath = Paths.get(FileUtil.toSystemDependentName((String)root2), new String[0]);
            if (!rootPath.isAbsolute()) {
                throw new InvalidPathException(root2, "Watch roots should be absolute");
            }
            return FileUtil.toSystemIndependentName((String)rootPath.toString());
        }
        catch (InvalidPathException e) {
            LOG.warn("invalid watch root", (Throwable)e);
            return null;
        }
    }

    private void removeWatchRequest(@NotNull LocalFileSystem.WatchRequest request2) {
        if (request2 == null) {
            WatchRootsManager.$$$reportNull$$$0(15);
        }
        String watchRoot = request2.getRootPath();
        NavigableMap<String, List<LocalFileSystem.WatchRequest>> roots2 = request2.isToWatchRecursively() ? this.myRecursiveWatchRoots : this.myFlatWatchRoots;
        List requests2 = (List)roots2.get(watchRoot);
        if (requests2 != null) {
            requests2.remove(request2);
            if (requests2.isEmpty()) {
                roots2.remove(watchRoot);
                if (request2.isToWatchRecursively()) {
                    if (WatchRootsUtil.removeRecursivePath(this.myOptimizedRecursiveWatchRoots, this.myRecursiveWatchRoots, watchRoot)) {
                        this.myWatcherRequiresUpdate = true;
                    }
                } else if (!WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, watchRoot)) {
                    this.myWatcherRequiresUpdate = true;
                }
            }
        }
    }

    private void addWatchSymlinkRequests(@NotNull List<WatchSymlinkRequest> watchSymlinkRequestsToAdd) {
        if (watchSymlinkRequestsToAdd == null) {
            WatchRootsManager.$$$reportNull$$$0(16);
        }
        for (WatchSymlinkRequest request2 : watchSymlinkRequestsToAdd) {
            if (request2.getRootPath().isEmpty() || request2.isRegistered()) continue;
            this.addWatchSymlinkRequest(request2);
        }
    }

    private void addWatchSymlinkRequest(@NotNull WatchSymlinkRequest request2) {
        if (request2 == null) {
            WatchRootsManager.$$$reportNull$$$0(17);
        }
        String watchRoot = request2.getRootPath();
        NavigableMap<String, List<LocalFileSystem.WatchRequest>> roots2 = request2.isToWatchRecursively() ? this.myRecursiveWatchRoots : this.myFlatWatchRoots;
        List requests2 = roots2.computeIfAbsent(watchRoot, key -> new SmartList());
        requests2.add(request2);
        if (requests2.size() == 1 && !WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, watchRoot) && request2.isToWatchRecursively()) {
            WatchRootsUtil.insertRecursivePath(this.myOptimizedRecursiveWatchRoots, watchRoot);
        }
        if (request2.setRegistered(true)) {
            this.myWatcherRequiresUpdate = true;
            this.myPathMappings.add((Pair<String, String>)new Pair((Object)watchRoot, (Object)request2.getOriginalPath()));
        }
    }

    private void removeWatchSymlinkRequests(@NotNull List<WatchSymlinkRequest> watchSymlinkRequestsToRemove) {
        if (watchSymlinkRequestsToRemove == null) {
            WatchRootsManager.$$$reportNull$$$0(18);
        }
        for (WatchSymlinkRequest request2 : watchSymlinkRequestsToRemove) {
            Ref remove2 = new Ref((Object)true);
            WatchRootsUtil.forEachPathSegment(request2.getOriginalPath(), '/', path2 -> {
                List requests2 = (List)this.myRecursiveWatchRoots.get(path2);
                if (requests2 != null && ContainerUtil.findInstance((Iterable)requests2, WatchRequestImpl.class) != null) {
                    remove2.set((Object)false);
                    return false;
                }
                return true;
            });
            if (!((Boolean)remove2.get()).booleanValue()) continue;
            this.removeWatchSymlinkRequest(request2);
        }
    }

    private void removeWatchSymlinkRequest(@NotNull WatchSymlinkRequest request2) {
        if (request2 == null) {
            WatchRootsManager.$$$reportNull$$$0(19);
        }
        if (!request2.isRegistered()) {
            return;
        }
        this.removeWatchRequest(request2);
        if (request2.setRegistered(false)) {
            this.myPathMappings.remove(new Pair((Object)request2.getRootPath(), (Object)request2.getOriginalPath()));
            this.myWatcherRequiresUpdate = true;
        }
    }

    private void collectSymlinkRequests(@NotNull WatchRequestImpl newRequest, @NotNull Collection<WatchSymlinkRequest> watchSymlinkRequestsToAdd) {
        if (newRequest == null) {
            WatchRootsManager.$$$reportNull$$$0(20);
        }
        if (watchSymlinkRequestsToAdd == null) {
            WatchRootsManager.$$$reportNull$$$0(21);
        }
        assert (newRequest.isToWatchRecursively()) : newRequest;
        WatchRootsUtil.collectByPrefix(this.mySymlinksByPath, newRequest.getRootPath(), e -> {
            if (((SymlinkData)e.getValue()).hasValidTarget()) {
                watchSymlinkRequestsToAdd.add(((SymlinkData)e.getValue()).getWatchRequest());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileWatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestsToRemove";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursiveRootsToAdd";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flatRootsToAdd";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/WatchRootsManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flatWatchRoots";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optimizedRecursiveWatchRoots";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToAdd";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchSymlinkRequestsToAdd";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchSymlinkRequestsToRemove";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/WatchRootsManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWatchedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceWatchedRoots";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateSymlink";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCanonicalPathMap";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateWatchRoots";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareWatchRoot";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeWatchRequest";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addWatchSymlinkRequests";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addWatchSymlinkRequest";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeWatchSymlinkRequests";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeWatchSymlinkRequest";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectSymlinkRequests";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SymlinkData {
        final int id;
        @NotNull
        final @SystemIndependent String path;
        @Nullable
        final @SystemIndependent String target;
        private WatchSymlinkRequest myWatchRequest;

        SymlinkData(int id2, @NotNull String path2, @Nullable String target2) {
            if (path2 == null) {
                SymlinkData.$$$reportNull$$$0(0);
            }
            this.id = id2;
            this.path = FileUtil.toSystemIndependentName((String)path2);
            this.target = target2 != null ? FileUtil.toSystemIndependentName((String)target2) : null;
        }

        @NotNull
        WatchSymlinkRequest getWatchRequest() {
            assert (this.hasValidTarget());
            if (this.myWatchRequest == null) {
                this.myWatchRequest = new WatchSymlinkRequest(this, true);
            }
            WatchSymlinkRequest watchSymlinkRequest = this.myWatchRequest;
            if (watchSymlinkRequest == null) {
                SymlinkData.$$$reportNull$$$0(1);
            }
            return watchSymlinkRequest;
        }

        boolean hasValidTarget() {
            return this.target != null;
        }

        void removeRequest(@NotNull WatchRootsManager manager2) {
            if (manager2 == null) {
                SymlinkData.$$$reportNull$$$0(2);
            }
            if (this.myWatchRequest != null) {
                manager2.removeWatchSymlinkRequest(this.myWatchRequest);
                this.myWatchRequest = null;
            }
        }

        void clear() {
            this.myWatchRequest = null;
        }

        public String toString() {
            return "SymlinkData{" + this.id + ", " + this.path + " -> " + this.target + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/impl/local/WatchRootsManager$SymlinkData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/impl/local/WatchRootsManager$SymlinkData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWatchRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRequest";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class WatchSymlinkRequest
    implements LocalFileSystem.WatchRequest {
        private final SymlinkData mySymlinkData;
        private final boolean myWatchRecursively;
        private boolean myRegistered;

        WatchSymlinkRequest(@NotNull SymlinkData data2, boolean watchRecursively) {
            if (data2 == null) {
                WatchSymlinkRequest.$$$reportNull$$$0(0);
            }
            this.myRegistered = false;
            this.mySymlinkData = data2;
            assert (this.mySymlinkData.hasValidTarget());
            this.myWatchRecursively = watchRecursively;
        }

        boolean isRegistered() {
            return this.myRegistered;
        }

        boolean setRegistered(boolean registered) {
            if (this.myRegistered != registered) {
                this.myRegistered = registered;
                return true;
            }
            return false;
        }

        @NotNull
        public @SystemIndependent String getRootPath() {
            String string = Objects.requireNonNull(this.mySymlinkData.target);
            if (string == null) {
                WatchSymlinkRequest.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isToWatchRecursively() {
            return this.myWatchRecursively;
        }

        String getOriginalPath() {
            return this.mySymlinkData.path;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/impl/local/WatchRootsManager$WatchSymlinkRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/impl/local/WatchRootsManager$WatchSymlinkRequest";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class WatchRequestImpl
    implements LocalFileSystem.WatchRequest {
        private final String myFSRootPath;
        private final boolean myWatchRecursively;

        WatchRequestImpl(@NotNull String rootPath, boolean watchRecursively) {
            if (rootPath == null) {
                WatchRequestImpl.$$$reportNull$$$0(0);
            }
            this.myFSRootPath = rootPath;
            this.myWatchRecursively = watchRecursively;
        }

        @NotNull
        public @SystemIndependent String getRootPath() {
            String string = this.myFSRootPath;
            if (string == null) {
                WatchRequestImpl.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isToWatchRecursively() {
            return this.myWatchRecursively;
        }

        public String toString() {
            return this.getRootPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/impl/local/WatchRootsManager$WatchRequestImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/impl/local/WatchRootsManager$WatchRequestImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

