/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.FrequentEventDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.CompoundVFileEvent;
import com.intellij.openapi.vfs.newvfs.LocalFileSystemRefreshWorker;
import com.intellij.openapi.vfs.newvfs.RefreshProgress;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.RefreshSessionImpl;
import com.intellij.openapi.vfs.newvfs.RefreshWorker;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.EDT;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class RefreshQueueImpl
extends RefreshQueue
implements Disposable {
    private static final Logger LOG = Logger.getInstance(RefreshQueueImpl.class);
    private final Executor myQueue = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"RefreshQueue Pool", (Executor)AppExecutorUtil.getAppExecutorService(), (int)1, (Disposable)this);
    private final Executor myEventProcessingQueue = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Async Refresh Event Processing", (Executor)AppExecutorUtil.getAppExecutorService(), (int)1, (Disposable)this);
    private final ProgressIndicator myRefreshIndicator = RefreshProgress.create(IdeCoreBundle.message((String)"file.synchronize.progress", (Object[])new Object[0]));
    private int myBusyThreads;
    private final Long2ObjectMap<RefreshSessionImpl> mySessions = new Long2ObjectOpenHashMap();
    private final FrequentEventDetector myEventCounter = new FrequentEventDetector(100, 100, FrequentEventDetector.Level.WARN);

    void execute(@NotNull RefreshSessionImpl session2) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(0);
        }
        if (session2.isAsynchronous()) {
            this.queueSessionAsync(session2, session2.getModality());
        } else {
            Application app2 = ApplicationManager.getApplication();
            if (app2.isWriteThread()) {
                this.queueSessionSync(session2);
            } else {
                if (((ApplicationEx)app2).holdsReadLock() || EDT.isCurrentThreadEdt()) {
                    LOG.error("Do not perform a synchronous refresh under read lock (except from EDT) - causes deadlocks if there are events to fire.");
                    return;
                }
                this.queueSessionAsync(session2, ModalityState.defaultModalityState());
                session2.waitFor();
            }
        }
    }

    private void queueSessionSync(@NotNull RefreshSessionImpl session2) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(1);
        }
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        this.executeRefreshSession(session2);
        RefreshQueueImpl.fireEventsSync(session2);
    }

    private static void fireEventsSync(@NotNull RefreshSessionImpl session2) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(2);
        }
        session2.fireEvents(ContainerUtil.map(session2.getEvents(), e -> new CompoundVFileEvent((VFileEvent)e)), Collections.emptyList(), false);
    }

    private void queueSessionAsync(@NotNull RefreshSessionImpl session2, @NotNull ModalityState modality) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(3);
        }
        if (modality == null) {
            RefreshQueueImpl.$$$reportNull$$$0(4);
        }
        this.myQueue.execute(() -> this.executeSession(session2, modality));
        this.myEventCounter.eventHappened((Object)session2);
    }

    private void executeSession(@NotNull RefreshSessionImpl session2, @NotNull ModalityState modality) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(5);
        }
        if (modality == null) {
            RefreshQueueImpl.$$$reportNull$$$0(6);
        }
        this.startRefreshActivity();
        try {
            HeavyProcessLatch.INSTANCE.performOperation(HeavyProcessLatch.Type.Syncing, IdeCoreBundle.message((String)"progress.title.doing.file.refresh.0", (Object[])new Object[]{session2}), () -> this.executeRefreshSession(session2));
        }
        finally {
            this.finishRefreshActivity();
            this.fireEventsAsync(session2, modality);
        }
    }

    private void fireEventsAsync(@NotNull RefreshSessionImpl session2, @NotNull ModalityState modality) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(7);
        }
        if (modality == null) {
            RefreshQueueImpl.$$$reportNull$$$0(8);
        }
        if (RefreshQueueImpl.isAsyncEventProcessingEnabled()) {
            this.scheduleAsynchronousPreprocessing(session2, modality);
        } else {
            AppUIExecutor.onWriteThread((ModalityState)modality).later().submit(() -> RefreshQueueImpl.fireEventsSync(session2));
        }
    }

    private static boolean isAsyncEventProcessingEnabled() {
        return Registry.is((String)"vfs.async.event.processing");
    }

    private void scheduleAsynchronousPreprocessing(@NotNull RefreshSessionImpl session2, @NotNull ModalityState modality) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(9);
        }
        if (modality == null) {
            RefreshQueueImpl.$$$reportNull$$$0(10);
        }
        this.startRefreshActivity();
        ReadAction.nonBlocking(() -> RefreshQueueImpl.runAsyncListeners(session2)).expireWith((Disposable)this).wrapProgress(this.myRefreshIndicator).finishOnUiThread(modality, Runnable::run).submit(this.myEventProcessingQueue).onProcessed(__ -> this.finishRefreshActivity()).onError(t -> {
            if (!this.myRefreshIndicator.isCanceled()) {
                LOG.error(t);
            }
        });
    }

    private synchronized void startRefreshActivity() {
        if (this.myBusyThreads++ == 0) {
            this.myRefreshIndicator.start();
        }
    }

    private synchronized void finishRefreshActivity() {
        if (--this.myBusyThreads == 0) {
            this.myRefreshIndicator.stop();
        }
    }

    @NotNull
    private static Runnable runAsyncListeners(@NotNull RefreshSessionImpl session2) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(11);
        }
        List events = ContainerUtil.mapNotNull(session2.getEvents(), e -> {
            VirtualFile file2;
            VirtualFile virtualFile2 = file2 = e instanceof VFileCreateEvent ? ((VFileCreateEvent)e).getParent() : e.getFile();
            if (file2 == null || file2.isValid()) {
                return new CompoundVFileEvent((VFileEvent)e);
            }
            return null;
        });
        List allEvents = ContainerUtil.flatMap((Iterable)events, e -> {
            SmartList toMap = new SmartList(e.getInducedEvents());
            toMap.add(e.getFileEvent());
            return toMap;
        });
        List<AsyncFileListener.ChangeApplier> appliers = AsyncEventSupport.runAsyncListeners(allEvents);
        Runnable runnable2 = () -> session2.fireEvents(events, appliers, true);
        if (runnable2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(12);
        }
        return runnable2;
    }

    private void executeRefreshSession(@NotNull RefreshSessionImpl session2) {
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(13);
        }
        try {
            this.updateSessionMap(session2, true);
            session2.scan();
        }
        finally {
            this.updateSessionMap(session2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSessionMap(@NotNull RefreshSessionImpl session2, boolean add2) {
        long id2;
        if (session2 == null) {
            RefreshQueueImpl.$$$reportNull$$$0(14);
        }
        if ((id2 = session2.getId()) != 0L) {
            Long2ObjectMap<RefreshSessionImpl> long2ObjectMap = this.mySessions;
            synchronized (long2ObjectMap) {
                if (add2) {
                    this.mySessions.put(id2, (Object)session2);
                } else {
                    this.mySessions.remove(id2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSession(long id2) {
        RefreshSessionImpl session2;
        Long2ObjectMap<RefreshSessionImpl> long2ObjectMap = this.mySessions;
        synchronized (long2ObjectMap) {
            session2 = (RefreshSessionImpl)((Object)this.mySessions.get(id2));
        }
        if (session2 != null) {
            session2.cancel();
        }
    }

    @NotNull
    public RefreshSession createSession(boolean async, boolean recursively, @Nullable Runnable finishRunnable, @NotNull ModalityState state) {
        if (state == null) {
            RefreshQueueImpl.$$$reportNull$$$0(15);
        }
        return new RefreshSessionImpl(async, recursively, finishRunnable, state);
    }

    public void processSingleEvent(boolean async, @NotNull VFileEvent event) {
        if (event == null) {
            RefreshQueueImpl.$$$reportNull$$$0(16);
        }
        new RefreshSessionImpl(async, Collections.singletonList(event)).launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRefreshInProgress() {
        RefreshQueueImpl refreshQueue = (RefreshQueueImpl)RefreshQueue.getInstance();
        if (!((BoundedTaskExecutor)refreshQueue.myQueue).isEmpty()) {
            return true;
        }
        Long2ObjectMap<RefreshSessionImpl> long2ObjectMap = refreshQueue.mySessions;
        synchronized (long2ObjectMap) {
            return !refreshQueue.mySessions.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Long2ObjectMap<RefreshSessionImpl> long2ObjectMap = this.mySessions;
        synchronized (long2ObjectMap) {
            for (RefreshSessionImpl session2 : this.mySessions.values()) {
                session2.cancel();
            }
        }
    }

    @TestOnly
    public static void setTestListener(@Nullable Consumer<? super VirtualFile> testListener) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        RefreshWorker.ourTestListener = testListener;
        LocalFileSystemRefreshWorker.setTestListener(testListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/RefreshQueueImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "runAsyncListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "queueSessionSync";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fireEventsSync";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "queueSessionAsync";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeSession";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fireEventsAsync";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAsynchronousPreprocessing";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runAsyncListeners";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeRefreshSession";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateSessionMap";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createSession";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processSingleEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

