/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public final class FsRoot
extends VirtualDirectoryImpl {
    private final String myPathWithOneSlash;

    public FsRoot(int id2, int nameId, @NotNull VfsData vfsData, @NotNull NewVirtualFileSystem fs, @NotNull String pathBeforeSlash, @NotNull FileAttributes attributes2, @NotNull String originalDebugPath) throws VfsData.FileAlreadyCreatedException {
        if (vfsData == null) {
            FsRoot.$$$reportNull$$$0(0);
        }
        if (fs == null) {
            FsRoot.$$$reportNull$$$0(1);
        }
        if (pathBeforeSlash == null) {
            FsRoot.$$$reportNull$$$0(2);
        }
        if (attributes2 == null) {
            FsRoot.$$$reportNull$$$0(3);
        }
        if (originalDebugPath == null) {
            FsRoot.$$$reportNull$$$0(4);
        }
        super(id2, vfsData.getSegment(id2, true), new VfsData.DirectoryData(), null, fs);
        if (!FsRoot.looksCanonical(pathBeforeSlash)) {
            throw new IllegalArgumentException("path must be canonical but got: '" + pathBeforeSlash + "'. FS: " + fs + "; attributes: " + attributes2 + "; original path: '" + originalDebugPath + "'");
        }
        this.myPathWithOneSlash = pathBeforeSlash + "/";
        VfsData.Segment segment = this.getSegment();
        VfsData.initFile(id2, segment, nameId, this.myData);
        segment.setFlag(id2, Integer.MIN_VALUE, attributes2.areChildrenCaseSensitive() == FileAttributes.CaseSensitivity.SENSITIVE);
        segment.setFlag(id2, 0x8000000, true);
    }

    @Override
    protected char @NotNull [] appendPathOnFileSystem(int pathLength, int @NotNull [] position) {
        if (position == null) {
            FsRoot.$$$reportNull$$$0(5);
        }
        int myLength = this.myPathWithOneSlash.length() - 1;
        char[] chars = new char[pathLength + myLength];
        CharArrayUtil.getChars((CharSequence)this.myPathWithOneSlash, (char[])chars, (int)0, (int)position[0], (int)myLength);
        position[0] = position[0] + myLength;
        if (chars == null) {
            FsRoot.$$$reportNull$$$0(6);
        }
        return chars;
    }

    @Override
    public void setNewName(@NotNull String newName2) {
        if (newName2 == null) {
            FsRoot.$$$reportNull$$$0(7);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void setParent(@NotNull VirtualFile newParent) {
        if (newParent == null) {
            FsRoot.$$$reportNull$$$0(8);
        }
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.myPathWithOneSlash;
        if (string == null) {
            FsRoot.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public String getUrl() {
        String string = this.getFileSystem().getProtocol() + "://" + this.getPath();
        if (string == null) {
            FsRoot.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getFileSystem().extractPresentableUrl(this.getName());
        if (string == null) {
            FsRoot.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static boolean looksCanonical(@NotNull String pathBeforeSlash) {
        int i2;
        if (pathBeforeSlash == null) {
            FsRoot.$$$reportNull$$$0(12);
        }
        if (pathBeforeSlash.endsWith("/")) {
            return false;
        }
        int start2 = 0;
        while ((i2 = pathBeforeSlash.indexOf("..", start2)) != -1) {
            if (!(i2 != 0 && pathBeforeSlash.charAt(i2 - 1) != '/' || i2 != pathBeforeSlash.length() - 2 && pathBeforeSlash.charAt(i2 + 2) != '/')) {
                return false;
            }
            start2 = i2 + 1;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfsData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathBeforeSlash";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalDebugPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/FsRoot";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/FsRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "appendPathOnFileSystem";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendPathOnFileSystem";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setNewName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "looksCanonical";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

