/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class VfsRootAccess {
    private static final boolean SHOULD_PERFORM_ACCESS_CHECK = System.getenv("NO_FS_ROOTS_ACCESS_CHECK") == null && System.getProperty("NO_FS_ROOTS_ACCESS_CHECK") == null;
    private static final Set<String> ourAdditionalRoots = CollectionFactory.createFilePathSet();
    private static boolean insideGettingRoots;

    @TestOnly
    static void assertAccessInTests(@NotNull VirtualFile child2, @NotNull NewVirtualFileSystem delegate2) {
        if (child2 == null) {
            VfsRootAccess.$$$reportNull$$$0(0);
        }
        if (delegate2 == null) {
            VfsRootAccess.$$$reportNull$$$0(1);
        }
        ApplicationEx app2 = ApplicationManagerEx.getApplicationEx();
        if (SHOULD_PERFORM_ACCESS_CHECK && app2.isUnitTestMode() && app2.isComponentCreated() && !ApplicationManagerEx.isInStressTest()) {
            boolean isUnder2;
            if (delegate2 != LocalFileSystem.getInstance() && delegate2 != JarFileSystem.getInstance()) {
                return;
            }
            if (child2.getParent() == null || child2.getParent().getParent() == null) {
                return;
            }
            Set<String> allowed = VfsRootAccess.allowedRoots();
            boolean bl = isUnder2 = allowed == null || allowed.isEmpty();
            if (!isUnder2) {
                VirtualFile local = child2;
                if (delegate2 == JarFileSystem.getInstance()) {
                    local = JarFileSystem.getInstance().getVirtualFileForJar(child2);
                    assert (local != null) : child2;
                }
                for (String root2 : allowed) {
                    String rootLocalPath;
                    if (VfsUtilCore.isAncestorOrSelf((String)root2, (VirtualFile)local)) {
                        isUnder2 = true;
                        break;
                    }
                    if (!root2.startsWith("jar://") || !(isUnder2 = VfsUtilCore.isAncestorOrSelf((String)(rootLocalPath = FileUtil.toSystemIndependentName((String)PathUtil.toPresentableUrl((String)root2))), (VirtualFile)local))) continue;
                    break;
                }
            }
            assert (isUnder2) : "File accessed outside allowed roots: " + child2 + ";\nAllowed roots: " + new ArrayList<String>(allowed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Set<String> allowedRoots() {
        if (insideGettingRoots) {
            return null;
        }
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length == 0) {
            return null;
        }
        @NonNls Set allowed = CollectionFactory.createFilePathSet();
        allowed.add(FileUtil.toSystemIndependentName((String)PathManager.getHomePath()));
        String homePath2 = PathManager.getHomePathFor(Application.class);
        if (homePath2 != null) {
            allowed.add(FileUtil.toSystemIndependentName((String)homePath2));
        }
        try {
            URL outUrl = Application.class.getResource("/");
            if (outUrl != null) {
                String output2 = new File(outUrl.toURI()).getParentFile().getParentFile().getPath();
                allowed.add(FileUtil.toSystemIndependentName((String)output2));
            }
        }
        catch (IllegalArgumentException | URISyntaxException outUrl) {
            // empty catch block
        }
        try {
            String wslName;
            allowed.add(FileUtil.toSystemIndependentName((String)VfsRootAccess.getJavaHome()));
            allowed.add(FileUtil.toSystemIndependentName((String)new File(FileUtil.getTempDirectory()).getParent()));
            allowed.add(FileUtil.toSystemIndependentName((String)System.getProperty("java.io.tmpdir")));
            allowed.add(FileUtil.toSystemIndependentName((String)SystemProperties.getUserHome()));
            allowed.add(FileUtil.toSystemIndependentName((String)VfsRootAccess.findInUserHome(".m2")));
            allowed.add(FileUtil.toSystemIndependentName((String)VfsRootAccess.findInUserHome(".gradle")));
            if (System.getenv().containsKey("GRADLE_USER_HOME")) {
                allowed.add(FileUtil.toSystemIndependentName((String)System.getenv("GRADLE_USER_HOME")));
            }
            if (SystemInfo.isWindows && (wslName = System.getProperty("wsl.distribution.name")) != null) {
                allowed.add(FileUtil.toSystemIndependentName((String)("\\\\wsl$\\" + wslName)));
            }
            allowed.add("/etc");
            allowed.add("/private/etc");
            for (Project project : openProjects) {
                if (!project.isInitialized()) {
                    return null;
                }
                ReadAction.run(() -> {
                    for (String url : ProjectRootManager.getInstance((Project)project).getContentRootUrls()) {
                        allowed.add(VfsUtilCore.urlToPath((String)url));
                    }
                    for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                        String homePath;
                        Sdk moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk();
                        if (moduleSdk == null || (homePath = moduleSdk.getHomePath()) == null) continue;
                        allowed.add(homePath);
                    }
                    for (String url : VfsRootAccess.getAllRootUrls(project)) {
                        allowed.add(StringUtil.trimEnd((String)VfsUtilCore.urlToPath((String)url), (String)"!/"));
                    }
                    String location = project.getBasePath();
                    assert (location != null) : project;
                    allowed.add(FileUtil.toSystemIndependentName((String)location));
                });
            }
        }
        catch (Error error) {
            // empty catch block
        }
        Project[] projectArray = ourAdditionalRoots;
        synchronized (ourAdditionalRoots) {
            allowed.addAll(ourAdditionalRoots);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return allowed;
        }
    }

    private static String getJavaHome() {
        String javaHomeParent;
        String javaHome = SystemProperties.getJavaHome();
        if (JdkUtil.checkForJre((String)javaHome) && !JdkUtil.checkForJdk((String)javaHome) && JdkUtil.checkForJre((String)(javaHomeParent = PathUtil.getParentPath((String)javaHome))) && JdkUtil.checkForJdk((String)javaHomeParent)) {
            javaHome = javaHomeParent;
        }
        return javaHome;
    }

    private static String findInUserHome(String path2) {
        File file2 = new File(SystemProperties.getUserHome(), path2);
        try {
            return file2.getCanonicalPath();
        }
        catch (IOException e) {
            return file2.getPath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<String> getAllRootUrls(Project project) {
        insideGettingRoots = true;
        try {
            Set roots2 = CollectionFactory.createSmallMemoryFootprintSet();
            OrderEnumerator enumerator2 = ProjectRootManager.getInstance((Project)project).orderEntries().using((RootModelProvider)new DefaultModulesProvider(project));
            ContainerUtil.addAll((Collection)roots2, (Object[])enumerator2.classes().getUrls());
            ContainerUtil.addAll((Collection)roots2, (Object[])enumerator2.sources().getUrls());
            Set set2 = roots2;
            return set2;
        }
        finally {
            insideGettingRoots = false;
        }
    }

    @TestOnly
    public static void allowRootAccess(@NotNull Disposable disposable2, String ... roots2) {
        if (disposable2 == null) {
            VfsRootAccess.$$$reportNull$$$0(2);
        }
        if (roots2 == null) {
            VfsRootAccess.$$$reportNull$$$0(3);
        }
        if (roots2.length == 0) {
            return;
        }
        VfsRootAccess.doAllow(roots2);
        Disposer.register((Disposable)disposable2, () -> VfsRootAccess.disallowRootAccess(roots2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doAllow(String ... roots2) {
        if (roots2 == null) {
            VfsRootAccess.$$$reportNull$$$0(4);
        }
        Set<String> set2 = ourAdditionalRoots;
        synchronized (set2) {
            for (String root2 : roots2) {
                String path2 = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)root2), (char)'/');
                if (path2.isEmpty()) {
                    throw new IllegalArgumentException("Must not pass empty pat but got: '" + Arrays.toString(roots2) + "'");
                }
                ourAdditionalRoots.add(path2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    private static void disallowRootAccess(String ... roots2) {
        if (roots2 == null) {
            VfsRootAccess.$$$reportNull$$$0(5);
        }
        Set<String> set2 = ourAdditionalRoots;
        synchronized (set2) {
            for (String root2 : roots2) {
                ourAdditionalRoots.remove(StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)root2), (char)'/'));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VfsRootAccess";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "assertAccessInTests";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "allowRootAccess";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doAllow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "disallowRootAccess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

