/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.util.io.ResizeableMappedFile;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public final class PersistentFSRecordsStorage {
    private static final int PARENT_OFFSET = 0;
    private static final int PARENT_SIZE = 4;
    private static final int NAME_OFFSET = 4;
    private static final int NAME_SIZE = 4;
    private static final int FLAGS_OFFSET = 8;
    private static final int FLAGS_SIZE = 4;
    private static final int ATTR_REF_OFFSET = 12;
    private static final int ATTR_REF_SIZE = 4;
    private static final int CONTENT_OFFSET = 16;
    private static final int CONTENT_SIZE = 4;
    private static final int TIMESTAMP_OFFSET = 20;
    private static final int TIMESTAMP_SIZE = 8;
    private static final int MOD_COUNT_OFFSET = 28;
    private static final int MOD_COUNT_SIZE = 4;
    private static final int LENGTH_OFFSET = 32;
    private static final int LENGTH_SIZE = 8;
    static final int RECORD_SIZE = 40;
    private static final byte[] ZEROES = new byte[40];
    private final ReadWriteLock myLock;
    @NotNull
    private final ResizeableMappedFile myFile;

    private <V, E extends Throwable> V read(ThrowableComputable<V, E> action2) throws E {
        this.myLock.readLock().lock();
        try {
            Object object = action2.compute();
            return (V)object;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    private <V, E extends Throwable> V write(ThrowableComputable<V, E> action2) throws E {
        this.myLock.writeLock().lock();
        try {
            Object object = action2.compute();
            return (V)object;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public PersistentFSRecordsStorage(@NotNull ResizeableMappedFile file2) {
        if (file2 == null) {
            PersistentFSRecordsStorage.$$$reportNull$$$0(0);
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myFile = file2;
    }

    int getGlobalModCount() throws IOException {
        return (Integer)this.read(() -> this.myFile.getInt(8L));
    }

    int incGlobalModCount() throws IOException {
        return (Integer)this.write(() -> {
            int count = this.getGlobalModCount() + 1;
            this.myFile.putInt(8L, count);
            return count;
        });
    }

    long getTimestamp() throws IOException {
        return (Long)this.read(() -> this.myFile.getLong(16L));
    }

    void setVersion(int version2) throws IOException {
        this.write(() -> {
            this.myFile.putInt(0L, version2);
            this.myFile.putLong(16L, System.currentTimeMillis());
            return null;
        });
    }

    int getVersion() throws IOException {
        return (Integer)this.read(() -> this.myFile.getInt(0L));
    }

    void setConnectionStatus(int connectionStatus) throws IOException {
        this.write(() -> {
            this.myFile.putInt(12L, connectionStatus);
            return null;
        });
    }

    int getConnectionStatus() throws IOException {
        return (Integer)this.read(() -> this.myFile.getInt(12L));
    }

    int getNameId(int id2) throws IOException {
        return (Integer)this.read(() -> {
            assert (id2 > 0) : id2;
            return this.getRecordInt(id2, 4);
        });
    }

    void setNameId(int id2, int nameId) throws IOException {
        this.write(() -> {
            PersistentFSConnection.ensureIdIsValid(nameId);
            this.putRecordInt(id2, 4, nameId);
            return null;
        });
    }

    int getParent(int id2) throws IOException {
        return (Integer)this.read(() -> this.getRecordInt(id2, 0));
    }

    void setParent(int id2, int parent) throws IOException {
        this.write(() -> {
            this.putRecordInt(id2, 0, parent);
            return null;
        });
    }

    int getModCount(int id2) throws IOException {
        return (Integer)this.read(() -> this.getRecordInt(id2, 28));
    }

    @PersistentFS.Attributes int doGetFlags(int id2) throws IOException {
        return (Integer)this.read(() -> this.getRecordInt(id2, 8));
    }

    void setFlags(int id2, @PersistentFS.Attributes int flags) throws IOException {
        this.write(() -> {
            this.putRecordInt(id2, 8, flags);
            return null;
        });
    }

    void setModCount(int id2, int value2) throws IOException {
        this.write(() -> {
            this.putRecordInt(id2, 28, value2);
            return null;
        });
    }

    int getContentRecordId(int fileId) throws IOException {
        return (Integer)this.read(() -> this.getRecordInt(fileId, 16));
    }

    void setContentRecordId(int id2, int value2) throws IOException {
        this.write(() -> {
            this.putRecordInt(id2, 16, value2);
            return null;
        });
    }

    int getAttributeRecordId(int id2) throws IOException {
        return (Integer)this.read(() -> this.getRecordInt(id2, 12));
    }

    void setAttributeRecordId(int id2, int value2) throws IOException {
        this.write(() -> {
            this.putRecordInt(id2, 12, value2);
            return null;
        });
    }

    long getTimestamp(int id2) throws IOException {
        return (Long)this.read(() -> this.myFile.getLong((long)PersistentFSRecordsStorage.getOffset(id2, 20)));
    }

    boolean putTimeStamp(int id2, long value2) throws IOException {
        return (Boolean)this.write(() -> {
            int timeStampOffset = PersistentFSRecordsStorage.getOffset(id2, 20);
            if (this.myFile.getLong((long)timeStampOffset) != value2) {
                this.myFile.putLong((long)timeStampOffset, value2);
                return true;
            }
            return false;
        });
    }

    long getLength(int id2) throws IOException {
        return (Long)this.read(() -> this.myFile.getLong((long)PersistentFSRecordsStorage.getOffset(id2, 32)));
    }

    boolean putLength(int id2, long value2) throws IOException {
        return (Boolean)this.write(() -> {
            int lengthOffset = PersistentFSRecordsStorage.getOffset(id2, 32);
            if (this.myFile.getLong((long)lengthOffset) != value2) {
                this.myFile.putLong((long)lengthOffset, value2);
                return true;
            }
            return false;
        });
    }

    void cleanRecord(int id2) throws IOException {
        this.write(() -> {
            this.myFile.put((long)id2 * 40L, ZEROES, 0, 40);
            return null;
        });
    }

    private int getRecordInt(int id2, int offset) throws IOException {
        return (Integer)this.read(() -> this.myFile.getInt((long)PersistentFSRecordsStorage.getOffset(id2, offset)));
    }

    private void putRecordInt(int id2, int offset, int value2) throws IOException {
        this.write(() -> {
            this.myFile.putInt((long)PersistentFSRecordsStorage.getOffset(id2, offset), value2);
            return null;
        });
    }

    private static int getOffset(int id2, int offset) {
        return id2 * 40 + offset;
    }

    long length() {
        return (Long)this.read(() -> this.myFile.length());
    }

    void close() {
        this.write(() -> {
            try {
                this.myFile.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    void force() {
        this.write(() -> {
            try {
                this.myFile.force();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    boolean isDirty() {
        return this.myFile.isDirty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsStorage", "<init>"));
    }
}

