/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.ListResult;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSAttributeAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;

final class PersistentFSTreeAccessor {
    private static final FileAttribute ourChildrenAttr = new FileAttribute("FsRecords.DIRECTORY_CHILDREN");
    @NotNull
    private final PersistentFSAttributeAccessor myAttributeAccessor;
    private final boolean myStoreRootsSeparately;
    private final PersistentFSConnection myFSConnection;
    private static final int ROOT_RECORD_ID = 1;

    PersistentFSTreeAccessor(@NotNull PersistentFSAttributeAccessor attributeAccessor, boolean storeRootsSeparately, @NotNull PersistentFSConnection connection) {
        if (attributeAccessor == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(1);
        }
        this.myAttributeAccessor = attributeAccessor;
        this.myStoreRootsSeparately = storeRootsSeparately;
        this.myFSConnection = connection;
    }

    void doSaveChildren(int parentId, @NotNull ListResult toSave) throws IOException {
        if (toSave == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(2);
        }
        this.myFSConnection.markDirty();
        try (DataOutputStream record = this.myAttributeAccessor.writeAttribute(parentId, ourChildrenAttr);){
            DataInputOutputUtil.writeINT((DataOutput)record, (int)toSave.children.size());
            int prevId = parentId;
            for (ChildInfo childInfo : toSave.children) {
                int childId = childInfo.getId();
                if (childId <= 0) {
                    throw new IllegalArgumentException("ids must be >0 but got: " + childId + "; childInfo: " + childInfo + "; list: " + toSave);
                }
                if (childId == parentId) {
                    FSRecords.LOG.error("Cyclic parent-child relations. parentId=" + parentId + "; list: " + toSave);
                    continue;
                }
                int delta = childId - prevId;
                if (prevId != parentId && delta <= 0) {
                    throw new IllegalArgumentException("The list must be sorted by (unique) id but got parentId: " + parentId + "; delta: " + delta + "; childInfo: " + childInfo + "; prevId: " + prevId + "; toSave: " + toSave);
                }
                DataInputOutputUtil.writeINT((DataOutput)record, (int)delta);
                prevId = childId;
            }
        }
    }

    @NotNull
    ListResult doLoadChildren(int parentId) throws IOException {
        PersistentFSConnection.ensureIdIsValid(parentId);
        DataInputStream input = this.myAttributeAccessor.readAttribute(parentId, ourChildrenAttr);
        int count = input == null ? 0 : DataInputOutputUtil.readINT((DataInput)input);
        ArrayList<ChildInfoImpl> result2 = count == 0 ? Collections.emptyList() : new ArrayList<ChildInfoImpl>(count);
        int prevId = parentId;
        for (int i2 = 0; i2 < count; ++i2) {
            int id2;
            prevId = id2 = DataInputOutputUtil.readINT((DataInput)input) + prevId;
            int nameId = this.myFSConnection.getRecords().getNameId(id2);
            ChildInfoImpl child2 = new ChildInfoImpl(id2, nameId, null, null, null);
            result2.add(child2);
        }
        ListResult listResult = new ListResult(result2, parentId);
        ListResult listResult2 = listResult;
        if (listResult2 == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(3);
        }
        return listResult2;
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    boolean wereChildrenAccessed(int id2) throws IOException {
        return this.myAttributeAccessor.hasAttributePage(id2, ourChildrenAttr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int @NotNull [] listRoots() throws IOException {
        int[] nArray;
        DataInputStream input;
        block21: {
            if (this.myStoreRootsSeparately) {
                IntArrayList result2 = new IntArrayList();
                try (LineNumberReader stream2 = new LineNumberReader(Files.newBufferedReader(this.myFSConnection.getPersistentFSPaths().getRootsFile()));){
                    String str;
                    while ((str = stream2.readLine()) != null) {
                        int index2 = str.indexOf(32);
                        int id2 = Integer.parseInt(str.substring(0, index2));
                        result2.add(id2);
                    }
                }
                catch (FileNotFoundException stream2) {
                    // empty catch block
                }
                int[] nArray2 = result2.toIntArray();
                if (nArray2 == null) {
                    PersistentFSTreeAccessor.$$$reportNull$$$0(4);
                }
                return nArray2;
            }
            input = this.myAttributeAccessor.readAttribute(1, ourChildrenAttr);
            if (input == null) {
                int[] stream2 = ArrayUtilRt.EMPTY_INT_ARRAY;
                if (stream2 == null) {
                    PersistentFSTreeAccessor.$$$reportNull$$$0(5);
                }
                return stream2;
            }
            int count = DataInputOutputUtil.readINT((DataInput)input);
            int[] result3 = ArrayUtil.newIntArray((int)count);
            int prevId = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                DataInputOutputUtil.readINT((DataInput)input);
                prevId = result3[i2] = DataInputOutputUtil.readINT((DataInput)input) + prevId;
            }
            nArray = result3;
            if (nArray != null) break block21;
            PersistentFSTreeAccessor.$$$reportNull$$$0(6);
        }
        return nArray;
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int @NotNull [] listIds(int id2) throws IOException {
        int[] nArray;
        DataInputStream input;
        block10: {
            input = this.myAttributeAccessor.readAttribute(id2, ourChildrenAttr);
            if (input == null) {
                int[] nArray2 = ArrayUtilRt.EMPTY_INT_ARRAY;
                if (nArray2 == null) {
                    PersistentFSTreeAccessor.$$$reportNull$$$0(7);
                }
                return nArray2;
            }
            int count = DataInputOutputUtil.readINT((DataInput)input);
            int[] result2 = ArrayUtil.newIntArray((int)count);
            int prevId = id2;
            for (int i2 = 0; i2 < count; ++i2) {
                prevId = result2[i2] = DataInputOutputUtil.readINT((DataInput)input) + prevId;
            }
            nArray = result2;
            if (nArray != null) break block10;
            PersistentFSTreeAccessor.$$$reportNull$$$0(8);
        }
        return nArray;
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    boolean mayHaveChildren(int id2) throws IOException {
        try (DataInputStream input = this.myAttributeAccessor.readAttribute(id2, ourChildrenAttr);){
            if (input == null) {
                boolean bl = true;
                return bl;
            }
            int count = DataInputOutputUtil.readINT((DataInput)input);
            boolean bl = count != 0;
            return bl;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    int findOrCreateRootRecord(@NotNull String rootUrl, @NotNull IntSupplier newRecord) throws IOException {
        int id2;
        if (rootUrl == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(9);
        }
        if (newRecord == null) {
            PersistentFSTreeAccessor.$$$reportNull$$$0(10);
        }
        PersistentFSConnection connection = this.myFSConnection;
        if (this.myStoreRootsSeparately) {
            int index2;
            Closeable stream2;
            try {
                stream2 = new LineNumberReader(Files.newBufferedReader(connection.getPersistentFSPaths().getRootsFile()));
                try {
                    String str;
                    while ((str = ((LineNumberReader)stream2).readLine()) != null) {
                        index2 = str.indexOf(32);
                        if (!str.substring(index2 + 1).equals(rootUrl)) continue;
                        int n = Integer.parseInt(str.substring(0, index2));
                        return n;
                    }
                }
                finally {
                    ((BufferedReader)stream2).close();
                }
            }
            catch (FileNotFoundException stream2) {
                // empty catch block
            }
            connection.markDirty();
            stream2 = Files.newBufferedWriter(connection.getPersistentFSPaths().getRootsFile(), StandardOpenOption.APPEND);
            try {
                int id3 = newRecord.getAsInt();
                ((Writer)stream2).write(id3 + " " + rootUrl + "\n");
                index2 = id3;
                return index2;
            }
            finally {
                if (stream2 != null) {
                    ((Writer)stream2).close();
                }
            }
        }
        int root2 = connection.getNames().tryEnumerate((Object)rootUrl);
        int[] names2 = ArrayUtilRt.EMPTY_INT_ARRAY;
        int[] ids = ArrayUtilRt.EMPTY_INT_ARRAY;
        try (DataInputStream input = this.myAttributeAccessor.readAttribute(1, ourChildrenAttr);){
            if (input != null) {
                int count = DataInputOutputUtil.readINT((DataInput)input);
                names2 = ArrayUtil.newIntArray((int)count);
                ids = ArrayUtil.newIntArray((int)count);
                int prevId = 0;
                int prevNameId = 0;
                for (int i2 = 0; i2 < count; ++i2) {
                    int name2 = DataInputOutputUtil.readINT((DataInput)input) + prevNameId;
                    int id4 = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                    if (name2 == root2) {
                        int n = id4;
                        return n;
                    }
                    prevNameId = names2[i2] = name2;
                    prevId = ids[i2] = id4;
                }
            }
        }
        connection.markDirty();
        root2 = connection.getNames().enumerate(rootUrl);
        try (DataOutputStream output2 = this.myAttributeAccessor.writeAttribute(1, ourChildrenAttr);){
            id2 = newRecord.getAsInt();
            int index3 = Arrays.binarySearch(ids, id2);
            ids = ArrayUtil.insert((int[])ids, (int)(-index3 - 1), (int)id2);
            names2 = ArrayUtil.insert((int[])names2, (int)(-index3 - 1), (int)root2);
            PersistentFSTreeAccessor.saveNameIdSequenceWithDeltas(names2, ids, output2);
        }
        return id2;
    }

    void deleteRootRecord(int fileId) throws IOException {
        int[] names2;
        int[] ids;
        PersistentFSConnection connection = this.myFSConnection;
        connection.markDirty();
        if (this.myStoreRootsSeparately) {
            ArrayList<Object> rootsThatLeft = new ArrayList<Object>();
            try (LineNumberReader stream22 = new LineNumberReader(Files.newBufferedReader(connection.getPersistentFSPaths().getRootsFile()));){
                Object str;
                while ((str = stream22.readLine()) != null) {
                    int n = ((String)str).indexOf(32);
                    int rootId = Integer.parseInt(((String)str).substring(0, n));
                    if (rootId == fileId) continue;
                    rootsThatLeft.add(str);
                }
            }
            catch (FileNotFoundException stream22) {
                // empty catch block
            }
            try (BufferedWriter stream = Files.newBufferedWriter(connection.getPersistentFSPaths().getRootsFile(), new OpenOption[0]);){
                for (String string : rootsThatLeft) {
                    stream.write(string);
                    stream.write("\n");
                }
            }
            return;
        }
        try (DataInputStream input = this.myAttributeAccessor.readAttribute(1, ourChildrenAttr);){
            assert (input != null);
            int n = DataInputOutputUtil.readINT((DataInput)input);
            int[] names22 = ArrayUtil.newIntArray((int)n);
            ids = ArrayUtil.newIntArray((int)n);
            int prevId = 0;
            int prevNameId = 0;
            for (int i2 = 0; i2 < n; ++i2) {
                names22[i2] = DataInputOutputUtil.readINT((DataInput)input) + prevNameId;
                ids[i2] = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                prevId = ids[i2];
                prevNameId = names22[i2];
            }
        }
        int index3 = ArrayUtil.find((int[])ids, (int)fileId);
        assert (index3 >= 0);
        names2 = ArrayUtil.remove((int[])names2, (int)index3);
        ids = ArrayUtil.remove((int[])ids, (int)index3);
        try (DataOutputStream dataOutputStream = this.myAttributeAccessor.writeAttribute(1, ourChildrenAttr);){
            PersistentFSTreeAccessor.saveNameIdSequenceWithDeltas(names2, ids, dataOutputStream);
        }
    }

    void ensureLoaded() throws IOException {
        this.myFSConnection.getAttributeId(ourChildrenAttr.getId());
    }

    private static void saveNameIdSequenceWithDeltas(int[] names2, int[] ids, DataOutputStream output2) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)output2, (int)names2.length);
        int prevId = 0;
        int prevNameId = 0;
        for (int i2 = 0; i2 < names2.length; ++i2) {
            DataInputOutputUtil.writeINT((DataOutput)output2, (int)(names2[i2] - prevNameId));
            DataInputOutputUtil.writeINT((DataOutput)output2, (int)(ids[i2] - prevId));
            prevId = ids[i2];
            prevNameId = names2[i2];
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeAccessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSave";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSTreeAccessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootUrl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRecord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSTreeAccessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadChildren";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "listRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "listIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doSaveChildren";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateRootRecord";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

