/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.jdkEx.JdkEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.mac.MacMainFrameDecorator;
import com.intellij.ui.mac.MacWinTabsHandler;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class IdeFrameDecorator
implements IdeFrameImpl.FrameDecorator {
    static final String FULL_SCREEN = "ide.frame.full.screen";
    protected final JFrame myFrame;
    private static final Logger LOG = Logger.getInstance(IdeFrameDecorator.class);
    private static final AtomicReference<Boolean> isCustomDecorationActiveCache = new AtomicReference();

    protected IdeFrameDecorator(@NotNull JFrame frame) {
        if (frame == null) {
            IdeFrameDecorator.$$$reportNull$$$0(0);
        }
        this.myFrame = frame;
    }

    @Override
    public abstract boolean isInFullScreen();

    public void setProject() {
    }

    @NotNull
    public abstract Promise<Boolean> toggleFullScreen(boolean var1);

    @Nullable
    public static IdeFrameDecorator decorate(@NotNull JFrame frame, @NotNull Disposable parentDisposable) {
        if (frame == null) {
            IdeFrameDecorator.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            IdeFrameDecorator.$$$reportNull$$$0(2);
        }
        try {
            if (SystemInfo.isMac) {
                return new MacMainFrameDecorator(frame, parentDisposable);
            }
            if (SystemInfo.isWindows) {
                return new WinMainFrameDecorator(frame);
            }
            if (SystemInfo.isXWindow && X11UiUtil.isFullScreenSupported()) {
                return new EWMHFrameDecorator(frame, parentDisposable);
            }
        }
        catch (Throwable t) {
            LOG.warn("Failed to initialize IdeFrameDecorator. " + t.getMessage(), t);
        }
        return null;
    }

    @NotNull
    public static JComponent wrapRootPaneNorthSide(@NotNull JRootPane rootPane, @NotNull JComponent northComponent) {
        if (rootPane == null) {
            IdeFrameDecorator.$$$reportNull$$$0(3);
        }
        if (northComponent == null) {
            IdeFrameDecorator.$$$reportNull$$$0(4);
        }
        if (SystemInfo.isMac) {
            JComponent jComponent = MacWinTabsHandler.wrapRootPaneNorthSide(rootPane, northComponent);
            if (jComponent == null) {
                IdeFrameDecorator.$$$reportNull$$$0(5);
            }
            return jComponent;
        }
        JComponent jComponent = northComponent;
        if (jComponent == null) {
            IdeFrameDecorator.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    protected void notifyFrameComponents(boolean state) {
        this.myFrame.getRootPane().putClientProperty(FULL_SCREEN, state);
        JMenuBar menuBar = this.myFrame.getJMenuBar();
        if (menuBar != null) {
            menuBar.putClientProperty(FULL_SCREEN, state);
        }
    }

    public static boolean isCustomDecorationAvailable() {
        return SystemInfo.isWindows && JdkEx.isCustomDecorationSupported();
    }

    public static boolean isCustomDecorationActive() {
        UISettings settings = UISettings.getInstanceOrNull();
        if (settings == null) {
            return IdeFrameDecorator.isCustomDecorationAvailable() && !Objects.equals(UISettings.getMergeMainMenuWithWindowTitleOverrideValue(), false);
        }
        return isCustomDecorationActiveCache.updateAndGet(cached -> {
            if (cached != null) {
                return cached;
            }
            if (!IdeFrameDecorator.isCustomDecorationAvailable()) {
                return false;
            }
            Boolean override = UISettings.getMergeMainMenuWithWindowTitleOverrideValue();
            if (override != null) {
                return override;
            }
            return settings.getMergeMainMenuWithWindowTitle();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPane";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "northComponent";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/IdeFrameDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/IdeFrameDecorator";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapRootPaneNorthSide";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "decorate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrapRootPaneNorthSide";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class EWMHFrameDecorator
    extends IdeFrameDecorator {
        private Boolean myRequestedState;

        private EWMHFrameDecorator(final @NotNull JFrame frame, @NotNull Disposable parentDisposable) {
            if (frame == null) {
                EWMHFrameDecorator.$$$reportNull$$$0(0);
            }
            if (parentDisposable == null) {
                EWMHFrameDecorator.$$$reportNull$$$0(1);
            }
            super(frame);
            this.myRequestedState = null;
            frame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (myRequestedState != null) {
                        this.notifyFrameComponents(myRequestedState);
                        myRequestedState = null;
                    }
                }
            });
            if (SystemInfo.isKDE && ComponentUtil.isDisableAutoRequestFocus()) {
                final WindowAdapter deiconifyListener = new WindowAdapter(){

                    @Override
                    public void windowDeiconified(WindowEvent event) {
                        frame.toFront();
                    }
                };
                frame.addWindowListener(deiconifyListener);
                Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                    public void dispose() {
                        frame.removeWindowListener(deiconifyListener);
                    }
                });
            }
        }

        @Override
        public boolean isInFullScreen() {
            return this.myFrame != null && X11UiUtil.isInFullScreenMode(this.myFrame);
        }

        @Override
        @NotNull
        public Promise<Boolean> toggleFullScreen(boolean state) {
            if (this.myFrame != null) {
                this.myRequestedState = state;
                X11UiUtil.toggleFullScreenMode(this.myFrame);
                if (this.myFrame.getJMenuBar() instanceof IdeMenuBar) {
                    IdeMenuBar frameMenuBar = (IdeMenuBar)this.myFrame.getJMenuBar();
                    frameMenuBar.onToggleFullScreen(state);
                }
            }
            Promise promise = Promises.resolvedPromise((Object)state);
            if (promise == null) {
                EWMHFrameDecorator.$$$reportNull$$$0(2);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/IdeFrameDecorator$EWMHFrameDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/IdeFrameDecorator$EWMHFrameDecorator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toggleFullScreen";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class WinMainFrameDecorator
    extends IdeFrameDecorator {
        private WinMainFrameDecorator(@NotNull JFrame frame) {
            if (frame == null) {
                WinMainFrameDecorator.$$$reportNull$$$0(0);
            }
            super(frame);
        }

        @Override
        public boolean isInFullScreen() {
            return UIUtil.isWindowClientPropertyTrue((Window)this.myFrame, (Object)IdeFrameDecorator.FULL_SCREEN);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Promise<Boolean> toggleFullScreen(boolean state) {
            GraphicsDevice device;
            Rectangle bounds2 = this.myFrame.getBounds();
            int extendedState = this.myFrame.getExtendedState();
            if (state && extendedState == 0) {
                this.myFrame.getRootPane().putClientProperty("normalBounds", bounds2);
            }
            if ((device = ScreenUtil.getScreenDevice((Rectangle)bounds2)) == null) {
                Promise promise = Promises.rejectedPromise();
                if (promise == null) {
                    WinMainFrameDecorator.$$$reportNull$$$0(1);
                }
                return promise;
            }
            Component toFocus = this.myFrame.getMostRecentFocusOwner();
            Rectangle defaultBounds = device.getDefaultConfiguration().getBounds();
            try {
                this.myFrame.getRootPane().putClientProperty("togglingFullScreenInProgress", Boolean.TRUE);
                this.myFrame.getRootPane().putClientProperty("dispose.temporary", Boolean.TRUE);
                this.myFrame.dispose();
                this.myFrame.setUndecorated(state);
            }
            finally {
                if (state) {
                    this.myFrame.setBounds(defaultBounds);
                } else {
                    Object o = this.myFrame.getRootPane().getClientProperty("normalBounds");
                    if (o instanceof Rectangle) {
                        this.myFrame.setBounds((Rectangle)o);
                    }
                }
                this.myFrame.setVisible(true);
                this.myFrame.getRootPane().putClientProperty("dispose.temporary", null);
                if (!state && (extendedState & 6) != 0) {
                    this.myFrame.setExtendedState(extendedState);
                }
                this.notifyFrameComponents(state);
                if (toFocus != null && !(toFocus instanceof JRootPane)) {
                    toFocus.requestFocusInWindow();
                }
            }
            EventQueue.invokeLater(() -> this.myFrame.getRootPane().putClientProperty("togglingFullScreenInProgress", null));
            Promise promise = Promises.resolvedPromise((Object)state);
            if (promise == null) {
                WinMainFrameDecorator.$$$reportNull$$$0(2);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/IdeFrameDecorator$WinMainFrameDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/IdeFrameDecorator$WinMainFrameDecorator";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toggleFullScreen";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

