/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.notification.NotificationsManager;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.CloseProjectWindowHelper;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.TitleInfoProvider;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.ActionCenterBalloonLayout;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.PopupHandler;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.io.SuperUserStatus;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class ProjectFrameHelper
implements IdeFrameEx,
AccessibleContextAccessor,
DataProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance(IdeFrameImpl.class);
    private boolean isUpdatingTitle;
    private String myTitle;
    private String fileTitle;
    private Path currentFile;
    private Project project;
    private IdeRootPane myRootPane;
    private BalloonLayout myBalloonLayout;
    @Nullable
    private IdeFrameDecorator myFrameDecorator;
    private volatile Image selfie;
    private IdeFrameImpl frame;

    public ProjectFrameHelper(@NotNull IdeFrameImpl frame, @Nullable Image selfie) {
        if (frame == null) {
            ProjectFrameHelper.$$$reportNull$$$0(0);
        }
        this.frame = frame;
        this.selfie = selfie;
        this.setupCloseAction();
        this.preInit();
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this);
    }

    @Nullable
    public static ProjectFrameHelper getFrameHelper(@Nullable Window window) {
        IdeFrameImpl projectFrame;
        if (window == null) {
            return null;
        }
        if (window instanceof IdeFrameImpl) {
            projectFrame = (IdeFrameImpl)window;
        } else {
            projectFrame = (IdeFrameImpl)SwingUtilities.getAncestorOfClass(IdeFrameImpl.class, window);
            if (projectFrame == null) {
                return null;
            }
        }
        IdeFrameImpl.FrameHelper frameLightHelper = projectFrame.getFrameHelper();
        return frameLightHelper == null ? null : (ProjectFrameHelper)frameLightHelper.getHelper();
    }

    private void preInit() {
        this.myRootPane = this.createIdeRootPane();
        this.frame.setRootPane(this.myRootPane);
        this.myFrameDecorator = IdeFrameDecorator.decorate(this.frame, this);
        this.frame.setFrameHelper(new IdeFrameImpl.FrameHelper(){

            @Override
            @Nullable
            public Object getData(@NotNull String dataId) {
                if (dataId == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ProjectFrameHelper.this.getData(dataId);
            }

            @Override
            @NlsSafe
            public String getAccessibleName() {
                StringBuilder builder2 = new StringBuilder();
                if (ProjectFrameHelper.this.project != null) {
                    builder2.append(ProjectFrameHelper.this.project.getName());
                    builder2.append(" - ");
                }
                builder2.append(ApplicationNamesInfo.getInstance().getFullProductName());
                return builder2.toString();
            }

            @Override
            public void dispose() {
                if (ProjectFrameHelper.isTemporaryDisposed(ProjectFrameHelper.this.frame)) {
                    ProjectFrameHelper.this.frame.doDispose();
                    return;
                }
                Disposer.dispose((Disposable)ProjectFrameHelper.this);
            }

            @Override
            public void updateView() {
                ProjectFrameHelper.this.updateView();
            }

            @Override
            @Nullable
            public Project getProject() {
                return ProjectFrameHelper.this.project;
            }

            @Override
            @NotNull
            public IdeFrame getHelper() {
                ProjectFrameHelper projectFrameHelper = ProjectFrameHelper.this;
                if (projectFrameHelper == null) {
                    1.$$$reportNull$$$0(1);
                }
                return projectFrameHelper;
            }

            @Override
            public void setTitle(@Nullable String title2) {
                if (ProjectFrameHelper.this.isUpdatingTitle) {
                    ProjectFrameHelper.this.frame.doSetTitle(title2);
                } else {
                    ProjectFrameHelper.this.myTitle = title2;
                }
                ProjectFrameHelper.this.updateTitle();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/wm/impl/ProjectFrameHelper$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/wm/impl/ProjectFrameHelper$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHelper";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getData";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, this.myFrameDecorator);
        this.myBalloonLayout = Registry.is((String)"ide.notification.action.center", (boolean)false) ? new ActionCenterBalloonLayout(this.myRootPane, (Insets)JBUI.insets((int)8)) : new BalloonLayoutImpl(this.myRootPane, (Insets)JBUI.insets((int)8));
        this.frame.setBackground(UIUtil.getPanelBackground());
    }

    @NotNull
    protected IdeRootPane createIdeRootPane() {
        return new IdeRootPane(this.frame, this, this);
    }

    public void releaseFrame() {
        this.myRootPane.removeToolbar();
        WindowManagerEx.getInstanceEx().releaseFrame(this);
    }

    public void init() {
        this.myRootPane.createAndConfigureStatusBar(this, this);
        MnemonicHelper.init((Component)this.frame);
        this.frame.setFocusTraversalPolicy(new IdeFocusTraversalPolicy());
        if (SystemInfoRt.isMac) {
            this.frame.setIconImage(null);
        }
        IdeMenuBar.installAppMenuIfNeeded(this.frame);
        AppUIUtil.updateWindowIcon(this.frame);
        MouseGestureManager.getInstance().add(this);
        ApplicationManager.getApplication().invokeLater(() -> ((NotificationsManagerImpl)NotificationsManager.getNotificationsManager()).dispatchEarlyNotifications(), ModalityState.NON_MODAL, ignored -> this.frame == null);
    }

    public JComponent getComponent() {
        return this.frame.getRootPane();
    }

    private void setupCloseAction() {
        this.frame.setDefaultCloseOperation(0);
        final CloseProjectWindowHelper helper2 = this.createCloseProjectWindowHelper();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(@NotNull WindowEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (ProjectFrameHelper.isTemporaryDisposed(ProjectFrameHelper.this.frame) || LaterInvocator.isInModalContext()) {
                    return;
                }
                Application app2 = ApplicationManager.getApplication();
                if (app2 != null && !app2.isDisposed()) {
                    helper2.windowClosing(ProjectFrameHelper.this.project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/ProjectFrameHelper$2", "windowClosing"));
            }
        });
    }

    @NotNull
    protected CloseProjectWindowHelper createCloseProjectWindowHelper() {
        return new CloseProjectWindowHelper();
    }

    @Nullable
    public IdeStatusBarImpl getStatusBar() {
        return this.myRootPane == null ? null : this.myRootPane.getStatusBar();
    }

    public void setFrameTitle(String text2) {
        this.frame.setTitle(text2);
    }

    void frameReleased() {
        if (this.project != null) {
            this.project = null;
            if (this.myRootPane != null) {
                this.myRootPane.deinstallNorthComponents();
            }
        }
        this.fileTitle = null;
        this.currentFile = null;
        this.myTitle = null;
        if (this.frame != null) {
            this.frame.doSetTitle("");
        }
    }

    @Override
    public void setFileTitle(@Nullable String fileTitle, @Nullable Path file2) {
        this.fileTitle = fileTitle;
        this.currentFile = file2;
        this.updateTitle();
    }

    @Override
    @Nullable
    public IdeRootPaneNorthExtension getNorthExtension(String key) {
        return this.myRootPane.findByName(key);
    }

    @NotNull
    protected List<TitleInfoProvider> getTitleInfoProviders() {
        List list2 = TitleInfoProvider.EP.getExtensionList();
        if (list2 == null) {
            ProjectFrameHelper.$$$reportNull$$$0(1);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTitle() {
        if (this.isUpdatingTitle) {
            return;
        }
        this.isUpdatingTitle = true;
        try {
            if (AdvancedSettings.getBoolean((String)"ide.show.fileType.icon.in.titleBar")) {
                File ioFile = this.currentFile == null ? null : this.currentFile.toFile();
                this.frame.getRootPane().putClientProperty("Window.documentFile", ioFile);
            }
            StringBuilder builder2 = new StringBuilder();
            ProjectFrameHelper.appendTitlePart(builder2, this.myTitle);
            ProjectFrameHelper.appendTitlePart(builder2, this.fileTitle);
            List<TitleInfoProvider> titleInfoProviders = this.getTitleInfoProviders();
            if (!titleInfoProviders.isEmpty()) {
                assert (this.project != null);
                for (TitleInfoProvider extension2 : titleInfoProviders) {
                    String it;
                    if (!extension2.isActive(this.project) || (it = extension2.getValue(this.project)).isEmpty()) continue;
                    ProjectFrameHelper.appendTitlePart(builder2, it, " ");
                }
            }
            if (builder2.length() > 0) {
                this.frame.doSetTitle(builder2.toString());
            }
        }
        finally {
            this.isUpdatingTitle = false;
        }
    }

    @Nullable
    public static String getSuperUserSuffix() {
        return !SuperUserStatus.isSuperUser() ? null : (SystemInfoRt.isWindows ? "Administrator" : "ROOT");
    }

    public void updateView() {
        this.myRootPane.updateToolbar();
        this.myRootPane.updateMainMenuActions();
        this.myRootPane.updateNorthComponents();
    }

    public AccessibleContext getCurrentAccessibleContext() {
        return this.frame.getAccessibleContext();
    }

    public static void appendTitlePart(@NotNull StringBuilder sb, @Nullable String s) {
        if (sb == null) {
            ProjectFrameHelper.$$$reportNull$$$0(2);
        }
        ProjectFrameHelper.appendTitlePart(sb, s, " \u2013 ");
    }

    private static void appendTitlePart(@NotNull StringBuilder sb, @Nullable String s, String separator2) {
        if (sb == null) {
            ProjectFrameHelper.$$$reportNull$$$0(3);
        }
        if (!Strings.isEmptyOrSpaces((CharSequence)s)) {
            if (sb.length() > 0) {
                sb.append(separator2);
            }
            sb.append(s);
        }
    }

    @Override
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            ProjectFrameHelper.$$$reportNull$$$0(4);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.project != null && this.project.isInitialized() ? this.project : null;
        }
        if (IdeFrame.KEY.is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.LAST_ACTIVE_TOOL_WINDOWS.is(dataId)) {
            ToolWindowManager manager2 = this.project != null && this.project.isInitialized() ? (ToolWindowManager)this.project.getServiceIfCreated(ToolWindowManager.class) : null;
            return manager2 instanceof ToolWindowManagerImpl ? JBIterable.from(((ToolWindowManagerImpl)manager2).getLastActiveToolWindows()).toArray((Object[])new ToolWindow[0]) : null;
        }
        return null;
    }

    @Nullable
    public Project getProject() {
        return this.project;
    }

    public void setProject(@NotNull Project project) {
        if (project == null) {
            ProjectFrameHelper.$$$reportNull$$$0(5);
        }
        if (this.project == project) {
            return;
        }
        this.project = project;
        if (this.myRootPane != null) {
            this.myRootPane.setProject(project);
            this.myRootPane.installNorthComponents(project);
            IdeStatusBarImpl statusBar2 = this.myRootPane.getStatusBar();
            if (statusBar2 != null) {
                project.getMessageBus().connect().subscribe(StatusBar.Info.TOPIC, (Object)statusBar2);
            }
        }
        this.installDefaultProjectStatusBarWidgets(project);
        this.updateTitle();
        if (this.selfie != null) {
            StartupManager.getInstance((Project)project).runAfterOpened(() -> {
                this.selfie = null;
            });
        }
        if (this.myFrameDecorator != null) {
            this.myFrameDecorator.setProject();
        }
    }

    protected void installDefaultProjectStatusBarWidgets(@NotNull Project project) {
        if (project == null) {
            ProjectFrameHelper.$$$reportNull$$$0(6);
        }
        ((StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class))).installPendingWidgets();
        IdeStatusBarImpl statusBar2 = Objects.requireNonNull(this.getStatusBar());
        PopupHandler.installPopupMenu((JComponent)statusBar2, (String)"ViewStatusBarWidgetsGroup", (String)"StatusBarPlace");
    }

    public void dispose() {
        MouseGestureManager.getInstance().remove(this);
        if (this.myBalloonLayout != null) {
            ((BalloonLayoutImpl)this.myBalloonLayout).dispose();
            this.myBalloonLayout = null;
        }
        if (this.myRootPane != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.myRootPane.removeNotify();
            }
            this.frame.setRootPane(new JRootPane());
            this.myRootPane = null;
        }
        if (this.frame != null) {
            this.frame.doDispose();
            this.frame.setFrameHelper(null, null);
            this.frame = null;
        }
        this.myFrameDecorator = null;
    }

    private static boolean isTemporaryDisposed(@Nullable RootPaneContainer frame) {
        return UIUtil.isClientPropertyTrue((Object)(frame == null ? null : frame.getRootPane()), (Object)"dispose.temporary");
    }

    @Nullable
    public IdeFrameImpl getFrame() {
        IdeFrameImpl frame = this.frame;
        if (frame == null) {
            if (Disposer.isDisposed((Disposable)this)) {
                LOG.error(this.getClass().getSimpleName() + " is already disposed");
            } else {
                LOG.error("Frame is null, but " + this.getClass().getSimpleName() + " is not disposed yet");
            }
        }
        return frame;
    }

    @NotNull
    public IdeFrameImpl requireNotNullFrame() {
        IdeFrameImpl frame = this.frame;
        if (frame != null) {
            IdeFrameImpl ideFrameImpl = frame;
            if (ideFrameImpl == null) {
                ProjectFrameHelper.$$$reportNull$$$0(7);
            }
            return ideFrameImpl;
        }
        if (Disposer.isDisposed((Disposable)this)) {
            throw new AssertionError((Object)(this.getClass().getSimpleName() + " is already disposed"));
        }
        throw new AssertionError((Object)("Frame is null, but " + this.getClass().getSimpleName() + " is not disposed yet"));
    }

    @ApiStatus.Internal
    @Nullable
    IdeRootPane getRootPane() {
        return this.myRootPane;
    }

    @NotNull
    public Rectangle suggestChildFrameBounds() {
        Rectangle b = this.frame.getBounds();
        b.x += 100;
        b.width -= 200;
        b.y += 100;
        b.height -= 200;
        Rectangle rectangle = b;
        if (rectangle == null) {
            ProjectFrameHelper.$$$reportNull$$$0(8);
        }
        return rectangle;
    }

    @Nullable
    public final BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    public boolean isInFullScreen() {
        return this.myFrameDecorator != null && this.myFrameDecorator.isInFullScreen();
    }

    @Override
    @NotNull
    public Promise<?> toggleFullScreen(boolean state) {
        if (this.temporaryFixForIdea156004(state) || this.myFrameDecorator == null) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                ProjectFrameHelper.$$$reportNull$$$0(9);
            }
            return promise;
        }
        Promise<Boolean> promise = this.myFrameDecorator.toggleFullScreen(state);
        if (promise == null) {
            ProjectFrameHelper.$$$reportNull$$$0(10);
        }
        return promise;
    }

    private boolean temporaryFixForIdea156004(boolean state) {
        if (SystemInfoRt.isMac) {
            try {
                Field modalBlockerField = Window.class.getDeclaredField("modalBlocker");
                modalBlockerField.setAccessible(true);
                Window modalBlocker = (Window)modalBlockerField.get(this.frame);
                if (modalBlocker != null) {
                    ApplicationManager.getApplication().invokeLater(() -> this.toggleFullScreen(state), ModalityState.NON_MODAL);
                    return true;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOG.error((Throwable)e);
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/ProjectFrameHelper";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/ProjectFrameHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleInfoProviders";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "requireNotNullFrame";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestChildFrameBounds";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toggleFullScreen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendTitlePart";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installDefaultProjectStatusBarWidgets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

